/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.core.test.db.TemporaryDatabaseAware;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.Querier;
import org.opennms.netmgt.config.PollOutagesConfig;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.eventd.AbstractEventUtil;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.events.api.EventWriter;
import org.opennms.netmgt.icmp.proxy.LocationAwarePingClient;
import org.opennms.netmgt.mock.MockContainer;
import org.opennms.netmgt.mock.MockElement;
import org.opennms.netmgt.mock.MockEventUtil;
import org.opennms.netmgt.mock.MockInterface;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockNode;
import org.opennms.netmgt.mock.MockPollerConfig;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.mock.MockVisitor;
import org.opennms.netmgt.mock.MockVisitorAdapter;
import org.opennms.netmgt.mock.OutageAnticipator;
import org.opennms.netmgt.mock.PollAnticipator;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.poller.DefaultPollContext;
import org.opennms.netmgt.poller.LocationAwarePollerClient;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.Poller;
import org.opennms.netmgt.poller.QueryManager;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.test.mock.MockUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-eventUtil.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-pinger.xml", "classpath:/META-INF/opennms/applicationContext-rpc-client-mock.xml", "classpath:/META-INF/opennms/applicationContext-rpc-poller.xml", "classpath:/META-INF/opennms/applicationContext-pollerdTest.xml"})
@JUnitConfigurationEnvironment(systemProperties={"org.opennms.netmgt.icmp.pingerClass=org.opennms.netmgt.icmp.jna.JnaPinger"})
@JUnitTemporaryDatabase(tempDbClass=MockDatabase.class, reuseDatabase=false)
public class PollerQueryManagerDaoIT
implements TemporaryDatabaseAware<MockDatabase> {
    private Poller m_poller;
    private MockNetwork m_network;
    private MockDatabase m_db;
    private MockPollerConfig m_pollerConfig;
    @Autowired
    private MockEventIpcManager m_eventMgr;
    private boolean m_daemonsStarted = false;
    private OutageAnticipator m_outageAnticipator;
    @Autowired
    private QueryManager m_queryManager;
    @Autowired
    private MonitoredServiceDao m_monitoredServiceDao;
    @Autowired
    private TransactionTemplate m_transactionTemplate;
    @Autowired
    private LocationAwarePollerClient m_locationAwarePollerClient;
    private LocationAwarePingClient m_locationAwarePingClient;

    public void setTemporaryDatabase(MockDatabase database) {
        this.m_db = database;
    }

    @Before
    public void setUp() throws Exception {
        MockUtil.println((String)"------------ Begin Test  --------------------------");
        MockLogAppender.setupLogging();
        this.m_network = new MockNetwork();
        this.m_network.setCriticalService("ICMP");
        this.m_network.addNode(1, "Router");
        this.m_network.addInterface("192.168.1.1");
        this.m_network.addService("ICMP");
        this.m_network.addService("SMTP");
        this.m_network.addService("SNMP");
        this.m_network.addInterface("192.168.1.2");
        this.m_network.addService("ICMP");
        this.m_network.addService("SMTP");
        this.m_network.addNode(2, "Server");
        this.m_network.addInterface("192.168.1.3");
        this.m_network.addService("ICMP");
        this.m_network.addService("HTTP");
        this.m_network.addService("SMTP");
        this.m_network.addService("SNMP");
        this.m_network.addNode(3, "Firewall");
        this.m_network.addInterface("192.168.1.4");
        this.m_network.addService("SMTP");
        this.m_network.addService("HTTP");
        this.m_network.addInterface("192.168.1.5");
        this.m_network.addService("SMTP");
        this.m_network.addService("HTTP");
        this.m_network.addNode(4, "DownNode");
        this.m_network.addInterface("192.168.1.6");
        this.m_network.addService("SNMP");
        this.m_db.populate(this.m_network);
        DataSourceFactory.setInstance((DataSource)this.m_db);
        this.m_pollerConfig = new MockPollerConfig(this.m_network);
        this.m_pollerConfig.setNextOutageIdSql(this.m_db.getNextOutageIdStatement());
        this.m_pollerConfig.setNodeOutageProcessingEnabled(true);
        this.m_pollerConfig.setCriticalService("ICMP");
        this.m_pollerConfig.addPackage("TestPackage");
        this.m_pollerConfig.addDowntime(1000L, 0L, -1L, false);
        this.m_pollerConfig.setDefaultPollInterval(1000L);
        this.m_pollerConfig.populatePackage(this.m_network, new MockService[0]);
        this.m_pollerConfig.addPackage("TestPkg2");
        this.m_pollerConfig.addDowntime(1000L, 0L, -1L, false);
        this.m_pollerConfig.setDefaultPollInterval(2000L);
        this.m_pollerConfig.addService(this.m_network.getService(2, "192.168.1.3", "HTTP"));
        this.m_outageAnticipator = new OutageAnticipator(this.m_db);
        this.m_eventMgr = new MockEventIpcManager();
        this.m_eventMgr.setEventWriter((EventWriter)this.m_db);
        this.m_eventMgr.addEventListener((EventListener)this.m_outageAnticipator);
        this.m_eventMgr.setSynchronous(false);
        this.m_locationAwarePingClient = (LocationAwarePingClient)Mockito.mock(LocationAwarePingClient.class);
        DefaultPollContext pollContext = new DefaultPollContext();
        pollContext.setEventManager((EventIpcManager)this.m_eventMgr);
        pollContext.setLocalHostName("localhost");
        pollContext.setName("Test.DefaultPollContext");
        pollContext.setPollerConfig((PollerConfig)this.m_pollerConfig);
        pollContext.setQueryManager(this.m_queryManager);
        pollContext.setLocationAwarePingClient(this.m_locationAwarePingClient);
        PollableNetwork network = new PollableNetwork((PollContext)pollContext);
        this.m_poller = new Poller();
        this.m_poller.setMonitoredServiceDao(this.m_monitoredServiceDao);
        this.m_poller.setTransactionTemplate(this.m_transactionTemplate);
        this.m_poller.setEventIpcManager((EventIpcManager)this.m_eventMgr);
        this.m_poller.setNetwork(network);
        this.m_poller.setQueryManager(this.m_queryManager);
        this.m_poller.setPollerConfig((PollerConfig)this.m_pollerConfig);
        this.m_poller.setPollOutagesConfig((PollOutagesConfig)this.m_pollerConfig);
        this.m_poller.setLocationAwarePollerClient(this.m_locationAwarePollerClient);
    }

    @After
    public void tearDown() throws Exception {
        this.m_eventMgr.finishProcessingEvents();
        this.stopDaemons();
        this.sleep(200L);
        this.m_db.drop();
        MockUtil.println((String)"------------ End Test  --------------------------");
    }

    @Test
    public void testIsRemotePackage() {
        Properties p = new Properties();
        p.setProperty("org.opennms.netmgt.ConfigFileConstants", "ERROR");
        MockLogAppender.setupLogging((Properties)p);
        Package pkg = new Package();
        pkg.setName("SFO");
        pkg.setRemote(Boolean.valueOf(true));
        Poller poller = new Poller();
        Assert.assertFalse((boolean)poller.pollableServiceInPackage(null, null, pkg));
        poller = null;
    }

    @Test
    public void testNullInterfaceOnNodeDown() {
        this.m_pollerConfig.setNodeOutageProcessingEnabled(true);
        MockNode node = this.m_network.getNode(2);
        MockService icmpService = this.m_network.getService(2, "192.168.1.3", "ICMP");
        MockService smtpService = this.m_network.getService(2, "192.168.1.3", "SMTP");
        MockService snmpService = this.m_network.getService(2, "192.168.1.3", "SNMP");
        this.startDaemons();
        this.anticipateDown((MockElement)node);
        icmpService.bringDown();
        smtpService.bringDown();
        snmpService.bringDown();
        this.verifyAnticipated(10000L);
        boolean foundNodeDown = false;
        for (Event event : this.m_eventMgr.getEventAnticipator().getAnticipatedEventsReceived()) {
            if (!"uei.opennms.org/nodes/nodeDown".equals(event.getUei())) continue;
            foundNodeDown = true;
            Assert.assertNull((Object)event.getInterfaceAddress());
        }
        Assert.assertTrue((boolean)foundNodeDown);
    }

    @Test
    @Ignore
    public void testBug1564() {
        this.m_pollerConfig.setNodeOutageProcessingEnabled(true);
        MockNode node = this.m_network.getNode(2);
        MockService icmpService = this.m_network.getService(2, "192.168.1.3", "ICMP");
        MockService smtpService = this.m_network.getService(2, "192.168.1.3", "SMTP");
        MockService snmpService = this.m_network.getService(2, "192.168.1.3", "SNMP");
        this.startDaemons();
        this.resetAnticipated();
        this.anticipateDown((MockElement)snmpService);
        snmpService.bringDown();
        this.verifyAnticipated(10000L);
        this.resetAnticipated();
        this.anticipateDown((MockElement)node);
        icmpService.bringDown();
        smtpService.bringDown();
        snmpService.bringDown();
        this.verifyAnticipated(10000L);
        this.anticipateDown((MockElement)smtpService);
        this.verifyAnticipated(10000L);
        this.anticipateDown((MockElement)snmpService);
        this.verifyAnticipated(10000L);
        this.m_pollerConfig.setNodeOutageProcessingEnabled(false);
        this.anticipateUp((MockElement)snmpService);
        snmpService.bringUp();
        this.verifyAnticipated(10000L);
        this.anticipateUp((MockElement)smtpService);
        smtpService.bringUp();
        this.verifyAnticipated(10000L);
        this.m_pollerConfig.setNodeOutageProcessingEnabled(true);
        smtpService.bringDown();
        this.anticipateUp((MockElement)smtpService);
        smtpService.bringUp();
        this.verifyAnticipated(10000L, true);
        this.anticipateUp((MockElement)snmpService);
        snmpService.bringUp();
        this.verifyAnticipated(10000L);
    }

    @Test
    public void testBug709() {
        this.m_pollerConfig.setNodeOutageProcessingEnabled(true);
        MockNode node = this.m_network.getNode(2);
        MockService icmpService = this.m_network.getService(2, "192.168.1.3", "ICMP");
        MockService httpService = this.m_network.getService(2, "192.168.1.3", "HTTP");
        this.startDaemons();
        this.resetAnticipated();
        this.anticipateDown((MockElement)httpService);
        httpService.bringDown();
        this.verifyAnticipated(10000L);
        this.resetAnticipated();
        this.anticipateDown((MockElement)node);
        icmpService.bringDown();
        this.sleep(5000L);
        this.resetAnticipated();
        this.anticipateUp((MockElement)httpService);
        this.anticipateUp((MockElement)node);
        node.bringUp();
        this.verifyAnticipated(10000L);
    }

    private void resetAnticipated() {
        this.m_eventMgr.getEventAnticipator().reset();
        this.m_outageAnticipator.reset();
    }

    @Test
    public void testNodeLostServiceWithReason() {
        this.m_pollerConfig.setNodeOutageProcessingEnabled(true);
        MockService svc = this.m_network.getService(1, "192.168.1.1", "ICMP");
        Event e = svc.createDownEvent();
        String reasonParm = "eventReason";
        String val = AbstractEventUtil.getInstance().getNamedParmValue("parm[" + reasonParm + "]", e);
        Assert.assertEquals((Object)"Service Not Responding.", (Object)val);
    }

    @Test
    public void testCritSvcStatusPropagation() {
        this.m_pollerConfig.setNodeOutageProcessingEnabled(true);
        MockNode node = this.m_network.getNode(1);
        this.anticipateDown((MockElement)node);
        this.startDaemons();
        this.bringDownCritSvcs((MockElement)node);
        this.verifyAnticipated(8000L);
    }

    @Test
    public void testInterfaceWithNoCriticalService() {
        this.m_pollerConfig.setNodeOutageProcessingEnabled(true);
        MockInterface iface = this.m_network.getInterface(3, "192.168.1.4");
        MockService svc = iface.getService("SMTP");
        MockService otherService = iface.getService("HTTP");
        this.startDaemons();
        this.anticipateDown((MockElement)iface);
        iface.bringDown();
        this.verifyAnticipated(8000L);
        this.anticipateUp((MockElement)iface);
        this.anticipateDown((MockElement)otherService, true);
        svc.bringUp();
        this.verifyAnticipated(8000L);
    }

    @Test
    public void testDontPollDuringScheduledOutages() {
        long start = System.currentTimeMillis();
        MockInterface iface = this.m_network.getInterface(1, "192.168.1.2");
        this.m_pollerConfig.addScheduledOutage(this.m_pollerConfig.getPackage("TestPackage"), "TestOutage", start, start + 5000L, iface.getIpAddr());
        MockUtil.println((String)"Begin Outage");
        this.startDaemons();
        long now = System.currentTimeMillis();
        this.sleep(3000L - (now - start));
        MockUtil.println((String)"End Outage");
        Assert.assertEquals((long)0L, (long)iface.getPollCount());
        this.sleep(5000L);
        Assert.assertTrue((0 < iface.getPollCount() ? 1 : 0) != 0);
    }

    private void testElementDeleted(MockElement element) {
        Event deleteEvent = element.createDeleteEvent();
        this.m_pollerConfig.setNodeOutageProcessingEnabled(false);
        PollAnticipator poll = new PollAnticipator();
        element.addAnticipator(poll);
        poll.anticipateAllServices(element);
        this.startDaemons();
        poll.waitForAnticipated(1000L);
        this.m_network.removeElement(element);
        this.m_eventMgr.sendEventToListeners(deleteEvent);
        this.m_network.resetInvalidPollCount();
        this.sleep(3000L);
        Assert.assertEquals((String)"Received a poll for an element that doesn't exist", (long)0L, (long)this.m_network.getInvalidPollCount());
    }

    @Test
    public void testServiceDeleted() {
        MockService svc = this.m_network.getService(1, "192.168.1.1", "SMTP");
        this.testElementDeleted((MockElement)svc);
    }

    @Test
    public void testInterfaceDeleted() {
        MockInterface iface = this.m_network.getInterface(1, "192.168.1.1");
        this.testElementDeleted((MockElement)iface);
    }

    @Test
    public void testNodeDeleted() {
        MockNode node = this.m_network.getNode(1);
        this.testElementDeleted((MockElement)node);
    }

    @Test
    public void testNodeLabelChanged() {
        MockNode element = this.m_network.getNode(1);
        String newLabel = "NEW LABEL";
        Event event = element.createNodeLabelChangedEvent(newLabel);
        this.m_pollerConfig.setNodeOutageProcessingEnabled(false);
        PollAnticipator poll = new PollAnticipator();
        element.addAnticipator(poll);
        poll.anticipateAllServices((MockElement)element);
        this.startDaemons();
        poll.waitForAnticipated(1000L);
        Assert.assertEquals((Object)"Router", (Object)this.m_poller.getNetwork().getNode(1).getNodeLabel());
        element.setLabel(newLabel);
        this.m_eventMgr.sendEventToListeners(event);
        Assert.assertEquals((Object)newLabel, (Object)this.m_poller.getNetwork().getNode(1).getNodeLabel());
    }

    public void testOutagesClosedOnDelete(MockElement element) {
        this.startDaemons();
        Event deleteEvent = element.createDeleteEvent();
        this.anticipateDown(element);
        element.bringDown();
        this.verifyAnticipated(5000L, false);
        this.m_outageAnticipator.anticipateOutageClosed(element, deleteEvent);
        this.m_eventMgr.sendEventToListeners(deleteEvent);
        this.m_network.removeElement(element);
        this.verifyAnticipated(5000L);
    }

    @Test
    public void testServiceOutagesClosedOnDelete() {
        MockService element = this.m_network.getService(1, "192.168.1.1", "SMTP");
        this.testOutagesClosedOnDelete((MockElement)element);
    }

    @Test
    public void testInterfaceOutagesClosedOnDelete() {
        MockInterface element = this.m_network.getInterface(1, "192.168.1.1");
        this.testOutagesClosedOnDelete((MockElement)element);
    }

    @Test
    public void testNodeOutagesClosedOnDelete() {
        MockNode element = this.m_network.getNode(1);
        this.testOutagesClosedOnDelete((MockElement)element);
    }

    @Test
    public void testInterfaceReparented() throws Exception {
        this.m_pollerConfig.setNodeOutageProcessingEnabled(true);
        MockNode node1 = this.m_network.getNode(1);
        MockNode node2 = this.m_network.getNode(2);
        Assert.assertNotNull((String)"Node 1 should have 192.168.1.1", (Object)node1.getInterface("192.168.1.1"));
        Assert.assertNotNull((String)"Node 1 should have 192.168.1.2", (Object)node1.getInterface("192.168.1.2"));
        Assert.assertNull((String)"Node 2 should not yet have 192.168.1.2", (Object)node2.getInterface("192.168.1.2"));
        Assert.assertNotNull((String)"Node 2 should have 192.168.1.3", (Object)node2.getInterface("192.168.1.3"));
        MockInterface dotTwo = this.m_network.getInterface(1, "192.168.1.2");
        MockInterface dotThree = this.m_network.getInterface(2, "192.168.1.3");
        Event reparentEvent = MockEventUtil.createReparentEvent((String)"Test", (String)"192.168.1.2", (int)1, (int)2);
        this.anticipateDown((MockElement)dotThree);
        this.startDaemons();
        int waitTime = 2000;
        int verifyTime = 2000;
        this.sleep(2000L);
        dotTwo.moveTo((MockContainer)node2);
        this.m_db.reparentInterface(dotTwo.getIpAddr(), node1.getNodeId(), node2.getNodeId());
        this.m_eventMgr.sendEventToListeners(reparentEvent);
        this.sleep(2000L);
        dotThree.bringDown();
        this.verifyAnticipated(2000L);
        this.resetAnticipated();
        this.anticipateDown((MockElement)node2);
        dotTwo.bringDown();
        this.sleep(2000L);
        this.verifyAnticipated(2000L);
        node1 = this.m_network.getNode(1);
        node2 = this.m_network.getNode(2);
        Assert.assertNotNull((String)"Node 1 should still have 192.168.1.1", (Object)node1.getInterface("192.168.1.1"));
        Assert.assertNull((String)"Node 1 should no longer have 192.168.1.2", (Object)node1.getInterface("192.168.1.2"));
        Assert.assertNotNull((String)"Node 2 should now have 192.168.1.2", (Object)node2.getInterface("192.168.1.2"));
        Assert.assertNotNull((String)"Node 2 should still have 192.168.1.3", (Object)node2.getInterface("192.168.1.3"));
    }

    @Test
    public void testNodeOutageProcessingDisabled() throws Exception {
        this.m_pollerConfig.setNodeOutageProcessingEnabled(false);
        MockNode node = this.m_network.getNode(1);
        this.startDaemons();
        this.resetAnticipated();
        this.anticipateServicesDown((MockElement)node);
        node.bringDown();
        this.verifyAnticipated(10000L);
        this.resetAnticipated();
        this.anticipateServicesUp((MockElement)node);
        node.bringUp();
        this.verifyAnticipated(10000L);
    }

    @Test
    public void testNodeOutageProcessingEnabled() throws Exception {
        this.m_pollerConfig.setNodeOutageProcessingEnabled(true);
        MockNode node = this.m_network.getNode(1);
        this.startDaemons();
        this.resetAnticipated();
        this.anticipateDown((MockElement)node);
        node.bringDown();
        this.verifyAnticipated(10000L);
        this.resetAnticipated();
        this.anticipateUp((MockElement)node);
        node.bringUp();
        this.verifyAnticipated(10000L);
    }

    @Test
    public void testNodeLostServiceIncludesReason() throws Exception {
        MockService element = this.m_network.getService(1, "192.168.1.1", "SMTP");
        String expectedReason = "Oh No!! An Outage!!";
        this.startDaemons();
        this.resetAnticipated();
        this.anticipateDown((MockElement)element);
        MockUtil.println((String)("Bringing down element: " + element));
        element.bringDown(expectedReason);
        MockUtil.println((String)("Finished bringing down element: " + element));
        this.verifyAnticipated(8000L);
        List receivedEvents = this.m_eventMgr.getEventAnticipator().getAnticipatedEventsReceived();
        Assert.assertEquals((long)2L, (long)receivedEvents.size());
        Iterator receivedEventsIter = receivedEvents.iterator();
        Event event1 = (Event)receivedEventsIter.next();
        Assert.assertEquals((Object)expectedReason, (Object)EventUtils.getParm((Event)event1, (String)"eventReason"));
        Event event2 = (Event)receivedEventsIter.next();
        Assert.assertNotNull((Object)event2);
        Assert.assertEquals((Object)"uei.opennms.org/internal/poller/outageCreated", (Object)event2.getUei());
        Assert.assertEquals((Object)"SMTP", (Object)event2.getService());
        Assert.assertEquals((Object)"192.168.1.1", (Object)event2.getInterface());
    }

    @Test
    public void testNodeLostRegainedService() throws Exception {
        this.testElementDownUp((MockElement)this.m_network.getService(1, "192.168.1.1", "SMTP"));
    }

    @Test
    public void testInterfaceDownUp() {
        this.testElementDownUp((MockElement)this.m_network.getInterface(1, "192.168.1.1"));
    }

    @Test
    public void testNodeDownUp() {
        this.testElementDownUp((MockElement)this.m_network.getNode(1));
    }

    private void testElementDownUp(MockElement element) {
        this.startDaemons();
        this.resetAnticipated();
        this.anticipateDown(element);
        MockUtil.println((String)("Bringing down element: " + element));
        element.bringDown();
        MockUtil.println((String)("Finished bringing down element: " + element));
        this.verifyAnticipated(5000L);
        this.sleep(2000L);
        this.resetAnticipated();
        this.anticipateUp(element);
        MockUtil.println((String)("Bringing up element: " + element));
        element.bringUp();
        MockUtil.println((String)("Finished bringing up element: " + element));
        this.verifyAnticipated(8000L);
    }

    @Test
    public void testNoEventsOnNoOutages() throws Exception {
        this.testElementDownUp((MockElement)this.m_network.getService(1, "192.168.1.1", "SMTP"));
        this.resetAnticipated();
        this.verifyAnticipated(8000L, true);
    }

    @Test
    public void testPolling() throws Exception {
        this.m_pollerConfig.setNodeOutageProcessingEnabled(false);
        PollAnticipator anticipator = new PollAnticipator();
        MockInterface iface = this.m_network.getInterface(1, "192.168.1.2");
        iface.addAnticipator(anticipator);
        anticipator.anticipateAllServices((MockElement)iface);
        anticipator.anticipateAllServices((MockElement)iface);
        anticipator.anticipateAllServices((MockElement)iface);
        this.startDaemons();
        Assert.assertEquals((long)0L, (long)anticipator.waitForAnticipated(4500L).size());
    }

    @Test
    public void testUnmangedWithOpenOutageAtStartup() throws InterruptedException {
        MockService svc = this.m_network.getService(1, "192.168.1.1", "SMTP");
        MockInterface iface = this.m_network.getInterface(1, "192.168.1.2");
        Event svcLostEvent = MockEventUtil.createNodeLostServiceEvent((String)"Test", (MockService)svc);
        this.m_db.writeEvent(svcLostEvent);
        this.createOutages((MockElement)svc, svcLostEvent);
        Event ifaceDownEvent = MockEventUtil.createInterfaceDownEvent((String)"Test", (MockInterface)iface);
        this.m_db.writeEvent(ifaceDownEvent);
        this.createOutages((MockElement)iface, ifaceDownEvent);
        this.m_db.setServiceStatus(svc, 'U');
        this.m_db.setInterfaceStatus(iface, 'U');
        Assert.assertEquals((long)1L, (long)this.m_db.countOpenOutagesForService(svc));
        Assert.assertEquals((long)1L, (long)this.m_db.countOutagesForService(svc));
        Assert.assertEquals((long)iface.getServices().size(), (long)this.m_db.countOutagesForInterface(iface));
        Assert.assertEquals((long)iface.getServices().size(), (long)this.m_db.countOpenOutagesForInterface(iface));
        this.startDaemons();
        Assert.assertEquals((long)0L, (long)this.m_db.countOpenOutagesForService(svc));
        Assert.assertEquals((long)1L, (long)this.m_db.countOutagesForService(svc));
        Assert.assertEquals((long)0L, (long)this.m_db.countOpenOutagesForInterface(iface));
        Assert.assertEquals((long)iface.getServices().size(), (long)this.m_db.countOutagesForInterface(iface));
    }

    @Test
    public void testNodeGainedServiceWhileNodeDownAndServiceUp() {
        this.startDaemons();
        MockNode node = this.m_network.getNode(4);
        MockService svc = this.m_network.getService(4, "192.168.1.6", "SNMP");
        this.anticipateDown((MockElement)node);
        node.bringDown();
        this.verifyAnticipated(5000L);
        this.resetAnticipated();
        this.anticipateUp((MockElement)node);
        this.anticipateDown((MockElement)svc, true);
        MockService newSvc = this.m_network.addService(4, "192.168.1.6", "SMTP");
        this.m_db.writeService(newSvc);
        Event e = MockEventUtil.createNodeGainedServiceEvent((String)"Test", (MockService)newSvc);
        this.m_eventMgr.sendEventToListeners(e);
        this.sleep(5000L);
        System.err.println(this.m_db.getOutages());
        this.verifyAnticipated(8000L);
    }

    @Test
    public void testNodeGainedServiceWhileNodeDownAndServiceDown() {
        this.startDaemons();
        MockNode node = this.m_network.getNode(4);
        MockService svc = this.m_network.getService(4, "192.168.1.6", "SNMP");
        this.anticipateDown((MockElement)node);
        node.bringDown();
        this.verifyAnticipated(5000L);
        this.resetAnticipated();
        MockService newSvc = this.m_network.addService(4, "192.168.1.6", "SMTP");
        this.m_db.writeService(newSvc);
        newSvc.bringDown();
        Event e = MockEventUtil.createNodeGainedServiceEvent((String)"Test", (MockService)newSvc);
        this.m_eventMgr.sendEventToListeners(e);
        this.sleep(5000L);
        System.err.println(this.m_db.getOutages());
        this.verifyAnticipated(8000L);
        this.anticipateUp((MockElement)node);
        this.anticipateDown((MockElement)svc, true);
        newSvc.bringUp();
        this.verifyAnticipated(5000L);
    }

    @Test
    public void testReparentCausesStatusChange() {
        this.m_pollerConfig.setNodeOutageProcessingEnabled(true);
        MockNode node1 = this.m_network.getNode(1);
        MockNode node2 = this.m_network.getNode(2);
        MockInterface dotOne = this.m_network.getInterface(1, "192.168.1.1");
        MockInterface dotTwo = this.m_network.getInterface(1, "192.168.1.2");
        MockInterface dotThree = this.m_network.getInterface(2, "192.168.1.3");
        this.anticipateDown((MockElement)node2);
        this.anticipateDown((MockElement)dotOne);
        node1.bringDown();
        node2.bringDown();
        dotTwo.bringUp();
        Event reparentEvent = MockEventUtil.createReparentEvent((String)"Test", (String)"192.168.1.2", (int)1, (int)2);
        this.startDaemons();
        this.verifyAnticipated(2000L);
        this.m_db.reparentInterface(dotTwo.getIpAddr(), dotTwo.getNodeId(), node2.getNodeId());
        dotTwo.moveTo((MockContainer)node2);
        this.resetAnticipated();
        this.anticipateDown((MockElement)node1, true);
        this.anticipateUp((MockElement)node2, true);
        this.anticipateDown((MockElement)dotThree, true);
        this.m_eventMgr.sendEventToListeners(reparentEvent);
        this.verifyAnticipated(20000L);
    }

    @Test
    public void testSendNodeGainedService() {
        this.m_pollerConfig.setNodeOutageProcessingEnabled(false);
        this.startDaemons();
        this.testSendNodeGainedService("SMTP", "HTTP");
    }

    @Test
    public void testSendNodeGainedServiceNodeOutages() {
        this.m_pollerConfig.setNodeOutageProcessingEnabled(true);
        this.startDaemons();
        this.testSendNodeGainedService("SMTP", "HTTP");
    }

    @Test
    public void testSendIPv6NodeGainedService() {
        this.m_pollerConfig.setNodeOutageProcessingEnabled(false);
        this.startDaemons();
        this.testSendNodeGainedServices(99, "TestNode", "fe80:0000:0000:0000:0231:f982:0123:4567", "SMTP", "HTTP");
    }

    @Test
    public void testSendIPv6NodeGainedServiceNodeOutages() {
        this.m_pollerConfig.setNodeOutageProcessingEnabled(true);
        this.startDaemons();
        this.testSendNodeGainedServices(99, "TestNode", "fe80:0000:0000:0000:0231:f982:0123:4567", "SMTP", "HTTP");
    }

    public void testSendNodeGainedService(String ... svcNames) {
        this.testSendNodeGainedServices(99, "TestNode", "10.1.1.1", svcNames);
    }

    private void testSendNodeGainedServices(int nodeid, String nodeLabel, String ipAddr, String ... svcNames) {
        Assert.assertNotNull((Object)svcNames);
        Assert.assertTrue((svcNames.length > 0 ? 1 : 0) != 0);
        MockNode node = this.m_network.addNode(nodeid, nodeLabel);
        this.m_db.writeNode(node);
        MockInterface iface = this.m_network.addInterface(nodeid, ipAddr);
        this.m_db.writeInterface(iface);
        ArrayList<MockService> services = new ArrayList<MockService>();
        for (String svcName : svcNames) {
            MockService svc = this.m_network.addService(nodeid, ipAddr, svcName);
            this.m_db.writeService(svc);
            this.m_pollerConfig.addService(svc);
            services.add(svc);
        }
        MockVisitorAdapter gainSvcSender = new MockVisitorAdapter(){

            public void visitService(MockService svc) {
                Event event = MockEventUtil.createNodeGainedServiceEvent((String)"Test", (MockService)svc);
                PollerQueryManagerDaoIT.this.m_eventMgr.sendEventToListeners(event);
            }
        };
        node.visit((MockVisitor)gainSvcSender);
        MockService svc1 = (MockService)services.get(0);
        PollAnticipator anticipator = new PollAnticipator();
        svc1.addAnticipator(anticipator);
        anticipator.anticipateAllServices((MockElement)svc1);
        StringBuffer didNotOccur = new StringBuffer();
        for (MockService service : anticipator.waitForAnticipated(10000L)) {
            didNotOccur.append(service.toString());
        }
        StringBuffer unanticipatedStuff = new StringBuffer();
        for (MockService service : anticipator.unanticipatedPolls()) {
            unanticipatedStuff.append(service.toString());
        }
        Assert.assertEquals((String)unanticipatedStuff.toString(), (Object)"", (Object)didNotOccur.toString());
        this.anticipateDown((MockElement)svc1);
        svc1.bringDown();
        this.verifyAnticipated(10000L);
    }

    @Test
    public void testSuspendPollingResumeService() {
        MockService svc = this.m_network.getService(1, "192.168.1.2", "SMTP");
        this.startDaemons();
        this.sleep(2000L);
        Assert.assertTrue((0 < svc.getPollCount() ? 1 : 0) != 0);
        this.m_eventMgr.sendEventToListeners(MockEventUtil.createSuspendPollingServiceEvent((String)"Test", (MockService)svc));
        svc.resetPollCount();
        this.sleep(5000L);
        Assert.assertEquals((long)0L, (long)svc.getPollCount());
        this.m_eventMgr.sendEventToListeners(MockEventUtil.createResumePollingServiceEvent((String)"Test", (MockService)svc));
        this.sleep(2000L);
        Assert.assertTrue((0 < svc.getPollCount() ? 1 : 0) != 0);
    }

    private void startDaemons() {
        this.m_poller.init();
        this.m_poller.start();
        this.m_daemonsStarted = true;
    }

    private void stopDaemons() {
        if (this.m_daemonsStarted) {
            this.m_poller.stop();
            this.m_daemonsStarted = false;
        }
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void verifyAnticipated(long millis) {
        this.verifyAnticipated(millis, true);
    }

    private void verifyAnticipated(long millis, boolean checkUnanticipated) {
        MockEventUtil.printEvents((String)"Events we're still waiting for: ", (Collection)this.m_eventMgr.getEventAnticipator().waitForAnticipated(millis));
        Assert.assertTrue((String)"Expected events not forthcoming", (boolean)this.m_eventMgr.getEventAnticipator().waitForAnticipated(0L).isEmpty());
        if (checkUnanticipated) {
            this.sleep(2000L);
            MockEventUtil.printEvents((String)"Unanticipated: ", (Collection)this.m_eventMgr.getEventAnticipator().getUnanticipatedEvents());
            Assert.assertEquals((String)"Received unexpected events", (long)0L, (long)this.m_eventMgr.getEventAnticipator().getUnanticipatedEvents().size());
        }
        this.sleep(1000L);
        this.m_eventMgr.finishProcessingEvents();
        Assert.assertEquals((String)"Wrong number of outages opened", (long)this.m_outageAnticipator.getExpectedOpens(), (long)this.m_outageAnticipator.getActualOpens());
        Assert.assertEquals((String)"Wrong number of outages in outage table", (long)this.m_outageAnticipator.getExpectedOutages(), (long)this.m_outageAnticipator.getActualOutages());
        Assert.assertTrue((String)"Created outages don't match the expected outages", (boolean)this.m_outageAnticipator.checkAnticipated());
    }

    private void anticipateUp(MockElement element) {
        this.anticipateUp(element, false);
    }

    private void anticipateUp(MockElement element, boolean force) {
        if (force || !element.getPollStatus().equals((Object)PollStatus.up())) {
            Event event = element.createUpEvent();
            this.m_eventMgr.getEventAnticipator().anticipateEvent(event);
            for (Event outageResolvedEvent : this.m_outageAnticipator.anticipateOutageClosed(element, event)) {
                this.m_eventMgr.getEventAnticipator().anticipateEvent(outageResolvedEvent);
            }
        }
    }

    private void anticipateDown(MockElement element) {
        this.anticipateDown(element, false);
    }

    private void anticipateDown(MockElement element, boolean force) {
        if (force || !element.getPollStatus().equals((Object)PollStatus.down())) {
            Event event = element.createDownEvent();
            this.m_eventMgr.getEventAnticipator().anticipateEvent(event);
            for (Event outageCreatedEvent : this.m_outageAnticipator.anticipateOutageOpened(element, event)) {
                this.m_eventMgr.getEventAnticipator().anticipateEvent(outageCreatedEvent);
            }
        }
    }

    private void anticipateServicesUp(MockElement node) {
        MockVisitorAdapter eventCreator = new MockVisitorAdapter(){

            public void visitService(MockService svc) {
                PollerQueryManagerDaoIT.this.anticipateUp((MockElement)svc);
            }
        };
        node.visit((MockVisitor)eventCreator);
    }

    private void anticipateServicesDown(MockElement node) {
        MockVisitorAdapter eventCreator = new MockVisitorAdapter(){

            public void visitService(MockService svc) {
                PollerQueryManagerDaoIT.this.anticipateDown((MockElement)svc);
            }
        };
        node.visit((MockVisitor)eventCreator);
    }

    private void createOutages(MockElement element, final Event event) {
        MockVisitorAdapter outageCreater = new MockVisitorAdapter(){

            public void visitService(MockService svc) {
                if (svc.getMgmtStatus().equals((Object)MockService.SvcMgmtStatus.ACTIVE)) {
                    PollerQueryManagerDaoIT.this.m_db.createOutage(svc, event);
                }
            }
        };
        element.visit((MockVisitor)outageCreater);
    }

    private void bringDownCritSvcs(MockElement element) {
        MockVisitorAdapter markCritSvcDown = new MockVisitorAdapter(){

            public void visitService(MockService svc) {
                if ("ICMP".equals(svc.getSvcName())) {
                    svc.bringDown();
                }
            }
        };
        element.visit((MockVisitor)markCritSvcDown);
    }

    class OutageChecker
    extends Querier {
        private Event m_lostSvcEvent;
        private Timestamp m_lostSvcTime;
        private MockService m_svc;
        private Event m_regainedSvcEvent;
        private Timestamp m_regainedSvcTime;

        OutageChecker(MockService svc, Event lostSvcEvent) throws Exception {
            this(svc, lostSvcEvent, null);
        }

        OutageChecker(MockService svc, Event lostSvcEvent, Event regainedSvcEvent) {
            super((DataSource)PollerQueryManagerDaoIT.this.m_db, "select * from outages where nodeid = ? and ipAddr = ? and serviceId = ?");
            this.m_svc = svc;
            this.m_lostSvcEvent = lostSvcEvent;
            this.m_lostSvcTime = new Timestamp(this.m_lostSvcEvent.getTime().getTime());
            this.m_regainedSvcEvent = regainedSvcEvent;
            if (this.m_regainedSvcEvent != null) {
                this.m_regainedSvcTime = new Timestamp(this.m_regainedSvcEvent.getTime().getTime());
            }
        }

        public void processRow(ResultSet rs) throws SQLException {
            Assert.assertEquals((long)this.m_svc.getNodeId(), (long)rs.getInt("nodeId"));
            Assert.assertEquals((Object)this.m_svc.getIpAddr(), (Object)rs.getString("ipAddr"));
            Assert.assertEquals((long)this.m_svc.getSvcId(), (long)rs.getInt("serviceId"));
            Assert.assertEquals((Object)this.m_lostSvcEvent.getDbid(), (Object)rs.getInt("svcLostEventId"));
            Assert.assertEquals((Object)this.m_lostSvcTime, (Object)rs.getTimestamp("ifLostService"));
            Assert.assertEquals((Object)this.getRegainedEventId(), (Object)rs.getObject("svcRegainedEventId"));
            Assert.assertEquals((Object)this.m_regainedSvcTime, (Object)rs.getTimestamp("ifRegainedService"));
        }

        private Integer getRegainedEventId() {
            if (this.m_regainedSvcEvent == null) {
                return null;
            }
            return (int)this.m_regainedSvcEvent.getDbid();
        }
    }
}

