/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.core.test.db.TemporaryDatabaseAware;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.dao.api.CriticalPath;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.PathOutageDao;
import org.opennms.netmgt.dao.api.PathOutageManager;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.events.api.EventWriter;
import org.opennms.netmgt.icmp.proxy.LocationAwarePingClient;
import org.opennms.netmgt.mock.MockElement;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockPollerConfig;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.mock.OutageAnticipator;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsPathOutage;
import org.opennms.netmgt.poller.DefaultPollContext;
import org.opennms.netmgt.poller.QueryManager;
import org.opennms.netmgt.poller.pollables.PollContext;
import org.opennms.netmgt.poller.pollables.PollEvent;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.snmp.InetAddrUtils;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-pollerdTest.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(tempDbClass=MockDatabase.class, reuseDatabase=false)
public class PollContextIT
implements TemporaryDatabaseAware<MockDatabase> {
    private MockNetwork m_mNetwork;
    private MockDatabase m_db;
    private MockPollerConfig m_pollerConfig;
    private DefaultPollContext m_pollContext;
    private PollableNetwork m_pNetwork;
    private PollableService m_pSvc;
    private MockService m_mSvc;
    private OutageAnticipator m_outageAnticipator;
    private MockEventIpcManager m_eventMgr;
    @Autowired
    QueryManager m_queryManager;
    @Autowired
    NodeDao m_nodeDao;
    @Autowired
    PathOutageDao m_pathOutageDao;
    @Autowired
    PathOutageManager m_pathOutageManager;
    LocationAwarePingClient m_locationAwarePingClient;

    public void setTemporaryDatabase(MockDatabase database) {
        this.m_db = database;
    }

    @Before
    public void setUp() throws Exception {
        MockLogAppender.setupLogging();
        this.m_mNetwork = new MockNetwork();
        this.m_mNetwork.addNode(1, "Router");
        this.m_mNetwork.addInterface("192.168.1.1");
        this.m_mNetwork.addService("ICMP");
        this.m_mNetwork.addService("SMTP");
        this.m_mNetwork.addInterface("192.168.1.2");
        this.m_mNetwork.addService("ICMP");
        this.m_mNetwork.addService("SMTP");
        this.m_mNetwork.addNode(2, "Server");
        this.m_mNetwork.addInterface("192.168.1.3");
        this.m_mNetwork.addService("ICMP");
        this.m_mNetwork.addService("HTTP");
        this.m_mNetwork.addNode(3, "Firewall");
        this.m_mNetwork.addInterface("192.168.1.4");
        this.m_mNetwork.addService("SMTP");
        this.m_mNetwork.addService("HTTP");
        this.m_mNetwork.addInterface("192.168.1.5");
        this.m_mNetwork.addService("SMTP");
        this.m_mNetwork.addService("HTTP");
        this.m_mSvc = this.m_mNetwork.getService(1, "192.168.1.1", "ICMP");
        this.m_db.populate(this.m_mNetwork);
        this.m_pollerConfig = new MockPollerConfig(this.m_mNetwork);
        this.m_pollerConfig.setNodeOutageProcessingEnabled(true);
        this.m_pollerConfig.setCriticalService("ICMP");
        this.m_pollerConfig.addPackage("TestPackage");
        this.m_pollerConfig.addDowntime(1000L, 0L, -1L, false);
        this.m_pollerConfig.setDefaultPollInterval(1000L);
        this.m_pollerConfig.populatePackage(this.m_mNetwork, new MockService[0]);
        this.m_pollerConfig.addPackage("TestPkg2");
        this.m_pollerConfig.addDowntime(1000L, 0L, -1L, false);
        this.m_pollerConfig.setDefaultPollInterval(2000L);
        this.m_pollerConfig.addService(this.m_mNetwork.getService(2, "192.168.1.3", "HTTP"));
        this.m_pollerConfig.setNextOutageIdSql(this.m_db.getNextOutageIdStatement());
        this.m_outageAnticipator = new OutageAnticipator(this.m_db);
        this.m_eventMgr = new MockEventIpcManager();
        this.m_eventMgr.setEventWriter((EventWriter)this.m_db);
        this.m_eventMgr.addEventListener((EventListener)this.m_outageAnticipator);
        this.m_locationAwarePingClient = (LocationAwarePingClient)Mockito.mock(LocationAwarePingClient.class);
        this.m_pollContext = new DefaultPollContext();
        this.m_pollContext.setEventManager((EventIpcManager)this.m_eventMgr);
        this.m_pollContext.setLocalHostName("localhost");
        this.m_pollContext.setName("PollContextTest.DefaultPollContext");
        this.m_pollContext.setPollerConfig((PollerConfig)this.m_pollerConfig);
        this.m_pollContext.setQueryManager(this.m_queryManager);
        this.m_pollContext.setLocationAwarePingClient(this.m_locationAwarePingClient);
        this.m_pNetwork = new PollableNetwork((PollContext)this.m_pollContext);
        this.m_pSvc = this.m_pNetwork.createService(1, "Router", null, InetAddressUtils.addr((String)"192.168.1.1"), "ICMP");
    }

    @Test
    public void testGetCriticalServiceName() {
        Assert.assertEquals((Object)"ICMP", (Object)this.m_pollContext.getCriticalServiceName());
        this.m_pollerConfig.setCriticalService("HTTP");
        Assert.assertEquals((Object)"HTTP", (Object)this.m_pollContext.getCriticalServiceName());
    }

    @Test
    public void testIsNodeProcessingEnabled() {
        Assert.assertTrue((boolean)this.m_pollContext.isNodeProcessingEnabled());
        this.m_pollerConfig.setNodeOutageProcessingEnabled(false);
        Assert.assertFalse((boolean)this.m_pollContext.isNodeProcessingEnabled());
    }

    @Test
    public void testIsPollingAllIfCritServiceUndefined() {
        Assert.assertTrue((boolean)this.m_pollContext.isPollingAllIfCritServiceUndefined());
        this.m_pollerConfig.setPollAllIfNoCriticalServiceDefined(false);
        Assert.assertFalse((boolean)this.m_pollContext.isPollingAllIfCritServiceUndefined());
    }

    @Test
    public void testSendEvent() {
        this.m_eventMgr.getEventAnticipator().anticipateEvent(this.m_mSvc.createDownEvent());
        PollEvent e = this.m_pollContext.sendEvent(this.m_mSvc.createDownEvent());
        this.m_eventMgr.finishProcessingEvents();
        Assert.assertNotNull((Object)e);
        Assert.assertTrue((String)"Invalid Event Id", (e.getEventId() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.m_eventMgr.getEventAnticipator().waitForAnticipated(0L).size());
        Assert.assertEquals((long)0L, (long)this.m_eventMgr.getEventAnticipator().getUnanticipatedEvents().size());
    }

    @Test
    public void testCreateEvent() throws Exception {
        Date date = new Date(1222222222000L);
        Event nodeEvent = this.m_pollContext.createEvent("uei.opennms.org/nodes/nodeDown", 1, null, null, date, String.valueOf(2));
        Assert.assertEquals((Object)"uei.opennms.org/nodes/nodeDown", (Object)nodeEvent.getUei());
        Assert.assertEquals((Object)1L, (Object)nodeEvent.getNodeid());
        Assert.assertNull((Object)nodeEvent.getInterface());
        Assert.assertNull((Object)nodeEvent.getService());
        Assert.assertEquals((String)"Unexpected time for event", (Object)date, (Object)nodeEvent.getTime());
        Event ifEvent = this.m_pollContext.createEvent("uei.opennms.org/nodes/interfaceUp", 1, InetAddressUtils.addr((String)"192.168.1.1"), null, date, null);
        Assert.assertEquals((Object)"uei.opennms.org/nodes/interfaceUp", (Object)ifEvent.getUei());
        Assert.assertEquals((Object)1L, (Object)ifEvent.getNodeid());
        Assert.assertEquals((Object)"192.168.1.1", (Object)ifEvent.getInterface());
        Assert.assertNull((Object)ifEvent.getService());
        Assert.assertEquals((String)"Unexpected time for event", (Object)date, (Object)ifEvent.getTime());
        Event svcEvent = this.m_pollContext.createEvent("uei.opennms.org/nodes/nodeGainedService", 1, InetAddressUtils.addr((String)"192.168.1.1"), "ICMP", date, null);
        Assert.assertEquals((Object)"uei.opennms.org/nodes/nodeGainedService", (Object)svcEvent.getUei());
        Assert.assertEquals((Object)1L, (Object)svcEvent.getNodeid());
        Assert.assertEquals((Object)"192.168.1.1", (Object)svcEvent.getInterface());
        Assert.assertEquals((Object)"ICMP", (Object)svcEvent.getService());
        Assert.assertEquals((String)"Unexpected time for event", (Object)date, (Object)svcEvent.getTime());
    }

    @Test
    public void testOpenResolveOutage() throws Exception {
        Event downEvent = this.m_mSvc.createDownEvent();
        this.m_outageAnticipator.anticipateOutageOpened((MockElement)this.m_mSvc, downEvent);
        PollEvent pollDownEvent = this.m_pollContext.sendEvent(downEvent);
        this.m_pollContext.openOutage(this.m_pSvc, pollDownEvent);
        this.verifyOutages();
        this.m_outageAnticipator.reset();
        Event upEvent = this.m_mSvc.createUpEvent();
        this.m_outageAnticipator.anticipateOutageClosed((MockElement)this.m_mSvc, upEvent);
        PollEvent pollUpEvent = this.m_pollContext.sendEvent(upEvent);
        this.m_pollContext.resolveOutage(this.m_pSvc, pollUpEvent);
        this.verifyOutages();
        Event downEvent2 = this.m_mSvc.createDownEvent();
        this.m_outageAnticipator.anticipateOutageOpened((MockElement)this.m_mSvc, downEvent2);
        PollEvent pollDownEvent2 = this.m_pollContext.sendEvent(downEvent2);
        this.m_pollContext.openOutage(this.m_pSvc, pollDownEvent2);
        this.verifyOutages();
        this.m_outageAnticipator.reset();
        Event upEvent2 = this.m_mSvc.createUpEvent();
        this.m_outageAnticipator.anticipateOutageClosed((MockElement)this.m_mSvc, upEvent2);
        PollEvent pollUpEvent2 = this.m_pollContext.sendEvent(upEvent2);
        this.m_pollContext.resolveOutage(this.m_pSvc, pollUpEvent2);
        this.verifyOutages();
    }

    private void verifyOutages() {
        this.m_eventMgr.finishProcessingEvents();
        Assert.assertEquals((String)"Wrong number of outages opened", (long)this.m_outageAnticipator.getExpectedOpens(), (long)this.m_outageAnticipator.getActualOpens());
        Assert.assertEquals((String)"Wrong number of outages in outage table", (long)this.m_outageAnticipator.getExpectedOutages(), (long)this.m_outageAnticipator.getActualOutages());
        Assert.assertTrue((String)"Created outages don't match the expected outages", (boolean)this.m_outageAnticipator.checkAnticipated());
    }

    @Test
    public void testIsServiceUnresponsiveEnabled() {
        Assert.assertFalse((boolean)this.m_pollContext.isServiceUnresponsiveEnabled());
        this.m_pollerConfig.setServiceUnresponsiveEnabled(true);
        Assert.assertTrue((boolean)this.m_pollContext.isServiceUnresponsiveEnabled());
    }

    @Test
    public void testGetNodeServices() {
        boolean foundIt;
        List services = this.m_queryManager.getNodeServices(1);
        Assert.assertEquals((long)4L, (long)services.size());
        for (String[] findMe : new String[][]{{"192.168.1.1", "ICMP"}, {"192.168.1.1", "SMTP"}, {"192.168.1.2", "ICMP"}, {"192.168.1.2", "SMTP"}}) {
            foundIt = false;
            for (String[] service : services) {
                if (!service[0].equals(findMe[0]) || !service[1].equals(findMe[1])) continue;
                foundIt = true;
                break;
            }
            if (foundIt) continue;
            Assert.fail((String)("Could not find service: " + findMe[0] + " " + findMe[1]));
        }
        services = this.m_queryManager.getNodeServices(2);
        Assert.assertEquals((long)2L, (long)services.size());
        for (String[] findMe : new String[][]{{"192.168.1.3", "ICMP"}, {"192.168.1.3", "HTTP"}}) {
            foundIt = false;
            for (String[] service : services) {
                if (!service[0].equals(findMe[0]) || !service[1].equals(findMe[1])) continue;
                foundIt = true;
                break;
            }
            if (foundIt) continue;
            Assert.fail((String)("Could not find service: " + findMe[0] + " " + findMe[1]));
        }
        services = this.m_queryManager.getNodeServices(3);
        Assert.assertEquals((long)4L, (long)services.size());
        for (String[] findMe : new String[][]{{"192.168.1.4", "HTTP"}, {"192.168.1.4", "SMTP"}, {"192.168.1.5", "HTTP"}, {"192.168.1.5", "SMTP"}}) {
            foundIt = false;
            for (String[] service : services) {
                if (!service[0].equals(findMe[0]) || !service[1].equals(findMe[1])) continue;
                foundIt = true;
                break;
            }
            if (foundIt) continue;
            Assert.fail((String)("Could not find service: " + findMe[0] + " " + findMe[1]));
        }
    }

    @Test
    public void testPathOutages() throws Exception {
        Assert.assertNotNull((Object)this.m_nodeDao);
        Assert.assertNotNull((Object)this.m_pathOutageDao);
        Assert.assertNotNull((Object)this.m_pathOutageManager);
        OnmsNode node = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(1));
        Assert.assertNotNull((Object)node);
        OnmsPathOutage pathOutage = new OnmsPathOutage(node, InetAddressUtils.addr((String)"169.254.0.1"), "ICMP");
        this.m_pathOutageDao.save((Object)pathOutage);
        this.m_pathOutageDao.flush();
        this.m_pollerConfig.setPathOutageEnabled(true);
        CriticalPath path = this.m_pathOutageManager.getCriticalPath(1);
        Assert.assertEquals((Object)InetAddrUtils.addr((String)"169.254.0.1"), (Object)path.getIpAddress());
        Event nodeEvent = this.m_pollContext.createEvent("uei.opennms.org/nodes/nodeDown", 1, null, null, new Date(), String.valueOf(2));
        Assert.assertNotNull((Object)nodeEvent);
        Assert.assertEquals((Object)"169.254.0.1", (Object)nodeEvent.getParm("criticalPathIp").getValue().getContent());
        Assert.assertEquals((Object)"pathOutage", (Object)nodeEvent.getParm("eventReason").getValue().getContent());
    }
}

