/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.core.test.db.TemporaryDatabaseAware;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.dao.api.CriticalPath;
import org.opennms.netmgt.dao.api.PathOutageManager;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockPollerConfig;
import org.opennms.netmgt.mock.MockService;
import org.opennms.netmgt.poller.DefaultPollContext;
import org.opennms.netmgt.poller.QueryManager;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.test.mock.MockUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-pollerdTest.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(tempDbClass=MockDatabase.class, reuseDatabase=false)
public class PathOutageManagerDaoIT
implements TemporaryDatabaseAware<MockDatabase> {
    private MockNetwork m_network;
    private MockDatabase m_db;
    private MockPollerConfig m_pollerConfig;
    @Autowired
    private QueryManager m_queryManager;
    @Autowired
    private PathOutageManager m_pathOutageManager;

    protected PathOutageManager getPathOutageManager() {
        return this.m_pathOutageManager;
    }

    public void setTemporaryDatabase(MockDatabase database) {
        this.m_db = database;
    }

    @Before
    public void setUp() throws Exception {
        MockUtil.println((String)"------------ Begin Test  --------------------------");
        MockLogAppender.setupLogging();
        this.m_network = new MockNetwork();
        this.m_network.setCriticalService("ICMP");
        this.m_network.addNode(1, "Router");
        this.m_network.addInterface("192.168.1.1");
        this.m_network.addService("ICMP");
        this.m_network.addPathOutage(1, InetAddressUtils.addr((String)"192.168.1.1"), "ICMP");
        this.m_network.addService("SMTP");
        this.m_network.addService("SNMP");
        this.m_network.addInterface("192.168.1.2");
        this.m_network.addService("ICMP");
        this.m_network.addService("SMTP");
        this.m_network.addNode(2, "Server");
        this.m_network.addInterface("192.168.1.3");
        this.m_network.addService("ICMP");
        this.m_network.addService("HTTP");
        this.m_network.addService("SMTP");
        this.m_network.addService("SNMP");
        this.m_network.addNode(3, "Firewall");
        this.m_network.addInterface("192.168.1.4");
        this.m_network.addService("SMTP");
        this.m_network.addPathOutage(3, InetAddressUtils.addr((String)"192.168.1.4"), "SMTP");
        this.m_network.addService("HTTP");
        this.m_network.addInterface("192.168.1.5");
        this.m_network.addService("SMTP");
        this.m_network.addService("HTTP");
        this.m_network.addNode(4, "DownNode");
        this.m_network.addInterface("192.168.1.6");
        this.m_network.addService("SNMP");
        this.m_db.populate(this.m_network);
        DataSourceFactory.setInstance((DataSource)this.m_db);
        this.m_pollerConfig = new MockPollerConfig(this.m_network);
        this.m_pollerConfig.setNextOutageIdSql(this.m_db.getNextOutageIdStatement());
        this.m_pollerConfig.setNodeOutageProcessingEnabled(true);
        this.m_pollerConfig.setCriticalService("ICMP");
        this.m_pollerConfig.addPackage("TestPackage");
        this.m_pollerConfig.addDowntime(1000L, 0L, -1L, false);
        this.m_pollerConfig.setDefaultPollInterval(1000L);
        this.m_pollerConfig.populatePackage(this.m_network, new MockService[0]);
        this.m_pollerConfig.addPackage("TestPkg2");
        this.m_pollerConfig.addDowntime(1000L, 0L, -1L, false);
        this.m_pollerConfig.setDefaultPollInterval(2000L);
        this.m_pollerConfig.addService(this.m_network.getService(2, "192.168.1.3", "HTTP"));
        DefaultPollContext pollContext = new DefaultPollContext();
        pollContext.setLocalHostName("localhost");
        pollContext.setName("Test.DefaultPollContext");
        pollContext.setPollerConfig((PollerConfig)this.m_pollerConfig);
        pollContext.setQueryManager(this.m_queryManager);
    }

    @After
    public void tearDown() throws Exception {
        PathOutageManagerDaoIT.sleep(200L);
        MockUtil.println((String)"------------ End Test  --------------------------");
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void test() throws SQLException, UnknownHostException {
        Connection conn = this.m_db.getConnection();
        String[] ar = this.getPathOutageManager().getLabelAndStatus("1", conn);
        Assert.assertEquals((Object)"Router", (Object)ar[0]);
        Assert.assertEquals((Object)"Normal", (Object)ar[1]);
        Assert.assertEquals((Object)"All Services Up", (Object)ar[2]);
        String[] cr = this.getPathOutageManager().getLabelAndStatus("3", conn);
        Assert.assertEquals((Object)"Firewall", (Object)cr[0]);
        Assert.assertEquals((Object)"Normal", (Object)cr[1]);
        Assert.assertEquals((Object)"All Services Up", (Object)cr[2]);
        Set lno = this.getPathOutageManager().getNodesInPath("192.168.1.1", "ICMP");
        Assert.assertEquals((Object)new Integer(1), lno.iterator().next());
        Set vno = this.getPathOutageManager().getNodesInPath("192.168.1.4", "SMTP");
        Assert.assertEquals((Object)new Integer(3), vno.iterator().next());
        List all = this.getPathOutageManager().getAllCriticalPaths();
        Assert.assertEquals((long)2L, (long)all.size());
        Assert.assertEquals((Object)"Firewall", (Object)((String[])all.get(0))[0]);
        Assert.assertEquals((Object)"192.168.1.4", (Object)((String[])all.get(0))[1]);
        Assert.assertEquals((Object)"SMTP", (Object)((String[])all.get(0))[2]);
        Assert.assertEquals((Object)"Router", (Object)((String[])all.get(1))[0]);
        Assert.assertEquals((Object)"192.168.1.1", (Object)((String[])all.get(1))[1]);
        Assert.assertEquals((Object)"ICMP", (Object)((String[])all.get(1))[2]);
        String[] dat = this.getPathOutageManager().getCriticalPathData("192.168.1.1", "ICMP");
        Assert.assertEquals((Object)"Router", (Object)dat[0]);
        Assert.assertEquals((Object)"1", (Object)dat[1]);
        Assert.assertEquals((Object)"1", (Object)dat[2]);
        Assert.assertEquals((Object)"Normal", (Object)dat[3]);
        String mm = this.getPathOutageManager().getPrettyCriticalPath(1);
        Assert.assertEquals((Object)"192.168.1.1 ICMP", (Object)mm);
        String nn = this.getPathOutageManager().getPrettyCriticalPath(3);
        Assert.assertEquals((Object)"192.168.1.4 SMTP", (Object)nn);
        CriticalPath pa = this.getPathOutageManager().getCriticalPath(1);
        Assert.assertEquals((Object)InetAddress.getByName("192.168.1.1"), (Object)pa.getIpAddress());
        Assert.assertEquals((Object)"ICMP", (Object)pa.getServiceName());
        CriticalPath nc = this.getPathOutageManager().getCriticalPath(3);
        Assert.assertEquals((Object)InetAddress.getByName("192.168.1.4"), (Object)nc.getIpAddress());
        Assert.assertEquals((Object)"SMTP", (Object)nc.getServiceName());
        Set test = this.getPathOutageManager().getAllNodesDependentOnAnyServiceOnInterface("192.168.1.1");
        Assert.assertEquals((long)1L, (long)test.size());
        Set less = this.getPathOutageManager().getAllNodesDependentOnAnyServiceOnNode(3);
        Assert.assertEquals((long)1L, (long)less.size());
        conn.close();
    }

    @Ignore
    @Test
    public void testMethod500Times() throws SQLException, UnknownHostException {
        for (int i = 0; i < 500; ++i) {
            this.test();
        }
    }
}

