/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.util.ArrayList;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.test.http.JUnitHttpServerExecutionListener;
import org.opennms.core.test.http.annotations.JUnitHttpServer;
import org.opennms.core.test.http.annotations.Webapp;
import org.opennms.netmgt.model.notifd.Argument;
import org.opennms.netmgt.notifd.MattermostNotificationStrategy;
import org.opennms.netmgt.notifd.MattermostNotificationStrategyTestServlet;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-mockDao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class MattermostNotificationStrategyIT {
    @Test
    @JUnitHttpServer(webapps={@Webapp(context="/hooks", path="src/test/resources/MattermostNotificationStrategyTest")})
    public void testSendValidJustArgs() {
        int port = JUnitHttpServerExecutionListener.getPort();
        Assert.assertTrue((port > 0 ? 1 : 0) != 0);
        try {
            MattermostNotificationStrategy ns = new MattermostNotificationStrategy();
            ArrayList<Argument> arguments = new ArrayList<Argument>();
            System.setProperty("org.opennms.netmgt.notifd.mattermost.webhookURL", "http://localhost:" + port + "/hooks/abunchofstuffthatidentifiesawebhook");
            System.setProperty("org.opennms.netmgt.notifd.mattermost.channel", "integrationtestsXX");
            System.setProperty("org.opennms.netmgt.notifd.mattermost.iconURL", "http://opennms.org/logo.pngXX");
            System.setProperty("org.opennms.netmgt.notifd.mattermost.iconEmoji", ":shipitXX:");
            System.setProperty("org.opennms.netmgt.notifd.mattermost.username", "opennmsXX");
            arguments.add(new Argument("url", null, "http://localhost:" + port + "/hooks/abunchofstuffthatidentifiesawebhook", false));
            arguments.add(new Argument("channel", null, "integrationtests", false));
            arguments.add(new Argument("username", null, "opennms", false));
            arguments.add(new Argument("iconurl", null, "http://opennms.org/logo.png", false));
            arguments.add(new Argument("iconemoji", null, ":shipit:", false));
            arguments.add(new Argument("-subject", null, "Test", false));
            arguments.add(new Argument("-tm", null, "This is only a test", false));
            int statusCode = ns.send(arguments);
            Assert.assertEquals((long)0L, (long)statusCode);
            JSONObject inputJson = MattermostNotificationStrategyTestServlet.getInputJson();
            Assert.assertNotNull((Object)inputJson);
            Assert.assertEquals((Object)"opennms", (Object)inputJson.get((Object)"username"));
            Assert.assertEquals((Object)"#### Test\nThis is only a test", (Object)inputJson.get((Object)"text"));
            Assert.assertEquals((Object)"integrationtests", (Object)inputJson.get((Object)"channel"));
            Assert.assertEquals((Object)"http://opennms.org/logo.png", (Object)inputJson.get((Object)"icon_url"));
            Assert.assertEquals((Object)":shipit:", (Object)inputJson.get((Object)"icon_emoji"));
            Assert.assertEquals((long)5L, (long)inputJson.size());
            arguments.clear();
            arguments.add(new Argument("-subject", null, "Test again", false));
            arguments.add(new Argument("-tm", null, "This is only a second test", false));
            statusCode = ns.send(arguments);
            Assert.assertEquals((long)0L, (long)statusCode);
            inputJson = MattermostNotificationStrategyTestServlet.getInputJson();
            Assert.assertNotNull((Object)inputJson);
            Assert.assertEquals((Object)"opennmsXX", (Object)inputJson.get((Object)"username"));
            Assert.assertEquals((Object)"#### Test again\nThis is only a second test", (Object)inputJson.get((Object)"text"));
            Assert.assertEquals((Object)"integrationtestsXX", (Object)inputJson.get((Object)"channel"));
            Assert.assertEquals((Object)"http://opennms.org/logo.pngXX", (Object)inputJson.get((Object)"icon_url"));
            Assert.assertEquals((Object)":shipitXX:", (Object)inputJson.get((Object)"icon_emoji"));
            Assert.assertEquals((long)5L, (long)inputJson.size());
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.fail((String)("Caught Exception: " + e.getMessage()));
        }
    }
}

