/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.model.notifd.Argument;
import org.opennms.netmgt.notifd.BSFNotificationStrategy;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-notifdTest.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class BSFNotificationStrategyIT {
    private BSFNotificationStrategy bsfNotificationStrategy = new BSFNotificationStrategy();
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    @Autowired
    private DatabasePopulator databasePopulator;

    @Before
    public void setUp() {
        MockLogAppender.setupLogging();
        this.databasePopulator.populateDatabase();
    }

    @After
    public void tearDown() {
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    public void canUseNodeInScript() throws IOException {
        File notifyBsh = this.tempFolder.newFile("notify.bsh");
        FileUtils.write((File)notifyBsh, (CharSequence)"results.put(\"status\", node.id == 1 ? \"OK\" : \"NOT_OK\");");
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        arguments.add(new Argument("file-name", null, notifyBsh.getAbsolutePath(), false));
        arguments.add(new Argument("-nodeid", null, "1", false));
        Assert.assertEquals((long)0L, (long)this.bsfNotificationStrategy.send(arguments));
    }
}

