/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.nb;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.opennms.netmgt.dao.api.IpNetToMediaDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.IpNetToMedia;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.nb.NmsNetworkBuilder;

public class Nms4930NetworkBuilder
extends NmsNetworkBuilder {
    NodeDao m_nodeDao;
    IpNetToMediaDao m_ipNetToMediaDao;

    public void addMacNodeWithSnmpInterface(String mac, String ip, Integer ifindex) {
        NetworkBuilder nb = this.getNetworkBuilder();
        nb.addNode(ip).setForeignSource("linkd").setForeignId(ip).setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface(ip).setIsSnmpPrimary("N").setIsManaged("M").addSnmpInterface(ifindex.intValue()).setIfName("eth0").setIfType(Integer.valueOf(6)).setPhysAddr(mac).setIfDescr("eth0");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        this.m_nodeDao.flush();
        IpNetToMedia at0 = new IpNetToMedia();
        at0.setSourceIfIndex(Integer.valueOf(100));
        at0.setPhysAddress(mac);
        at0.setLastPollTime(at0.getCreateTime());
        at0.setSourceNode(this.m_nodeDao.findByForeignId("linkd", ip));
        try {
            at0.setNetAddress(InetAddress.getByName(ip));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        at0.setIpNetToMediaType(IpNetToMedia.IpNetToMediaType.IPNETTOMEDIA_TYPE_DYNAMIC);
        this.m_ipNetToMediaDao.saveOrUpdate((Object)at0);
        this.m_ipNetToMediaDao.flush();
    }

    public void addMacNode(String mac, String ip) {
        NetworkBuilder nb = this.getNetworkBuilder();
        nb.addNode(ip).setForeignSource("linkd").setForeignId(ip).setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface(ip).setIsSnmpPrimary("N").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        this.m_nodeDao.flush();
        IpNetToMedia at0 = new IpNetToMedia();
        at0.setSourceIfIndex(Integer.valueOf(100));
        at0.setPhysAddress(mac);
        at0.setLastPollTime(at0.getCreateTime());
        at0.setSourceNode(this.m_nodeDao.findByForeignId("linkd", ip));
        try {
            at0.setNetAddress(InetAddress.getByName(ip));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        at0.setIpNetToMediaType(IpNetToMedia.IpNetToMediaType.IPNETTOMEDIA_TYPE_DYNAMIC);
        this.m_ipNetToMediaDao.saveOrUpdate((Object)at0);
        this.m_ipNetToMediaDao.flush();
    }

    public void buildNetwork4930() {
        NetworkBuilder nb = this.getNetworkBuilder();
        nb.addNode("dlink1").setForeignSource("linkd").setForeignId("dlink1").setSysObjectId(".1.3.6.1.4.1.9.1.122").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.1.1.2").setIsSnmpPrimary("P").setIsManaged("M").addSnmpInterface(3).setIfType(Integer.valueOf(6)).setCollectionEnabled(true).setIfSpeed(100000000L).setPhysAddr("c2007db90010");
        nb.addInterface("10.1.2.1").setIsSnmpPrimary("S").setIsManaged("M").addSnmpInterface(1).setIfType(Integer.valueOf(6)).setCollectionEnabled(true).setIfSpeed(100000000L).setPhysAddr("c2007db90000");
        nb.addInterface("10.1.3.1").setIsSnmpPrimary("S").setIsManaged("M").addSnmpInterface(2).setIfType(Integer.valueOf(6)).setCollectionEnabled(true).setIfSpeed(100000000L).setPhysAddr("c2007db90001");
        nb.addSnmpInterface(24).setIfType(Integer.valueOf(6)).setIfName("Fa0/24").setIfSpeed(100000000L);
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("dlink2").setForeignSource("linkd").setForeignId("dlink2").setSysObjectId(".1.3.6.1.4.1.9.1.122").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.1.2.2").setIsSnmpPrimary("P").setIsManaged("M").addSnmpInterface(1).setIfType(Integer.valueOf(6)).setCollectionEnabled(true).setIfSpeed(100000000L).setPhysAddr("c2017db90000");
        nb.addInterface("10.1.5.1").setIsSnmpPrimary("S").setIsManaged("M").addSnmpInterface(2).setIfType(Integer.valueOf(6)).setCollectionEnabled(true).setIfSpeed(100000000L).setPhysAddr("c2017db90001");
        nb.addSnmpInterface(10).setIfType(Integer.valueOf(6)).setIfName("FastEthernet0/10").setIfSpeed(100000000L);
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        this.m_nodeDao.flush();
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public IpNetToMediaDao getIpNetToMediaDao() {
        return this.m_ipNetToMediaDao;
    }

    public void setIpNetToMediaDao(IpNetToMediaDao ipNetToMediaDao) {
        this.m_ipNetToMediaDao = ipNetToMediaDao;
    }
}

