/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.enlinkd.EnLinkdBuilderITCase;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.IpNetToMedia;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.nb.Nms4930NetworkBuilder;

public class Nms4930EnIT
extends EnLinkdBuilderITCase {
    Nms4930NetworkBuilder builder = new Nms4930NetworkBuilder();
    String[] macsonbbport = new String[]{"001e58a6aed7", "00265abd0b08", "1caff72905d8", "1caff702cffd", "00e0d8107c0c", "001562cae2cf", "001cf0d18441", "001e58a31b47"};
    String[] macofdlink1onbbport = new String[]{"001cf0c7b1a7", "1caff702cffd", "2c27d7e7cc9d", "00265aac671e", "00169d46fe1a", "00192f0fce19", "00270e0a788a", "001e58a6aed7", "1c6f65b3599a", "1caff702d055", "1caff72905d8", "1caff763d385", "001de5a4604a", "00804834ccff", "001b11ea9133", "001cf0d18441", "001cf0d1843f", "001562cae2cf", "000c29dcc076", "f07d68711f89", "f07d6876c565", "001a81001978", "00265abd0b08", "001349fb1db4", "001e58a31b47", "001a4d8b168e", "0013774b4ab2", "00e0d8107c0c", "000f90223a1a", "00c0266a1d1d"};

    @Before
    public void setUpNetwork4930() throws Exception {
        this.builder.setNodeDao(this.m_nodeDao);
        this.builder.setIpNetToMediaDao(this.m_ipNetToMediaDao);
        this.builder.buildNetwork4930();
        this.builder.addMacNodeWithSnmpInterface("001e58a6aed7", "10.100.1.7", 101);
        this.builder.addMacNode("000ffeb10e26", "10.100.2.6");
        Assert.assertEquals((long)4L, (long)this.m_nodeDao.countAll());
        Assert.assertEquals((long)2L, (long)this.m_ipNetToMediaDao.countAll());
        IpNetToMedia at0 = (IpNetToMedia)this.m_ipNetToMediaDao.findByPhysAddress("001e58a6aed7").get(0);
        Assert.assertNotNull((Object)at0);
        Assert.assertEquals((Object)"10.100.1.7", (Object)at0.getNetAddress().getHostAddress());
        IpNetToMedia at1 = (IpNetToMedia)this.m_ipNetToMediaDao.findByPhysAddress("000ffeb10e26").get(0);
        Assert.assertNotNull((Object)at1);
        Assert.assertEquals((Object)"10.100.2.6", (Object)at1.getNetAddress().getHostAddress());
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:linkd/nms4930/dlink_DES-3026.properties")})
    public void testNms4930Bft() throws Exception {
        OnmsNode dlink1 = this.m_nodeDao.findByForeignId("linkd", "dlink1");
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(dlink1.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(dlink1.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        List links = this.m_linkd.getQueryManager().useBridgeTopologyUpdateBFT(dlink1.getId().intValue());
        Assert.assertEquals((long)59L, (long)links.size());
        for (BridgeMacLink link : links) {
            System.err.println(link.printTopology());
            if (BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_SELF == link.getBridgeDot1qTpFdbStatus()) continue;
            Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
            link.setBridgeMacLinkLastPollTime(link.getBridgeMacLinkCreateTime());
            this.m_bridgeMacLinkDao.save((Object)link);
        }
        Assert.assertEquals((long)58L, (long)this.m_bridgeMacLinkDao.countAll());
        for (BridgeMacLink maclink : this.m_bridgeMacLinkDao.findAll()) {
            Assert.assertEquals(null, (Object)maclink.getBridgeDot1qTpFdbStatus());
            Assert.assertNotNull((Object)maclink.getBridgePortIfIndex());
            Assert.assertNotNull((Object)maclink.getBridgePort());
            Assert.assertNotNull((Object)maclink.getNode());
            Assert.assertNotNull((Object)maclink.getMacAddress());
            System.err.println(maclink.printTopology());
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:linkd/nms4930/dlink_DES-3026.properties"), @JUnitSnmpAgent(host="10.1.2.2", port=161, resource="classpath:linkd/nms4930/dlink_DGS-3612G.properties")})
    public void testNms4930Network() throws Exception {
        OnmsNode dlink1 = this.m_nodeDao.findByForeignId("linkd", "dlink1");
        OnmsNode dlink2 = this.m_nodeDao.findByForeignId("linkd", "dlink2");
        OnmsNode nodebetweendlink1dlink2 = this.m_nodeDao.findByForeignId("linkd", "10.100.1.7");
        OnmsNode nodeonlink1dport6 = this.m_nodeDao.findByForeignId("linkd", "10.100.2.6");
        Assert.assertNotNull((Object)nodebetweendlink1dlink2);
        Assert.assertNotNull((Object)nodeonlink1dport6);
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(dlink1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(dlink2.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(dlink1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runTopologyDiscovery(dlink1.getId().intValue()));
        this.checkTopologyDlink1(dlink1);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(dlink2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runTopologyDiscovery(dlink2.getId().intValue()));
        this.checkTopology(dlink1, dlink2, nodeonlink1dport6, nodebetweendlink1dlink2);
    }

    private void checkTopologyDlink1(OnmsNode dlink1) {
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)1L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(1)).size());
        Assert.assertEquals((long)2L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(2)).size());
        Assert.assertEquals((long)1L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(3)).size());
        Assert.assertEquals((long)8L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(4)).size());
        Assert.assertEquals((long)2L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(5)).size());
        Assert.assertEquals((long)14L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(6)).size());
        Assert.assertEquals((long)30L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(24)).size());
        Assert.assertEquals((long)58L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertEquals((long)2L, (long)this.m_bridgeMacLinkDao.getAllBridgeLinksToIpAddrToNodes().size());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.getAllBridgeLinksToBridgeNodes().size());
        for (BridgeMacLink maclink : this.m_bridgeMacLinkDao.findAll()) {
            Assert.assertEquals(null, (Object)maclink.getBridgeDot1qTpFdbStatus());
            Assert.assertNotNull((Object)maclink.getBridgePortIfIndex());
            Assert.assertNotNull((Object)maclink.getBridgePort());
            Assert.assertNotNull((Object)maclink.getNode());
            Assert.assertNotNull((Object)maclink.getMacAddress());
        }
    }

    private void checkTopology(OnmsNode dlink1, OnmsNode dlink2, OnmsNode nodeonlink1dport6, OnmsNode nodebetweendlink1dlink2) {
        Assert.assertEquals((long)1L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(1)).size());
        Assert.assertEquals((long)2L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(2)).size());
        Assert.assertEquals((long)1L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(3)).size());
        Assert.assertEquals((long)8L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(4)).size());
        Assert.assertEquals((long)2L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(5)).size());
        Assert.assertEquals((long)14L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(6)).size());
        Assert.assertEquals((long)35L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(1)).size());
        Assert.assertEquals((long)71L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(2)).size());
        Assert.assertEquals((long)29L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(3)).size());
        Assert.assertEquals((long)142L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(5)).size());
        Assert.assertEquals((long)47L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(6)).size());
        Assert.assertEquals((long)5L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(7)).size());
        Assert.assertEquals((long)123L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(8)).size());
        Assert.assertEquals((long)163L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(12)).size());
        Assert.assertEquals((long)8L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink1.getId(), Integer.valueOf(24)).size());
        Assert.assertEquals((long)8L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(10)).size());
        Assert.assertEquals((long)1L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)659L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertEquals((long)3L, (long)this.m_bridgeMacLinkDao.getAllBridgeLinksToIpAddrToNodes().size());
        Assert.assertEquals((long)8L, (long)this.m_bridgeMacLinkDao.getAllBridgeLinksToBridgeNodes().size());
        for (BridgeMacLink link : this.m_bridgeMacLinkDao.findAll()) {
            Assert.assertNotNull((Object)link.getNode());
            Assert.assertNotNull((Object)link.getBridgePort());
            Assert.assertNotNull((Object)link.getBridgePortIfIndex());
            Assert.assertNotNull((Object)link.getMacAddress());
            Assert.assertEquals(null, (Object)link.getBridgeDot1qTpFdbStatus());
        }
        for (BridgeMacLink link : this.m_bridgeMacLinkDao.getAllBridgeLinksToIpAddrToNodes()) {
            Assert.assertNotNull((Object)link.getSrcNodeId());
            Assert.assertNotNull((Object)link.getBridgePort());
            Assert.assertNotNull((Object)link.getBridgePortIfIndex());
            Assert.assertNotNull((Object)link.getTargetNodeId());
            Assert.assertNotNull((Object)link.getMacAddr());
            Assert.assertNotNull((Object)link.getTargetPortIfName());
            if (link.getSrcNodeId().intValue() == dlink1.getId().intValue()) {
                if (link.getBridgePort() == 6) {
                    Assert.assertEquals((long)link.getBridgePortIfIndex().intValue(), (long)6L);
                    Assert.assertEquals((long)link.getTargetNodeId().intValue(), (long)nodeonlink1dport6.getId().intValue());
                    Assert.assertEquals((Object)link.getMacAddr(), (Object)"000ffeb10e26");
                    Assert.assertEquals((Object)link.getTargetPortIfName(), (Object)"10.100.2.6");
                    Assert.assertEquals((Object)link.getTargetIfIndex(), null);
                    continue;
                }
                if (link.getBridgePort() == 24) {
                    Assert.assertEquals((long)link.getBridgePortIfIndex().intValue(), (long)24L);
                    Assert.assertEquals((long)link.getTargetNodeId().intValue(), (long)nodebetweendlink1dlink2.getId().intValue());
                    Assert.assertEquals((Object)link.getMacAddr(), (Object)"001e58a6aed7");
                    Assert.assertEquals((Object)link.getTargetPortIfName(), (Object)"10.100.1.7");
                    Assert.assertEquals((long)link.getTargetIfIndex().intValue(), (long)101L);
                    continue;
                }
                Assert.assertTrue((boolean)false);
                continue;
            }
            if (link.getSrcNodeId().intValue() == dlink2.getId().intValue()) {
                Assert.assertEquals((long)link.getBridgePortIfIndex().intValue(), (long)10L);
                Assert.assertEquals((long)link.getTargetNodeId().intValue(), (long)nodebetweendlink1dlink2.getId().intValue());
                Assert.assertEquals((Object)link.getMacAddr(), (Object)"001e58a6aed7");
                Assert.assertEquals((Object)link.getTargetPortIfName(), (Object)"10.100.1.7");
                Assert.assertEquals((long)link.getTargetIfIndex().intValue(), (long)101L);
                continue;
            }
            Assert.assertTrue((boolean)false);
        }
        for (BridgeMacLink link : this.m_bridgeMacLinkDao.getAllBridgeLinksToBridgeNodes()) {
            Assert.assertNotNull((Object)link.getSrcNodeId());
            Assert.assertNotNull((Object)link.getBridgePort());
            Assert.assertNotNull((Object)link.getBridgePortIfIndex());
            Assert.assertNotNull((Object)link.getTargetNodeId());
            Assert.assertNotNull((Object)link.getMacAddr());
            Assert.assertNotNull((Object)link.getTargetBridgePort());
            Assert.assertNotNull((Object)link.getTargetIfIndex());
            Assert.assertNotNull((Object)link.getTargetId());
            Assert.assertEquals((long)dlink1.getId().intValue(), (long)link.getSrcNodeId().intValue());
            Assert.assertEquals((long)dlink2.getId().intValue(), (long)link.getTargetNodeId().intValue());
        }
        for (String mac : this.macsonbbport) {
            List maclinks = this.m_bridgeMacLinkDao.findByMacAddress(mac);
            Assert.assertEquals((long)2L, (long)maclinks.size());
            Nms4930EnIT.printBackboneBridgeMacLink((BridgeMacLink)maclinks.get(0), (BridgeMacLink)maclinks.get(1));
        }
    }

    private void checkTopologyDlink2(OnmsNode dlink2) {
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)35L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(1)).size());
        Assert.assertEquals((long)71L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(2)).size());
        Assert.assertEquals((long)29L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(3)).size());
        Assert.assertEquals((long)142L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(5)).size());
        Assert.assertEquals((long)47L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(6)).size());
        Assert.assertEquals((long)5L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(7)).size());
        Assert.assertEquals((long)123L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(8)).size());
        Assert.assertEquals((long)362L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(10)).size());
        Assert.assertEquals((long)163L, (long)this.m_bridgeMacLinkDao.findByNodeIdBridgePort(dlink2.getId(), Integer.valueOf(12)).size());
        Assert.assertEquals((long)977L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertEquals((long)1L, (long)this.m_bridgeMacLinkDao.getAllBridgeLinksToIpAddrToNodes().size());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.getAllBridgeLinksToBridgeNodes().size());
        for (BridgeMacLink maclink : this.m_bridgeMacLinkDao.findAll()) {
            Assert.assertEquals(null, (Object)maclink.getBridgeDot1qTpFdbStatus());
            Assert.assertNotNull((Object)maclink.getBridgePortIfIndex());
            Assert.assertNotNull((Object)maclink.getBridgePort());
            Assert.assertNotNull((Object)maclink.getNode());
            Assert.assertNotNull((Object)maclink.getMacAddress());
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.1.1.2", port=161, resource="classpath:linkd/nms4930/dlink_DES-3026.properties"), @JUnitSnmpAgent(host="10.1.2.2", port=161, resource="classpath:linkd/nms4930/dlink_DGS-3612G.properties")})
    public void testNms4930NetworkReverse() throws Exception {
        OnmsNode dlink1 = this.m_nodeDao.findByForeignId("linkd", "dlink1");
        OnmsNode dlink2 = this.m_nodeDao.findByForeignId("linkd", "dlink2");
        OnmsNode nodebetweendlink1dlink2 = this.m_nodeDao.findByForeignId("linkd", "10.100.1.7");
        OnmsNode nodeonlink1dport6 = this.m_nodeDao.findByForeignId("linkd", "10.100.2.6");
        Assert.assertNotNull((Object)nodebetweendlink1dlink2);
        Assert.assertNotNull((Object)nodeonlink1dport6);
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useBridgeDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(dlink2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(dlink1.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(dlink2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runTopologyDiscovery(dlink2.getId().intValue()));
        this.checkTopologyDlink2(dlink2);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(dlink1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runTopologyDiscovery(dlink1.getId().intValue()));
        this.checkTopology(dlink1, dlink2, nodeonlink1dport6, nodebetweendlink1dlink2);
    }
}

