/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.enlinkd.EnLinkdBuilderITCase;
import org.opennms.netmgt.model.CdpLink;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OspfElement;
import org.opennms.netmgt.nb.Nms17216NetworkBuilder;
import org.opennms.netmgt.nb.NmsNetworkBuilder;

public class Nms17216EnIT
extends EnLinkdBuilderITCase {
    Nms17216NetworkBuilder builder = new Nms17216NetworkBuilder();

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:linkd/nms17216/switch1-walk.txt"), @JUnitSnmpAgent(host="172.16.10.2", port=161, resource="classpath:linkd/nms17216/switch2-walk.txt"), @JUnitSnmpAgent(host="172.16.10.3", port=161, resource="classpath:linkd/nms17216/switch3-walk.txt"), @JUnitSnmpAgent(host="172.16.50.2", port=161, resource="classpath:linkd/nms17216/switch4-walk.txt"), @JUnitSnmpAgent(host="172.16.10.4", port=161, resource="classpath:linkd/nms17216/switch5-walk.txt")})
    public void testNetwork17216LldpLinks() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getSwitch1());
        this.m_nodeDao.save((Object)this.builder.getSwitch2());
        this.m_nodeDao.save((Object)this.builder.getSwitch3());
        this.m_nodeDao.save((Object)this.builder.getSwitch4());
        this.m_nodeDao.save((Object)this.builder.getSwitch5());
        this.m_nodeDao.flush();
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        Assert.assertTrue((boolean)this.m_linkdConfig.useLldpDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useBridgeDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        OnmsNode switch1 = this.m_nodeDao.findByForeignId("linkd", "Switch1");
        OnmsNode switch2 = this.m_nodeDao.findByForeignId("linkd", "Switch2");
        OnmsNode switch3 = this.m_nodeDao.findByForeignId("linkd", "Switch3");
        OnmsNode switch4 = this.m_nodeDao.findByForeignId("linkd", "Switch4");
        OnmsNode switch5 = this.m_nodeDao.findByForeignId("linkd", "Switch5");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch3.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch4.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch5.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_lldpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch1.getId().intValue()));
        Assert.assertEquals((long)4L, (long)this.m_lldpLinkDao.countAll());
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch2.getId().intValue()));
        Assert.assertEquals((long)10L, (long)this.m_lldpLinkDao.countAll());
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch3.getId().intValue()));
        Assert.assertEquals((long)12L, (long)this.m_lldpLinkDao.countAll());
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch4.getId().intValue()));
        Assert.assertEquals((long)12L, (long)this.m_lldpLinkDao.countAll());
        Thread.sleep(1000L);
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch5.getId().intValue()));
        Assert.assertEquals((long)12L, (long)this.m_lldpLinkDao.countAll());
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            Assert.assertNotNull((Object)node.getLldpElement());
            Nms17216EnIT.printLldpElement(node.getLldpElement());
            Assert.assertEquals((Object)LldpUtils.LldpChassisIdSubType.LLDP_CHASSISID_SUBTYPE_MACADDRESS, (Object)node.getLldpElement().getLldpChassisIdSubType());
            if (node.getId().intValue() == switch1.getId().intValue()) {
                Assert.assertEquals((Object)"0016c8bd4d80", (Object)node.getLldpElement().getLldpChassisId());
                Assert.assertEquals((Object)"Switch1", (Object)node.getLldpElement().getLldpSysname());
                continue;
            }
            if (node.getId().intValue() == switch2.getId().intValue()) {
                Assert.assertEquals((Object)"0016c894aa80", (Object)node.getLldpElement().getLldpChassisId());
                Assert.assertEquals((Object)"Switch2", (Object)node.getLldpElement().getLldpSysname());
                continue;
            }
            if (node.getId().intValue() == switch3.getId().intValue()) {
                Assert.assertEquals((Object)"f4ea67ebdc00", (Object)node.getLldpElement().getLldpChassisId());
                Assert.assertEquals((Object)"Switch3", (Object)node.getLldpElement().getLldpSysname());
                continue;
            }
            if (node.getId().intValue() == switch4.getId().intValue()) {
                Assert.assertEquals((Object)"a4187504e400", (Object)node.getLldpElement().getLldpChassisId());
                Assert.assertEquals((Object)"Switch4", (Object)node.getLldpElement().getLldpSysname());
                continue;
            }
            if (node.getId().intValue() == switch5.getId().intValue()) {
                Assert.assertEquals((Object)"f4ea67f82980", (Object)node.getLldpElement().getLldpChassisId());
                Assert.assertEquals((Object)"Switch5", (Object)node.getLldpElement().getLldpSysname());
                continue;
            }
            Assert.assertTrue((boolean)false);
        }
        block19: for (LldpLink link : this.m_lldpLinkDao.findAll()) {
            Nms17216EnIT.printLldpLink(link);
            Assert.assertEquals((Object)LldpUtils.LldpChassisIdSubType.LLDP_CHASSISID_SUBTYPE_MACADDRESS, (Object)link.getLldpRemChassisIdSubType());
            Assert.assertEquals((Object)LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_INTERFACENAME, (Object)link.getLldpPortIdSubType());
            Assert.assertEquals((Object)LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_INTERFACENAME, (Object)link.getLldpRemPortIdSubType());
            Assert.assertNull((Object)link.getLldpPortIfindex());
            if (link.getNode().getId().intValue() == switch1.getId().intValue()) {
                Assert.assertEquals((Object)"0016c894aa80", (Object)link.getLldpRemChassisId());
                Assert.assertEquals((Object)"Switch2", (Object)link.getLldpRemSysname());
                switch (link.getLldpLocalPortNum()) {
                    case 9: {
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFNAME_MAP.get(10109), (Object)link.getLldpPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFDESCR_MAP.get(10109), (Object)link.getLldpPortDescr());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFNAME_MAP.get(10101), (Object)link.getLldpRemPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10101), (Object)link.getLldpRemPortDescr());
                        continue block19;
                    }
                    case 10: {
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFNAME_MAP.get(10110), (Object)link.getLldpPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFDESCR_MAP.get(10110), (Object)link.getLldpPortDescr());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFNAME_MAP.get(10102), (Object)link.getLldpRemPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10102), (Object)link.getLldpRemPortDescr());
                        continue block19;
                    }
                    case 11: {
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFNAME_MAP.get(10111), (Object)link.getLldpPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFDESCR_MAP.get(10111), (Object)link.getLldpPortDescr());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFNAME_MAP.get(10103), (Object)link.getLldpRemPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10103), (Object)link.getLldpRemPortDescr());
                        continue block19;
                    }
                    case 12: {
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFNAME_MAP.get(10112), (Object)link.getLldpPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFDESCR_MAP.get(10112), (Object)link.getLldpPortDescr());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFNAME_MAP.get(10104), (Object)link.getLldpRemPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10104), (Object)link.getLldpRemPortDescr());
                        continue block19;
                    }
                }
                Assert.assertTrue((boolean)false);
                continue;
            }
            if (link.getNode().getId().intValue() == switch2.getId().intValue()) {
                switch (link.getLldpLocalPortNum()) {
                    case 1: {
                        Assert.assertEquals((Object)"0016c8bd4d80", (Object)link.getLldpRemChassisId());
                        Assert.assertEquals((Object)"Switch1", (Object)link.getLldpRemSysname());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFNAME_MAP.get(10101), (Object)link.getLldpPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10101), (Object)link.getLldpPortDescr());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFNAME_MAP.get(10109), (Object)link.getLldpRemPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFDESCR_MAP.get(10109), (Object)link.getLldpRemPortDescr());
                        continue block19;
                    }
                    case 2: {
                        Assert.assertEquals((Object)"0016c8bd4d80", (Object)link.getLldpRemChassisId());
                        Assert.assertEquals((Object)"Switch1", (Object)link.getLldpRemSysname());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFNAME_MAP.get(10102), (Object)link.getLldpPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10102), (Object)link.getLldpPortDescr());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFNAME_MAP.get(10110), (Object)link.getLldpRemPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFDESCR_MAP.get(10110), (Object)link.getLldpRemPortDescr());
                        continue block19;
                    }
                    case 3: {
                        Assert.assertEquals((Object)"0016c8bd4d80", (Object)link.getLldpRemChassisId());
                        Assert.assertEquals((Object)"Switch1", (Object)link.getLldpRemSysname());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFNAME_MAP.get(10103), (Object)link.getLldpPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10103), (Object)link.getLldpPortDescr());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFNAME_MAP.get(10111), (Object)link.getLldpRemPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFDESCR_MAP.get(10111), (Object)link.getLldpRemPortDescr());
                        continue block19;
                    }
                    case 4: {
                        Assert.assertEquals((Object)"0016c8bd4d80", (Object)link.getLldpRemChassisId());
                        Assert.assertEquals((Object)"Switch1", (Object)link.getLldpRemSysname());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFNAME_MAP.get(10104), (Object)link.getLldpPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10104), (Object)link.getLldpPortDescr());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFNAME_MAP.get(10112), (Object)link.getLldpRemPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFDESCR_MAP.get(10112), (Object)link.getLldpRemPortDescr());
                        continue block19;
                    }
                    case 19: {
                        Assert.assertEquals((Object)"f4ea67ebdc00", (Object)link.getLldpRemChassisId());
                        Assert.assertEquals((Object)"Switch3", (Object)link.getLldpRemSysname());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFNAME_MAP.get(10119), (Object)link.getLldpPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10119), (Object)link.getLldpPortDescr());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH3_IF_IFNAME_MAP.get(10019), (Object)link.getLldpRemPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH3_IF_IFDESCR_MAP.get(10019), (Object)link.getLldpRemPortDescr());
                        continue block19;
                    }
                    case 20: {
                        Assert.assertEquals((Object)"f4ea67ebdc00", (Object)link.getLldpRemChassisId());
                        Assert.assertEquals((Object)"Switch3", (Object)link.getLldpRemSysname());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFNAME_MAP.get(10120), (Object)link.getLldpPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10120), (Object)link.getLldpPortDescr());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH3_IF_IFNAME_MAP.get(10020), (Object)link.getLldpRemPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH3_IF_IFDESCR_MAP.get(10020), (Object)link.getLldpRemPortDescr());
                        continue block19;
                    }
                }
                Assert.assertTrue((boolean)false);
                continue;
            }
            if (link.getNode().getId().intValue() == switch3.getId().intValue()) {
                Assert.assertEquals((Object)"0016c894aa80", (Object)link.getLldpRemChassisId());
                Assert.assertEquals((Object)"Switch2", (Object)link.getLldpRemSysname());
                switch (link.getLldpLocalPortNum()) {
                    case 19: {
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH3_IF_IFNAME_MAP.get(10019), (Object)link.getLldpPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH3_IF_IFDESCR_MAP.get(10019), (Object)link.getLldpPortDescr());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFNAME_MAP.get(10119), (Object)link.getLldpRemPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10119), (Object)link.getLldpRemPortDescr());
                        continue block19;
                    }
                    case 20: {
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH3_IF_IFNAME_MAP.get(10020), (Object)link.getLldpPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH3_IF_IFDESCR_MAP.get(10020), (Object)link.getLldpPortDescr());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFNAME_MAP.get(10120), (Object)link.getLldpRemPortId());
                        Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10120), (Object)link.getLldpRemPortDescr());
                        continue block19;
                    }
                }
                Assert.assertTrue((boolean)false);
                continue;
            }
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="172.16.10.1", port=161, resource="classpath:linkd/nms17216/switch1-walk.txt"), @JUnitSnmpAgent(host="172.16.10.2", port=161, resource="classpath:linkd/nms17216/switch2-walk.txt"), @JUnitSnmpAgent(host="172.16.10.3", port=161, resource="classpath:linkd/nms17216/switch3-walk.txt"), @JUnitSnmpAgent(host="172.16.50.2", port=161, resource="classpath:linkd/nms17216/switch4-walk.txt"), @JUnitSnmpAgent(host="172.16.10.4", port=161, resource="classpath:linkd/nms17216/switch5-walk.txt"), @JUnitSnmpAgent(host="192.168.100.245", port=161, resource="classpath:linkd/nms17216/router1-walk.txt"), @JUnitSnmpAgent(host="192.168.100.241", port=161, resource="classpath:linkd/nms17216/router2-walk.txt"), @JUnitSnmpAgent(host="172.16.50.1", port=161, resource="classpath:linkd/nms17216/router3-walk.txt"), @JUnitSnmpAgent(host="10.10.10.1", port=161, resource="classpath:linkd/nms17216/router4-walk.txt")})
    public void testNetwork17216CdpLinks() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getSwitch1());
        this.m_nodeDao.save((Object)this.builder.getSwitch2());
        this.m_nodeDao.save((Object)this.builder.getSwitch3());
        this.m_nodeDao.save((Object)this.builder.getSwitch4());
        this.m_nodeDao.save((Object)this.builder.getSwitch5());
        this.m_nodeDao.save((Object)this.builder.getRouter1());
        this.m_nodeDao.save((Object)this.builder.getRouter2());
        this.m_nodeDao.save((Object)this.builder.getRouter3());
        this.m_nodeDao.save((Object)this.builder.getRouter4());
        this.m_nodeDao.flush();
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(Boolean.valueOf(true));
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(Boolean.valueOf(false));
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(Boolean.valueOf(false));
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useCdpDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useBridgeDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        OnmsNode switch1 = this.m_nodeDao.findByForeignId("linkd", "Switch1");
        OnmsNode switch2 = this.m_nodeDao.findByForeignId("linkd", "Switch2");
        OnmsNode switch3 = this.m_nodeDao.findByForeignId("linkd", "Switch3");
        OnmsNode switch4 = this.m_nodeDao.findByForeignId("linkd", "Switch4");
        OnmsNode switch5 = this.m_nodeDao.findByForeignId("linkd", "Switch5");
        OnmsNode router1 = this.m_nodeDao.findByForeignId("linkd", "Router1");
        OnmsNode router2 = this.m_nodeDao.findByForeignId("linkd", "Router2");
        OnmsNode router3 = this.m_nodeDao.findByForeignId("linkd", "Router3");
        OnmsNode router4 = this.m_nodeDao.findByForeignId("linkd", "Router4");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch3.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch4.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(switch5.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(router1.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(router2.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(router3.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(router4.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch1.getId().intValue()));
        Assert.assertEquals((long)5L, (long)this.m_cdpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch2.getId().intValue()));
        Assert.assertEquals((long)11L, (long)this.m_cdpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch3.getId().intValue()));
        Assert.assertEquals((long)15L, (long)this.m_cdpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch4.getId().intValue()));
        Assert.assertEquals((long)16L, (long)this.m_cdpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(switch5.getId().intValue()));
        Assert.assertEquals((long)18L, (long)this.m_cdpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(router1.getId().intValue()));
        Assert.assertEquals((long)20L, (long)this.m_cdpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(router2.getId().intValue()));
        Assert.assertEquals((long)22L, (long)this.m_cdpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(router3.getId().intValue()));
        Assert.assertEquals((long)25L, (long)this.m_cdpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(router4.getId().intValue()));
        Assert.assertEquals((long)26L, (long)this.m_cdpLinkDao.countAll());
        Assert.assertEquals((long)13L, (long)this.m_cdpLinkDao.findLinksForTopology().size());
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            Assert.assertNotNull((Object)node.getCdpElement());
            Nms17216EnIT.printCdpElement(node.getCdpElement());
            Assert.assertEquals((Object)OspfElement.TruthValue.TRUE, (Object)node.getCdpElement().getCdpGlobalRun());
            if (node.getId().intValue() == switch1.getId().intValue()) {
                Assert.assertEquals((Object)"Switch1", (Object)node.getCdpElement().getCdpGlobalDeviceId());
                continue;
            }
            if (node.getId().intValue() == switch2.getId().intValue()) {
                Assert.assertEquals((Object)"Switch2", (Object)node.getCdpElement().getCdpGlobalDeviceId());
                continue;
            }
            if (node.getId().intValue() == switch3.getId().intValue()) {
                Assert.assertEquals((Object)"Switch3", (Object)node.getCdpElement().getCdpGlobalDeviceId());
                continue;
            }
            if (node.getId().intValue() == switch4.getId().intValue()) {
                Assert.assertEquals((Object)"Switch4", (Object)node.getCdpElement().getCdpGlobalDeviceId());
                continue;
            }
            if (node.getId().intValue() == switch5.getId().intValue()) {
                Assert.assertEquals((Object)"Switch5", (Object)node.getCdpElement().getCdpGlobalDeviceId());
                continue;
            }
            if (node.getId().intValue() == router1.getId().intValue()) {
                Assert.assertEquals((Object)"Router1", (Object)node.getCdpElement().getCdpGlobalDeviceId());
                continue;
            }
            if (node.getId().intValue() == router2.getId().intValue()) {
                Assert.assertEquals((Object)"Router2", (Object)node.getCdpElement().getCdpGlobalDeviceId());
                continue;
            }
            if (node.getId().intValue() == router3.getId().intValue()) {
                Assert.assertEquals((Object)"Router3", (Object)node.getCdpElement().getCdpGlobalDeviceId());
                continue;
            }
            if (node.getId().intValue() == router4.getId().intValue()) {
                Assert.assertEquals((Object)"Router4", (Object)node.getCdpElement().getCdpGlobalDeviceId());
                continue;
            }
            Assert.assertTrue((boolean)false);
        }
        for (CdpLink link : this.m_cdpLinkDao.findAll()) {
            Nms17216EnIT.printCdpLink(link);
            Assert.assertEquals((Object)CdpLink.CiscoNetworkProtocolType.ip, (Object)link.getCdpCacheAddressType());
            if (link.getNode().getId().intValue() == switch1.getId().intValue()) {
                if (link.getCdpCacheIfIndex() == 10101 && link.getCdpCacheDeviceIndex() == 1) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFDESCR_MAP.get(10101), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((Object)"192.168.100.245", (Object)link.getCdpCacheAddress());
                    Assert.assertEquals((Object)"Cisco IOS Software, 2800 Software (C2800NM-ADVENTERPRISEK9-M), Version 12.4(24)T1, RELEASE SOFTWARE (fc3) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2009 by Cisco Systems, Inc. Compiled Fri 19-Jun-09 15:13 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Router1", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"Cisco 2811", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.ROUTER1_IF_IFDESCR_MAP.get(7), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                if (link.getCdpCacheIfIndex() == 10109 && link.getCdpCacheDeviceIndex() == 5) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFDESCR_MAP.get(10109), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((Object)"172.16.10.2", (Object)link.getCdpCacheAddress());
                    Assert.assertEquals((Object)"Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2011 by Cisco Systems, Inc. Compiled Thu 05-May-11 02:53 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Switch2", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"cisco WS-C2960G-24TC-L", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10101), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                if (link.getCdpCacheIfIndex() == 10110 && link.getCdpCacheDeviceIndex() == 2) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFDESCR_MAP.get(10110), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((Object)"172.16.10.2", (Object)link.getCdpCacheAddress());
                    Assert.assertEquals((Object)"Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2011 by Cisco Systems, Inc. Compiled Thu 05-May-11 02:53 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Switch2", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"cisco WS-C2960G-24TC-L", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10102), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                if (link.getCdpCacheIfIndex() == 10111 && link.getCdpCacheDeviceIndex() == 3) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFDESCR_MAP.get(10111), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((Object)"172.16.10.2", (Object)link.getCdpCacheAddress());
                    Assert.assertEquals((Object)"Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2011 by Cisco Systems, Inc. Compiled Thu 05-May-11 02:53 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Switch2", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"cisco WS-C2960G-24TC-L", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10103), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                if (link.getCdpCacheIfIndex() == 10112 && link.getCdpCacheDeviceIndex() == 4) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFDESCR_MAP.get(10112), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((Object)"172.16.10.2", (Object)link.getCdpCacheAddress());
                    Assert.assertEquals((Object)"Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2011 by Cisco Systems, Inc. Compiled Thu 05-May-11 02:53 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Switch2", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"cisco WS-C2960G-24TC-L", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10104), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                Assert.assertTrue((boolean)false);
                continue;
            }
            if (link.getNode().getId().intValue() == switch2.getId().intValue()) {
                if (link.getCdpCacheIfIndex() == 10101 && link.getCdpCacheDeviceIndex() == 3) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10101), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((Object)"172.16.10.1", (Object)link.getCdpCacheAddress());
                    Assert.assertEquals((Object)"Cisco IOS Software, C3560 Software (C3560-IPSERVICESK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2011 by Cisco Systems, Inc. Compiled Thu 05-May-11 02:19 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Switch1", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"cisco WS-C3560G-24PS", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFDESCR_MAP.get(10109), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                if (link.getCdpCacheIfIndex() == 10102 && link.getCdpCacheDeviceIndex() == 4) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10102), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((Object)"172.16.10.1", (Object)link.getCdpCacheAddress());
                    Assert.assertEquals((Object)"Cisco IOS Software, C3560 Software (C3560-IPSERVICESK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2011 by Cisco Systems, Inc. Compiled Thu 05-May-11 02:19 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Switch1", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"cisco WS-C3560G-24PS", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFDESCR_MAP.get(10110), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                if (link.getCdpCacheIfIndex() == 10103 && link.getCdpCacheDeviceIndex() == 5) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10103), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((Object)"172.16.10.1", (Object)link.getCdpCacheAddress());
                    Assert.assertEquals((Object)"Cisco IOS Software, C3560 Software (C3560-IPSERVICESK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2011 by Cisco Systems, Inc. Compiled Thu 05-May-11 02:19 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Switch1", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"cisco WS-C3560G-24PS", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFDESCR_MAP.get(10111), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                if (link.getCdpCacheIfIndex() == 10104 && link.getCdpCacheDeviceIndex() == 6) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10104), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((Object)"172.16.10.1", (Object)link.getCdpCacheAddress());
                    Assert.assertEquals((Object)"Cisco IOS Software, C3560 Software (C3560-IPSERVICESK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2011 by Cisco Systems, Inc. Compiled Thu 05-May-11 02:19 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Switch1", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"cisco WS-C3560G-24PS", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFDESCR_MAP.get(10112), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                if (link.getCdpCacheIfIndex() == 10119 && link.getCdpCacheDeviceIndex() == 1) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10119), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((Object)"172.16.10.3", (Object)link.getCdpCacheAddress());
                    Assert.assertEquals((Object)"Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(50)SE5, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2010 by Cisco Systems, Inc. Compiled Tue 28-Sep-10 13:44 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Switch3", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"cisco WS-C2960-24TT-L", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH3_IF_IFDESCR_MAP.get(10019), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                if (link.getCdpCacheIfIndex() == 10120 && link.getCdpCacheDeviceIndex() == 2) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10120), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((Object)"172.16.10.3", (Object)link.getCdpCacheAddress());
                    Assert.assertEquals((Object)"Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(50)SE5, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2010 by Cisco Systems, Inc. Compiled Tue 28-Sep-10 13:44 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Switch3", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"cisco WS-C2960-24TT-L", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH3_IF_IFDESCR_MAP.get(10020), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                Assert.assertTrue((boolean)false);
                continue;
            }
            if (link.getNode().getId().intValue() == switch3.getId().intValue()) {
                if (link.getCdpCacheIfIndex() == 10019 && link.getCdpCacheDeviceIndex() == 3) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH3_IF_IFDESCR_MAP.get(10019), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((Object)"172.16.10.2", (Object)link.getCdpCacheAddress());
                    Assert.assertEquals((Object)"Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2011 by Cisco Systems, Inc. Compiled Thu 05-May-11 02:53 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Switch2", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"cisco WS-C2960G-24TC-L", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10119), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                if (link.getCdpCacheIfIndex() == 10020 && link.getCdpCacheDeviceIndex() == 4) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH3_IF_IFDESCR_MAP.get(10020), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((Object)"172.16.10.2", (Object)link.getCdpCacheAddress());
                    Assert.assertEquals((Object)"Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2011 by Cisco Systems, Inc. Compiled Thu 05-May-11 02:53 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Switch2", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"cisco WS-C2960G-24TC-L", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH2_IF_IFDESCR_MAP.get(10120), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                if (link.getCdpCacheIfIndex() == 10023 && link.getCdpCacheDeviceIndex() == 1) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH3_IF_IFDESCR_MAP.get(10023), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((Object)"172.16.10.4", (Object)link.getCdpCacheAddress());
                    Assert.assertEquals((Object)"Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(50)SE5, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2010 by Cisco Systems, Inc. Compiled Tue 28-Sep-10 13:44 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Switch5", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"cisco WS-C2960-24TT-L", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH5_IF_IFDESCR_MAP.get(10001), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                if (link.getCdpCacheIfIndex() == 10024 && link.getCdpCacheDeviceIndex() == 2) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH3_IF_IFDESCR_MAP.get(10024), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((Object)"172.16.10.4", (Object)link.getCdpCacheAddress());
                    Assert.assertEquals((Object)"Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(50)SE5, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2010 by Cisco Systems, Inc. Compiled Tue 28-Sep-10 13:44 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Switch5", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"cisco WS-C2960-24TT-L", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH5_IF_IFDESCR_MAP.get(10013), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                Assert.assertTrue((boolean)false);
                continue;
            }
            if (link.getNode().getId().intValue() == switch4.getId().intValue()) {
                if (link.getCdpCacheIfIndex() == 10001 && link.getCdpCacheDeviceIndex() == 1) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH4_IF_IFDESCR_MAP.get(10001), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((Object)"172.16.50.1", (Object)link.getCdpCacheAddress());
                    Assert.assertEquals((Object)"Cisco IOS Software, C2900 Software (C2900-UNIVERSALK9-M), Version 15.1(4)M4, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2012 by Cisco Systems, Inc. Compiled Tue 20-Mar-12 18:57 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Router3", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"Cisco CISCO2911/K9", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.ROUTER3_IF_IFDESCR_MAP.get(9), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                Assert.assertTrue((boolean)false);
                continue;
            }
            if (link.getNode().getId().intValue() == switch5.getId().intValue()) {
                if (link.getCdpCacheIfIndex() == 10001 && link.getCdpCacheDeviceIndex() == 1) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH5_IF_IFDESCR_MAP.get(10001), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((Object)"172.16.10.3", (Object)link.getCdpCacheAddress());
                    Assert.assertEquals((Object)"Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(50)SE5, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2010 by Cisco Systems, Inc. Compiled Tue 28-Sep-10 13:44 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Switch3", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"cisco WS-C2960-24TT-L", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH3_IF_IFDESCR_MAP.get(10023), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                if (link.getCdpCacheIfIndex() == 10013 && link.getCdpCacheDeviceIndex() == 2) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH5_IF_IFDESCR_MAP.get(10013), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((Object)"172.16.10.3", (Object)link.getCdpCacheAddress());
                    Assert.assertEquals((Object)"Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(50)SE5, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2010 by Cisco Systems, Inc. Compiled Tue 28-Sep-10 13:44 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Switch3", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"cisco WS-C2960-24TT-L", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH3_IF_IFDESCR_MAP.get(10024), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                Assert.assertTrue((boolean)false);
                continue;
            }
            if (link.getNode().getId().intValue() == router1.getId().intValue()) {
                if (link.getCdpCacheIfIndex() == 7 && link.getCdpCacheDeviceIndex() == 2) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.ROUTER1_IF_IFDESCR_MAP.get(7), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((long)10101L, (long)NmsNetworkBuilder.SWITCH1_IP_IF_MAP.get(InetAddressUtils.addr((String)link.getCdpCacheAddress())).intValue());
                    Assert.assertEquals((Object)"Cisco IOS Software, C3560 Software (C3560-IPSERVICESK9-M), Version 12.2(58)SE1, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2011 by Cisco Systems, Inc. Compiled Thu 05-May-11 02:19 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Switch1", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"cisco WS-C3560G-24PS", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH1_IF_IFDESCR_MAP.get(10101), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                if (link.getCdpCacheIfIndex() == 13 && link.getCdpCacheDeviceIndex() == 1) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.ROUTER1_IF_IFDESCR_MAP.get(13), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((long)12L, (long)NmsNetworkBuilder.ROUTER2_IP_IF_MAP.get(InetAddressUtils.addr((String)link.getCdpCacheAddress())).intValue());
                    Assert.assertEquals((Object)"Cisco IOS Software, C2900 Software (C2900-UNIVERSALK9-M), Version 15.1(4)M4, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2012 by Cisco Systems, Inc. Compiled Tue 20-Mar-12 18:57 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Router2", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"Cisco CISCO2911/K9", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.ROUTER2_IF_IFDESCR_MAP.get(12), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                Assert.assertTrue((boolean)false);
                continue;
            }
            if (link.getNode().getId().intValue() == router2.getId().intValue()) {
                if (link.getCdpCacheIfIndex() == 12 && link.getCdpCacheDeviceIndex() == 2) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.ROUTER2_IF_IFDESCR_MAP.get(12), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((long)13L, (long)NmsNetworkBuilder.ROUTER1_IP_IF_MAP.get(InetAddressUtils.addr((String)link.getCdpCacheAddress())).intValue());
                    Assert.assertEquals((Object)"Cisco IOS Software, 2800 Software (C2800NM-ADVENTERPRISEK9-M), Version 12.4(24)T1, RELEASE SOFTWARE (fc3) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2009 by Cisco Systems, Inc. Compiled Fri 19-Jun-09 15:13 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Router1", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"Cisco 2811", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.ROUTER1_IF_IFDESCR_MAP.get(13), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                if (link.getCdpCacheIfIndex() == 13 && link.getCdpCacheDeviceIndex() == 1) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.ROUTER2_IF_IFDESCR_MAP.get(13), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((long)13L, (long)NmsNetworkBuilder.ROUTER3_IP_IF_MAP.get(InetAddressUtils.addr((String)link.getCdpCacheAddress())).intValue());
                    Assert.assertEquals((Object)"Cisco IOS Software, C2900 Software (C2900-UNIVERSALK9-M), Version 15.1(4)M4, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2012 by Cisco Systems, Inc. Compiled Tue 20-Mar-12 18:57 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Router3", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"Cisco CISCO2911/K9", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.ROUTER3_IF_IFDESCR_MAP.get(13), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                Assert.assertTrue((boolean)false);
                continue;
            }
            if (link.getNode().getId().intValue() == router3.getId().intValue()) {
                if (link.getCdpCacheIfIndex() == 8 && link.getCdpCacheDeviceIndex() == 2) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.ROUTER3_IF_IFDESCR_MAP.get(8), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((long)3L, (long)NmsNetworkBuilder.ROUTER4_IP_IF_MAP.get(InetAddressUtils.addr((String)link.getCdpCacheAddress())).intValue());
                    Assert.assertEquals((Object)"Cisco IOS Software, C2900 Software (C2900-UNIVERSALK9-M), Version 15.1(4)M4, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2012 by Cisco Systems, Inc. Compiled Tue 20-Mar-12 18:57 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Router4", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"Cisco CISCO2911/K9", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.ROUTER4_IF_IFDESCR_MAP.get(3), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                if (link.getCdpCacheIfIndex() == 9 && link.getCdpCacheDeviceIndex() == 3) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.ROUTER3_IF_IFDESCR_MAP.get(9), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((Object)"172.16.50.2", (Object)link.getCdpCacheAddress());
                    Assert.assertEquals((Object)"Cisco IOS Software, C2960 Software (C2960-LANBASEK9-M), Version 12.2(50)SE5, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2010 by Cisco Systems, Inc. Compiled Tue 28-Sep-10 13:44 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Switch4", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"cisco WS-C2960-24TT-L", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.SWITCH4_IF_IFDESCR_MAP.get(10001), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                if (link.getCdpCacheIfIndex() == 13 && link.getCdpCacheDeviceIndex() == 1) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.ROUTER3_IF_IFDESCR_MAP.get(13), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((long)13L, (long)NmsNetworkBuilder.ROUTER2_IP_IF_MAP.get(InetAddressUtils.addr((String)link.getCdpCacheAddress())).intValue());
                    Assert.assertEquals((Object)"Cisco IOS Software, C2900 Software (C2900-UNIVERSALK9-M), Version 15.1(4)M4, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2012 by Cisco Systems, Inc. Compiled Tue 20-Mar-12 18:57 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Router2", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"Cisco CISCO2911/K9", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.ROUTER2_IF_IFDESCR_MAP.get(13), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                Assert.assertTrue((boolean)false);
                continue;
            }
            if (link.getNode().getId().intValue() == router4.getId().intValue()) {
                if (link.getCdpCacheIfIndex() == 3 && link.getCdpCacheDeviceIndex() == 1) {
                    Assert.assertEquals((Object)NmsNetworkBuilder.ROUTER4_IF_IFDESCR_MAP.get(3), (Object)link.getCdpInterfaceName());
                    Assert.assertEquals((long)8L, (long)NmsNetworkBuilder.ROUTER3_IP_IF_MAP.get(InetAddressUtils.addr((String)link.getCdpCacheAddress())).intValue());
                    Assert.assertEquals((Object)"Cisco IOS Software, C2900 Software (C2900-UNIVERSALK9-M), Version 15.1(4)M4, RELEASE SOFTWARE (fc1) Technical Support: http://www.cisco.com/techsupport Copyright (c) 1986-2012 by Cisco Systems, Inc. Compiled Tue 20-Mar-12 18:57 by prod_rel_team", (Object)link.getCdpCacheVersion());
                    Assert.assertEquals((Object)"Router3", (Object)link.getCdpCacheDeviceId());
                    Assert.assertEquals((Object)"Cisco CISCO2911/K9", (Object)link.getCdpCacheDevicePlatform());
                    Assert.assertEquals((Object)NmsNetworkBuilder.ROUTER3_IF_IFDESCR_MAP.get(8), (Object)link.getCdpCacheDevicePort());
                    continue;
                }
                Assert.assertTrue((boolean)false);
                continue;
            }
            Assert.assertTrue((boolean)false);
        }
    }
}

