/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.junit.Assert;
import org.opennms.core.rpc.api.RpcClientFactory;
import org.opennms.core.rpc.mock.MockRpcClientFactory;
import org.opennms.netmgt.collectd.CollectionSpecification;
import org.opennms.netmgt.collectd.DefaultCollectdInstrumentation;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionException;
import org.opennms.netmgt.collection.api.CollectionInstrumentation;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.CollectionStatus;
import org.opennms.netmgt.collection.api.LocationAwareCollectorClient;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.api.ServiceCollectorRegistry;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.client.rpc.CollectorClientRpcModule;
import org.opennms.netmgt.collection.client.rpc.LocationAwareCollectorClientImpl;
import org.opennms.netmgt.collection.persistence.rrd.RrdPersisterFactory;
import org.opennms.netmgt.collection.support.DefaultServiceCollectorRegistry;
import org.opennms.netmgt.config.collectd.Filter;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.config.collectd.Parameter;
import org.opennms.netmgt.config.collectd.Service;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.dao.support.FilesystemResourceStorageDao;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.test.FileAnticipator;

public abstract class CollectorTestUtils {
    static LocationAwareCollectorClient createLocationAwareCollectorClient() {
        DefaultServiceCollectorRegistry serviceCollectorRegistry = new DefaultServiceCollectorRegistry();
        CollectorClientRpcModule collectorClientRpcModule = new CollectorClientRpcModule();
        collectorClientRpcModule.setServiceCollectorRegistry((ServiceCollectorRegistry)serviceCollectorRegistry);
        collectorClientRpcModule.setExecutor((Executor)Executors.newSingleThreadExecutor());
        MockRpcClientFactory rpcClientFactory = new MockRpcClientFactory();
        LocationAwareCollectorClientImpl locationAwareCollectorClient = new LocationAwareCollectorClientImpl((RpcClientFactory)rpcClientFactory);
        locationAwareCollectorClient.setRpcModule(collectorClientRpcModule);
        locationAwareCollectorClient.afterPropertiesSet();
        return locationAwareCollectorClient;
    }

    static CollectionSpecification createCollectionSpec(String svcName, ServiceCollector svcCollector, String collectionName) {
        Package pkg = new Package();
        Filter filter = new Filter();
        filter.setContent("IPADDR IPLIKE *.*.*.*");
        pkg.setFilter(filter);
        Service service = new Service();
        service.setName(svcName);
        Parameter collectionParm = new Parameter();
        collectionParm.setKey("collection");
        collectionParm.setValue(collectionName);
        service.addParameter(collectionParm);
        pkg.addService(service);
        CollectionSpecification spec = new CollectionSpecification(pkg, svcName, svcCollector, (CollectionInstrumentation)new DefaultCollectdInstrumentation(), CollectorTestUtils.createLocationAwareCollectorClient());
        return spec;
    }

    public static void persistCollectionSet(RrdStrategy<?, ?> rrdStrategy, FilesystemResourceStorageDao resourceStorageDao, CollectionSpecification spec, CollectionSet collectionSet) {
        RrdRepository repository = spec.getRrdRepository("default");
        System.err.println("repository = " + repository);
        ServiceParameters params = spec.getServiceParameters();
        System.err.println("service parameters = " + params);
        RrdPersisterFactory persisterFactory = new RrdPersisterFactory();
        persisterFactory.setRrdStrategy(rrdStrategy);
        persisterFactory.setResourceStorageDao((ResourceStorageDao)resourceStorageDao);
        Persister persister = persisterFactory.createPersister(params, repository);
        System.err.println("persister = " + persister);
        collectionSet.visit((CollectionSetVisitor)persister);
    }

    public static void collectNTimes(RrdStrategy<?, ?> rrdStrategy, FilesystemResourceStorageDao resourceStorageDao, CollectionSpecification spec, CollectionAgent agent, int numUpdates) throws InterruptedException, CollectionException {
        for (int i = 0; i < numUpdates; ++i) {
            CollectionSet collectionSet = spec.collect(agent);
            Assert.assertEquals((String)"collection status", (Object)CollectionStatus.SUCCEEDED, (Object)collectionSet.getStatus());
            CollectorTestUtils.persistCollectionSet(rrdStrategy, resourceStorageDao, spec, collectionSet);
            System.err.println("COLLECTION " + i + " FINISHED");
            Thread.sleep(1010L);
        }
    }

    public static void failToCollectNTimes(RrdStrategy<?, ?> rrdStrategy, FilesystemResourceStorageDao resourceStorageDao, CollectionSpecification spec, CollectionAgent agent, int numUpdates) throws InterruptedException, CollectionException {
        for (int i = 0; i < numUpdates; ++i) {
            CollectionSet collectionSet = spec.collect(agent);
            Assert.assertEquals((String)"collection status", (Object)CollectionStatus.FAILED, (Object)collectionSet.getStatus());
            CollectorTestUtils.persistCollectionSet(rrdStrategy, resourceStorageDao, spec, collectionSet);
            System.err.println("COLLECTION " + i + " FINISHED");
            Thread.sleep(1010L);
        }
    }

    public static File anticipatePath(FileAnticipator fa, File rootDir, String ... pathElements) {
        File parent = rootDir;
        Assert.assertTrue((pathElements.length > 0 ? 1 : 0) != 0);
        for (String pathElement : pathElements) {
            parent = fa.expecting(parent, pathElement);
        }
        return parent;
    }

    public static String rrd(RrdStrategy<Object, Object> rrdStrategy, String file) {
        return file + rrdStrategy.getDefaultFileExtension();
    }
}

