/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.CollectionMath;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.icmp.PingerFactory;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Distributable
@Component
public final class StrafePingMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(StrafePingMonitor.class);
    private static final int DEFAULT_MULTI_PING_COUNT = 20;
    private static final long DEFAULT_PING_INTERVAL = 50L;
    private static final int DEFAULT_FAILURE_PING_COUNT = 20;
    private Supplier<PingerFactory> pingerFactory = Suppliers.memoize(() -> (PingerFactory)BeanUtils.getBean((String)"daoContext", (String)"pingerFactory", PingerFactory.class));

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        PollStatus serviceStatus = PollStatus.unavailable(null);
        InetAddress host = svc.getAddress();
        ArrayList responseTimes = null;
        try {
            long timeout = ParameterMap.getKeyedLong(parameters, (String)"timeout", (long)800L);
            int count = ParameterMap.getKeyedInteger(parameters, (String)"ping-count", (int)20);
            long pingInterval = ParameterMap.getKeyedLong(parameters, (String)"wait-interval", (long)50L);
            int failurePingCount = ParameterMap.getKeyedInteger(parameters, (String)"failure-ping-count", (int)20);
            int packetSize = ParameterMap.getKeyedInteger(parameters, (String)"packet-size", (int)64);
            int dscp = ParameterMap.getKeyedDecodedInteger(parameters, (String)"dscp", (int)0);
            boolean allowFragmentation = ParameterMap.getKeyedBoolean(parameters, (String)"allow-fragmentation", (boolean)true);
            responseTimes = new ArrayList(((PingerFactory)this.pingerFactory.get()).getInstance(dscp, allowFragmentation).parallelPing(host, count, timeout, pingInterval, packetSize));
            if (CollectionMath.countNull(responseTimes) >= (long)failurePingCount) {
                LOG.debug("Service {} on interface {} is down, but continuing to gather latency data", (Object)svc.getSvcName(), (Object)svc.getIpAddr());
                serviceStatus = PollStatus.unavailable("the failure ping count (" + failurePingCount + ") was reached");
            } else {
                serviceStatus = PollStatus.available();
            }
            Collections.sort(responseTimes, new Comparator<Number>(){

                @Override
                public int compare(Number arg0, Number arg1) {
                    if (arg0 == null) {
                        return -1;
                    }
                    if (arg1 == null) {
                        return 1;
                    }
                    if (arg0.doubleValue() == arg1.doubleValue()) {
                        return 0;
                    }
                    return arg0.doubleValue() < arg1.doubleValue() ? -1 : 1;
                }
            });
            LinkedHashMap<String, Number> returnval = new LinkedHashMap<String, Number>();
            for (int i = 0; i < responseTimes.size(); ++i) {
                returnval.put("ping" + (i + 1), (Number)responseTimes.get(i));
            }
            returnval.put("loss", CollectionMath.countNull(responseTimes));
            returnval.put("median", CollectionMath.median(responseTimes));
            returnval.put("response-time", CollectionMath.average(responseTimes));
            serviceStatus.setProperties(returnval);
        }
        catch (Throwable e) {
            LOG.debug("failed to ping {}", (Object)host, (Object)e);
        }
        return serviceStatus;
    }

    public void setPingerFactory(PingerFactory pingerFactory) {
        this.pingerFactory = Suppliers.ofInstance((Object)pingerFactory);
    }
}

