/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.opennms.netmgt.config.microblog.MicroblogProfile;
import org.opennms.netmgt.dao.api.MicroblogConfigurationDao;
import org.opennms.netmgt.dao.jaxb.DefaultMicroblogConfigurationDao;
import org.opennms.netmgt.notifd.MicroblogAuthorization;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import twitter4j.Twitter;
import twitter4j.TwitterFactory;
import twitter4j.auth.AccessToken;
import twitter4j.conf.ConfigurationBuilder;

public class MicroblogClient {
    private final MicroblogConfigurationDao m_configDao;

    public MicroblogClient(MicroblogConfigurationDao dao) {
        this.m_configDao = dao;
    }

    public MicroblogClient(Resource configResource) {
        DefaultMicroblogConfigurationDao dao = new DefaultMicroblogConfigurationDao();
        dao.setConfigResource(configResource);
        dao.afterPropertiesSet();
        this.m_configDao = dao;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("=== Configure Microblog Authentication ===");
        System.out.println("");
        String configPath = System.getProperty("opennms.home") + File.separator + "etc" + File.separator + "microblog-configuration.xml";
        File configFile = new File(configPath);
        if (!configFile.exists()) {
            MicroblogClient.usage();
        }
        String profile = null;
        if (args.length > 0) {
            profile = args[0];
        }
        try {
            MicroblogClient client = new MicroblogClient((Resource)new FileSystemResource(configFile));
            int step = 1;
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            if (!client.hasOAuth(profile)) {
                System.out.println("This utility is for connecting OpenNMS notifications with Twitter, or any other");
                System.out.println("microblog site which uses OAuth.  These examples will use Twitter URLs, but you");
                System.out.println("should be able to do the equivalent with any Twitter-compatible site like identi.ca.");
                System.out.println("");
                System.out.println("If you wish to use a username and password instead, just enter them into your");
                System.out.println("microblog-configuration.xml file.");
                System.out.println("");
                System.out.println("Step " + step++ + ".  Go to https://twitter.com/oauth_clients/new and create a Twitter");
                System.out.println("\"application\" for your OpenNMS install.  If you have already created an application,");
                System.out.println("you can get the info you need for the next steps at https://dev.twitter.com/apps/");
                System.out.println("instead.  Make sure you go to 'Keys and Access Tokens' and configure the 'Access Level'");
                System.out.println("to allow 'Read, Write and Access direct messages'.");
                System.out.println("");
                System.out.print("Step " + step++ + ".  Enter your consumer key: ");
                String consumerKey = br.readLine();
                System.out.println("");
                System.out.print("Step " + step++ + ".  Enter your consumer secret: ");
                String consumerSecret = br.readLine();
                System.out.println("");
                client.getProfile(profile).setOauthConsumerKey(consumerKey);
                client.getProfile(profile).setOauthConsumerSecret(consumerSecret);
                if (!client.hasOAuth(profile)) {
                    System.err.println("Something went wrong, either your consumer key or secret were empty.  Bailing.");
                    System.exit(1);
                }
            }
            MicroblogAuthorization auth = client.requestAuthorization(profile);
            System.out.println("Step " + step++ + ".  Go to " + auth.getUrl());
            System.out.println("in your browser and authorize OpenNMS.");
            System.out.println("");
            System.out.print("Step " + step++ + ".  Type your PIN from the web page, or hit ENTER if there is no PIN: ");
            String pin = br.readLine();
            AccessToken token = null;
            if (pin == null || pin.length() == 0 || !pin.matches("^[0-9]*$")) {
                System.err.println("No pin, or pin input was not numeric.  Trying pinless auth.");
                token = auth.retrieveToken();
            } else {
                token = auth.retrieveToken(pin);
            }
            System.out.println("");
            System.out.println("Step " + step + ".  There is no step " + step++ + ".");
            System.out.println("");
            System.out.print("Saving tokens to " + configPath + "... ");
            client.saveAccessToken(profile, token);
            System.out.println("done");
            System.out.println("");
        }
        catch (Exception e) {
            System.err.println("Failed to get access token.");
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private void saveAccessToken(String profile, AccessToken token) throws IOException {
        MicroblogProfile mp = this.getProfile(profile);
        mp.setOauthAccessToken(token.getToken());
        mp.setOauthAccessTokenSecret(token.getTokenSecret());
        this.m_configDao.saveProfile(mp);
    }

    public MicroblogProfile getProfile(String profile) {
        MicroblogProfile mp = this.m_configDao.getProfile(profile);
        if (mp != null) {
            return mp;
        }
        return this.m_configDao.getDefaultProfile();
    }

    private static void usage() {
        System.out.println("usage: microblog-auth [profile]");
        System.out.println("");
        System.out.println("  profile: The profile in microblog-configuration.xml to update. (optional)");
        System.out.println("");
        System.exit(1);
    }

    public boolean isOAuthUsable(String profile) {
        return this.hasOAuth(profile) && this.hasOAuthAccessToken(profile);
    }

    public boolean hasOAuth(String profile) {
        MicroblogProfile mp = this.getProfile(profile);
        if (mp == null) {
            return false;
        }
        return !MicroblogClient.isEmpty(mp.getOauthConsumerKey()) && !MicroblogClient.isEmpty(mp.getOauthConsumerSecret());
    }

    public boolean hasOAuthAccessToken(String profile) {
        MicroblogProfile mp = this.getProfile(profile);
        if (mp == null) {
            return false;
        }
        return !MicroblogClient.isEmpty(mp.getOauthAccessToken()) && !MicroblogClient.isEmpty(mp.getOauthAccessTokenSecret());
    }

    public boolean hasBasicAuth(String profile) {
        MicroblogProfile mp = this.getProfile(profile);
        if (mp == null) {
            return false;
        }
        return !MicroblogClient.isEmpty(mp.getAuthenUsername()) && !MicroblogClient.isEmpty(mp.getAuthenPassword());
    }

    private static boolean isEmpty(String value) {
        return value == null || "".equals(value);
    }

    public MicroblogAuthorization requestAuthorization(String profile) throws MicroblogAuthorization.MicroblogAuthorizationException {
        return new MicroblogAuthorization(this.getTwitter(profile));
    }

    public Twitter getTwitter(String profile) {
        MicroblogProfile mp = this.getProfile(profile);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.setClientURL(mp.getServiceUrl());
        if (!MicroblogClient.isEmpty(mp.getOauthConsumerKey())) {
            builder.setOAuthConsumerKey(mp.getOauthConsumerKey());
        }
        if (!MicroblogClient.isEmpty(mp.getOauthConsumerSecret())) {
            builder.setOAuthConsumerSecret(mp.getOauthConsumerSecret());
        }
        if (!MicroblogClient.isEmpty(mp.getOauthAccessToken())) {
            builder.setOAuthAccessToken(mp.getOauthAccessToken());
        }
        if (!MicroblogClient.isEmpty(mp.getOauthAccessTokenSecret())) {
            builder.setOAuthAccessTokenSecret(mp.getOauthAccessTokenSecret());
        }
        if (!MicroblogClient.isEmpty(mp.getAuthenUsername())) {
            builder.setUser(mp.getAuthenUsername());
        }
        if (!MicroblogClient.isEmpty(mp.getAuthenPassword())) {
            builder.setPassword(mp.getAuthenPassword());
        }
        return new TwitterFactory(builder.build()).getInstance();
    }
}

