/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.model.BridgeBridgeLink;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.topology.Bridge;
import org.opennms.netmgt.model.topology.BroadcastDomain;
import org.opennms.netmgt.model.topology.SharedSegment;
import org.opennms.netmgt.model.topology.SimpleConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeDiscoveryBridgeTopology
extends NodeDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryBridgeTopology.class);
    Map<Bridge, List<BridgeMacLink>> m_notYetParsedBFTMap;
    BroadcastDomain m_domain;

    public BroadcastDomain getDomain() {
        return this.m_domain;
    }

    public void setDomain(BroadcastDomain domain) {
        this.m_domain = domain;
    }

    public Map<Bridge, List<BridgeMacLink>> getNotYetParsedBFTMap() {
        return this.m_notYetParsedBFTMap;
    }

    public void addUpdatedBFT(Bridge bridge, List<BridgeMacLink> notYetParsedBFTMap) {
        if (this.m_notYetParsedBFTMap == null) {
            this.m_notYetParsedBFTMap = new HashMap<Bridge, List<BridgeMacLink>>();
        }
        this.m_notYetParsedBFTMap.put(bridge, notYetParsedBFTMap);
    }

    public NodeDiscoveryBridgeTopology(EnhancedLinkd linkd, Node node) {
        super(linkd, node);
    }

    private Set<Integer> getAllNodesWithUpdatedBFTOnDomain(Set<String> incomingSet, Map<Integer, List<BridgeMacLink>> nodeBftMap) {
        HashSet<Integer> nodeswithupdatedbftonbroadcastdomain = new HashSet<Integer>();
        nodeswithupdatedbftonbroadcastdomain.add(this.getNodeId());
        LOG.info("run: node: [{}], getting nodes with updated bft on broadcast domain. Start", (Object)this.getNodeId());
        for (Integer curNodeId : nodeBftMap.keySet()) {
            if (curNodeId.intValue() == this.getNodeId()) continue;
            HashSet<String> retainedSet = new HashSet<String>();
            for (BridgeMacLink link : nodeBftMap.get(curNodeId)) {
                retainedSet.add(link.getMacAddress());
            }
            LOG.debug("run: node: [{}], parsing updated bft node: [{}], macs {}", new Object[]{this.getNodeId(), curNodeId, retainedSet});
            retainedSet.retainAll(incomingSet);
            LOG.debug("run: node: [{}], node: [{}] - common mac address set: {}", new Object[]{this.getNodeId(), curNodeId, retainedSet});
            if (retainedSet.size() <= 10 && !((double)retainedSet.size() >= (double)incomingSet.size() * 0.1)) continue;
            nodeswithupdatedbftonbroadcastdomain.add(curNodeId);
            LOG.debug("run: node: [{}], node: [{}] - put on same broadcast domain, common macs: {} ", new Object[]{this.getNodeId(), curNodeId, retainedSet});
        }
        LOG.info("run: node: [{}], getting nodes with updated bft on broadcast domain. End", (Object)this.getNodeId());
        return nodeswithupdatedbftonbroadcastdomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.m_linkd.getQueryManager().hasUpdatedBft(this.getNodeId())) {
            LOG.info("run: node: [{}], no bft.Exiting Bridge Topology Discovery", (Object)this.getNodeId());
            return;
        }
        List<BridgeMacLink> links = this.m_linkd.getQueryManager().getBridgeTopologyUpdateBFT(this.getNodeId());
        if (links == null || links.size() == 0) {
            LOG.info("run: node: [{}]. no updates macs found.", (Object)this.getNodeId());
            return;
        }
        Date now = new Date();
        HashSet<String> incomingSet = new HashSet<String>();
        List<BridgeMacLink> list = links;
        synchronized (list) {
            for (BridgeMacLink link : links) {
                incomingSet.add(link.getMacAddress());
            }
        }
        LOG.debug("run: node: [{}]. macs found: {}", (Object)this.getNodeId(), incomingSet);
        LOG.info("run: node: [{}], getting broadcast domain. Start", (Object)this.getNodeId());
        for (BroadcastDomain domain : this.m_linkd.getQueryManager().getAllBroadcastDomains()) {
            LOG.debug("run: node: [{}], parsing domain with nodes: {}, macs: {}", new Object[]{this.getNodeId(), domain.getBridgeNodesOnDomain(), domain.getMacsOnDomain()});
            HashSet retainedSet = new HashSet(domain.getMacsOnDomain());
            retainedSet.retainAll(incomingSet);
            LOG.debug("run: node: [{}], retained: {}", (Object)this.getNodeId(), retainedSet);
            if (retainedSet.size() <= 10 && !((double)retainedSet.size() >= (double)incomingSet.size() * 0.1)) continue;
            LOG.debug("run: node: [{}], domain {} found!", (Object)this.getNodeId(), (Object)domain.getBridgeNodesOnDomain());
            this.m_domain = domain;
        }
        if (this.m_domain == null) {
            LOG.debug("run: node: [{}] Creating a new Domain", (Object)this.getNodeId());
            this.m_domain = new BroadcastDomain();
            this.m_linkd.getQueryManager().save(this.m_domain);
        }
        LOG.debug("run: node: [{}], Found Broadcast Bomain. Print Topology. {} ", (Object)this.getNodeId(), (Object)this.m_domain.printTopology());
        LOG.info("run: node: [{}], getting broadcast domain. End", (Object)this.getNodeId());
        Map<Integer, List<BridgeMacLink>> nodeBftMap = this.m_linkd.getQueryManager().getUpdateBftMap();
        Set<Integer> nodeswithupdatedbftonbroadcastdomain = this.getAllNodesWithUpdatedBFTOnDomain(incomingSet, nodeBftMap);
        boolean stop = false;
        for (BroadcastDomain domain : this.m_linkd.getQueryManager().getAllBroadcastDomains()) {
            if (this.m_domain == domain) continue;
            LOG.debug("run: node [{}]: cleaning broadcast domain {}.", (Object)this.getNodeId(), (Object)domain.getBridgeNodesOnDomain());
            for (Integer curNodeId : nodeswithupdatedbftonbroadcastdomain) {
                if (!domain.containBridgeId(curNodeId.intValue())) continue;
                LOG.debug("run: node [{}]: node [{}]: removing from broadcast domain {}!", new Object[]{this.getNodeId(), curNodeId, domain.getBridgeNodesOnDomain()});
                if (!domain.getLock((Object)this)) {
                    LOG.info("run: node [{}]: node [{}]: broadcast domain {}: is locked. cannot clear topology.", new Object[]{this.getNodeId(), curNodeId, domain.getBridgeNodesOnDomain()});
                    stop = true;
                    continue;
                }
                domain.clearTopologyForBridge(curNodeId);
                domain.removeBridge(curNodeId.intValue());
                this.m_linkd.getQueryManager().store(domain, now);
                domain.releaseLock((Object)this);
                this.m_linkd.getQueryManager().cleanBroadcastDomains();
            }
        }
        if (stop || !this.m_domain.getLock((Object)this)) {
            LOG.info("run: node [{}]: broadcast domain locked. scheduling with time interval {}", (Object)this.getNodeId(), (Object)this.getInitialSleepTime());
            this.schedule();
            return;
        }
        this.m_notYetParsedBFTMap = new HashMap<Bridge, List<BridgeMacLink>>();
        for (Integer nodeid : nodeswithupdatedbftonbroadcastdomain) {
            this.sendStartEvent(nodeid);
            this.m_domain.addBridge(new Bridge(nodeid));
            LOG.debug("run: node: [{}], getting update bft for node [{}] on domain", (Object)this.getNodeId(), (Object)nodeid);
            List<BridgeMacLink> bft = this.m_linkd.getQueryManager().useBridgeTopologyUpdateBFT(nodeid);
            if (bft == null || bft.isEmpty()) {
                LOG.debug("run: node: [{}], no update bft for node [{}] on domain", (Object)this.getNodeId(), (Object)nodeid);
                continue;
            }
            this.m_notYetParsedBFTMap.put(this.m_domain.getBridge(nodeid.intValue()), bft);
        }
        for (Integer nodeid : nodeBftMap.keySet()) {
            if (nodeswithupdatedbftonbroadcastdomain.contains(nodeid)) continue;
            LOG.info("run: node [{}]: bridge [{}] with updated bft. Not even more on broadcast domain {}: clear topology.", new Object[]{this.getNodeId(), nodeid, this.m_domain.getBridgeNodesOnDomain()});
            this.m_domain.clearTopologyForBridge(nodeid);
            this.m_domain.removeBridge(nodeid.intValue());
        }
        this.m_linkd.getQueryManager().cleanBroadcastDomains();
        this.m_domain.setBridgeElements(this.m_linkd.getQueryManager().getBridgeElements(this.m_domain.getBridgeNodesOnDomain()));
        if (this.m_notYetParsedBFTMap.isEmpty()) {
            LOG.info("run: node: [{}], broadcast domain has no topology updates. No more action is needed.", (Object)this.getNodeId());
            return;
        }
        this.calculate();
        LOG.info("run: node: [{}], saving Topology.", (Object)this.getNodeId());
        this.m_linkd.getQueryManager().store(this.m_domain, now);
        LOG.info("run: node: [{}], saved Topology.", (Object)this.getNodeId());
        for (Integer curNode : nodeswithupdatedbftonbroadcastdomain) {
            this.sendCompletedEvent(curNode);
        }
        this.m_domain.releaseLock((Object)this);
        LOG.info("run: node: {}, releaseLock broadcast domain: {}.", (Object)this.getNodeId(), (Object)this.m_domain.getBridgeNodesOnDomain());
    }

    @Override
    protected void runCollection() {
    }

    @Override
    public String getName() {
        return "DiscoveryBridgeTopology";
    }

    protected void calculate() {
        LOG.debug("calculate: node[{}]: Print Topology {}", (Object)this.getNodeId(), (Object)this.m_domain.printTopology());
        LOG.info("calculate: node: [{}]: start: broadcast domain {} topology calculation.", (Object)this.getNodeId(), (Object)this.m_domain.getBridgeNodesOnDomain());
        Bridge electedRoot = this.m_domain.electRootBridge();
        if (electedRoot == null && this.m_domain.hasRootBridge()) {
            LOG.debug("calculate: node [{}]: electRootBridge: mantaining old root bridge: {}", (Object)this.getNodeId(), (Object)this.m_domain.getRootBridgeId());
            electedRoot = this.m_domain.getRootBridge();
        } else if (electedRoot == null) {
            int size = 0;
            Object rootBridge = null;
            for (Bridge bridge : this.m_notYetParsedBFTMap.keySet()) {
                LOG.debug("calculate: node [{}]: bridge [{}]: max bft size \"{}\" in topology", new Object[]{this.getNodeId(), bridge.getId(), this.m_notYetParsedBFTMap.get(bridge).size()});
                if (size >= this.m_notYetParsedBFTMap.get(bridge).size()) continue;
                rootBridge = bridge;
                size = this.m_notYetParsedBFTMap.get(bridge).size();
            }
            if (rootBridge != null) {
                LOG.debug("calculate: node [{}]: bridge [{}]: elected root with max bft size \"{}\" in topology", new Object[]{this.getNodeId(), rootBridge.getId(), size});
                electedRoot = rootBridge;
            }
        }
        if (electedRoot == null) {
            electedRoot = (Bridge)this.m_domain.getBridges().iterator().next();
            LOG.debug("calculate: node [{}]: electRootBridge: first root bridge: {}", (Object)this.getNodeId(), (Object)electedRoot.getId());
        }
        if (electedRoot == null || electedRoot.getId() == null) {
            LOG.error("calculate: [{}]: electedRootBridge should not be null", (Object)this.getNodeId());
            return;
        }
        List rootBft = this.m_notYetParsedBFTMap.remove(electedRoot);
        if (this.m_domain.hasRootBridge() && this.m_domain.getRootBridge().getId() == electedRoot.getId() && rootBft == null) {
            LOG.debug("calculate: node [{}]: elected root bridge: [{}], old root bridge. no updated bft", (Object)this.getNodeId(), (Object)electedRoot.getId());
            rootBft = this.m_domain.calculateRootBFT();
        } else if (this.m_domain.hasRootBridge() && this.m_domain.getRootBridge().getId() == electedRoot.getId() && rootBft != null) {
            LOG.debug("calculate: node [{}]: elected root bridge: [{}], old root bridge. updated bft", (Object)this.getNodeId(), (Object)electedRoot.getId());
            if (this.m_domain.getTopology().isEmpty()) {
                LOG.debug("calculate: node [{}]: elected root bridge: [{}], clean topology found. Adding root shared segments", (Object)this.getNodeId(), (Object)electedRoot.getId());
                this.loadFirstLevelSharedSegment(rootBft);
            }
        } else if (rootBft != null) {
            LOG.debug("calculate: node [{}]: elected root bridge: [{}], new root. updated bft", (Object)this.getNodeId(), (Object)electedRoot.getId());
            if (this.m_domain.getTopology().isEmpty()) {
                LOG.debug("calculate: node [{}]: new elected root bridge: [{}], is the first bridge in topology. Adding root shared segments", (Object)this.getNodeId(), (Object)electedRoot.getId());
                this.loadFirstLevelSharedSegment(rootBft);
                electedRoot.setRootBridge(true);
                electedRoot.setRootPort(null);
            } else {
                this.m_domain.clearTopologyForBridge(electedRoot.getId());
                this.calculate(this.m_domain.getRootBridge(), this.m_domain.calculateRootBFT(), electedRoot, rootBft);
                this.m_domain.hierarchySetUp(electedRoot);
            }
        } else {
            LOG.debug("calculate: node [{}]: elected root bridge: [{}], is new root bridge with old bft", (Object)this.getNodeId(), (Object)electedRoot.getId());
            this.m_domain.hierarchySetUp(electedRoot);
            rootBft = this.m_domain.calculateRootBFT();
        }
        LOG.debug("calculate: node[{}]: Root Bridge [{}] elected.", new Object[]{this.getNodeId(), electedRoot.getId(), this.m_domain.printTopology()});
        for (Bridge xBridge : this.m_notYetParsedBFTMap.keySet()) {
            this.m_domain.clearTopologyForBridge(xBridge.getId());
            LOG.debug("calculate: node[{}]: Removed bridge: [{}].", (Object)this.getNodeId(), (Object)xBridge.getId());
        }
        LOG.debug("calculate: node[{}]: Print Topology {}", (Object)this.getNodeId(), (Object)this.m_domain.printTopology());
        HashSet<Bridge> nodetobeparsed = new HashSet<Bridge>(this.m_notYetParsedBFTMap.keySet());
        for (Bridge xBridge : nodetobeparsed) {
            LOG.info("calculate: node: [{}]: bridge [{}]: calculate topology: start.", (Object)this.getNodeId(), (Object)xBridge.getId());
            this.calculate(electedRoot, rootBft, xBridge, new ArrayList<BridgeMacLink>((Collection)this.m_notYetParsedBFTMap.remove(xBridge)));
            LOG.info("calculate: node: [{}]: bridge [{}]: calculate topology: stop.", (Object)this.getNodeId(), (Object)xBridge.getId());
        }
        LOG.info("calculate: node: [{}]: stop: broadcast domain {} topology calculated.", (Object)this.getNodeId(), (Object)this.m_domain.getBridgeNodesOnDomain());
        LOG.debug("calculate: node[{}]: Print Topology {}", (Object)this.getNodeId(), (Object)this.m_domain.printTopology());
    }

    private void loadFirstLevelSharedSegment(List<BridgeMacLink> electedRootBFT) {
        HashMap<Integer, SharedSegment> rootleafs = new HashMap<Integer, SharedSegment>();
        for (BridgeMacLink link : electedRootBFT) {
            if (link.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) continue;
            if (rootleafs.containsKey(link.getBridgePort())) {
                ((SharedSegment)rootleafs.get(link.getBridgePort())).add(link);
                continue;
            }
            rootleafs.put(link.getBridgePort(), new SharedSegment(this.m_domain, link));
        }
        for (SharedSegment rootleaf : rootleafs.values()) {
            LOG.debug("calculate: node [{}]: add shared segment[designated bridge:[{}],designated port:{}, macs: {}]", new Object[]{this.getNodeId(), rootleaf.getDesignatedBridge(), rootleaf.getDesignatedPort(), rootleaf.getMacsOnSegment()});
            this.m_domain.add(rootleaf);
        }
    }

    private void calculate(Bridge root, List<BridgeMacLink> rootbft, Bridge xBridge, List<BridgeMacLink> xbft) {
        BridgeTopologyHelper rx = new BridgeTopologyHelper(root, rootbft, xBridge, xbft);
        Integer rxDesignatedPort = rx.getFirstBridgeConnectionPort();
        if (rxDesignatedPort == null) {
            LOG.warn("calculate: node [{}]: cannot found simple connection for bridges: [{},{}]", new Object[]{this.getNodeId(), root.getId(), xBridge.getId()});
            this.m_domain.clearTopology();
            return;
        }
        Integer xrDesignatedPort = rx.getSecondBridgeConnectionPort();
        if (xrDesignatedPort == null) {
            LOG.warn("calculate: node [{}]: cannot found simple connectionfor bridges: [{},{}]", new Object[]{this.getNodeId(), xBridge.getId(), root.getId()});
            this.m_domain.clearTopology();
            return;
        }
        LOG.debug("calculate: node [{}]: level 1: bridge: [{}]. setting root port {} ", new Object[]{this.getNodeId(), xBridge.getId(), xrDesignatedPort});
        xBridge.setRootPort(xrDesignatedPort);
        xBridge.setRootBridge(false);
        SharedSegment topSegment = this.m_domain.getSharedSegment(root.getId(), rxDesignatedPort);
        if (topSegment == null) {
            LOG.warn("calculate: node [{}]: nodeid [{}], port {}. top segment not found.", new Object[]{this.getNodeId(), this.m_domain.getRootBridgeId(), rxDesignatedPort});
            this.m_domain.clearTopology();
            return;
        }
        if (!this.findBridgesTopo(rx, topSegment, xBridge, xbft, 0)) {
            this.m_domain.clearTopology();
        }
    }

    private boolean findBridgesTopo(BridgeTopologyHelper rx, SharedSegment topSegment, Bridge xBridge, List<BridgeMacLink> xBFT, int level) {
        LOG.debug("calculate: node [{}]: level {}: bridge: [{}], topo top segment found: [ids {}, designated bridge [{}, port {}], macs {}", new Object[]{this.getNodeId(), ++level, xBridge.getId(), topSegment.getBridgeIdsOnSegment(), topSegment.getDesignatedBridge(), topSegment.getDesignatedPort(), topSegment.getMacsOnSegment()});
        if (level == 30) {
            LOG.warn("calculate: node [{}]: level {}: bridge: [{}], too many iteration on topology exiting.....", new Object[]{this.getNodeId(), level, xBridge.getId()});
            return false;
        }
        HashSet<Integer> portsAdded = new HashSet<Integer>();
        HashSet<String> throughSets = new HashSet<String>();
        HashMap<Integer, List> bftSets = new HashMap<Integer, List>();
        for (Bridge yBridge : this.m_domain.getBridgeOnSharedSegment(topSegment)) {
            bftSets.put(yBridge.getId(), this.m_domain.calculateBFT(yBridge));
        }
        for (Bridge yBridge : this.m_domain.getBridgeOnSharedSegment(topSegment)) {
            Integer yBridgeId = yBridge.getId();
            if (yBridgeId.intValue() == topSegment.getDesignatedBridge().intValue()) continue;
            LOG.debug("calculate: node [{}]: level {}: bridge: [{}]: Bridge [{}] on top segment. Searching simple connection", new Object[]{this.getNodeId(), level, xBridge.getId(), yBridge.getId()});
            Integer yrDesignatedPort = yBridge.getRootPort();
            LOG.debug("calculate: node [{}]: level {}: bridge: {}, Bridge: [{}, designated port: {}]", new Object[]{this.getNodeId(), level, xBridge.getId(), yBridgeId, yrDesignatedPort});
            BridgeTopologyHelper yx = new BridgeTopologyHelper(yBridge, (List)bftSets.get(yBridgeId), xBridge, xBFT);
            Integer xyDesignatedPort = yx.getSecondBridgeConnectionPort();
            Integer yxDesignatedPort = yx.getFirstBridgeConnectionPort();
            if (xyDesignatedPort == rx.getSecondBridgeConnectionPort() && yxDesignatedPort != yrDesignatedPort) {
                LOG.debug("calculate: node [{}]: level {}: Bridge: [{}] is a leaf of Bridge: [{}], going one level down", new Object[]{this.getNodeId(), level, xBridge.getId(), yBridge.getId()});
                return this.findBridgesTopo(yx, this.m_domain.getSharedSegment(yBridgeId, yxDesignatedPort), xBridge, xBFT, level);
            }
            if (yxDesignatedPort == yrDesignatedPort && xyDesignatedPort != rx.getSecondBridgeConnectionPort()) {
                LOG.debug("calculate: node [{}]: level {}: bridge: [{},designated port [{}]]: is 'upper' Bridge: [{}]. Adding shared segment.", new Object[]{this.getNodeId(), level, xBridge.getId(), yBridge.getId(), xyDesignatedPort});
                SharedSegment leafSegment = new SharedSegment(this.m_domain, yx.getSimpleConnection().getDlink(), yx.getSimpleConnection().getMacs());
                leafSegment.setDesignatedBridge(xBridge.getId());
                this.m_domain.add(leafSegment);
                portsAdded.add(xyDesignatedPort);
                LOG.debug("calculate: node [{}]: level {}: bridge [{}]. Removing Bridge [{}]: through set {} from top segment.", new Object[]{this.getNodeId(), level, xBridge.getId(), yBridge.getId(), yx.getFirstBridgeTroughSet()});
                topSegment.removeMacs(yx.getFirstBridgeTroughSet());
                LOG.debug("calculate: node [{}]: level {}: bridge [{}]. Remove bridge [{}] from top segment.", new Object[]{this.getNodeId(), level, xBridge.getId(), yBridge.getId()});
                topSegment.removeBridge(yBridgeId.intValue());
            }
            if (xyDesignatedPort != rx.getSecondBridgeConnectionPort() && yxDesignatedPort != yrDesignatedPort) {
                LOG.warn("calculate: node [{}]: level {}: bridge [{}]. Topology mismatch. Clearing...topology", new Object[]{this.getNodeId(), level, xBridge.getId()});
                return false;
            }
            throughSets.addAll(yx.getFirstBridgeTroughSet());
        }
        LOG.debug("calculate: node [{}]: level {}: bridge: [{}]. removing through set {} from top segment", new Object[]{this.getNodeId(), level, xBridge.getId(), rx.getSecondBridgeTroughSet()});
        topSegment.removeMacs(rx.getSecondBridgeTroughSet());
        LOG.debug("calculate: node [{}]: level {}: bridge: [{}]. assign macs {} to top segment", new Object[]{this.getNodeId(), level, xBridge.getId(), rx.getSimpleConnection().getMacs()});
        topSegment.assign(rx.getSimpleConnection().getMacs(), rx.getSimpleConnection().getDlink());
        LOG.debug("calculate: node [{}]: level {}: bridge: [{}]. removing through sets {} from top segment", new Object[]{this.getNodeId(), level, xBridge.getId(), throughSets});
        topSegment.removeMacs(throughSets);
        LOG.debug("calculate: node [{}]: level {}: bridge: [{}]. resulting top segment: [ids {}, designated bridge [{}, port: {}], mac : {}]", new Object[]{this.getNodeId(), level, xBridge.getId(), topSegment.getBridgeIdsOnSegment(), topSegment.getDesignatedBridge(), topSegment.getDesignatedPort(), topSegment.getMacsOnSegment()});
        for (Integer xbridgePort : rx.getSecondBridgeTroughSetBft().keySet()) {
            if (portsAdded.contains(xbridgePort)) continue;
            SharedSegment xleafSegment = new SharedSegment(this.m_domain, rx.getSecondBridgeTroughSetBft().get(xbridgePort));
            xleafSegment.setDesignatedBridge(xBridge.getId());
            this.m_domain.add(xleafSegment);
            LOG.debug("calculate: node [{}]: level {}: bridge: [{}]. Add shared segment. [ designated bridge:[{}], port:{}, mac: {}]", new Object[]{this.getNodeId(), level, xBridge.getId(), xleafSegment.getDesignatedBridge(), xleafSegment.getDesignatedPort(), xleafSegment.getMacsOnSegment()});
        }
        return true;
    }

    private class BridgeTopologyHelper {
        Integer m_xy;
        Integer m_yx;
        Map<Integer, List<BridgeMacLink>> m_throughSetX = new HashMap<Integer, List<BridgeMacLink>>();
        Map<Integer, List<BridgeMacLink>> m_throughSetY = new HashMap<Integer, List<BridgeMacLink>>();
        Set<String> m_xythrowsetmacs = new HashSet<String>();
        SimpleConnection m_simpleconnection;

        public BridgeTopologyHelper(Bridge xBridge, List<BridgeMacLink> xBFT, Bridge yBridge, List<BridgeMacLink> yBFT) {
            Integer yx;
            Integer xy;
            HashMap<String, BridgeMacLink> xmactoport = new HashMap<String, BridgeMacLink>();
            HashMap<String, BridgeMacLink> ymactoport = new HashMap<String, BridgeMacLink>();
            HashSet<String> xmacs = new HashSet<String>();
            HashSet<String> ymacs = new HashSet<String>();
            LOG.debug("BridgeTopologyHelper: nodes [{}, {}]: search simple connection.\n xbft\n{}\n ybft\n{}", new Object[]{xBridge.getId(), yBridge.getId(), BroadcastDomain.printTopologyBFT(xBFT), BroadcastDomain.printTopologyBFT(yBFT)});
            for (BridgeMacLink xlink : xBFT) {
                if (xBridge.getId().intValue() == xlink.getNode().getId().intValue() && xlink.getBridgeDot1qTpFdbStatus() == BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) {
                    xmactoport.put(xlink.getMacAddress(), xlink);
                }
                if (xBridge.getId().intValue() != xlink.getNode().getId().intValue() || xlink.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_SELF) continue;
                xmacs.add(xlink.getMacAddress());
            }
            for (BridgeMacLink ylink : yBFT) {
                if (yBridge.getId().intValue() == ylink.getNode().getId().intValue() && ylink.getBridgeDot1qTpFdbStatus() == BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) {
                    ymactoport.put(ylink.getMacAddress(), ylink);
                }
                if (yBridge.getId().intValue() != ylink.getNode().getId().intValue() || ylink.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_SELF) continue;
                ymacs.add(ylink.getMacAddress());
            }
            if (NodeDiscoveryBridgeTopology.this.m_domain.getBridgeMacAddresses(xBridge.getId()) != null) {
                xmacs.addAll(NodeDiscoveryBridgeTopology.this.m_domain.getBridgeMacAddresses(xBridge.getId()));
            }
            if (NodeDiscoveryBridgeTopology.this.m_domain.getBridgeMacAddresses(yBridge.getId()) != null) {
                ymacs.addAll(NodeDiscoveryBridgeTopology.this.m_domain.getBridgeMacAddresses(yBridge.getId()));
            }
            if ((xy = this.condition1(ymacs, xmactoport)) != null) {
                this.m_xy = xy;
            }
            if ((yx = this.condition1(xmacs, ymactoport)) != null) {
                this.m_yx = yx;
            }
            if (this.m_xy == null || this.m_yx == null) {
                HashSet<String> commonlearnedmacs = new HashSet<String>(xmactoport.keySet());
                commonlearnedmacs.retainAll(new HashSet(ymactoport.keySet()));
                LOG.debug("BridgeTopologyHelper: bridges [{},{}] common (learned mac): {}", new Object[]{xBridge.getId(), yBridge.getId(), commonlearnedmacs});
                if (this.m_yx != null && this.m_xy == null) {
                    this.m_xy = this.condition2(commonlearnedmacs, this.m_yx, ymactoport, xmactoport);
                }
                if (this.m_yx == null && this.m_xy != null) {
                    this.m_yx = this.condition2(commonlearnedmacs, this.m_xy, xmactoport, ymactoport);
                }
                if (this.m_yx == null || this.m_xy == null) {
                    List<Integer> ports = this.condition3(commonlearnedmacs, xmactoport, ymactoport);
                    this.m_xy = ports.get(0);
                    this.m_yx = ports.get(1);
                }
                if (this.m_xy == null || this.m_xy == null) {
                    return;
                }
            }
            LOG.debug("BridgeTopologyHelper: simple connection: [nodeid {}, port {}] <--> [nodeid {}, port {}]", new Object[]{xBridge.getId(), this.m_xy, yBridge.getId(), this.m_yx});
            BridgeMacLink xylink = null;
            BridgeMacLink yxlink = null;
            HashSet<String> macsOnSegment = new HashSet<String>();
            for (BridgeMacLink xlink : xBFT) {
                if (xlink.getBridgePort() == this.m_xy && xlink.getBridgeDot1qTpFdbStatus() == BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) {
                    if (ymactoport.get(xlink.getMacAddress()) != null && this.m_yx == ((BridgeMacLink)ymactoport.get(xlink.getMacAddress())).getBridgePort()) {
                        macsOnSegment.add(xlink.getMacAddress());
                        LOG.debug("BridgeTopologyHelper: simple connection: link added: [bridge:[{}],port:{},mac:{}].", new Object[]{xlink.getNode().getId(), xlink.getBridgePort(), xlink.getMacAddress()});
                    } else {
                        this.m_xythrowsetmacs.add(xlink.getMacAddress());
                        LOG.debug("BridgeTopologyHelper: simple connection: throghset: mac added: [bridge:[{}],port:{},mac:{}].", new Object[]{xlink.getNode().getId(), xlink.getBridgePort(), xlink.getMacAddress()});
                    }
                    if (xylink != null) continue;
                    xylink = xlink;
                    continue;
                }
                if (xlink.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) continue;
                LOG.debug("BridgeTopologyHelper: throgh set: link added: [bridge:[{}],port:{},mac:{}].", new Object[]{xlink.getNode().getId(), xlink.getBridgePort(), xlink.getMacAddress()});
                if (!this.m_throughSetX.containsKey(xlink.getBridgePort())) {
                    this.m_throughSetX.put(xlink.getBridgePort(), new ArrayList());
                }
                this.m_throughSetX.get(xlink.getBridgePort()).add(xlink);
            }
            for (BridgeMacLink ylink : yBFT) {
                if (ylink.getBridgePort() == this.m_yx && ylink.getBridgeDot1qTpFdbStatus() == BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) {
                    if (xmactoport.get(ylink.getMacAddress()) != null && this.m_xy == ((BridgeMacLink)xmactoport.get(ylink.getMacAddress())).getBridgePort()) {
                        macsOnSegment.add(ylink.getMacAddress());
                        LOG.debug("BridgeTopologyHelper: simple connection: link added: [bridge:[{}],port:{},mac:{}].", new Object[]{ylink.getNode().getId(), ylink.getBridgePort(), ylink.getMacAddress()});
                    } else {
                        this.m_xythrowsetmacs.add(ylink.getMacAddress());
                        LOG.debug("BridgeTopologyHelper: simple connection: throghset: mac added: [bridge:[{}],port:{},mac:{}].", new Object[]{ylink.getNode().getId(), ylink.getBridgePort(), ylink.getMacAddress()});
                    }
                    if (yxlink != null) continue;
                    yxlink = ylink;
                    continue;
                }
                if (ylink.getBridgeDot1qTpFdbStatus() != BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED) continue;
                LOG.debug("BridgeTopologyHelper: throgh set: link added: [bridge:[{}],port:{},mac:{}].", new Object[]{ylink.getNode().getId(), ylink.getBridgePort(), ylink.getMacAddress()});
                if (!this.m_throughSetY.containsKey(ylink.getBridgePort())) {
                    this.m_throughSetY.put(ylink.getBridgePort(), new ArrayList());
                }
                this.m_throughSetY.get(ylink.getBridgePort()).add(ylink);
            }
            LOG.debug("BridgeTopologyHelper: links:{}, found on simple connection.", (Object)macsOnSegment.size());
            BridgeBridgeLink blink = new BridgeBridgeLink();
            if (xylink != null && yxlink != null) {
                blink.setNode(yxlink.getNode());
                blink.setBridgePort(yxlink.getBridgePort());
                blink.setBridgePortIfIndex(yxlink.getBridgePortIfIndex());
                blink.setBridgePortIfName(yxlink.getBridgePortIfName());
                blink.setVlan(yxlink.getVlan());
                blink.setDesignatedNode(xylink.getNode());
                blink.setDesignatedPort(xylink.getBridgePort());
                blink.setDesignatedPortIfIndex(xylink.getBridgePortIfIndex());
                blink.setDesignatedPortIfName(xylink.getBridgePortIfName());
                blink.setDesignatedVlan(xylink.getVlan());
            }
            this.m_simpleconnection = new SimpleConnection(macsOnSegment, blink);
        }

        private List<Integer> condition3(Set<String> commonlearnedmacs, Map<String, BridgeMacLink> xbft, Map<String, BridgeMacLink> ybft) {
            String mac1 = null;
            String mac2 = null;
            Integer yp1 = null;
            Integer yp2 = null;
            Integer xp1 = null;
            Integer xp2 = null;
            ArrayList<Integer> bbports = new ArrayList<Integer>(2);
            for (String mac : commonlearnedmacs) {
                LOG.debug("BridgeTopologyHelper: condition3: parsing common BFT mac: {}", (Object)mac);
                if (mac1 == null) {
                    mac1 = mac;
                    yp1 = ybft.get(mac).getBridgePort();
                    xp1 = xbft.get(mac).getBridgePort();
                    LOG.debug("BridgeTopologyHelper: condition3: mac1: {} xp1: {} yp1: {} ", new Object[]{mac1, xp1, yp1});
                    continue;
                }
                if (ybft.get(mac).getBridgePort() == yp1 && xbft.get(mac).getBridgePort() == xp1) continue;
                if (mac2 == null) {
                    mac2 = mac;
                    yp2 = ybft.get(mac).getBridgePort();
                    xp2 = xbft.get(mac).getBridgePort();
                    LOG.debug("BridgeTopologyHelper: condition3: mac2: {} xp2: {} yp2: {} ", new Object[]{mac2, xp2, yp2});
                    continue;
                }
                if (ybft.get(mac).getBridgePort() == yp2 && xbft.get(mac).getBridgePort() == xp2) continue;
                Integer yp3 = ybft.get(mac).getBridgePort();
                Integer xp3 = xbft.get(mac).getBridgePort();
                LOG.debug("BridgeTopologyHelper: condition3: mac3: {} x3: {} yp3: {} ", new Object[]{mac, xp3, yp3});
                if (xp1 == xp2 && xp1 != xp3 && (yp1 != yp3 || yp2 != yp3)) {
                    bbports.add(0, xp1);
                    bbports.add(1, yp3);
                    return bbports;
                }
                if (yp1 == yp2 && yp1 != yp3 && (xp1 != xp3 || xp2 != xp3)) {
                    bbports.add(0, xp3);
                    bbports.add(1, yp1);
                    return bbports;
                }
                if (xp1 == xp3 && xp1 != xp2 && (yp1 != yp2 || yp2 != yp3)) {
                    bbports.add(0, xp1);
                    bbports.add(1, yp2);
                    return bbports;
                }
                if (yp1 == yp3 && yp1 != yp2 && (xp1 != xp2 || xp2 != xp3)) {
                    bbports.add(0, xp2);
                    bbports.add(1, yp1);
                    return bbports;
                }
                if (xp3 == xp2 && xp1 != xp3 && (yp1 != yp3 || yp2 != yp1)) {
                    bbports.add(0, xp2);
                    bbports.add(1, yp1);
                    return bbports;
                }
                if (yp3 != yp2 || yp1 == yp3 || xp1 == xp3 && xp2 == xp1) continue;
                bbports.add(0, xp1);
                bbports.add(1, yp2);
                return bbports;
            }
            if (mac2 == null) {
                bbports.add(0, xp1);
                bbports.add(1, yp1);
                return bbports;
            }
            return bbports;
        }

        private Integer condition2(Set<String> commonlearnedmacs, Integer yx, Map<String, BridgeMacLink> ybft, Map<String, BridgeMacLink> xbft) {
            String mac1 = null;
            String mac2 = null;
            Integer p1 = null;
            Integer xy1 = null;
            Integer p2 = null;
            Integer xy2 = null;
            for (String mac : commonlearnedmacs) {
                if (mac1 == null) {
                    mac1 = mac;
                    p1 = ybft.get(mac).getBridgePort();
                    xy1 = xbft.get(mac).getBridgePort();
                    LOG.debug("BridgeTopologyHelper: condition2: mac1: {} xy1: {} p1: {} ", new Object[]{mac1, xy1, p1});
                    continue;
                }
                if (ybft.get(mac).getBridgePort().intValue() == p1.intValue()) continue;
                if (xbft.get(mac).getBridgePort().intValue() == xy1.intValue()) {
                    LOG.debug("BridgeTopologyHelper: condition2: xy1 bridge port {}", (Object)xy1);
                    return xy1;
                }
                if (mac2 == null) {
                    mac2 = mac;
                    p2 = ybft.get(mac).getBridgePort();
                    xy2 = xbft.get(mac).getBridgePort();
                    LOG.debug("BridgeTopologyHelper: condition2: mac2: {} xy2: {} p2: {} ", new Object[]{mac2, xy2, p2});
                    continue;
                }
                if (ybft.get(mac).getBridgePort().intValue() == p2.intValue() || xbft.get(mac).getBridgePort().intValue() != xy2.intValue()) continue;
                LOG.debug("BridgeTopologyHelper: condition2: xy2 bridge port {}", (Object)xy2);
                return xy2;
            }
            if (xy2 == null) {
                return xy1;
            }
            return null;
        }

        private Integer condition1(Set<String> bridgemacaddressess, Map<String, BridgeMacLink> otherbridgeft) {
            for (String mac : bridgemacaddressess) {
                if (!otherbridgeft.containsKey(mac)) continue;
                LOG.debug("BridgeTopologyHelper: condition1: base address {} --> port: {} ", (Object)mac, (Object)otherbridgeft.get(mac).getBridgePort());
                return otherbridgeft.get(mac).getBridgePort();
            }
            LOG.debug("BridgeTopologyHelper: condition1: [base address: {}]. Not found.", bridgemacaddressess);
            return null;
        }

        public Integer getFirstBridgeConnectionPort() {
            return this.m_xy;
        }

        public Integer getSecondBridgeConnectionPort() {
            return this.m_yx;
        }

        public SimpleConnection getSimpleConnection() {
            return this.m_simpleconnection;
        }

        public Set<String> getFirstBridgeTroughSet() {
            HashSet<String> macs = new HashSet<String>();
            for (List<BridgeMacLink> links : this.m_throughSetX.values()) {
                for (BridgeMacLink link : links) {
                    macs.add(link.getMacAddress());
                }
            }
            macs.addAll(this.m_xythrowsetmacs);
            return macs;
        }

        public Set<String> getSecondBridgeTroughSet() {
            HashSet<String> macs = new HashSet<String>();
            for (List<BridgeMacLink> links : this.m_throughSetY.values()) {
                for (BridgeMacLink link : links) {
                    macs.add(link.getMacAddress());
                }
            }
            macs.addAll(this.m_xythrowsetmacs);
            return macs;
        }

        public Map<Integer, List<BridgeMacLink>> getSecondBridgeTroughSetBft() {
            return this.m_throughSetY;
        }
    }
}

