/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import javax.sql.DataSource;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.junit.Ignore;
import org.junit.runner.RunWith;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.test.ConfigurationTestUtils;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.core.test.db.TemporaryDatabaseAware;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.TimeConverter;
import org.opennms.netmgt.config.DestinationPathManager;
import org.opennms.netmgt.config.GroupManager;
import org.opennms.netmgt.config.NotifdConfigManager;
import org.opennms.netmgt.config.NotificationCommandManager;
import org.opennms.netmgt.config.NotificationManager;
import org.opennms.netmgt.config.PollOutagesConfigManager;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.config.groups.Group;
import org.opennms.netmgt.config.mock.MockDestinationPathManager;
import org.opennms.netmgt.config.mock.MockGroupManager;
import org.opennms.netmgt.config.mock.MockNotifdConfigManager;
import org.opennms.netmgt.config.mock.MockNotificationCommandManager;
import org.opennms.netmgt.config.mock.MockNotificationManager;
import org.opennms.netmgt.config.mock.MockNotificationStrategy;
import org.opennms.netmgt.config.mock.MockUserManager;
import org.opennms.netmgt.config.users.Contact;
import org.opennms.netmgt.config.users.User;
import org.opennms.netmgt.dao.mock.MockEventIpcManager;
import org.opennms.netmgt.eventd.EventUtil;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventWriter;
import org.opennms.netmgt.mock.MockNetwork;
import org.opennms.netmgt.mock.MockNotification;
import org.opennms.netmgt.mock.MockPollerConfig;
import org.opennms.netmgt.mock.NotificationAnticipator;
import org.opennms.netmgt.notifd.BroadcastEventProcessor;
import org.opennms.netmgt.notifd.Notifd;
import org.opennms.test.DaoTestConfigBean;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.test.mock.MockUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-commonConfigs.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath:/META-INF/opennms/mockEventIpcManager.xml", "classpath:/META-INF/opennms/applicationContext-notifdTest.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(tempDbClass=MockDatabase.class, reuseDatabase=false)
@Ignore
public class NotificationsITCase
implements TemporaryDatabaseAware<MockDatabase> {
    @Autowired
    protected Notifd m_notifd;
    @Autowired
    protected BroadcastEventProcessor m_eventProcessor;
    @Autowired
    protected EventUtil m_eventUtil;
    protected MockEventIpcManager m_eventMgr;
    protected MockNotifdConfigManager m_notifdConfig;
    protected MockGroupManager m_groupManager;
    protected MockUserManager m_userManager;
    protected NotificationManager m_notificationManager;
    protected NotificationCommandManager m_notificationCommandManger;
    protected MockDestinationPathManager m_destinationPathManager;
    protected MockDatabase m_db;
    protected MockNetwork m_network;
    protected NotificationAnticipator m_anticipator;
    private PollOutagesConfigManager m_pollOutagesConfigManager;

    protected void setUp() throws Exception {
        MockUtil.println((String)"################# Running Test ################");
        DaoTestConfigBean bean = new DaoTestConfigBean();
        bean.afterPropertiesSet();
        MockLogAppender.setupLogging();
        this.m_network = this.createMockNetwork();
        this.m_db.populate(this.m_network);
        DataSourceFactory.setInstance((DataSource)this.m_db);
        this.m_eventMgr = new MockEventIpcManager();
        this.m_eventMgr.setEventWriter((EventWriter)this.m_db);
        this.m_notifdConfig = new MockNotifdConfigManager(ConfigurationTestUtils.getConfigForResourceWithReplacements((Object)this, (String)"notifd-configuration.xml", (String[][])new String[0][]));
        this.m_notifdConfig.setNextNotifIdSql(this.m_db.getNextNotifIdSql());
        this.m_notifdConfig.setNextUserNotifIdSql(this.m_db.getNextUserNotifIdSql());
        this.m_groupManager = this.createGroupManager();
        this.m_userManager = this.createUserManager(this.m_groupManager);
        this.m_destinationPathManager = new MockDestinationPathManager(ConfigurationTestUtils.getConfigForResourceWithReplacements((Object)this, (String)"destination-paths.xml", (String[][])new String[0][]));
        this.m_notificationCommandManger = new MockNotificationCommandManager(ConfigurationTestUtils.getConfigForResourceWithReplacements((Object)this, (String)"notification-commands.xml", (String[][])new String[0][]));
        this.m_notificationManager = new MockNotificationManager((NotifdConfigManager)this.m_notifdConfig, (DataSource)this.m_db, ConfigurationTestUtils.getConfigForResourceWithReplacements((Object)this, (String)"notifications.xml", (String[][])new String[0][]));
        this.m_pollOutagesConfigManager = new MockPollerConfig(this.m_network);
        this.m_anticipator = new NotificationAnticipator();
        MockNotificationStrategy.setAnticipator((NotificationAnticipator)this.m_anticipator);
        this.m_notifd.setConfigManager((NotifdConfigManager)this.m_notifdConfig);
        this.m_eventProcessor.setEventManager((EventIpcManager)this.m_eventMgr);
        this.m_eventProcessor.setNotifdConfigManager((NotifdConfigManager)this.m_notifdConfig);
        this.m_eventProcessor.setGroupManager((GroupManager)this.m_groupManager);
        this.m_eventProcessor.setUserManager((UserManager)this.m_userManager);
        this.m_eventProcessor.setDestinationPathManager((DestinationPathManager)this.m_destinationPathManager);
        this.m_eventProcessor.setNotificationCommandManager(this.m_notificationCommandManger);
        this.m_eventProcessor.setNotificationManager(this.m_notificationManager);
        this.m_eventProcessor.setPollOutagesConfigManager(this.m_pollOutagesConfigManager);
        this.m_notifd.init();
        this.m_notifd.start();
        MockUtil.println((String)"################ Finish Setup ################");
    }

    protected MockNetwork createMockNetwork() {
        MockNetwork network = new MockNetwork();
        network.createStandardNetwork();
        return network;
    }

    private MockUserManager createUserManager(MockGroupManager groupManager) throws MarshalException, ValidationException, IOException {
        return new MockUserManager((GroupManager)groupManager, ConfigurationTestUtils.getConfigForResourceWithReplacements((Object)this, (String)"users.xml", (String[][])new String[0][]));
    }

    private MockGroupManager createGroupManager() throws MarshalException, ValidationException, IOException {
        return new MockGroupManager(ConfigurationTestUtils.getConfigForResourceWithReplacements((Object)this, (String)"groups.xml", (String[][])new String[0][]));
    }

    protected void tearDown() throws Exception {
        this.tearDown(false);
    }

    protected void tearDown(boolean allowAllLogMessages) throws Exception {
        this.m_eventMgr.finishProcessingEvents();
        this.m_notifd.stop();
        MockNotificationStrategy.setAnticipator(null);
        if (!allowAllLogMessages) {
            MockLogAppender.assertNoWarningsOrGreater();
        }
    }

    public void testDoNothing() {
    }

    protected long anticipateNotificationsForGroup(String subject, String textMsg, String groupName, Date startTime, long interval) throws Exception {
        return this.anticipateNotificationsForGroup(subject, textMsg, groupName, startTime.getTime(), interval);
    }

    protected long anticipateNotificationsForGroup(String subject, String textMsg, String groupName, long startTime, long interval) throws Exception {
        Group group = this.m_groupManager.getGroup(groupName);
        String[] users = group.getUser();
        return this.anticipateNotificationsForUsers(users, subject, textMsg, startTime, interval);
    }

    protected long anticipateNotificationsForRole(String subject, String textMsg, String groupName, Date startTime, long interval) throws Exception {
        return this.anticipateNotificationsForRole(subject, textMsg, groupName, startTime.getTime(), interval);
    }

    protected long anticipateNotificationsForRole(String subject, String textMsg, String roleName, long startTime, long interval) throws MarshalException, ValidationException, IOException {
        String[] users = this.m_userManager.getUsersScheduledForRole(roleName, new Date(startTime));
        return this.anticipateNotificationsForUsers(users, subject, textMsg, startTime, interval);
    }

    protected long anticipateNotificationsForUsers(String[] users, String subject, String textMsg, long startTime, long interval) throws IOException, MarshalException, ValidationException {
        long expectedTime = startTime;
        for (int i = 0; i < users.length; ++i) {
            User user = this.m_userManager.getUser(users[i]);
            Contact[] contacts = user.getContacts().toArray(new Contact[0]);
            for (int j = 0; j < contacts.length; ++j) {
                Contact contact = contacts[j];
                if (!"email".equals(contact.getType())) continue;
                this.m_anticipator.anticipateNotification(this.createMockNotification(expectedTime, subject, textMsg, contact.getInfo()));
            }
            expectedTime += interval;
        }
        return expectedTime - interval;
    }

    protected Collection<String> getUsersInGroup(String groupName) throws Exception {
        Group group = this.m_groupManager.getGroup(groupName);
        String[] users = group.getUser();
        return Arrays.asList(users);
    }

    protected void verifyAnticipated(long lastNotifyTime, long waitTime) {
        this.verifyAnticipated(lastNotifyTime, waitTime, 1000L);
    }

    protected void verifyAnticipated(long lastNotifyTime, long waitTime, long sleepTime) {
        this.m_anticipator.verifyAnticipated(lastNotifyTime, waitTime, sleepTime);
    }

    protected void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected MockNotification createMockNotification(long expectedTime, String subject, String textMsg, String email) {
        MockNotification notification = new MockNotification();
        notification.setExpectedTime(expectedTime);
        notification.setSubject(subject);
        notification.setTextMsg(textMsg);
        notification.setEmail(email);
        return notification;
    }

    protected long computeInterval() throws IOException, MarshalException, ValidationException {
        String interval = this.m_destinationPathManager.getPath("Intervals").getTarget(0).getInterval();
        return TimeConverter.convertToMillis((String)interval);
    }

    public void setTemporaryDatabase(MockDatabase database) {
        this.m_db = database;
    }
}

