/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.opennms.netmgt.notifd.MicroblogAuthorization;
import org.opennms.netmgt.notifd.MicroblogClient;
import org.springframework.core.io.Resource;
import org.springframework.security.util.InMemoryResource;

public class MicroblogClientTest {
    private final String m_consumerKey = "";
    private final String m_consumerSecret = "";

    @Test
    public void testOAuthConfig() {
        InMemoryResource configResource = new InMemoryResource("<?xml version=\"1.0\"?>\n<microblog-configuration default-microblog-profile-name=\"twitter\">\n    <microblog-profile\n        name=\"twitter\"\n        service-url=\"https://twitter.com/\"\n        oauth-consumer-key=\"ABC\"\n        oauth-consumer-secret=\"DEF\"\n    />\n</microblog-configuration>\n");
        MicroblogClient client = new MicroblogClient((Resource)configResource);
        String profile = "twitter";
        Assert.assertNotNull((Object)client.getProfile("twitter"));
        Assert.assertTrue((boolean)client.hasOAuth("twitter"));
        Assert.assertFalse((boolean)client.hasBasicAuth("twitter"));
        Assert.assertFalse((boolean)client.hasOAuthAccessToken("twitter"));
    }

    @Test
    public void testPasswordConfig() {
        InMemoryResource configResource = new InMemoryResource("<?xml version=\"1.0\"?>\n<microblog-configuration default-microblog-profile-name=\"twitter\">\n    <microblog-profile\n        name=\"twitter\"\n        authen-username=\"thisIsBogus\"\n        authen-password=\"thisIsAlsoBogus\"\n        service-url=\"https://twitter.com/\"\n    />\n</microblog-configuration>\n");
        MicroblogClient client = new MicroblogClient((Resource)configResource);
        String profile = "twitter";
        Assert.assertNotNull((Object)client.getProfile("twitter"));
        Assert.assertFalse((boolean)client.hasOAuth("twitter"));
        Assert.assertTrue((boolean)client.hasBasicAuth("twitter"));
        Assert.assertFalse((boolean)client.hasOAuthAccessToken("twitter"));
    }

    @Test
    @Ignore
    public void testOAuthRegistration() throws Exception {
        InMemoryResource configResource = new InMemoryResource("<?xml version=\"1.0\"?>\n<microblog-configuration default-microblog-profile-name=\"twitter\">\n    <microblog-profile\n        name=\"twitter\"\n        service-url=\"https://twitter.com/\"\n        oauth-consumer-key=\"\"\n        oauth-consumer-secret=\"\"\n    />\n</microblog-configuration>\n");
        MicroblogClient client = new MicroblogClient((Resource)configResource);
        String profile = "twitter";
        Assert.assertNotNull((Object)client.getProfile("twitter"));
        Assert.assertTrue((boolean)client.hasOAuth("twitter"));
        Assert.assertFalse((boolean)client.hasBasicAuth("twitter"));
        Assert.assertFalse((boolean)client.hasOAuthAccessToken("twitter"));
        MicroblogAuthorization auth = client.requestAuthorization("twitter");
        Assert.assertNotNull((Object)auth);
        Assert.assertNotNull((Object)auth.getUrl());
        Assert.assertTrue((String)(auth.getUrl() + " should contain twitter.com/"), (boolean)auth.getUrl().contains("twitter.com/"));
    }
}

