/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.enlinkd.EnLinkdBuilderITCase;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.nb.Nms0123NetworkBuilder;

public class Nms0123EnIT
extends EnLinkdBuilderITCase {
    Nms0123NetworkBuilder builder = new Nms0123NetworkBuilder();

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="1.1.1.1", port=161, resource="classpath:linkd/nms0123/itpn0111.txt")})
    public void testItpn0111Lldp() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getItpn0111());
        this.m_nodeDao.flush();
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(true);
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(false);
        Assert.assertTrue((boolean)this.m_linkdConfig.useLldpDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useBridgeDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        OnmsNode itpn0111 = this.m_nodeDao.findByForeignId("linkd", "itpn0111");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(itpn0111.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_lldpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(itpn0111.getId().intValue()));
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            if (node.getLldpElement() == null) continue;
            Nms0123EnIT.printLldpElement(node.getLldpElement());
        }
        List topologyA = this.m_lldpLinkDao.findAll();
        Assert.assertEquals((long)4L, (long)topologyA.size());
        Nms0123EnIT.printLldpTopology(topologyA);
    }

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="2.2.2.2", port=161, resource="classpath:linkd/nms0123/itpn0112.txt")})
    public void testItpn0112Lldp() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getItpn0112());
        this.m_nodeDao.flush();
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(true);
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(false);
        Assert.assertTrue((boolean)this.m_linkdConfig.useLldpDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useBridgeDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        OnmsNode itpn0112 = this.m_nodeDao.findByForeignId("linkd", "itpn0112");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(itpn0112.getId().intValue()));
        Assert.assertEquals((long)0L, (long)this.m_lldpLinkDao.countAll());
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(itpn0112.getId().intValue()));
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            if (node.getLldpElement() == null) continue;
            Nms0123EnIT.printLldpElement(node.getLldpElement());
        }
        List topologyA = this.m_lldpLinkDao.findAll();
        Assert.assertEquals((long)2L, (long)topologyA.size());
        Nms0123EnIT.printLldpTopology(topologyA);
    }
}

