/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.model.BridgeBridgeLink;
import org.opennms.netmgt.model.BridgeElement;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.CdpElement;
import org.opennms.netmgt.model.CdpLink;
import org.opennms.netmgt.model.LldpElement;
import org.opennms.netmgt.model.LldpLink;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OspfElement;
import org.opennms.netmgt.model.OspfLink;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.model.topology.SharedSegment;

public abstract class EnLinkdTestHelper {
    protected static void printLldpTopology(List<LldpLink> lldplinks) {
        for (LldpLink link : lldplinks) {
            EnLinkdTestHelper.printLldpLink(link);
        }
    }

    protected static void printLldpElements(List<LldpElement> lldpelements) {
        for (LldpElement element : lldpelements) {
            EnLinkdTestHelper.printLldpElement(element);
        }
    }

    protected static void printCdpElement(CdpElement cdpElement) {
        System.err.println("----------cdp element --------");
        System.err.println("Nodeid: " + cdpElement.getNode().getId());
        System.err.println("Cdp Global Device Id: " + cdpElement.getCdpGlobalDeviceId());
        System.err.println("Cdp Global Run: " + OspfElement.TruthValue.getTypeString((Integer)cdpElement.getCdpGlobalRun().getValue()));
    }

    protected static void printCdpLink(CdpLink link) {
        System.err.println("----------cdp link --------");
        System.err.println("Create time: " + link.getCdpLinkCreateTime());
        System.err.println("Last Poll time: " + link.getCdpLinkLastPollTime());
        System.err.println("----------Source Node--------");
        System.err.println("Nodeid: " + link.getNode().getId());
        System.err.println("----------Source Port--------");
        System.err.println("cdpcacheifindex: " + link.getCdpCacheIfIndex());
        System.err.println("cdpcachedeviceindex: " + link.getCdpCacheDeviceIndex());
        System.err.println("cdpinterfacename: " + link.getCdpInterfaceName());
        System.err.println("----------Rem Node--------");
        System.err.println("cdpcacheaddresstype: " + CdpLink.CiscoNetworkProtocolType.getTypeString((Integer)link.getCdpCacheAddressType().getValue()));
        System.err.println("cdpcacheaddress: " + link.getCdpCacheAddress());
        System.err.println("cdpcacheversion: " + link.getCdpCacheVersion());
        System.err.println("cdpcachedeviceid: " + link.getCdpCacheDeviceId());
        System.err.println("cdpcachedeviceplatform: " + link.getCdpCacheDevicePlatform());
        System.err.println("----------Remote Port--------");
        System.err.println("cdpcachedeviceport: " + link.getCdpCacheDevicePort());
        System.err.println("");
    }

    protected static void printLldpElement(LldpElement lldpElement) {
        System.err.println("----------lldp element --------");
        System.err.println("Nodeid: " + lldpElement.getNode().getId());
        System.err.println("lldp chassis type/id: " + LldpUtils.LldpChassisIdSubType.getTypeString((Integer)lldpElement.getLldpChassisIdSubType().getValue()) + "/" + lldpElement.getLldpChassisId());
        System.err.println("lldp sysname: " + lldpElement.getLldpSysname());
    }

    protected static void printLldpLink(LldpLink link) {
        System.err.println("----------lldp link --------");
        System.err.println("Create time: " + link.getLldpLinkCreateTime());
        System.err.println("Last Poll time: " + link.getLldpLinkLastPollTime());
        System.err.println("----------Source Node--------");
        System.err.println("Nodeid: " + link.getNode().getId());
        System.err.println("----------Source Port--------");
        System.err.println("lldp port num: " + link.getLldpLocalPortNum());
        System.err.println("lldp port ifindex: " + link.getLldpPortIfindex());
        System.err.println("lldp port type/id: " + LldpUtils.LldpPortIdSubType.getTypeString((Integer)link.getLldpPortIdSubType().getValue()) + "/" + link.getLldpPortId());
        System.err.println("lldp port descr: " + link.getLldpPortDescr());
        System.err.println("----------Rem Node--------");
        System.err.println("lldp rem chassis type/id: " + LldpUtils.LldpChassisIdSubType.getTypeString((Integer)link.getLldpRemChassisIdSubType().getValue()) + "/" + link.getLldpRemChassisId());
        System.err.println("lldp rem sysname: " + link.getLldpRemSysname());
        System.err.println("----------Remote Port--------");
        System.err.println("lldp rem port type/id: " + LldpUtils.LldpPortIdSubType.getTypeString((Integer)link.getLldpRemPortIdSubType().getValue()) + "/" + link.getLldpRemPortId());
        System.err.println("lldp rem port descr: " + link.getLldpRemPortDescr());
        System.err.println("");
    }

    protected static void printOspfTopology(List<OspfLink> ospflinks) {
        for (OspfLink link : ospflinks) {
            EnLinkdTestHelper.printOspfLink(link);
        }
    }

    protected static void printOspfElements(List<OspfElement> ospfelements) {
        for (OspfElement element : ospfelements) {
            EnLinkdTestHelper.printOspfElement(element);
        }
    }

    protected static void printOspfElement(OspfElement element) {
        System.err.println("----------ospf element --------");
        System.err.println("Nodeid: " + element.getNode().getId());
        System.err.println("ospf router id/mask/ifindex: " + InetAddressUtils.str((InetAddress)element.getOspfRouterId()) + "/" + InetAddressUtils.str((InetAddress)element.getOspfRouterIdNetmask()) + "/" + element.getOspfRouterIdIfindex());
        System.err.println("ospf admin status: " + OspfElement.Status.getTypeString((Integer)element.getOspfAdminStat().getValue()));
        System.err.println("ospf version number: " + element.getOspfVersionNumber());
        System.err.println("ospf Border Router Status: " + OspfElement.TruthValue.getTypeString((Integer)element.getOspfBdrRtrStatus().getValue()));
        System.err.println("ospf AS Boder Router Status: " + OspfElement.TruthValue.getTypeString((Integer)element.getOspfASBdrRtrStatus().getValue()));
        System.err.println("");
    }

    protected static void printOspfLink(OspfLink link) {
        System.err.println("----------ospf link --------");
        System.err.println("Create time: " + link.getOspfLinkCreateTime());
        System.err.println("Last Poll time: " + link.getOspfLinkLastPollTime());
        System.err.println("----------Source Node--------");
        System.err.println("Nodeid: " + link.getNode().getId());
        System.err.println("----------Source Port--------");
        System.err.println("ospf router id/mask/ifindex/addressleifindex: " + InetAddressUtils.str((InetAddress)link.getOspfIpAddr()) + "/" + InetAddressUtils.str((InetAddress)link.getOspfIpMask()) + "/" + link.getOspfIfIndex() + "/" + link.getOspfAddressLessIndex());
        System.err.println("----------Rem Node--------");
        System.err.println("ospf rem router id: " + InetAddressUtils.str((InetAddress)link.getOspfRemRouterId()));
        System.err.println("----------Remote Port--------");
        System.err.println("ospf rem router ip: " + InetAddressUtils.str((InetAddress)link.getOspfRemIpAddr()));
        System.err.println("ospf rem router address less ifindex: " + link.getOspfRemAddressLessIndex());
        System.err.println("");
    }

    public static void printBridgeTopology(List<SharedSegment> shareds) {
        for (SharedSegment shared : shareds) {
            EnLinkdTestHelper.printSharedSegment(shared);
        }
    }

    public static void printSharedSegment(SharedSegment shared) {
        System.err.println("");
        System.err.println("------shared Segment-----");
        System.err.println("designated bridge: " + shared.getDesignatedBridge());
        System.err.println("designated port: " + shared.getDesignatedPort());
        System.err.println("macs on segment: " + shared.getMacsOnSegment());
        System.err.println("bridge ids on segment: " + shared.getBridgeIdsOnSegment());
        for (BridgeBridgeLink blink : shared.getBridgeBridgeLinks()) {
            EnLinkdTestHelper.printBridgeBridgeLink(blink);
        }
        for (BridgeMacLink mlink : shared.getBridgeMacLinks()) {
            EnLinkdTestHelper.printBridgeMacLink(mlink);
        }
        System.err.println("------shared Segment-----");
    }

    public static void printBridgeMacLink(BridgeMacLink mlink) {
        System.err.println("------BridgeMacLink-----");
        System.err.println("Create time: " + mlink.getBridgeMacLinkCreateTime());
        System.err.println("Last poll time: " + mlink.getBridgeMacLinkLastPollTime());
        System.err.println("nodeid: " + mlink.getNode().getId());
        System.err.println("bridgeport: " + mlink.getBridgePort());
        System.err.println("ifindex: " + mlink.getBridgePortIfIndex());
        System.err.println("mac: " + mlink.getMacAddress());
        System.err.println("status: " + BridgeMacLink.BridgeDot1qTpFdbStatus.getTypeString((Integer)mlink.getBridgeDot1qTpFdbStatus().getValue()));
        System.err.println("------BridgeMacLink-----");
    }

    public static void printStoredBridgeMacLink(BridgeMacLink mlink) {
        System.err.println("------BridgeMacLink-----");
        System.err.println("Create time: " + mlink.getBridgeMacLinkCreateTime());
        System.err.println("Last poll time: " + mlink.getBridgeMacLinkLastPollTime());
        System.err.println("nodeid: " + mlink.getNode().getId());
        System.err.println("bridgeport: " + mlink.getBridgePort());
        System.err.println("ifindex: " + mlink.getBridgePortIfIndex());
        System.err.println("mac: " + mlink.getMacAddress());
        System.err.println("------BridgeMacLink-----");
    }

    public static void printBridgeBridgeLink(BridgeBridgeLink blink) {
        System.err.println("------BridgeBridgeLink-----");
        System.err.println("nodeid: " + blink.getNode().getId());
        System.err.println("bridgeport: " + blink.getBridgePort());
        System.err.println("designatednodeid: " + blink.getDesignatedNode().getId());
        System.err.println("designatedbridgeport: " + blink.getDesignatedPort());
        System.err.println("------BridgeBridgeLink-----");
    }

    public List<BridgeMacLink> addBridgeForwardingTableEntry(OnmsNode node, Integer bridgeport, String mac, List<BridgeMacLink> bft) {
        BridgeMacLink link = new BridgeMacLink();
        link.setNode(node);
        link.setBridgePort(bridgeport);
        link.setMacAddress(mac);
        link.setBridgeDot1qTpFdbStatus(BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED);
        bft.add(link);
        return bft;
    }

    protected static void printBackboneBridgeMacLink(BridgeMacLink link1, BridgeMacLink link2) {
        if (link1.getMacAddress().equals(link2.getMacAddress())) {
            System.err.println("nodeid: " + link1.getNode().getId() + " port:" + link1.getBridgePort() + "-->" + link1.getMacAddress() + "<-- port: " + link2.getBridgePort() + " nodeid: " + link2.getNode().getId());
        }
    }

    @SafeVarargs
    public static <T> boolean checkLinks(Iterable<T> iterable, Predicate<T> ... matchers) {
        for (Predicate<T> matcher : matchers) {
            if (Iterables.any(iterable, matcher)) continue;
            return false;
        }
        return true;
    }

    public static Predicate<OspfLink> ospfLinkMatcher(OnmsNode node, OnmsNode parentNode, int ifIndex, int parentIfIndex) {
        return link -> node.equals(link.getNode()) && parentNode.getOspfElement().getOspfRouterId().equals(link.getOspfRemRouterId()) && ifIndex == link.getOspfIfIndex() && parentIfIndex == link.getOspfAddressLessIndex();
    }

    class TwoBridgeWithBackbonePortsTopologyWithBridgeinBft {
        Integer nodeAId = 1101;
        Integer nodeBId = 1102;
        Integer portA1 = 1;
        Integer portAB = 12;
        Integer portBA = 21;
        Integer portB2 = 2;
        String macA11 = "000daa000a11";
        String macA12 = "000daa000a12";
        String macAB = "000daa0000ab";
        String macB21 = "000daa000b21";
        String macB22 = "000daa000b22";
        String macB = "bbbbbbbbbbbb";
        OnmsNode nodeA = new OnmsNode();
        BridgeElement elementA = new BridgeElement();
        List<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        List<BridgeMacLink> bftA = new ArrayList<BridgeMacLink>();
        OnmsNode nodeB = new OnmsNode();
        BridgeElement elementB = new BridgeElement();
        List<BridgeMacLink> bftB = new ArrayList<BridgeMacLink>();

        public TwoBridgeWithBackbonePortsTopologyWithBridgeinBft() {
            this.nodeA.setId(this.nodeAId);
            this.elementA.setNode(this.nodeA);
            this.elementA.setBaseBridgeAddress("aaaaaaaaaaaa");
            this.elemlist.add(this.elementA);
            this.nodeB.setId(this.nodeBId);
            this.elementB.setNode(this.nodeB);
            this.elementB.setBaseBridgeAddress(this.macB);
            this.elemlist.add(this.elementB);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.macA11, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.macA12, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macB, this.bftA);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macA11, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macA12, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macAB, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB2, this.macB21, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB2, this.macB22, this.bftB);
        }

        public void check(List<SharedSegment> shsegs) {
            EnLinkdTestHelper.printBridgeTopology(shsegs);
            Assert.assertEquals((long)3L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                boolean pass2;
                boolean pass1;
                List links;
                Assert.assertEquals((Object)false, (Object)shared.noMacsOnSegment());
                if (shared.getMacsOnSegment().contains(this.macAB)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    links = shared.getBridgeMacLinks();
                    Assert.assertEquals((long)2L, (long)links.size());
                    for (BridgeMacLink link : links) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        if (link.getNode().getId() == this.nodeAId) {
                            Assert.assertEquals((Object)"bbbbbbbbbbbb", (Object)link.getMacAddress());
                            Assert.assertEquals((Object)this.portAB, (Object)link.getBridgePort());
                            continue;
                        }
                        if (link.getNode().getId() == this.nodeBId) {
                            Assert.assertEquals((Object)this.macAB, (Object)link.getMacAddress());
                            Assert.assertEquals((Object)this.portBA, (Object)link.getBridgePort());
                            continue;
                        }
                        Assert.assertTrue((boolean)false);
                    }
                    BridgeBridgeLink dlink = (BridgeBridgeLink)shared.getBridgeBridgeLinks().iterator().next();
                    Assert.assertEquals((Object)this.nodeBId, (Object)dlink.getDesignatedNode().getId());
                    Assert.assertEquals((Object)this.portBA, (Object)dlink.getDesignatedPort());
                    Assert.assertEquals((Object)this.nodeAId, (Object)dlink.getNode().getId());
                    Assert.assertEquals((Object)this.portAB, (Object)dlink.getBridgePort());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.macA11)) {
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.macA12));
                    Assert.assertEquals((Object)this.nodeAId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portA1, (Object)shared.getDesignatedPort());
                    links = shared.getBridgeMacLinks();
                    Assert.assertEquals((long)2L, (long)links.size());
                    for (BridgeMacLink link : links) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                        Assert.assertEquals((Object)this.portA1, (Object)link.getBridgePort());
                        pass1 = true;
                        pass2 = true;
                        if (pass1 && link.getMacAddress().equals(this.macA11)) {
                            Assert.assertTrue((boolean)true);
                            pass1 = false;
                            continue;
                        }
                        if (pass2 && link.getMacAddress().equals(this.macA12)) {
                            Assert.assertTrue((boolean)true);
                            pass2 = false;
                            continue;
                        }
                        Assert.assertTrue((boolean)false);
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.macB21)) {
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.macB22));
                    Assert.assertEquals((Object)this.nodeBId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portB2, (Object)shared.getDesignatedPort());
                    links = shared.getBridgeMacLinks();
                    Assert.assertEquals((long)2L, (long)links.size());
                    for (BridgeMacLink link : links) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                        Assert.assertEquals((Object)this.portB2, (Object)link.getBridgePort());
                        pass1 = true;
                        pass2 = true;
                        if (pass1 && link.getMacAddress().equals(this.macB21)) {
                            Assert.assertTrue((boolean)true);
                            pass1 = false;
                            continue;
                        }
                        if (pass2 && link.getMacAddress().equals(this.macB22)) {
                            Assert.assertTrue((boolean)true);
                            pass2 = false;
                            continue;
                        }
                        Assert.assertTrue((boolean)false);
                    }
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }
    }

    class TwoBridgeWithBackbonePortsTopology {
        Integer nodeAId = 1101;
        Integer nodeBId = 1102;
        Integer portA1 = 1;
        Integer portAB = 12;
        Integer portBA = 21;
        Integer portB2 = 2;
        String macA11 = "000daa000a11";
        String macA12 = "000daa000a12";
        String macAB = "000daa0000ab";
        String macB21 = "000daa000b21";
        String macB22 = "000daa000b22";
        OnmsNode nodeA = new OnmsNode();
        BridgeElement elementA = new BridgeElement();
        List<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        List<BridgeMacLink> bftA = new ArrayList<BridgeMacLink>();
        OnmsNode nodeB = new OnmsNode();
        BridgeElement elementB = new BridgeElement();
        List<BridgeMacLink> bftB = new ArrayList<BridgeMacLink>();

        public TwoBridgeWithBackbonePortsTopology() {
            this.nodeA.setId(this.nodeAId);
            this.elementA.setNode(this.nodeA);
            this.elementA.setBaseBridgeAddress("aaaaaaaaaaaa");
            this.elemlist.add(this.elementA);
            this.nodeB.setId(this.nodeBId);
            this.elementB.setNode(this.nodeB);
            this.elementB.setBaseBridgeAddress("bbbbbbbbbbbb");
            this.elemlist.add(this.elementB);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.macA11, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.macA12, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macAB, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macB21, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macB22, this.bftA);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macA11, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macA12, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macAB, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB2, this.macB21, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB2, this.macB22, this.bftB);
        }

        public void check(List<SharedSegment> shsegs) {
            EnLinkdTestHelper.printBridgeTopology(shsegs);
            Assert.assertEquals((long)3L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                boolean pass2;
                boolean pass1;
                List links;
                Assert.assertEquals((Object)false, (Object)shared.noMacsOnSegment());
                if (shared.getMacsOnSegment().contains(this.macAB)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    links = shared.getBridgeMacLinks();
                    Assert.assertEquals((long)2L, (long)links.size());
                    for (BridgeMacLink link : links) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((Object)this.macAB, (Object)link.getMacAddress());
                        if (link.getNode().getId() == this.nodeAId) {
                            Assert.assertEquals((Object)this.portAB, (Object)link.getBridgePort());
                            continue;
                        }
                        if (link.getNode().getId() == this.nodeBId) {
                            Assert.assertEquals((Object)this.portBA, (Object)link.getBridgePort());
                            continue;
                        }
                        Assert.assertTrue((boolean)false);
                    }
                    BridgeBridgeLink dlink = (BridgeBridgeLink)shared.getBridgeBridgeLinks().iterator().next();
                    Assert.assertEquals((Object)this.nodeAId, (Object)dlink.getDesignatedNode().getId());
                    Assert.assertEquals((Object)this.portAB, (Object)dlink.getDesignatedPort());
                    Assert.assertEquals((Object)this.nodeBId, (Object)dlink.getNode().getId());
                    Assert.assertEquals((Object)this.portBA, (Object)dlink.getBridgePort());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.macA11)) {
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.macA12));
                    Assert.assertEquals((Object)this.nodeAId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portA1, (Object)shared.getDesignatedPort());
                    links = shared.getBridgeMacLinks();
                    Assert.assertEquals((long)2L, (long)links.size());
                    for (BridgeMacLink link : links) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                        Assert.assertEquals((Object)this.portA1, (Object)link.getBridgePort());
                        pass1 = true;
                        pass2 = true;
                        if (pass1 && link.getMacAddress().equals(this.macA11)) {
                            Assert.assertTrue((boolean)true);
                            pass1 = false;
                            continue;
                        }
                        if (pass2 && link.getMacAddress().equals(this.macA12)) {
                            Assert.assertTrue((boolean)true);
                            pass2 = false;
                            continue;
                        }
                        Assert.assertTrue((boolean)false);
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.macB21)) {
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.macB22));
                    Assert.assertEquals((Object)this.nodeBId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portB2, (Object)shared.getDesignatedPort());
                    links = shared.getBridgeMacLinks();
                    Assert.assertEquals((long)2L, (long)links.size());
                    for (BridgeMacLink link : links) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                        Assert.assertEquals((Object)this.portB2, (Object)link.getBridgePort());
                        pass1 = true;
                        pass2 = true;
                        if (pass1 && link.getMacAddress().equals(this.macB21)) {
                            Assert.assertTrue((boolean)true);
                            pass1 = false;
                            continue;
                        }
                        if (pass2 && link.getMacAddress().equals(this.macB22)) {
                            Assert.assertTrue((boolean)true);
                            pass2 = false;
                            continue;
                        }
                        Assert.assertTrue((boolean)false);
                    }
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }
    }

    class TwoMergeBridgeTopology {
        List<BridgeMacLink> bftB = new ArrayList<BridgeMacLink>();
        Integer portA8 = 8;
        Integer portAB = 16;
        Integer portBA = 24;
        Integer portB6 = 6;
        String mac1 = "000daaaa0001";
        String mac2 = "000daaaa0002";
        String mac3 = "000daaaa0003";
        String mac4 = "000daaaa0004";
        String mac5 = "000daaaa0005";
        String mac6 = "000daaaa0006";
        String mac7 = "000daaaa0007";
        String mac8 = "000daaaa0008";
        String mac9 = "000daaaa0009";
        Integer nodeAId = 1111;
        Integer nodeBId = 2222;
        OnmsNode nodeA = new OnmsNode();
        BridgeElement elementA = new BridgeElement();
        List<BridgeMacLink> bftA = new ArrayList<BridgeMacLink>();
        List<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        OnmsNode nodeB = new OnmsNode();
        BridgeElement elementB = new BridgeElement();

        public TwoMergeBridgeTopology() {
            this.nodeA.setId(this.nodeAId);
            this.elementA.setNode(this.nodeA);
            this.elementA.setBaseBridgeAddress("aaaaaaaaaaaa");
            this.elemlist.add(this.elementA);
            this.nodeB.setId(this.nodeBId);
            this.elementB.setNode(this.nodeB);
            this.elementB.setBaseBridgeAddress("bbbbbbbbbbbb");
            this.elemlist.add(this.elementB);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac1, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac2, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac3, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac4, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac5, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac6, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac7, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA8, this.mac8, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac9, this.bftA);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac1, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac2, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac3, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac4, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac5, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB6, this.mac6, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac7, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac8, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac9, this.bftB);
        }

        public void check(List<SharedSegment> shsegs) {
            EnLinkdTestHelper.printBridgeTopology(shsegs);
            Assert.assertEquals((long)3L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                BridgeMacLink link;
                Assert.assertEquals((Object)false, (Object)shared.noMacsOnSegment());
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((Object)this.nodeAId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portAB, (Object)shared.getDesignatedPort());
                    Assert.assertEquals((long)14L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)7L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac2));
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac3));
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac4));
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac5));
                    Assert.assertEquals((Object)false, (Object)shared.getMacsOnSegment().contains(this.mac6));
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac7));
                    Assert.assertEquals((Object)false, (Object)shared.getMacsOnSegment().contains(this.mac8));
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac9));
                    for (BridgeMacLink link2 : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link2.getBridgeDot1qTpFdbStatus());
                        Assert.assertTrue((boolean)shared.getMacsOnSegment().contains(link2.getMacAddress()));
                        if (link2.getNode().getId() == this.nodeAId) {
                            Assert.assertEquals((Object)this.portAB, (Object)link2.getBridgePort());
                            continue;
                        }
                        if (link2.getNode().getId() == this.nodeBId) {
                            Assert.assertEquals((Object)this.portBA, (Object)link2.getBridgePort());
                            continue;
                        }
                        Assert.assertTrue((boolean)false);
                    }
                    BridgeBridgeLink dlink = (BridgeBridgeLink)shared.getBridgeBridgeLinks().iterator().next();
                    Assert.assertEquals((Object)this.nodeAId, (Object)dlink.getDesignatedNode().getId());
                    Assert.assertEquals((Object)this.portAB, (Object)dlink.getDesignatedPort());
                    Assert.assertEquals((Object)this.nodeBId, (Object)dlink.getNode().getId());
                    Assert.assertEquals((Object)this.portBA, (Object)dlink.getBridgePort());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac6)) {
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)this.nodeBId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portB6, (Object)shared.getDesignatedPort());
                    link = (BridgeMacLink)shared.getBridgeMacLinks().iterator().next();
                    Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                    Assert.assertEquals((Object)this.mac6, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portB6, (Object)link.getBridgePort());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac8)) {
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)this.nodeAId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portA8, (Object)shared.getDesignatedPort());
                    link = (BridgeMacLink)shared.getBridgeMacLinks().iterator().next();
                    Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                    Assert.assertEquals((Object)this.mac8, (Object)link.getMacAddress());
                    Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portA8, (Object)link.getBridgePort());
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }
    }

    class TwoConnectedBridgeTopology {
        Integer portA1 = 1;
        Integer portA2 = 2;
        Integer portA3 = 3;
        Integer portA4 = 4;
        Integer portA5 = 5;
        Integer portAB = 16;
        Integer portBA = 24;
        Integer portB6 = 6;
        Integer portB7 = 7;
        Integer portB8 = 8;
        Integer portB9 = 9;
        String mac1 = "000daaaa0001";
        String mac2 = "000daaaa0002";
        String mac3 = "000daaaa0003";
        String mac4 = "000daaaa0004";
        String mac5 = "000daaaa0005";
        String mac6 = "000daaaa0006";
        String mac7 = "000daaaa0007";
        String mac8 = "000daaaa0008";
        String mac9 = "000daaaa0009";
        Integer nodeAId = 1111;
        Integer nodeBId = 2222;
        OnmsNode nodeA = new OnmsNode();
        BridgeElement elementA = new BridgeElement();
        List<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        List<BridgeMacLink> bftA = new ArrayList<BridgeMacLink>();
        OnmsNode nodeB = new OnmsNode();
        BridgeElement elementB = new BridgeElement();
        List<BridgeMacLink> bftB = new ArrayList<BridgeMacLink>();

        public TwoConnectedBridgeTopology() {
            this.nodeA.setId(this.nodeAId);
            this.elementA.setNode(this.nodeA);
            this.elementA.setBaseBridgeAddress("aaaaaaaaaaaa");
            this.elemlist.add(this.elementA);
            this.nodeB.setId(this.nodeBId);
            this.elementB.setNode(this.nodeB);
            this.elementB.setBaseBridgeAddress("bbbbbbbbbbbb");
            this.elemlist.add(this.elementB);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.mac1, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA2, this.mac2, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA3, this.mac3, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA4, this.mac4, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA5, this.mac5, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac6, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac7, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac8, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac9, this.bftA);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac1, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac2, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac3, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac4, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac5, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB6, this.mac6, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB7, this.mac7, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB8, this.mac8, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB9, this.mac9, this.bftB);
        }

        public void check(List<SharedSegment> shsegs) {
            EnLinkdTestHelper.printBridgeTopology(shsegs);
            Assert.assertEquals((long)10L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                BridgeMacLink link;
                if (shared.noMacsOnSegment()) {
                    Assert.assertEquals((long)0L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeBridgeLinks().size());
                    link = (BridgeBridgeLink)shared.getBridgeBridgeLinks().iterator().next();
                    Assert.assertEquals((Object)this.nodeAId, (Object)link.getDesignatedNode().getId());
                    Assert.assertEquals((Object)this.portAB, (Object)link.getDesignatedPort());
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portBA, (Object)link.getBridgePort());
                    continue;
                }
                Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                link = (BridgeMacLink)shared.getBridgeMacLinks().iterator().next();
                Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                if (link.getMacAddress().equals(this.mac1)) {
                    Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portA1, (Object)link.getBridgePort());
                    continue;
                }
                if (link.getMacAddress().equals(this.mac2)) {
                    Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portA2, (Object)link.getBridgePort());
                    continue;
                }
                if (link.getMacAddress().equals(this.mac3)) {
                    Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portA3, (Object)link.getBridgePort());
                    continue;
                }
                if (link.getMacAddress().equals(this.mac4)) {
                    Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portA4, (Object)link.getBridgePort());
                    continue;
                }
                if (link.getMacAddress().equals(this.mac5)) {
                    Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portA5, (Object)link.getBridgePort());
                    continue;
                }
                if (link.getMacAddress().equals(this.mac6)) {
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portB6, (Object)link.getBridgePort());
                    continue;
                }
                if (link.getMacAddress().equals(this.mac7)) {
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portB7, (Object)link.getBridgePort());
                    continue;
                }
                if (link.getMacAddress().equals(this.mac8)) {
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portB8, (Object)link.getBridgePort());
                    continue;
                }
                if (link.getMacAddress().equals(this.mac9)) {
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portB9, (Object)link.getBridgePort());
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }
    }

    class OneBridgeCompleteTopology {
        Integer portA1 = 1;
        Integer portA2 = 2;
        Integer portA3 = 3;
        Integer portA4 = 4;
        Integer portA23 = 23;
        Integer portA24 = 24;
        Integer portA25 = 25;
        String mac1 = "000daaaa0001";
        String mac2 = "000daaaa0002";
        String mac3 = "000daaaa0003";
        String mac4 = "000daaaa0004";
        String mac231 = "000daaaa0231";
        String mac232 = "000daaaa0232";
        String mac233 = "000daaaa0233";
        String mac234 = "000daaaa0234";
        String mac241 = "000daaaa0241";
        String mac242 = "000daaaa0242";
        String mac243 = "000daaaa0243";
        String mac244 = "000daaaa0244";
        String mac245 = "000daaaa0245";
        String mac251 = "000daaaa0251";
        String mac252 = "000daaaa0252";
        String mac253 = "000daaaa0253";
        Integer nodeAId = 30;
        OnmsNode nodeA = new OnmsNode();
        BridgeElement element = new BridgeElement();
        List<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        List<BridgeMacLink> bftA = new ArrayList<BridgeMacLink>();

        public OneBridgeCompleteTopology() {
            this.nodeA.setId(this.nodeAId);
            this.nodeA.setLocation(new OnmsMonitoringLocation("Default", "Default"));
            this.element.setNode(this.nodeA);
            this.element.setBaseBridgeAddress("aaaaaaaaaaaa");
            this.elemlist.add(this.element);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.mac1, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA2, this.mac2, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA3, this.mac3, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA4, this.mac4, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA23, this.mac231, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA23, this.mac232, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA23, this.mac233, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA23, this.mac234, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA24, this.mac241, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA24, this.mac242, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA24, this.mac243, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA24, this.mac244, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA24, this.mac245, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA25, this.mac251, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA25, this.mac252, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA25, this.mac253, this.bftA);
        }

        public void check(List<SharedSegment> links) {
            EnLinkdTestHelper.printBridgeTopology(links);
            Assert.assertEquals((long)7L, (long)links.size());
            for (SharedSegment shared : links) {
                Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                Assert.assertEquals((Object)this.nodeAId, (Object)shared.getDesignatedBridge());
                Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                    Set macs;
                    Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                    Assert.assertEquals((Object)link.getBridgePort(), (Object)shared.getDesignatedPort());
                    if (link.getBridgePort() == this.portA1) {
                        Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                        Assert.assertEquals((Object)this.mac1, (Object)link.getMacAddress());
                        continue;
                    }
                    if (link.getBridgePort() == this.portA2) {
                        Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                        Assert.assertEquals((Object)this.mac2, (Object)link.getMacAddress());
                        continue;
                    }
                    if (link.getBridgePort() == this.portA3) {
                        Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                        Assert.assertEquals((Object)this.mac3, (Object)link.getMacAddress());
                        continue;
                    }
                    if (link.getBridgePort() == this.portA4) {
                        Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                        Assert.assertEquals((Object)this.mac4, (Object)link.getMacAddress());
                        continue;
                    }
                    if (link.getBridgePort() == this.portA23) {
                        macs = shared.getMacsOnSegment();
                        Assert.assertEquals((long)4L, (long)macs.size());
                        Assert.assertTrue((boolean)macs.contains(this.mac231));
                        Assert.assertTrue((boolean)macs.contains(this.mac232));
                        Assert.assertTrue((boolean)macs.contains(this.mac233));
                        Assert.assertTrue((boolean)macs.contains(this.mac234));
                        continue;
                    }
                    if (link.getBridgePort() == this.portA24) {
                        macs = shared.getMacsOnSegment();
                        Assert.assertEquals((long)5L, (long)macs.size());
                        Assert.assertTrue((boolean)macs.contains(this.mac241));
                        Assert.assertTrue((boolean)macs.contains(this.mac242));
                        Assert.assertTrue((boolean)macs.contains(this.mac243));
                        Assert.assertTrue((boolean)macs.contains(this.mac244));
                        Assert.assertTrue((boolean)macs.contains(this.mac245));
                        continue;
                    }
                    if (link.getBridgePort() == this.portA25) {
                        macs = shared.getMacsOnSegment();
                        Assert.assertEquals((long)3L, (long)macs.size());
                        Assert.assertTrue((boolean)macs.contains(this.mac251));
                        Assert.assertTrue((boolean)macs.contains(this.mac252));
                        Assert.assertTrue((boolean)macs.contains(this.mac253));
                        continue;
                    }
                    Assert.assertEquals((long)-1L, (long)1L);
                }
            }
        }
    }

    class OneBridgeMoreMacOnePortTopology {
        Integer nodeAId = 20;
        OnmsNode nodeA = new OnmsNode();
        BridgeElement element = new BridgeElement();
        List<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        List<BridgeMacLink> bftA = new ArrayList<BridgeMacLink>();
        Integer portA1 = 1;
        String mac1 = "000daaaa0001";
        String mac2 = "000daaaa0002";
        String mac3 = "000daaaa0003";
        String mac4 = "000daaaa0004";

        public OneBridgeMoreMacOnePortTopology() {
            this.nodeA.setId(this.nodeAId);
            this.element.setNode(this.nodeA);
            this.element.setBaseBridgeAddress("aaaaaaaaaaaa");
            this.elemlist.add(this.element);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.mac1, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.mac2, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.mac3, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.mac4, this.bftA);
        }

        public void check(List<SharedSegment> links) {
            EnLinkdTestHelper.printBridgeTopology(links);
            Assert.assertEquals((long)1L, (long)links.size());
            for (SharedSegment shared : links) {
                Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                Assert.assertEquals((Object)this.nodeAId, (Object)shared.getDesignatedBridge());
                Assert.assertEquals((Object)this.portA1, (Object)shared.getDesignatedPort());
                Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                Assert.assertEquals((long)4L, (long)shared.getMacsOnSegment().size());
                Set macs = shared.getMacsOnSegment();
                Assert.assertTrue((boolean)macs.contains(this.mac1));
                Assert.assertTrue((boolean)macs.contains(this.mac2));
                Assert.assertTrue((boolean)macs.contains(this.mac3));
                Assert.assertTrue((boolean)macs.contains(this.mac4));
                for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                    Assert.assertEquals((Object)this.portA1, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                }
            }
        }
    }

    class OneBridgeOnePortOneMacTopology {
        Integer nodeAId = 10;
        Integer portA1 = 1;
        Integer portA2 = 2;
        Integer portA3 = 3;
        Integer portA4 = 4;
        Integer portA5 = 5;
        String mac1 = "000daaaa0001";
        String mac2 = "000daaaa0002";
        String mac3 = "000daaaa0003";
        String mac4 = "000daaaa0004";
        String mac5 = "000daaaa0005";
        OnmsNode nodeA = new OnmsNode();
        BridgeElement element = new BridgeElement();
        List<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        List<BridgeMacLink> bftA = new ArrayList<BridgeMacLink>();

        public OneBridgeOnePortOneMacTopology() {
            this.nodeA.setId(this.nodeAId);
            this.element.setNode(this.nodeA);
            this.element.setBaseBridgeAddress("aaaaaaaaaaaa");
            this.elemlist.add(this.element);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.mac1, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA2, this.mac2, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA3, this.mac3, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA4, this.mac4, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA5, this.mac5, this.bftA);
        }

        public void check(List<SharedSegment> links) {
            EnLinkdTestHelper.printBridgeTopology(links);
            Assert.assertEquals((long)5L, (long)links.size());
            for (SharedSegment shared : links) {
                Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                Assert.assertEquals((Object)this.nodeAId, (Object)shared.getDesignatedBridge());
                Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                    Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                    Assert.assertEquals((Object)link.getBridgePort(), (Object)shared.getDesignatedPort());
                    if (link.getBridgePort() == this.portA1) {
                        Assert.assertEquals((Object)this.mac1, (Object)link.getMacAddress());
                        continue;
                    }
                    if (link.getBridgePort() == this.portA2) {
                        Assert.assertEquals((Object)this.mac2, (Object)link.getMacAddress());
                        continue;
                    }
                    if (link.getBridgePort() == this.portA3) {
                        Assert.assertEquals((Object)this.mac3, (Object)link.getMacAddress());
                        continue;
                    }
                    if (link.getBridgePort() == this.portA4) {
                        Assert.assertEquals((Object)this.mac4, (Object)link.getMacAddress());
                        continue;
                    }
                    if (link.getBridgePort() == this.portA5) {
                        Assert.assertEquals((Object)this.mac5, (Object)link.getMacAddress());
                        continue;
                    }
                    Assert.assertEquals((long)-1L, (long)1L);
                }
            }
        }
    }

    class TwoNodeTopology {
        Integer nodeAId = 22101;
        Integer nodeBId = 22102;
        Integer portA1 = 1;
        Integer portA6 = 6;
        Integer portAB = 12;
        Integer portBA = 21;
        Integer portB2 = 2;
        Integer portB7 = 7;
        String macA11 = "000daa000a11";
        String macA12 = "000daa000a12";
        String macA13 = "000daa000a13";
        String macA14 = "000daa000a14";
        String macA61 = "000daa000a61";
        String macA62 = "000daa000a62";
        String macA63 = "000daa000a63";
        String macA64 = "000daa000a64";
        String macAB1 = "000daa000ab1";
        String macAB2 = "000daa000ab2";
        String macAB3 = "000daa000ab3";
        String macAB4 = "000daa000ab4";
        String macAB5 = "000daa000ab5";
        String macAB6 = "000daa000ab6";
        String macBA1 = "000daa000ba1";
        String macBA2 = "000daa000ba2";
        String macBA3 = "000daa000ba3";
        String macB21 = "000daa000b21";
        String macB22 = "000daa000b22";
        String macB23 = "000daa000b23";
        String macB71 = "000daa000b71";
        String macB72 = "000daa000b72";
        String macB73 = "000daa000b73";
        BridgeElement elementA = new BridgeElement();
        BridgeElement elementB = new BridgeElement();
        OnmsNode nodeA = new OnmsNode();
        OnmsNode nodeB = new OnmsNode();
        List<BridgeMacLink> bftA = new ArrayList<BridgeMacLink>();
        List<BridgeMacLink> bftB = new ArrayList<BridgeMacLink>();
        List<BridgeElement> elemlist = new ArrayList<BridgeElement>();

        public TwoNodeTopology() {
            this.nodeA.setId(this.nodeAId);
            this.elementA.setNode(this.nodeA);
            this.elementA.setBaseBridgeAddress("aaaaaaaaaaaa");
            this.elemlist.add(this.elementA);
            this.nodeB.setId(this.nodeBId);
            this.elementB.setNode(this.nodeB);
            this.elementB.setBaseBridgeAddress("bbbbbbbbbbbb");
            this.elemlist.add(this.elementB);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.macA11, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.macA12, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.macA13, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA1, this.macA14, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA6, this.macA61, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA6, this.macA62, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA6, this.macA63, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA6, this.macA64, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macAB1, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macAB2, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macAB3, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macAB4, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macAB5, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macAB6, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macB21, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.macB22, this.bftA);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macA11, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macA12, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macA61, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macA62, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macA63, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macAB1, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macAB2, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macAB3, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macBA1, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macBA2, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.macBA3, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB2, this.macB21, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB2, this.macB22, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB2, this.macB23, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB7, this.macB71, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB7, this.macB72, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB7, this.macB73, this.bftB);
        }

        public void check2nodeTopology(List<SharedSegment> shsegs, boolean revertedbblink) {
            Assert.assertEquals((long)5L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                EnLinkdTestHelper.printSharedSegment(shared);
                Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                Set nodeidsOnSegment = shared.getBridgeIdsOnSegment();
                List links = shared.getBridgeMacLinks();
                Set macs = shared.getMacsOnSegment();
                if (shared.getDesignatedBridge().intValue() == this.nodeBId.intValue() && shared.getDesignatedPort() == this.portBA || shared.getDesignatedBridge().intValue() == this.nodeAId.intValue() && shared.getDesignatedPort() == this.portAB) {
                    Assert.assertEquals((long)2L, (long)nodeidsOnSegment.size());
                    Assert.assertEquals((long)9L, (long)macs.size());
                    Assert.assertEquals((long)12L, (long)links.size());
                    Assert.assertTrue((boolean)nodeidsOnSegment.contains(this.nodeAId));
                    Assert.assertTrue((boolean)nodeidsOnSegment.contains(this.nodeBId));
                    Assert.assertTrue((boolean)macs.contains(this.macAB1));
                    Assert.assertTrue((boolean)macs.contains(this.macAB2));
                    Assert.assertTrue((boolean)macs.contains(this.macAB3));
                    Assert.assertTrue((boolean)macs.contains(this.macAB4));
                    Assert.assertTrue((boolean)macs.contains(this.macAB5));
                    Assert.assertTrue((boolean)macs.contains(this.macAB6));
                    Assert.assertTrue((boolean)macs.contains(this.macBA1));
                    Assert.assertTrue((boolean)macs.contains(this.macBA2));
                    Assert.assertTrue((boolean)macs.contains(this.macBA3));
                    for (BridgeMacLink link : links) {
                        if (link.getNode().getId() == this.nodeAId) {
                            Assert.assertEquals((Object)this.portAB, (Object)link.getBridgePort());
                            continue;
                        }
                        if (link.getNode().getId() == this.nodeBId) {
                            Assert.assertEquals((Object)this.portBA, (Object)link.getBridgePort());
                            continue;
                        }
                        Assert.assertTrue((boolean)false);
                    }
                    Assert.assertEquals((long)1L, (long)shared.getBridgeBridgeLinks().size());
                    BridgeBridgeLink dlink = (BridgeBridgeLink)shared.getBridgeBridgeLinks().iterator().next();
                    Assert.assertEquals((Object)this.nodeBId, (Object)dlink.getDesignatedNode().getId());
                    Assert.assertEquals((Object)this.portBA, (Object)dlink.getDesignatedPort());
                    Assert.assertEquals((Object)this.nodeAId, (Object)dlink.getNode().getId());
                    Assert.assertEquals((Object)this.portAB, (Object)dlink.getBridgePort());
                    continue;
                }
                if (shared.getDesignatedBridge().intValue() == this.nodeBId.intValue() && shared.getDesignatedPort() == this.portB2) {
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)1L, (long)nodeidsOnSegment.size());
                    Assert.assertTrue((boolean)nodeidsOnSegment.contains(this.nodeBId));
                    Assert.assertEquals((long)3L, (long)macs.size());
                    Assert.assertEquals((long)3L, (long)links.size());
                    Assert.assertTrue((boolean)macs.contains(this.macB21));
                    Assert.assertTrue((boolean)macs.contains(this.macB22));
                    Assert.assertTrue((boolean)macs.contains(this.macB23));
                    for (BridgeMacLink link : links) {
                        Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                        Assert.assertEquals((Object)this.portB2, (Object)link.getBridgePort());
                    }
                    continue;
                }
                if (shared.getDesignatedBridge().intValue() == this.nodeBId.intValue() && shared.getDesignatedPort() == this.portB7) {
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)1L, (long)nodeidsOnSegment.size());
                    Assert.assertTrue((boolean)nodeidsOnSegment.contains(this.nodeBId));
                    Assert.assertEquals((long)3L, (long)macs.size());
                    Assert.assertEquals((long)3L, (long)links.size());
                    Assert.assertTrue((boolean)macs.contains(this.macB71));
                    Assert.assertTrue((boolean)macs.contains(this.macB72));
                    Assert.assertTrue((boolean)macs.contains(this.macB73));
                    for (BridgeMacLink link : links) {
                        Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                        Assert.assertEquals((Object)this.portB7, (Object)link.getBridgePort());
                    }
                    continue;
                }
                if (shared.getDesignatedBridge().intValue() == this.nodeAId.intValue() && shared.getDesignatedPort() == this.portA1) {
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)1L, (long)nodeidsOnSegment.size());
                    Assert.assertTrue((boolean)nodeidsOnSegment.contains(this.nodeAId));
                    Assert.assertEquals((long)4L, (long)macs.size());
                    Assert.assertEquals((long)4L, (long)links.size());
                    Assert.assertTrue((boolean)macs.contains(this.macA11));
                    Assert.assertTrue((boolean)macs.contains(this.macA12));
                    Assert.assertTrue((boolean)macs.contains(this.macA13));
                    Assert.assertTrue((boolean)macs.contains(this.macA14));
                    for (BridgeMacLink link : links) {
                        Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                        Assert.assertEquals((Object)this.portA1, (Object)link.getBridgePort());
                    }
                    continue;
                }
                if (shared.getDesignatedBridge().intValue() == this.nodeAId.intValue() && shared.getDesignatedPort() == this.portA6) {
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)1L, (long)nodeidsOnSegment.size());
                    Assert.assertTrue((boolean)nodeidsOnSegment.contains(this.nodeAId));
                    Assert.assertEquals((long)4L, (long)macs.size());
                    Assert.assertEquals((long)4L, (long)links.size());
                    Assert.assertTrue((boolean)macs.contains(this.macA61));
                    Assert.assertTrue((boolean)macs.contains(this.macA62));
                    Assert.assertTrue((boolean)macs.contains(this.macA63));
                    Assert.assertTrue((boolean)macs.contains(this.macA64));
                    for (BridgeMacLink link : links) {
                        Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                        Assert.assertEquals((Object)this.portA6, (Object)link.getBridgePort());
                    }
                    continue;
                }
                Assert.assertTrue((boolean)false);
            }
        }
    }

    class DEFGHILTopology {
        Integer nodeDId = 104;
        Integer nodeEId = 105;
        Integer nodeFId = 106;
        Integer nodeGId = 107;
        Integer nodeHId = 108;
        Integer nodeIId = 109;
        Integer nodeLId = 110;
        Integer portD = 44;
        Integer portDD = 40;
        Integer portE = 55;
        Integer portEE = 50;
        Integer portF = 66;
        Integer portFF = 60;
        Integer portG7 = 7;
        Integer portG8 = 8;
        Integer portGD = 74;
        Integer portGE = 75;
        Integer portGF = 76;
        Integer portH1 = 1;
        Integer portH2 = 2;
        Integer portHH = 80;
        Integer portI3 = 3;
        Integer portI4 = 4;
        Integer portII = 90;
        Integer portL5 = 3;
        Integer portL6 = 4;
        Integer portLL = 20;
        String mac1 = "000daaaa0441";
        String mac2 = "000daaaa0442";
        String mac3 = "000daaaa0663";
        String mac4 = "000daaaa0664";
        String mac5 = "000daaaa0555";
        String mac6 = "000daaaa0556";
        String mac7 = "000daaaa0707";
        String mac8 = "000daaaa0808";
        OnmsNode nodeD = new OnmsNode();
        OnmsNode nodeE = new OnmsNode();
        OnmsNode nodeF = new OnmsNode();
        OnmsNode nodeG = new OnmsNode();
        OnmsNode nodeH = new OnmsNode();
        OnmsNode nodeI = new OnmsNode();
        OnmsNode nodeL = new OnmsNode();
        BridgeElement elementD = new BridgeElement();
        BridgeElement elementE = new BridgeElement();
        BridgeElement elementF = new BridgeElement();
        BridgeElement elementG = new BridgeElement();
        BridgeElement elementH = new BridgeElement();
        BridgeElement elementI = new BridgeElement();
        BridgeElement elementL = new BridgeElement();
        List<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        List<BridgeMacLink> bftD = new ArrayList<BridgeMacLink>();
        List<BridgeMacLink> bftE = new ArrayList<BridgeMacLink>();
        List<BridgeMacLink> bftF = new ArrayList<BridgeMacLink>();
        List<BridgeMacLink> bftG = new ArrayList<BridgeMacLink>();
        List<BridgeMacLink> bftH = new ArrayList<BridgeMacLink>();
        List<BridgeMacLink> bftI = new ArrayList<BridgeMacLink>();
        List<BridgeMacLink> bftL = new ArrayList<BridgeMacLink>();

        public DEFGHILTopology() {
            this.nodeD.setId(this.nodeDId);
            this.elementD.setNode(this.nodeD);
            this.elementD.setBaseBridgeAddress("dddddddddddd");
            this.elemlist.add(this.elementD);
            this.nodeE.setId(this.nodeEId);
            this.elementE.setNode(this.nodeE);
            this.elementE.setBaseBridgeAddress("ddddddddeddd");
            this.elemlist.add(this.elementE);
            this.nodeF.setId(this.nodeFId);
            this.elementF.setNode(this.nodeF);
            this.elementF.setBaseBridgeAddress("ddddddddfddd");
            this.elemlist.add(this.elementF);
            this.nodeG.setId(this.nodeGId);
            this.elementG.setNode(this.nodeG);
            this.elementG.setBaseBridgeAddress("ddddddd1dddd");
            this.elemlist.add(this.elementG);
            this.nodeI.setId(this.nodeIId);
            this.elementI.setNode(this.nodeI);
            this.elementI.setBaseBridgeAddress("ddddddd2dddd");
            this.elemlist.add(this.elementI);
            this.nodeH.setId(this.nodeHId);
            this.elementH.setNode(this.nodeH);
            this.elementH.setBaseBridgeAddress("ddddddd3dddd");
            this.elemlist.add(this.elementH);
            this.nodeL.setId(this.nodeLId);
            this.elementL.setNode(this.nodeL);
            this.elementL.setBaseBridgeAddress("ddddddd4dddd");
            this.elemlist.add(this.elementL);
            this.bftD = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, this.portD, this.mac1, this.bftD);
            this.bftD = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, this.portD, this.mac2, this.bftD);
            this.bftD = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, this.portDD, this.mac3, this.bftD);
            this.bftD = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, this.portDD, this.mac4, this.bftD);
            this.bftD = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, this.portDD, this.mac5, this.bftD);
            this.bftD = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, this.portDD, this.mac6, this.bftD);
            this.bftD = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, this.portDD, this.mac7, this.bftD);
            this.bftD = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeD, this.portDD, this.mac8, this.bftD);
            this.bftE = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, this.portEE, this.mac1, this.bftE);
            this.bftE = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, this.portEE, this.mac2, this.bftE);
            this.bftE = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, this.portEE, this.mac3, this.bftE);
            this.bftE = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, this.portEE, this.mac4, this.bftE);
            this.bftE = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, this.portE, this.mac5, this.bftE);
            this.bftE = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, this.portE, this.mac6, this.bftE);
            this.bftE = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, this.portEE, this.mac7, this.bftE);
            this.bftE = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeE, this.portEE, this.mac8, this.bftE);
            this.bftF = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeF, this.portFF, this.mac1, this.bftF);
            this.bftF = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeF, this.portFF, this.mac2, this.bftF);
            this.bftF = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeF, this.portF, this.mac3, this.bftF);
            this.bftF = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeF, this.portF, this.mac4, this.bftF);
            this.bftF = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeF, this.portFF, this.mac5, this.bftF);
            this.bftF = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeF, this.portFF, this.mac6, this.bftF);
            this.bftF = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeF, this.portFF, this.mac7, this.bftF);
            this.bftF = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeF, this.portFF, this.mac8, this.bftF);
            this.bftG = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeG, this.portGD, this.mac1, this.bftG);
            this.bftG = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeG, this.portGD, this.mac2, this.bftG);
            this.bftG = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeG, this.portGF, this.mac3, this.bftG);
            this.bftG = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeG, this.portGF, this.mac4, this.bftG);
            this.bftG = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeG, this.portGE, this.mac5, this.bftG);
            this.bftG = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeG, this.portGE, this.mac6, this.bftG);
            this.bftG = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeG, this.portG7, this.mac7, this.bftG);
            this.bftG = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeG, this.portG8, this.mac8, this.bftG);
            this.bftH = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeH, this.portH1, this.mac1, this.bftH);
            this.bftH = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeH, this.portH2, this.mac2, this.bftH);
            this.bftH = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeH, this.portHH, this.mac3, this.bftH);
            this.bftH = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeH, this.portHH, this.mac4, this.bftH);
            this.bftH = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeH, this.portHH, this.mac5, this.bftH);
            this.bftH = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeH, this.portHH, this.mac6, this.bftH);
            this.bftH = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeH, this.portHH, this.mac7, this.bftH);
            this.bftH = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeH, this.portHH, this.mac8, this.bftH);
            this.bftI = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeI, this.portII, this.mac1, this.bftI);
            this.bftI = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeI, this.portII, this.mac2, this.bftI);
            this.bftI = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeI, this.portI3, this.mac3, this.bftI);
            this.bftI = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeI, this.portI4, this.mac4, this.bftI);
            this.bftI = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeI, this.portII, this.mac5, this.bftI);
            this.bftI = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeI, this.portII, this.mac6, this.bftI);
            this.bftI = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeI, this.portII, this.mac7, this.bftI);
            this.bftI = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeI, this.portII, this.mac8, this.bftI);
            this.bftL = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeL, this.portLL, this.mac1, this.bftL);
            this.bftL = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeL, this.portLL, this.mac2, this.bftL);
            this.bftL = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeL, this.portLL, this.mac3, this.bftL);
            this.bftL = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeL, this.portLL, this.mac4, this.bftL);
            this.bftL = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeL, this.portL5, this.mac5, this.bftL);
            this.bftL = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeL, this.portL6, this.mac6, this.bftL);
            this.bftL = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeL, this.portLL, this.mac7, this.bftL);
            this.bftL = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeL, this.portLL, this.mac8, this.bftL);
        }

        public void checkDE(List<SharedSegment> shsegs) {
            EnLinkdTestHelper.printBridgeTopology(shsegs);
            Assert.assertEquals((long)3L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac2));
                    Assert.assertEquals((long)2L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)this.nodeDId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portD.intValue(), (long)shared.getDesignatedPort().intValue());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((long)this.nodeDId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portD, (Object)link.getBridgePort());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac5)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac6));
                    Assert.assertEquals((long)2L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)this.nodeEId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portE.intValue(), (long)shared.getDesignatedPort().intValue());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((long)this.nodeEId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portE, (Object)link.getBridgePort());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac7)) {
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeDId));
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeEId));
                    Assert.assertEquals((long)4L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac3));
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac4));
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac8));
                    Assert.assertEquals((long)8L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeBridgeLinks().size());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        if (this.nodeDId.intValue() == link.getNode().getId().intValue()) {
                            Assert.assertEquals((Object)this.portDD, (Object)link.getBridgePort());
                            continue;
                        }
                        if (this.nodeEId.intValue() == link.getNode().getId().intValue()) {
                            Assert.assertEquals((Object)this.portEE, (Object)link.getBridgePort());
                            continue;
                        }
                        Assert.assertEquals((Object)false, (Object)true);
                    }
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }

        public void checkDF(List<SharedSegment> shsegs) {
            EnLinkdTestHelper.printBridgeTopology(shsegs);
            Assert.assertEquals((long)3L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac2));
                    Assert.assertEquals((long)2L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)this.nodeDId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portD.intValue(), (long)shared.getDesignatedPort().intValue());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((long)this.nodeDId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portD, (Object)link.getBridgePort());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac3)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac4));
                    Assert.assertEquals((long)2L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)this.nodeFId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portF.intValue(), (long)shared.getDesignatedPort().intValue());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((long)this.nodeFId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portF, (Object)link.getBridgePort());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac7)) {
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeDId));
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeFId));
                    Assert.assertEquals((long)4L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac5));
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac6));
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac8));
                    Assert.assertEquals((long)8L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeBridgeLinks().size());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        if (this.nodeDId.intValue() == link.getNode().getId().intValue()) {
                            Assert.assertEquals((Object)this.portDD, (Object)link.getBridgePort());
                            continue;
                        }
                        if (this.nodeFId.intValue() == link.getNode().getId().intValue()) {
                            Assert.assertEquals((Object)this.portFF, (Object)link.getBridgePort());
                            continue;
                        }
                        Assert.assertEquals((Object)false, (Object)true);
                    }
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }

        public void checkDG(List<SharedSegment> shsegs) {
            EnLinkdTestHelper.printBridgeTopology(shsegs);
            Assert.assertEquals((long)6L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                if (shared.noMacsOnSegment()) {
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeGId));
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeDId));
                    Assert.assertEquals((long)1L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeMacLinks().size());
                    BridgeBridgeLink link = (BridgeBridgeLink)shared.getBridgeBridgeLinks().iterator().next();
                    Assert.assertEquals((Object)this.nodeDId, (Object)link.getDesignatedNode().getId());
                    Assert.assertEquals((Object)this.nodeGId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portDD, (Object)link.getDesignatedPort());
                    Assert.assertEquals((Object)this.portGD, (Object)link.getBridgePort());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac2));
                    Assert.assertEquals((long)2L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)this.nodeDId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portD.intValue(), (long)shared.getDesignatedPort().intValue());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((long)this.nodeDId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portD, (Object)link.getBridgePort());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac3)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac4));
                    Assert.assertEquals((long)2L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)this.nodeGId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portGF.intValue(), (long)shared.getDesignatedPort().intValue());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((long)this.nodeGId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portGF, (Object)link.getBridgePort());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac5)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac6));
                    Assert.assertEquals((long)2L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)this.nodeGId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portGE.intValue(), (long)shared.getDesignatedPort().intValue());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((long)this.nodeGId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portGE, (Object)link.getBridgePort());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac7)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeGId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)this.nodeGId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portG7.intValue(), (long)shared.getDesignatedPort().intValue());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((Object)this.portG7, (Object)link.getBridgePort());
                        Assert.assertEquals((Object)this.nodeGId, (Object)link.getNode().getId());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac8)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeGId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)this.nodeGId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portG8.intValue(), (long)shared.getDesignatedPort().intValue());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((Object)this.portG8, (Object)link.getBridgePort());
                        Assert.assertEquals((Object)this.nodeGId, (Object)link.getNode().getId());
                    }
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }

        public void checkEF(List<SharedSegment> shsegs) {
            EnLinkdTestHelper.printBridgeTopology(shsegs);
            Assert.assertEquals((long)3L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                if (shared.getMacsOnSegment().contains(this.mac3)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac4));
                    Assert.assertEquals((long)2L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)this.nodeFId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portF.intValue(), (long)shared.getDesignatedPort().intValue());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((long)this.nodeFId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portF, (Object)link.getBridgePort());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac5)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac6));
                    Assert.assertEquals((long)2L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)this.nodeEId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portE.intValue(), (long)shared.getDesignatedPort().intValue());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((long)this.nodeEId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portE, (Object)link.getBridgePort());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeFId));
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeEId));
                    Assert.assertEquals((long)4L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac2));
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac7));
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac8));
                    Assert.assertEquals((long)8L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeBridgeLinks().size());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        if (this.nodeFId.intValue() == link.getNode().getId().intValue()) {
                            Assert.assertEquals((Object)this.portFF, (Object)link.getBridgePort());
                            continue;
                        }
                        if (this.nodeEId.intValue() == link.getNode().getId().intValue()) {
                            Assert.assertEquals((Object)this.portEE, (Object)link.getBridgePort());
                            continue;
                        }
                        Assert.assertEquals((Object)false, (Object)true);
                    }
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }

        public void checkDEF(List<SharedSegment> shsegs) {
            EnLinkdTestHelper.printBridgeTopology(shsegs);
            Assert.assertEquals((long)4L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac2));
                    Assert.assertEquals((long)2L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)this.nodeDId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portD.intValue(), (long)shared.getDesignatedPort().intValue());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((long)this.nodeDId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portD, (Object)link.getBridgePort());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac5)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac6));
                    Assert.assertEquals((long)2L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)this.nodeEId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portE.intValue(), (long)shared.getDesignatedPort().intValue());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((long)this.nodeEId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portE, (Object)link.getBridgePort());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac3)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac4));
                    Assert.assertEquals((long)2L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)this.nodeFId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portF.intValue(), (long)shared.getDesignatedPort().intValue());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((long)this.nodeFId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portF, (Object)link.getBridgePort());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac7)) {
                    Assert.assertEquals((long)3L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeDId));
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeEId));
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeFId));
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac8));
                    Assert.assertEquals((long)6L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)2L, (long)shared.getBridgeBridgeLinks().size());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        if (this.nodeDId.intValue() == link.getNode().getId().intValue()) {
                            Assert.assertEquals((Object)this.portDD, (Object)link.getBridgePort());
                            continue;
                        }
                        if (this.nodeEId.intValue() == link.getNode().getId().intValue()) {
                            Assert.assertEquals((Object)this.portEE, (Object)link.getBridgePort());
                            continue;
                        }
                        if (this.nodeFId.intValue() == link.getNode().getId().intValue()) {
                            Assert.assertEquals((Object)this.portFF, (Object)link.getBridgePort());
                            continue;
                        }
                        Assert.assertEquals((Object)false, (Object)true);
                    }
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }

        public void checkDEFG(List<SharedSegment> shsegs) {
            Assert.assertEquals((long)8L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                EnLinkdTestHelper.printSharedSegment(shared);
                if (shared.noMacsOnSegment()) {
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeGId));
                    Assert.assertEquals((long)1L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeMacLinks().size());
                    BridgeBridgeLink link = (BridgeBridgeLink)shared.getBridgeBridgeLinks().iterator().next();
                    if (shared.getBridgeIdsOnSegment().contains(this.nodeDId)) {
                        Assert.assertEquals((long)this.nodeDId.intValue(), (long)link.getDesignatedNode().getId().intValue());
                        Assert.assertEquals((Object)this.portDD, (Object)link.getDesignatedPort());
                        Assert.assertEquals((long)this.nodeGId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portGD, (Object)link.getBridgePort());
                        continue;
                    }
                    if (shared.getBridgeIdsOnSegment().contains(this.nodeEId)) {
                        Assert.assertEquals((long)this.nodeEId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portEE, (Object)link.getBridgePort());
                        Assert.assertEquals((long)this.nodeGId.intValue(), (long)link.getDesignatedNode().getId().intValue());
                        Assert.assertEquals((Object)this.portGE, (Object)link.getDesignatedPort());
                        continue;
                    }
                    if (shared.getBridgeIdsOnSegment().contains(this.nodeFId)) {
                        Assert.assertEquals((long)this.nodeFId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portFF, (Object)link.getBridgePort());
                        Assert.assertEquals((long)this.nodeGId.intValue(), (long)link.getDesignatedNode().getId().intValue());
                        Assert.assertEquals((Object)this.portGF, (Object)link.getDesignatedPort());
                        continue;
                    }
                    Assert.assertEquals((Object)false, (Object)true);
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac2));
                    Assert.assertEquals((long)2L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)this.nodeDId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portD.intValue(), (long)shared.getDesignatedPort().intValue());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((long)this.nodeDId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portD, (Object)link.getBridgePort());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac5)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac6));
                    Assert.assertEquals((long)2L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)this.nodeEId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portE.intValue(), (long)shared.getDesignatedPort().intValue());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((long)this.nodeEId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portE, (Object)link.getBridgePort());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac3)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getMacsOnSegment().contains(this.mac4));
                    Assert.assertEquals((long)2L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)this.nodeFId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portF.intValue(), (long)shared.getDesignatedPort().intValue());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((long)this.nodeFId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portF, (Object)link.getBridgePort());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac7)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeGId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((long)this.nodeGId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((long)this.portG7.intValue(), (long)link.getBridgePort().intValue());
                        Assert.assertEquals((Object)this.mac7, (Object)link.getMacAddress());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac8)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeGId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    for (BridgeMacLink link : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((long)this.nodeGId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((long)this.portG8.intValue(), (long)link.getBridgePort().intValue());
                        Assert.assertEquals((Object)this.mac8, (Object)link.getMacAddress());
                    }
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }

        public void check(List<SharedSegment> shsegs) {
            Assert.assertEquals((long)14L, (long)shsegs.size());
            for (SharedSegment shared : shsegs) {
                BridgeBridgeLink link;
                EnLinkdTestHelper.printSharedSegment(shared);
                if (shared.noMacsOnSegment()) {
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeMacLinks().size());
                    link = (BridgeBridgeLink)shared.getBridgeBridgeLinks().iterator().next();
                    if (shared.getBridgeIdsOnSegment().contains(this.nodeDId) && shared.getDesignatedPort().intValue() == this.portDD.intValue()) {
                        Assert.assertEquals((long)this.nodeDId.intValue(), (long)link.getDesignatedNode().getId().intValue());
                        Assert.assertEquals((Object)this.portDD, (Object)link.getDesignatedPort());
                        Assert.assertEquals((long)this.nodeGId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portGD, (Object)link.getBridgePort());
                        continue;
                    }
                    if (shared.getBridgeIdsOnSegment().contains(this.nodeDId) && shared.getDesignatedPort().intValue() == this.portD.intValue()) {
                        Assert.assertEquals((long)this.nodeDId.intValue(), (long)link.getDesignatedNode().getId().intValue());
                        Assert.assertEquals((Object)this.portD, (Object)link.getDesignatedPort());
                        Assert.assertEquals((long)this.nodeHId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portHH, (Object)link.getBridgePort());
                        continue;
                    }
                    if (shared.getBridgeIdsOnSegment().contains(this.nodeGId) && shared.getDesignatedPort().intValue() == this.portGE.intValue()) {
                        Assert.assertEquals((long)this.nodeEId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portEE, (Object)link.getBridgePort());
                        Assert.assertEquals((long)this.nodeGId.intValue(), (long)link.getDesignatedNode().getId().intValue());
                        Assert.assertEquals((Object)this.portGE, (Object)link.getDesignatedPort());
                        continue;
                    }
                    if (shared.getBridgeIdsOnSegment().contains(this.nodeEId) && shared.getDesignatedPort().intValue() == this.portE.intValue()) {
                        Assert.assertEquals((long)this.nodeEId.intValue(), (long)link.getDesignatedNode().getId().intValue());
                        Assert.assertEquals((Object)this.portE, (Object)link.getDesignatedPort());
                        Assert.assertEquals((long)this.nodeLId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portLL, (Object)link.getBridgePort());
                        continue;
                    }
                    if (shared.getBridgeIdsOnSegment().contains(this.nodeGId) && shared.getDesignatedPort().intValue() == this.portGF.intValue()) {
                        Assert.assertEquals((long)this.nodeFId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portFF, (Object)link.getBridgePort());
                        Assert.assertEquals((long)this.nodeGId.intValue(), (long)link.getDesignatedNode().getId().intValue());
                        Assert.assertEquals((Object)this.portGF, (Object)link.getDesignatedPort());
                        continue;
                    }
                    if (shared.getBridgeIdsOnSegment().contains(this.nodeFId) && shared.getDesignatedPort().intValue() == this.portF.intValue()) {
                        Assert.assertEquals((long)this.nodeFId.intValue(), (long)link.getDesignatedNode().getId().intValue());
                        Assert.assertEquals((Object)this.portF, (Object)link.getDesignatedPort());
                        Assert.assertEquals((long)this.nodeIId.intValue(), (long)link.getNode().getId().intValue());
                        Assert.assertEquals((Object)this.portII, (Object)link.getBridgePort());
                        continue;
                    }
                    Assert.assertEquals((Object)false, (Object)true);
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeHId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)this.nodeHId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portH1.intValue(), (long)shared.getDesignatedPort().intValue());
                    link = (BridgeMacLink)shared.getBridgeMacLinks().iterator().next();
                    Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                    Assert.assertEquals((long)this.nodeHId.intValue(), (long)link.getNode().getId().intValue());
                    Assert.assertEquals((Object)this.portH1, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac1, (Object)link.getMacAddress());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac2)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeHId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)this.nodeHId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portH2.intValue(), (long)shared.getDesignatedPort().intValue());
                    link = (BridgeMacLink)shared.getBridgeMacLinks().iterator().next();
                    Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                    Assert.assertEquals((long)this.nodeHId.intValue(), (long)link.getNode().getId().intValue());
                    Assert.assertEquals((Object)this.portH2, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac2, (Object)link.getMacAddress());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac3)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeIId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)this.nodeIId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portI3.intValue(), (long)shared.getDesignatedPort().intValue());
                    link = (BridgeMacLink)shared.getBridgeMacLinks().iterator().next();
                    Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                    Assert.assertEquals((long)this.nodeIId.intValue(), (long)link.getNode().getId().intValue());
                    Assert.assertEquals((Object)this.portI3, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac3, (Object)link.getMacAddress());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac4)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeIId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)this.nodeIId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portI4.intValue(), (long)shared.getDesignatedPort().intValue());
                    link = (BridgeMacLink)shared.getBridgeMacLinks().iterator().next();
                    Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                    Assert.assertEquals((long)this.nodeIId.intValue(), (long)link.getNode().getId().intValue());
                    Assert.assertEquals((Object)this.portI4, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac4, (Object)link.getMacAddress());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac5)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeLId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)this.nodeLId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portL5.intValue(), (long)shared.getDesignatedPort().intValue());
                    link = (BridgeMacLink)shared.getBridgeMacLinks().iterator().next();
                    Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                    Assert.assertEquals((long)this.nodeLId.intValue(), (long)link.getNode().getId().intValue());
                    Assert.assertEquals((Object)this.portL5, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac5, (Object)link.getMacAddress());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac6)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeLId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    Assert.assertEquals((long)this.nodeLId.intValue(), (long)shared.getDesignatedBridge().intValue());
                    Assert.assertEquals((long)this.portL6.intValue(), (long)shared.getDesignatedPort().intValue());
                    link = (BridgeMacLink)shared.getBridgeMacLinks().iterator().next();
                    Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                    Assert.assertEquals((long)this.nodeLId.intValue(), (long)link.getNode().getId().intValue());
                    Assert.assertEquals((Object)this.portL6, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac6, (Object)link.getMacAddress());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac7)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeGId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    for (BridgeMacLink link2 : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link2.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((long)this.nodeGId.intValue(), (long)link2.getNode().getId().intValue());
                        Assert.assertEquals((long)this.portG7.intValue(), (long)link2.getBridgePort().intValue());
                        Assert.assertEquals((Object)this.mac7, (Object)link2.getMacAddress());
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac8)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((Object)true, (Object)shared.getBridgeIdsOnSegment().contains(this.nodeGId));
                    Assert.assertEquals((long)1L, (long)shared.getMacsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeMacLinks().size());
                    Assert.assertEquals((long)0L, (long)shared.getBridgeBridgeLinks().size());
                    for (BridgeMacLink link2 : shared.getBridgeMacLinks()) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link2.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((long)this.nodeGId.intValue(), (long)link2.getNode().getId().intValue());
                        Assert.assertEquals((long)this.portG8.intValue(), (long)link2.getBridgePort().intValue());
                        Assert.assertEquals((Object)this.mac8, (Object)link2.getMacAddress());
                    }
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }
    }

    class ABCTopology {
        Integer nodeAId = 101;
        Integer nodeBId = 102;
        Integer nodeCId = 103;
        OnmsNode nodeA = new OnmsNode();
        OnmsNode nodeB = new OnmsNode();
        OnmsNode nodeC = new OnmsNode();
        BridgeElement elementA = new BridgeElement();
        BridgeElement elementB = new BridgeElement();
        BridgeElement elementC = new BridgeElement();
        List<BridgeElement> elemlist = new ArrayList<BridgeElement>();
        List<BridgeMacLink> bftB = new ArrayList<BridgeMacLink>();
        List<BridgeMacLink> bftA = new ArrayList<BridgeMacLink>();
        List<BridgeMacLink> bftC = new ArrayList<BridgeMacLink>();
        Integer portA = 1;
        Integer portAB = 12;
        Integer portBA = 21;
        Integer portB = 2;
        Integer portBC = 23;
        Integer portCB = 32;
        Integer portC = 3;
        String mac1 = "000daaaa0101";
        String mac2 = "000daaaa0202";
        String mac3 = "000daaaa0303";

        public ABCTopology() {
            this.nodeA.setId(this.nodeAId);
            this.elementA.setNode(this.nodeA);
            this.elementA.setBaseBridgeAddress("aaaaaaaaaaaa");
            this.elemlist.add(this.elementA);
            this.nodeB.setId(this.nodeBId);
            this.elementB.setNode(this.nodeB);
            this.elementB.setBaseBridgeAddress("bbbbbbbbbbbb");
            this.elemlist.add(this.elementB);
            this.nodeC.setId(this.nodeCId);
            this.elementC.setNode(this.nodeC);
            this.elementC.setBaseBridgeAddress("cccccccccccc");
            this.elemlist.add(this.elementC);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portA, this.mac1, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac2, this.bftA);
            this.bftA = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeA, this.portAB, this.mac3, this.bftA);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBA, this.mac1, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portB, this.mac2, this.bftB);
            this.bftB = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeB, this.portBC, this.mac3, this.bftB);
            this.bftC = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, this.portCB, this.mac1, this.bftC);
            this.bftC = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, this.portCB, this.mac2, this.bftC);
            this.bftC = EnLinkdTestHelper.this.addBridgeForwardingTableEntry(this.nodeC, this.portC, this.mac3, this.bftC);
        }

        public void checkAC(List<SharedSegment> shsegms) {
            EnLinkdTestHelper.printBridgeTopology(shsegms);
            Assert.assertEquals((long)3L, (long)shsegms.size());
            for (SharedSegment shared : shsegms) {
                BridgeMacLink link;
                List links = shared.getBridgeMacLinks();
                List bblinks = shared.getBridgeBridgeLinks();
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)0L, (long)bblinks.size());
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((Object)this.nodeAId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portA, (Object)shared.getDesignatedPort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                    Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portA, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac1, (Object)link.getMacAddress());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac2)) {
                    Assert.assertEquals((long)1L, (long)bblinks.size());
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)2L, (long)links.size());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    for (BridgeMacLink link2 : links) {
                        Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link2.getBridgeDot1qTpFdbStatus());
                        Assert.assertEquals((Object)this.mac2, (Object)link2.getMacAddress());
                        boolean pass1 = true;
                        boolean pass2 = true;
                        if (pass1 && link2.getNode().getId() == this.nodeAId) {
                            Assert.assertEquals((Object)this.portAB, (Object)link2.getBridgePort());
                            pass1 = false;
                            continue;
                        }
                        if (pass2 && link2.getNode().getId() == this.nodeCId) {
                            Assert.assertEquals((Object)this.portCB, (Object)link2.getBridgePort());
                            pass2 = false;
                            continue;
                        }
                        Assert.assertTrue((boolean)false);
                    }
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac3)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((Object)this.nodeCId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portC, (Object)shared.getDesignatedPort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                    Assert.assertEquals((Object)this.nodeCId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portC, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac3, (Object)link.getMacAddress());
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }

        public void checkAB(List<SharedSegment> shsegms) {
            EnLinkdTestHelper.printBridgeTopology(shsegms);
            Assert.assertEquals((long)4L, (long)shsegms.size());
            for (SharedSegment shared : shsegms) {
                BridgeMacLink link;
                List links = shared.getBridgeMacLinks();
                List bblinks = shared.getBridgeBridgeLinks();
                if (shared.noMacsOnSegment()) {
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)0L, (long)links.size());
                    Assert.assertEquals((long)1L, (long)bblinks.size());
                    BridgeBridgeLink bblink = (BridgeBridgeLink)bblinks.iterator().next();
                    Assert.assertEquals((Object)this.nodeAId, (Object)bblink.getDesignatedNode().getId());
                    Assert.assertEquals((Object)this.nodeBId, (Object)bblink.getNode().getId());
                    Assert.assertEquals((Object)this.portAB, (Object)bblink.getDesignatedPort());
                    Assert.assertEquals((Object)this.portBA, (Object)bblink.getBridgePort());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((Object)this.nodeAId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portA, (Object)shared.getDesignatedPort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                    Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portA, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac1, (Object)link.getMacAddress());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac2)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((Object)this.nodeBId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portB, (Object)shared.getDesignatedPort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portB, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac2, (Object)link.getMacAddress());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac3)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((Object)this.nodeBId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portBC, (Object)shared.getDesignatedPort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portBC, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac3, (Object)link.getMacAddress());
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }

        public void checkBC(List<SharedSegment> shsegms) {
            EnLinkdTestHelper.printBridgeTopology(shsegms);
            Assert.assertEquals((long)4L, (long)shsegms.size());
            for (SharedSegment shared : shsegms) {
                BridgeMacLink link;
                List links = shared.getBridgeMacLinks();
                List bblinks = shared.getBridgeBridgeLinks();
                if (shared.noMacsOnSegment()) {
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)0L, (long)links.size());
                    Assert.assertEquals((long)1L, (long)bblinks.size());
                    BridgeBridgeLink bblink = (BridgeBridgeLink)bblinks.iterator().next();
                    Assert.assertEquals((Object)this.nodeBId, (Object)bblink.getDesignatedNode().getId());
                    Assert.assertEquals((Object)this.nodeCId, (Object)bblink.getNode().getId());
                    Assert.assertEquals((Object)this.portBC, (Object)bblink.getDesignatedPort());
                    Assert.assertEquals((Object)this.portCB, (Object)bblink.getBridgePort());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((Object)this.nodeBId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portBA, (Object)shared.getDesignatedPort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portBA, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac1, (Object)link.getMacAddress());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac2)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((Object)this.nodeBId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portB, (Object)shared.getDesignatedPort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portB, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac2, (Object)link.getMacAddress());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac3)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((Object)this.nodeCId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portC, (Object)shared.getDesignatedPort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                    Assert.assertEquals((Object)this.nodeCId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portC, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac3, (Object)link.getMacAddress());
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }

        public void check(List<SharedSegment> shsegms) {
            EnLinkdTestHelper.printBridgeTopology(shsegms);
            Assert.assertEquals((long)5L, (long)shsegms.size());
            for (SharedSegment shared : shsegms) {
                BridgeMacLink link;
                List links = shared.getBridgeMacLinks();
                List bblinks = shared.getBridgeBridgeLinks();
                if (shared.noMacsOnSegment()) {
                    Assert.assertEquals((long)2L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)0L, (long)links.size());
                    Assert.assertEquals((long)1L, (long)bblinks.size());
                    BridgeBridgeLink bblink = (BridgeBridgeLink)bblinks.iterator().next();
                    if (bblink.getNode().getId() == this.nodeAId) {
                        Assert.assertEquals((Object)this.nodeAId, (Object)bblink.getNode().getId());
                        Assert.assertEquals((Object)this.nodeBId, (Object)bblink.getDesignatedNode().getId());
                        Assert.assertEquals((Object)this.portAB, (Object)bblink.getBridgePort());
                        Assert.assertEquals((Object)this.portBA, (Object)bblink.getDesignatedPort());
                        continue;
                    }
                    if (bblink.getDesignatedNode().getId() != this.nodeCId) continue;
                    Assert.assertEquals((Object)this.nodeBId, (Object)bblink.getNode().getId());
                    Assert.assertEquals((Object)this.nodeCId, (Object)bblink.getDesignatedNode().getId());
                    Assert.assertEquals((Object)this.portBC, (Object)bblink.getBridgePort());
                    Assert.assertEquals((Object)this.portCB, (Object)bblink.getDesignatedPort());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac1)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((Object)this.nodeAId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portA, (Object)shared.getDesignatedPort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                    Assert.assertEquals((Object)this.nodeAId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portA, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac1, (Object)link.getMacAddress());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac2)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((Object)this.nodeBId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portB, (Object)shared.getDesignatedPort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                    Assert.assertEquals((Object)this.nodeBId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portB, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac2, (Object)link.getMacAddress());
                    continue;
                }
                if (shared.getMacsOnSegment().contains(this.mac3)) {
                    Assert.assertEquals((long)1L, (long)shared.getBridgeIdsOnSegment().size());
                    Assert.assertEquals((long)1L, (long)links.size());
                    Assert.assertEquals((Object)this.nodeCId, (Object)shared.getDesignatedBridge());
                    Assert.assertEquals((Object)this.portC, (Object)shared.getDesignatedPort());
                    Assert.assertTrue((!shared.noMacsOnSegment() ? 1 : 0) != 0);
                    link = (BridgeMacLink)links.iterator().next();
                    Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
                    Assert.assertEquals((Object)this.nodeCId, (Object)link.getNode().getId());
                    Assert.assertEquals((Object)this.portC, (Object)link.getBridgePort());
                    Assert.assertEquals((Object)this.mac3, (Object)link.getMacAddress());
                    continue;
                }
                Assert.assertEquals((Object)false, (Object)true);
            }
        }
    }
}

