/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.EnLinkdBuilderITCase;
import org.opennms.netmgt.enlinkd.EnLinkdTestHelper;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.model.BridgeBridgeLink;
import org.opennms.netmgt.model.BridgeMacLink;
import org.opennms.netmgt.model.NetworkBuilder;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.model.topology.BroadcastDomain;
import org.opennms.netmgt.model.topology.SharedSegment;
import org.opennms.netmgt.nb.Nms10205bNetworkBuilder;
import org.opennms.netmgt.nb.Nms17216NetworkBuilder;

public class EnLinkdIT
extends EnLinkdBuilderITCase {
    Nms10205bNetworkBuilder builder10205a = new Nms10205bNetworkBuilder();
    Nms17216NetworkBuilder builder = new Nms17216NetworkBuilder();

    @Test
    public void testGetSnmpNodeList() throws Exception {
        this.m_nodeDao.save((Object)this.builder10205a.getMumbai());
        this.m_nodeDao.save((Object)this.builder10205a.getDelhi());
        this.m_nodeDao.save((Object)this.builder.getSwitch1());
        this.m_nodeDao.flush();
        int mumbai = this.m_nodeDao.findByForeignId("linkd", "Mumbai").getId();
        int delhi = this.m_nodeDao.findByForeignId("linkd", "Delhi").getId();
        int switch1 = this.m_nodeDao.findByForeignId("linkd", "Switch1").getId();
        List linkablenodes = this.m_linkd.getQueryManager().getSnmpNodeList();
        Assert.assertNotNull((Object)linkablenodes);
        Assert.assertEquals((long)3L, (long)linkablenodes.size());
        for (Node linkablenode : linkablenodes) {
            if (linkablenode.getNodeId() == mumbai) {
                Assert.assertEquals((Object)InetAddressUtils.addr((String)"10.205.56.5"), (Object)linkablenode.getSnmpPrimaryIpAddr());
                Assert.assertEquals((Object)".1.3.6.1.4.1.2636.1.1.1.2.9", (Object)linkablenode.getSysoid());
                continue;
            }
            if (linkablenode.getNodeId() == delhi) {
                Assert.assertEquals((Object)InetAddressUtils.addr((String)"10.205.56.7"), (Object)linkablenode.getSnmpPrimaryIpAddr());
                Assert.assertEquals((Object)".1.3.6.1.4.1.2636.1.1.1.2.29", (Object)linkablenode.getSysoid());
                continue;
            }
            if (linkablenode.getNodeId() == switch1) {
                Assert.assertEquals((Object)InetAddressUtils.addr((String)"172.16.10.1"), (Object)linkablenode.getSnmpPrimaryIpAddr());
                Assert.assertEquals((Object)".1.3.6.1.4.1.9.1.614", (Object)linkablenode.getSysoid());
                continue;
            }
            Assert.assertTrue((boolean)false);
        }
        Node delhilinkablenode = this.m_linkd.getQueryManager().getSnmpNode(delhi);
        Assert.assertNotNull((Object)delhilinkablenode);
        Assert.assertEquals((long)delhi, (long)delhilinkablenode.getNodeId());
        Assert.assertEquals((Object)InetAddressUtils.addr((String)"10.205.56.7"), (Object)delhilinkablenode.getSnmpPrimaryIpAddr());
        Assert.assertEquals((Object)".1.3.6.1.4.1.2636.1.1.1.2.29", (Object)delhilinkablenode.getSysoid());
    }

    @Test
    public void testStoreBft() {
        EnLinkdTestHelper.OneBridgeCompleteTopology topology = new EnLinkdTestHelper.OneBridgeCompleteTopology();
        this.m_nodeDao.save((Object)topology.nodeA);
        this.m_linkd.getQueryManager().store(topology.nodeAId.intValue(), topology.bftA);
        List links = this.m_linkd.getQueryManager().useBridgeTopologyUpdateBFT(topology.nodeAId.intValue());
        Assert.assertEquals((long)topology.bftA.size(), (long)links.size());
        for (BridgeMacLink link : links) {
            Assert.assertEquals((Object)BridgeMacLink.BridgeDot1qTpFdbStatus.DOT1D_TP_FDB_STATUS_LEARNED, (Object)link.getBridgeDot1qTpFdbStatus());
            EnLinkdIT.printBridgeMacLink(link);
        }
    }

    @Test
    public void testLoadTopology() {
        OnmsMonitoringLocation location = new OnmsMonitoringLocation("Default", "Default");
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        OnmsNode lnodeA = topology.nodeA;
        lnodeA.setForeignSource("linkd");
        lnodeA.setForeignId("nodeA");
        lnodeA.setLabel("nodeA");
        lnodeA.setLocation(location);
        OnmsNode lnodeB = topology.nodeB;
        lnodeB.setForeignSource("linkd");
        lnodeB.setForeignId("nodeB");
        lnodeB.setLabel("nodeB");
        lnodeB.setLocation(location);
        OnmsNode lnodeC = topology.nodeC;
        lnodeC.setForeignSource("linkd");
        lnodeC.setForeignId("nodeC");
        lnodeC.setLabel("nodeC");
        lnodeC.setLocation(location);
        this.m_nodeDao.save((Object)lnodeA);
        this.m_nodeDao.save((Object)lnodeB);
        this.m_nodeDao.save((Object)lnodeC);
        OnmsNode nodeA = this.m_nodeDao.findByForeignId("linkd", "nodeA");
        OnmsNode nodeB = this.m_nodeDao.findByForeignId("linkd", "nodeB");
        OnmsNode nodeC = this.m_nodeDao.findByForeignId("linkd", "nodeC");
        topology.nodeAId = nodeA.getId();
        topology.nodeBId = nodeB.getId();
        topology.nodeCId = nodeC.getId();
        topology.nodeA = nodeA;
        topology.nodeB = nodeB;
        topology.nodeC = nodeC;
        BridgeBridgeLink ablink = new BridgeBridgeLink();
        ablink.setNode(nodeA);
        ablink.setBridgePort(topology.portAB);
        ablink.setDesignatedNode(nodeB);
        ablink.setDesignatedPort(topology.portBA);
        ablink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)ablink);
        BridgeBridgeLink bclink = new BridgeBridgeLink();
        bclink.setNode(nodeC);
        bclink.setBridgePort(topology.portCB);
        bclink.setDesignatedNode(nodeB);
        bclink.setDesignatedPort(topology.portBC);
        bclink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)bclink);
        BridgeMacLink mac1 = new BridgeMacLink();
        mac1.setNode(nodeA);
        mac1.setBridgePort(topology.portA);
        mac1.setMacAddress(topology.mac1);
        mac1.setBridgeMacLinkLastPollTime(mac1.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac1);
        BridgeMacLink mac2 = new BridgeMacLink();
        mac2.setNode(nodeB);
        mac2.setBridgePort(topology.portB);
        mac2.setMacAddress(topology.mac2);
        mac2.setBridgeMacLinkLastPollTime(mac2.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac2);
        BridgeMacLink mac3 = new BridgeMacLink();
        mac3.setNode(nodeC);
        mac3.setBridgePort(topology.portC);
        mac3.setMacAddress(topology.mac3);
        mac3.setBridgeMacLinkLastPollTime(mac3.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac3);
        this.m_bridgeMacLinkDao.flush();
        this.m_bridgeBridgeLinkDao.flush();
        Assert.assertEquals((long)3L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertEquals((long)2L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertNotNull((Object)this.m_bridgeTopologyDao);
        this.m_linkd.getQueryManager().loadBridgeTopology();
        Assert.assertEquals((long)1L, (long)this.m_bridgeTopologyDao.getAll().size());
        BroadcastDomain nodeAbd = this.m_linkd.getQueryManager().getBridgeTopologyBroadcastDomain(nodeA.getId().intValue());
        Assert.assertNotNull((Object)nodeAbd);
        BroadcastDomain nodeBbd = this.m_linkd.getQueryManager().getBridgeTopologyBroadcastDomain(nodeB.getId().intValue());
        BroadcastDomain nodeCbd = this.m_linkd.getQueryManager().getBridgeTopologyBroadcastDomain(nodeC.getId().intValue());
        Assert.assertEquals((Object)nodeAbd, (Object)nodeBbd);
        Assert.assertEquals((Object)nodeAbd, (Object)nodeCbd);
        nodeAbd.hierarchySetUp(nodeAbd.getBridge(nodeA.getId().intValue()));
        topology.check(nodeAbd.getTopology());
        List nodeASegments = this.m_bridgeTopologyDao.getBridgeNodeSharedSegments(this.m_bridgeBridgeLinkDao, this.m_bridgeMacLinkDao, nodeA.getId().intValue());
        Assert.assertEquals((long)2L, (long)nodeASegments.size());
        for (SharedSegment segment : nodeASegments) {
            EnLinkdIT.printSharedSegment(segment);
        }
    }

    @Test
    public void testDeleteBridgeC() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        NetworkBuilder nb = new NetworkBuilder();
        nb.addNode("nodeA").setForeignSource("linkd").setForeignId("nodeA").setSysObjectId("0.0").setSysName("nodeA").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.1").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("nodeB").setForeignSource("linkd").setForeignId("nodeB").setSysObjectId("0.0").setSysName("nodeB").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.2").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("nodeC").setForeignSource("linkd").setForeignId("nodeC").setSysObjectId("0.0").setSysName("nodeC").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.3").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        OnmsNode nodeA = this.m_nodeDao.findByForeignId("linkd", "nodeA");
        OnmsNode nodeB = this.m_nodeDao.findByForeignId("linkd", "nodeB");
        OnmsNode nodeC = this.m_nodeDao.findByForeignId("linkd", "nodeC");
        topology.nodeAId = nodeA.getId();
        topology.nodeBId = nodeB.getId();
        topology.nodeCId = nodeC.getId();
        topology.nodeA = nodeA;
        topology.nodeB = nodeB;
        topology.nodeC = nodeC;
        BridgeBridgeLink ablink = new BridgeBridgeLink();
        ablink.setNode(nodeA);
        ablink.setBridgePort(topology.portAB);
        ablink.setDesignatedNode(nodeB);
        ablink.setDesignatedPort(topology.portBA);
        ablink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)ablink);
        BridgeBridgeLink bclink = new BridgeBridgeLink();
        bclink.setNode(nodeC);
        bclink.setBridgePort(topology.portCB);
        bclink.setDesignatedNode(nodeB);
        bclink.setDesignatedPort(topology.portBC);
        bclink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)bclink);
        BridgeMacLink mac1 = new BridgeMacLink();
        mac1.setNode(nodeA);
        mac1.setBridgePort(topology.portA);
        mac1.setMacAddress(topology.mac1);
        mac1.setBridgeMacLinkLastPollTime(mac1.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac1);
        BridgeMacLink mac2 = new BridgeMacLink();
        mac2.setNode(nodeB);
        mac2.setBridgePort(topology.portB);
        mac2.setMacAddress(topology.mac2);
        mac2.setBridgeMacLinkLastPollTime(mac2.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac2);
        BridgeMacLink mac3 = new BridgeMacLink();
        mac3.setNode(nodeC);
        mac3.setBridgePort(topology.portC);
        mac3.setMacAddress(topology.mac3);
        mac3.setBridgeMacLinkLastPollTime(mac3.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac3);
        this.m_bridgeMacLinkDao.flush();
        this.m_bridgeBridgeLinkDao.flush();
        Assert.assertEquals((long)3L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertEquals((long)2L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertNotNull((Object)this.m_bridgeTopologyDao);
        this.m_linkd.getQueryManager().loadBridgeTopology();
        Assert.assertEquals((long)1L, (long)this.m_bridgeTopologyDao.getAll().size());
        BroadcastDomain nodeAbd = this.m_linkd.getQueryManager().getBridgeTopologyBroadcastDomain(nodeA.getId().intValue());
        Assert.assertNotNull((Object)nodeAbd);
        BroadcastDomain nodeBbd = this.m_linkd.getQueryManager().getBridgeTopologyBroadcastDomain(nodeB.getId().intValue());
        Assert.assertNotNull((Object)nodeBbd);
        Assert.assertEquals((Object)nodeAbd, (Object)nodeBbd);
        BroadcastDomain nodeCbd = this.m_linkd.getQueryManager().getBridgeTopologyBroadcastDomain(nodeC.getId().intValue());
        Assert.assertNotNull((Object)nodeCbd);
        Assert.assertEquals((Object)nodeAbd, (Object)nodeCbd);
        Assert.assertNull((Object)nodeAbd.getRootBridgeId());
        Assert.assertTrue((boolean)nodeAbd.containBridgeId(nodeA.getId().intValue()));
        Assert.assertTrue((boolean)nodeAbd.containBridgeId(nodeB.getId().intValue()));
        Assert.assertTrue((boolean)nodeAbd.containBridgeId(nodeC.getId().intValue()));
        nodeAbd.hierarchySetUp(nodeAbd.getBridge(nodeA.getId().intValue()));
        Assert.assertNotNull((Object)nodeAbd.getRootBridgeId());
        topology.check(nodeAbd.getTopology());
        this.m_linkd.deleteNode(nodeC.getId().intValue());
        Assert.assertEquals((long)1L, (long)this.m_bridgeTopologyDao.getAll().size());
        BroadcastDomain domain = (BroadcastDomain)this.m_bridgeTopologyDao.getAll().iterator().next();
        topology.checkAB(domain.getTopology());
    }

    @Test
    public void testDeleteBridgeB() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        NetworkBuilder nb = new NetworkBuilder();
        nb.addNode("nodeA").setForeignSource("linkd").setForeignId("nodeA").setSysObjectId("0.0").setSysName("nodeA").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.1").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("nodeB").setForeignSource("linkd").setForeignId("nodeB").setSysObjectId("0.0").setSysName("nodeB").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.2").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("nodeC").setForeignSource("linkd").setForeignId("nodeC").setSysObjectId("0.0").setSysName("nodeC").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.3").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        OnmsNode nodeA = this.m_nodeDao.findByForeignId("linkd", "nodeA");
        OnmsNode nodeB = this.m_nodeDao.findByForeignId("linkd", "nodeB");
        OnmsNode nodeC = this.m_nodeDao.findByForeignId("linkd", "nodeC");
        topology.nodeAId = nodeA.getId();
        topology.nodeBId = nodeB.getId();
        topology.nodeCId = nodeC.getId();
        topology.nodeA = nodeA;
        topology.nodeB = nodeB;
        topology.nodeC = nodeC;
        BridgeBridgeLink ablink = new BridgeBridgeLink();
        ablink.setNode(nodeB);
        ablink.setBridgePort(topology.portBA);
        ablink.setDesignatedNode(nodeA);
        ablink.setDesignatedPort(topology.portAB);
        ablink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)ablink);
        BridgeBridgeLink bclink = new BridgeBridgeLink();
        bclink.setNode(nodeC);
        bclink.setBridgePort(topology.portCB);
        bclink.setDesignatedNode(nodeB);
        bclink.setDesignatedPort(topology.portBC);
        bclink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)bclink);
        BridgeMacLink mac1 = new BridgeMacLink();
        mac1.setNode(nodeA);
        mac1.setBridgePort(topology.portA);
        mac1.setMacAddress(topology.mac1);
        mac1.setBridgeMacLinkLastPollTime(mac1.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac1);
        BridgeMacLink mac2 = new BridgeMacLink();
        mac2.setNode(nodeB);
        mac2.setBridgePort(topology.portB);
        mac2.setMacAddress(topology.mac2);
        mac2.setBridgeMacLinkLastPollTime(mac2.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac2);
        BridgeMacLink mac3 = new BridgeMacLink();
        mac3.setNode(nodeC);
        mac3.setBridgePort(topology.portC);
        mac3.setMacAddress(topology.mac3);
        mac3.setBridgeMacLinkLastPollTime(mac3.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac3);
        this.m_bridgeMacLinkDao.flush();
        this.m_bridgeBridgeLinkDao.flush();
        Assert.assertEquals((long)3L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertEquals((long)2L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertNotNull((Object)this.m_bridgeTopologyDao);
        this.m_linkd.getQueryManager().loadBridgeTopology();
        Assert.assertEquals((long)1L, (long)this.m_bridgeTopologyDao.getAll().size());
        BroadcastDomain nodeAbd = this.m_linkd.getQueryManager().getBridgeTopologyBroadcastDomain(nodeA.getId().intValue());
        Assert.assertNotNull((Object)nodeAbd);
        BroadcastDomain nodeBbd = this.m_linkd.getQueryManager().getBridgeTopologyBroadcastDomain(nodeB.getId().intValue());
        BroadcastDomain nodeCbd = this.m_linkd.getQueryManager().getBridgeTopologyBroadcastDomain(nodeC.getId().intValue());
        Assert.assertEquals((Object)nodeAbd, (Object)nodeBbd);
        Assert.assertEquals((Object)nodeAbd, (Object)nodeCbd);
        Assert.assertNull((Object)nodeAbd.getRootBridgeId());
        Assert.assertTrue((boolean)nodeAbd.containBridgeId(nodeA.getId().intValue()));
        Assert.assertTrue((boolean)nodeAbd.containBridgeId(nodeB.getId().intValue()));
        Assert.assertTrue((boolean)nodeAbd.containBridgeId(nodeC.getId().intValue()));
        nodeAbd.hierarchySetUp(nodeAbd.getBridge(nodeA.getId().intValue()));
        Assert.assertNotNull((Object)nodeAbd.getRootBridgeId());
        topology.check(nodeAbd.getTopology());
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(nodeB.getId().intValue()));
        this.m_linkd.deleteNode(nodeB.getId().intValue());
        Assert.assertEquals((long)1L, (long)this.m_bridgeTopologyDao.getAll().size());
        BroadcastDomain domain = (BroadcastDomain)this.m_bridgeTopologyDao.getAll().iterator().next();
        topology.checkAC(domain.getTopology());
    }

    @Test
    public void testDeleteBridgeA() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        NetworkBuilder nb = new NetworkBuilder();
        nb.addNode("nodeA").setForeignSource("linkd").setForeignId("nodeA").setSysObjectId("0.0").setSysName("nodeA").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.1").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("nodeB").setForeignSource("linkd").setForeignId("nodeB").setSysObjectId("0.0").setSysName("nodeB").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.2").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        nb.addNode("nodeC").setForeignSource("linkd").setForeignId("nodeC").setSysObjectId("0.0").setSysName("nodeC").setType(OnmsNode.NodeType.ACTIVE);
        nb.addInterface("10.0.1.3").setIsSnmpPrimary("P").setIsManaged("M");
        this.m_nodeDao.save((Object)nb.getCurrentNode());
        OnmsNode nodeA = this.m_nodeDao.findByForeignId("linkd", "nodeA");
        OnmsNode nodeB = this.m_nodeDao.findByForeignId("linkd", "nodeB");
        OnmsNode nodeC = this.m_nodeDao.findByForeignId("linkd", "nodeC");
        topology.nodeAId = nodeA.getId();
        topology.nodeBId = nodeB.getId();
        topology.nodeCId = nodeC.getId();
        topology.nodeA = nodeA;
        topology.nodeB = nodeB;
        topology.nodeC = nodeC;
        BridgeBridgeLink ablink = new BridgeBridgeLink();
        ablink.setNode(nodeB);
        ablink.setBridgePort(topology.portBA);
        ablink.setDesignatedNode(nodeA);
        ablink.setDesignatedPort(topology.portAB);
        ablink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)ablink);
        BridgeBridgeLink bclink = new BridgeBridgeLink();
        bclink.setNode(nodeC);
        bclink.setBridgePort(topology.portCB);
        bclink.setDesignatedNode(nodeB);
        bclink.setDesignatedPort(topology.portBC);
        bclink.setBridgeBridgeLinkLastPollTime(ablink.getBridgeBridgeLinkCreateTime());
        this.m_bridgeBridgeLinkDao.save((Object)bclink);
        BridgeMacLink mac1 = new BridgeMacLink();
        mac1.setNode(nodeA);
        mac1.setBridgePort(topology.portA);
        mac1.setMacAddress(topology.mac1);
        mac1.setBridgeMacLinkLastPollTime(mac1.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac1);
        BridgeMacLink mac2 = new BridgeMacLink();
        mac2.setNode(nodeB);
        mac2.setBridgePort(topology.portB);
        mac2.setMacAddress(topology.mac2);
        mac2.setBridgeMacLinkLastPollTime(mac2.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac2);
        BridgeMacLink mac3 = new BridgeMacLink();
        mac3.setNode(nodeC);
        mac3.setBridgePort(topology.portC);
        mac3.setMacAddress(topology.mac3);
        mac3.setBridgeMacLinkLastPollTime(mac3.getBridgeMacLinkCreateTime());
        this.m_bridgeMacLinkDao.save((Object)mac3);
        this.m_bridgeMacLinkDao.flush();
        this.m_bridgeBridgeLinkDao.flush();
        Assert.assertEquals((long)3L, (long)this.m_bridgeMacLinkDao.countAll());
        Assert.assertEquals((long)2L, (long)this.m_bridgeBridgeLinkDao.countAll());
        Assert.assertNotNull((Object)this.m_bridgeTopologyDao);
        this.m_linkd.getQueryManager().loadBridgeTopology();
        Assert.assertEquals((long)1L, (long)this.m_bridgeTopologyDao.getAll().size());
        BroadcastDomain nodeAbd = this.m_linkd.getQueryManager().getBridgeTopologyBroadcastDomain(nodeA.getId().intValue());
        Assert.assertNotNull((Object)nodeAbd);
        BroadcastDomain nodeBbd = this.m_linkd.getQueryManager().getBridgeTopologyBroadcastDomain(nodeB.getId().intValue());
        BroadcastDomain nodeCbd = this.m_linkd.getQueryManager().getBridgeTopologyBroadcastDomain(nodeC.getId().intValue());
        Assert.assertEquals((Object)nodeAbd, (Object)nodeBbd);
        Assert.assertEquals((Object)nodeAbd, (Object)nodeCbd);
        Assert.assertNull((Object)nodeAbd.getRootBridgeId());
        Assert.assertTrue((boolean)nodeAbd.containBridgeId(nodeA.getId().intValue()));
        Assert.assertTrue((boolean)nodeAbd.containBridgeId(nodeB.getId().intValue()));
        Assert.assertTrue((boolean)nodeAbd.containBridgeId(nodeC.getId().intValue()));
        nodeAbd.hierarchySetUp(nodeAbd.getBridge(nodeA.getId().intValue()));
        Assert.assertNotNull((Object)nodeAbd.getRootBridgeId());
        topology.check(nodeAbd.getTopology());
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(nodeA.getId().intValue()));
        this.m_linkd.scheduleBridgeTopologyDiscovery(nodeA.getId().intValue());
        this.m_linkd.deleteNode(nodeA.getId().intValue());
        Assert.assertEquals((long)1L, (long)this.m_bridgeTopologyDao.getAll().size());
        BroadcastDomain domain = (BroadcastDomain)this.m_bridgeTopologyDao.getAll().iterator().next();
        topology.checkBC(domain.getTopology());
    }
}

