/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.enlinkd.EnLinkdBuilderITCase;
import org.opennms.netmgt.model.CdpElement;
import org.opennms.netmgt.model.CdpLink;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OspfElement;
import org.opennms.netmgt.nb.Nms7467NetworkBuilder;

public class Nms7467EnIT
extends EnLinkdBuilderITCase {
    private Nms7467NetworkBuilder builder = new Nms7467NetworkBuilder();

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="192.0.2.7", port=161, resource="classpath:linkd/nms7467/192.0.2.7-walk.txt")})
    public void testCisco01Links() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getCiscoWsC2948());
        this.m_nodeDao.flush();
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseIsisDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(false);
        Assert.assertTrue((!this.m_linkdConfig.useIsisDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useBridgeDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.m_linkdConfig.useCdpDiscovery());
        OnmsNode cisco01 = this.m_nodeDao.findByForeignId("linkd", "ciscoswitch");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(cisco01.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(cisco01.getId().intValue()));
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            Assert.assertNotNull((Object)node.getCdpElement());
            Nms7467EnIT.printCdpElement(node.getCdpElement());
            Assert.assertEquals((Object)OspfElement.TruthValue.TRUE, (Object)node.getCdpElement().getCdpGlobalRun());
            Assert.assertEquals((Object)"JAB043408B7", (Object)node.getCdpElement().getCdpGlobalDeviceId());
            Assert.assertEquals((Object)CdpElement.CdpGlobalDeviceIdFormat.other, (Object)node.getCdpElement().getCdpGlobalDeviceIdFormat());
        }
        Assert.assertEquals((long)5L, (long)this.m_cdpLinkDao.countAll());
        for (CdpLink link : this.m_cdpLinkDao.findAll()) {
            Assert.assertNotNull((Object)link);
            Nms7467EnIT.printCdpLink(link);
        }
    }
}

