/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgent;
import org.opennms.core.test.snmp.annotations.JUnitSnmpAgents;
import org.opennms.netmgt.enlinkd.EnLinkdBuilderITCase;
import org.opennms.netmgt.model.IsIsElement;
import org.opennms.netmgt.model.IsIsLink;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.nb.Nms6802NetworkBuilder;

public class Nms6801EnIT
extends EnLinkdBuilderITCase {
    Nms6802NetworkBuilder builder = new Nms6802NetworkBuilder();

    @Test
    @JUnitSnmpAgents(value={@JUnitSnmpAgent(host="10.100.68.2", port=161, resource="classpath:linkd/nms6802/cisco-ios-xr-walk.txt")})
    public void testIsIsLinks() throws Exception {
        this.m_nodeDao.save((Object)this.builder.getCiscoIosXrRouter());
        this.m_nodeDao.flush();
        this.m_linkdConfig.getConfiguration().setUseBridgeDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseOspfDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseLldpDiscovery(false);
        this.m_linkdConfig.getConfiguration().setUseCdpDiscovery(false);
        Assert.assertTrue((boolean)this.m_linkdConfig.useIsisDiscovery());
        Assert.assertTrue((!this.m_linkdConfig.useBridgeDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useOspfDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useLldpDiscovery() ? 1 : 0) != 0);
        Assert.assertTrue((!this.m_linkdConfig.useCdpDiscovery() ? 1 : 0) != 0);
        OnmsNode ciscoiosxr = this.m_nodeDao.findByForeignId("linkd", "cisco-ios-xr");
        Assert.assertTrue((boolean)this.m_linkd.scheduleNodeCollection(ciscoiosxr.getId().intValue()));
        Assert.assertTrue((boolean)this.m_linkd.runSingleSnmpCollection(ciscoiosxr.getId().intValue()));
        Assert.assertEquals((long)4L, (long)this.m_isisLinkDao.countAll());
        Assert.assertEquals((long)0L, (long)this.m_isisLinkDao.getLinksForTopology().size());
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            Assert.assertNotNull((Object)node.getIsisElement());
            System.err.println(node.getIsisElement());
            Assert.assertEquals((Object)"093176090107", (Object)node.getIsisElement().getIsisSysID());
            Assert.assertEquals((Object)IsIsElement.IsisAdminState.on, (Object)node.getIsisElement().getIsisSysAdminState());
        }
        block7: for (IsIsLink link : this.m_isisLinkDao.findAll()) {
            System.err.println(link);
            Assert.assertEquals((Object)IsIsElement.IsisAdminState.on, (Object)link.getIsisCircAdminState());
            Assert.assertEquals((Object)IsIsLink.IsisISAdjState.up, (Object)link.getIsisISAdjState());
            Assert.assertEquals((Object)"000000000000", (Object)link.getIsisISAdjNeighSNPAAddress());
            Assert.assertEquals((Object)IsIsLink.IsisISAdjNeighSysType.l2IntermediateSystem, (Object)link.getIsisISAdjNeighSysType());
            switch (link.getIsisCircIndex()) {
                case 19: {
                    Assert.assertEquals((long)5L, (long)link.getIsisISAdjIndex().intValue());
                    Assert.assertEquals((long)19L, (long)link.getIsisCircIfIndex().intValue());
                    Assert.assertEquals((Object)"093176092059", (Object)link.getIsisISAdjNeighSysID());
                    Assert.assertEquals((long)234881856L, (long)link.getIsisISAdjNbrExtendedCircID().intValue());
                    continue block7;
                }
                case 20: {
                    Assert.assertEquals((long)5L, (long)link.getIsisISAdjIndex().intValue());
                    Assert.assertEquals((long)20L, (long)link.getIsisCircIfIndex().intValue());
                    Assert.assertEquals((Object)"093176092059", (Object)link.getIsisISAdjNeighSysID());
                    Assert.assertEquals((long)234881920L, (long)link.getIsisISAdjNbrExtendedCircID().intValue());
                    continue block7;
                }
                case 27: {
                    Assert.assertEquals((long)3L, (long)link.getIsisISAdjIndex().intValue());
                    Assert.assertEquals((long)27L, (long)link.getIsisCircIfIndex().intValue());
                    Assert.assertEquals((Object)"093176090003", (Object)link.getIsisISAdjNeighSysID());
                    Assert.assertEquals((long)33554880L, (long)link.getIsisISAdjNbrExtendedCircID().intValue());
                    continue block7;
                }
                case 28: {
                    Assert.assertEquals((long)3L, (long)link.getIsisISAdjIndex().intValue());
                    Assert.assertEquals((long)28L, (long)link.getIsisCircIfIndex().intValue());
                    Assert.assertEquals((Object)"093176090003", (Object)link.getIsisISAdjNeighSysID());
                    Assert.assertEquals((long)0x2000200L, (long)link.getIsisISAdjNbrExtendedCircID().intValue());
                    continue block7;
                }
            }
            Assert.assertTrue((boolean)false);
        }
    }
}

