/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.test.MockLogAppender;
import org.opennms.netmgt.config.EnhancedLinkdConfig;
import org.opennms.netmgt.config.EnhancedLinkdConfigManager;
import org.opennms.netmgt.config.enlinkd.EnlinkdConfiguration;
import org.opennms.netmgt.enlinkd.EnLinkdTestHelper;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.NodeDiscoveryBridgeTopology;
import org.opennms.netmgt.model.topology.Bridge;
import org.opennms.netmgt.model.topology.BroadcastDomain;

public class BroadcastDomainTest
extends EnLinkdTestHelper {
    EnhancedLinkd linkd;

    @Before
    public void setUp() throws Exception {
        Properties p = new Properties();
        p.setProperty("log4j.logger.org.opennms.netmgt.model.topology", "DEBUG");
        MockLogAppender.setupLogging((Properties)p);
        this.linkd = new EnhancedLinkd();
        EnhancedLinkdConfigManager config = new EnhancedLinkdConfigManager(){

            public void save() throws MarshalException, IOException, ValidationException {
            }

            public void reload() throws IOException, MarshalException, ValidationException {
                m_config = new EnlinkdConfiguration();
                m_config.setInitial_sleep_time(1000L);
                m_config.setRescan_interval(10000L);
            }

            protected void saveXml(String xml) throws IOException {
            }
        };
        config.reload();
        this.linkd.setLinkdConfig((EnhancedLinkdConfig)config);
    }

    @Test
    public void testLock() throws Exception {
        Object locker = new Object();
        Object notlocker = new Object();
        BroadcastDomain domain = new BroadcastDomain();
        Assert.assertTrue((boolean)domain.getLock(locker));
        Assert.assertTrue((!domain.getLock(notlocker) ? 1 : 0) != 0);
        Assert.assertTrue((!domain.releaseLock(notlocker) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)domain.releaseLock(locker));
    }

    @Test
    public void testOneBridgeOnePortOneMac() throws Exception {
        EnLinkdTestHelper.OneBridgeOnePortOneMacTopology topology = new EnLinkdTestHelper.OneBridgeOnePortOneMacTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.check(ndbt.getDomain().getTopology());
    }

    @Test
    public void testOneBridgeMoreMacOnePort() throws Exception {
        EnLinkdTestHelper.OneBridgeMoreMacOnePortTopology topology = new EnLinkdTestHelper.OneBridgeMoreMacOnePortTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.check(ndbt.getDomain().getTopology());
    }

    @Test
    public void testOneBridgeComplete() throws Exception {
        EnLinkdTestHelper.OneBridgeCompleteTopology topology = new EnLinkdTestHelper.OneBridgeCompleteTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.check(ndbt.getDomain().getTopology());
    }

    @Test
    public void testTwoConnectedBridge() throws Exception {
        EnLinkdTestHelper.TwoConnectedBridgeTopology topology = new EnLinkdTestHelper.TwoConnectedBridgeTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.addBridge(new Bridge(topology.nodeBId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.check(ndbt.getDomain().getTopology());
    }

    @Test
    public void testTwoMergeBridge() throws Exception {
        EnLinkdTestHelper.TwoMergeBridgeTopology topology = new EnLinkdTestHelper.TwoMergeBridgeTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.addBridge(new Bridge(topology.nodeBId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.check(ndbt.getDomain().getTopology());
    }

    @Test
    public void testTwoBridgeWithBackbonePorts() {
        EnLinkdTestHelper.TwoBridgeWithBackbonePortsTopology topology = new EnLinkdTestHelper.TwoBridgeWithBackbonePortsTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.addBridge(new Bridge(topology.nodeBId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.check(ndbt.getDomain().getTopology());
    }

    @Test
    public void testTwoBridgeWithBackbonePortsUsingBridgeAddressInBft() {
        EnLinkdTestHelper.TwoBridgeWithBackbonePortsTopologyWithBridgeinBft topology = new EnLinkdTestHelper.TwoBridgeWithBackbonePortsTopologyWithBridgeinBft();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.addBridge(new Bridge(topology.nodeBId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.check(ndbt.getDomain().getTopology());
    }

    @Test
    public void testTwoBridgeOneCalculation() {
        EnLinkdTestHelper.TwoNodeTopology topology = new EnLinkdTestHelper.TwoNodeTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.addBridge(new Bridge(topology.nodeBId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.check2nodeTopology(ndbt.getDomain().getTopology(), false);
        Assert.assertEquals((Object)topology.nodeBId, (Object)ndbt.getDomain().getRootBridgeId());
    }

    @Test
    public void testTwoBridgeTwoCalculation() {
        EnLinkdTestHelper.TwoNodeTopology topology = new EnLinkdTestHelper.TwoNodeTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeBId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        List shsegs = ndbt.getDomain().getTopology();
        BroadcastDomainTest.printBridgeTopology(shsegs);
        Assert.assertEquals((long)3L, (long)shsegs.size());
        domain.addBridge(new Bridge(topology.nodeAId));
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.calculate();
        topology.check2nodeTopology(ndbt.getDomain().getTopology(), false);
        Assert.assertEquals((Object)topology.nodeBId, (Object)domain.getRootBridgeId());
    }

    @Test
    public void testTwoBridgeTwoCalculationReverse() {
        EnLinkdTestHelper.TwoNodeTopology topology = new EnLinkdTestHelper.TwoNodeTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        List shsegs = ndbt.getDomain().getTopology();
        BroadcastDomainTest.printBridgeTopology(shsegs);
        Assert.assertEquals((long)3L, (long)shsegs.size());
        domain.addBridge(new Bridge(topology.nodeBId));
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.calculate();
        topology.check2nodeTopology(ndbt.getDomain().getTopology(), true);
        Assert.assertEquals((Object)topology.nodeBId, (Object)domain.getRootBridgeId());
    }

    @Test
    public void testAB() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.addBridge(new Bridge(topology.nodeBId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.checkAB(ndbt.getDomain().getTopology());
    }

    @Test
    public void testBA() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.addBridge(new Bridge(topology.nodeAId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.checkAB(ndbt.getDomain().getTopology());
    }

    @Test
    public void testAC() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.addBridge(new Bridge(topology.nodeCId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeCId.intValue()), topology.bftC);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.checkAC(ndbt.getDomain().getTopology());
    }

    @Test
    public void testCA() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeCId));
        domain.addBridge(new Bridge(topology.nodeAId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeCId.intValue()), topology.bftC);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.checkAC(ndbt.getDomain().getTopology());
    }

    @Test
    public void testBC() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.addBridge(new Bridge(topology.nodeCId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeCId.intValue()), topology.bftC);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.checkBC(ndbt.getDomain().getTopology());
    }

    @Test
    public void testCB() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeCId));
        domain.addBridge(new Bridge(topology.nodeBId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeCId.intValue()), topology.bftC);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.checkBC(ndbt.getDomain().getTopology());
    }

    @Test
    public void testABC() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.addBridge(new Bridge(topology.nodeCId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeCId.intValue()), topology.bftC);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.check(ndbt.getDomain().getTopology());
    }

    @Test
    public void testAThenBC() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.addBridge(new Bridge(topology.nodeCId));
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeCId.intValue()), topology.bftC);
        ndbt.calculate();
        topology.check(ndbt.getDomain().getTopology());
    }

    @Test
    public void testACThenB() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.addBridge(new Bridge(topology.nodeCId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeCId.intValue()), topology.bftC);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.checkAC(ndbt.getDomain().getTopology());
        domain.addBridge(new Bridge(topology.nodeBId));
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.calculate();
        topology.check(ndbt.getDomain().getTopology());
    }

    @Test
    public void testBAThenC() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeBId));
        domain.addBridge(new Bridge(topology.nodeAId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.checkAB(ndbt.getDomain().getTopology());
        domain.addBridge(new Bridge(topology.nodeCId));
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeCId.intValue()), topology.bftC);
        ndbt.calculate();
        topology.check(ndbt.getDomain().getTopology());
    }

    @Test
    public void testBThenCA() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeBId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        domain.addBridge(new Bridge(topology.nodeCId));
        domain.addBridge(new Bridge(topology.nodeAId));
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeCId.intValue()), topology.bftC);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.calculate();
        topology.check(ndbt.getDomain().getTopology());
    }

    @Test
    public void testCThenAB() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeCId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeCId.intValue()), topology.bftC);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        domain.addBridge(new Bridge(topology.nodeAId));
        domain.addBridge(new Bridge(topology.nodeBId));
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.calculate();
        topology.check(ndbt.getDomain().getTopology());
    }

    @Test
    public void testCBThenA() {
        EnLinkdTestHelper.ABCTopology topology = new EnLinkdTestHelper.ABCTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeCId));
        domain.addBridge(new Bridge(topology.nodeBId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeCId.intValue()), topology.bftC);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeBId.intValue()), topology.bftB);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.checkBC(ndbt.getDomain().getTopology());
        domain.addBridge(new Bridge(topology.nodeAId));
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeAId.intValue()), topology.bftA);
        ndbt.calculate();
        topology.check(ndbt.getDomain().getTopology());
    }

    @Test
    public void testDE() {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeDId));
        domain.addBridge(new Bridge(topology.nodeEId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeDId.intValue()), topology.bftD);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeEId.intValue()), topology.bftE);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.checkDE(ndbt.getDomain().getTopology());
    }

    @Test
    public void testDF() {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeDId));
        domain.addBridge(new Bridge(topology.nodeFId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeDId.intValue()), topology.bftD);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeFId.intValue()), topology.bftF);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.checkDF(ndbt.getDomain().getTopology());
    }

    @Test
    public void testEF() {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeEId));
        domain.addBridge(new Bridge(topology.nodeFId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeEId.intValue()), topology.bftE);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeFId.intValue()), topology.bftF);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.checkEF(ndbt.getDomain().getTopology());
    }

    @Test
    public void testDG() {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeDId));
        domain.addBridge(new Bridge(topology.nodeGId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeDId.intValue()), topology.bftD);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeGId.intValue()), topology.bftG);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.checkDG(ndbt.getDomain().getTopology());
    }

    @Test
    public void testDEF() {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeDId));
        domain.addBridge(new Bridge(topology.nodeEId));
        domain.addBridge(new Bridge(topology.nodeFId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeDId.intValue()), topology.bftD);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeEId.intValue()), topology.bftE);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeFId.intValue()), topology.bftF);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.checkDEF(ndbt.getDomain().getTopology());
    }

    @Test
    public void testDFThenE() {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeDId));
        domain.addBridge(new Bridge(topology.nodeFId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeDId.intValue()), topology.bftD);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeFId.intValue()), topology.bftF);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.checkDF(ndbt.getDomain().getTopology());
        domain.addBridge(new Bridge(topology.nodeEId));
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeEId.intValue()), topology.bftE);
        ndbt.calculate();
        topology.checkDEF(ndbt.getDomain().getTopology());
    }

    @Test
    public void testDEFG() {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeDId));
        domain.addBridge(new Bridge(topology.nodeEId));
        domain.addBridge(new Bridge(topology.nodeFId));
        domain.addBridge(new Bridge(topology.nodeGId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeDId.intValue()), topology.bftD);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeEId.intValue()), topology.bftE);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeFId.intValue()), topology.bftF);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeGId.intValue()), topology.bftG);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.checkDEFG(ndbt.getDomain().getTopology());
    }

    @Test
    public void testDEFGHIL() {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeDId));
        domain.addBridge(new Bridge(topology.nodeEId));
        domain.addBridge(new Bridge(topology.nodeFId));
        domain.addBridge(new Bridge(topology.nodeGId));
        domain.addBridge(new Bridge(topology.nodeHId));
        domain.addBridge(new Bridge(topology.nodeIId));
        domain.addBridge(new Bridge(topology.nodeLId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeDId.intValue()), topology.bftD);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeEId.intValue()), topology.bftE);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeFId.intValue()), topology.bftF);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeGId.intValue()), topology.bftG);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeHId.intValue()), topology.bftH);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeIId.intValue()), topology.bftI);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeLId.intValue()), topology.bftL);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.check(ndbt.getDomain().getTopology());
    }

    @Test
    public void testCleanTopology() {
    }

    @Test
    public void testCleanTopologyRoot() {
    }

    @Test
    public void testHierarchySetUp() {
        EnLinkdTestHelper.DEFGHILTopology topology = new EnLinkdTestHelper.DEFGHILTopology();
        NodeDiscoveryBridgeTopology ndbt = new NodeDiscoveryBridgeTopology(this.linkd, null);
        BroadcastDomain domain = new BroadcastDomain();
        domain.addBridge(new Bridge(topology.nodeDId));
        domain.addBridge(new Bridge(topology.nodeEId));
        domain.addBridge(new Bridge(topology.nodeFId));
        domain.addBridge(new Bridge(topology.nodeGId));
        domain.addBridge(new Bridge(topology.nodeHId));
        domain.addBridge(new Bridge(topology.nodeIId));
        domain.addBridge(new Bridge(topology.nodeLId));
        ndbt.setDomain(domain);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeDId.intValue()), topology.bftD);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeEId.intValue()), topology.bftE);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeFId.intValue()), topology.bftF);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeGId.intValue()), topology.bftG);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeHId.intValue()), topology.bftH);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeIId.intValue()), topology.bftI);
        ndbt.addUpdatedBFT(domain.getBridge(topology.nodeLId.intValue()), topology.bftL);
        ndbt.setBridgeElements(topology.elemlist);
        ndbt.calculate();
        topology.check(ndbt.getDomain().getTopology());
        domain.hierarchySetUp(domain.getBridge(topology.nodeGId.intValue()));
        Assert.assertEquals((Object)topology.nodeGId, (Object)ndbt.getDomain().getRootBridgeId());
        Assert.assertEquals((Object)true, (Object)ndbt.getDomain().getBridge(topology.nodeGId.intValue()).isRootBridge());
        Assert.assertEquals(null, (Object)ndbt.getDomain().getBridge(topology.nodeGId.intValue()).getRootPort());
        Assert.assertEquals((Object)false, (Object)ndbt.getDomain().getBridge(topology.nodeDId.intValue()).isRootBridge());
        Assert.assertEquals((Object)topology.portDD, (Object)ndbt.getDomain().getBridge(topology.nodeDId.intValue()).getRootPort());
        Assert.assertEquals((Object)false, (Object)ndbt.getDomain().getBridge(topology.nodeEId.intValue()).isRootBridge());
        Assert.assertEquals((Object)topology.portEE, (Object)ndbt.getDomain().getBridge(topology.nodeEId.intValue()).getRootPort());
        Assert.assertEquals((Object)false, (Object)ndbt.getDomain().getBridge(topology.nodeFId.intValue()).isRootBridge());
        Assert.assertEquals((Object)topology.portFF, (Object)ndbt.getDomain().getBridge(topology.nodeFId.intValue()).getRootPort());
        Assert.assertEquals((Object)false, (Object)ndbt.getDomain().getBridge(topology.nodeHId.intValue()).isRootBridge());
        Assert.assertEquals((Object)topology.portHH, (Object)ndbt.getDomain().getBridge(topology.nodeHId.intValue()).getRootPort());
        Assert.assertEquals((Object)false, (Object)ndbt.getDomain().getBridge(topology.nodeIId.intValue()).isRootBridge());
        Assert.assertEquals((Object)topology.portII, (Object)ndbt.getDomain().getBridge(topology.nodeIId.intValue()).getRootPort());
        Assert.assertEquals((Object)false, (Object)ndbt.getDomain().getBridge(topology.nodeLId.intValue()).isRootBridge());
        Assert.assertEquals((Object)topology.portLL, (Object)ndbt.getDomain().getBridge(topology.nodeLId.intValue()).getRootPort());
        BroadcastDomainTest.printBridgeTopology(ndbt.getDomain().getTopology());
    }
}

