/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc.utils;

import java.util.Date;
import org.opennms.netmgt.events.api.EventConstants;
import org.opennms.netmgt.rtc.DataManager;
import org.opennms.netmgt.rtc.datablock.RTCCategory;
import org.opennms.netmgt.xml.rtc.Category;
import org.opennms.netmgt.xml.rtc.EuiLevel;
import org.opennms.netmgt.xml.rtc.Header;
import org.opennms.netmgt.xml.rtc.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyEuiLevelMapper {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyEuiLevelMapper.class);
    private final Header m_header;
    private final DataManager m_dataMgr;

    public LegacyEuiLevelMapper(DataManager dataMgr) {
        this.m_dataMgr = dataMgr;
        this.m_header = new Header();
        this.m_header.setVer("1.9a");
        this.m_header.setMstation("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EuiLevel convertToEuiLevelXML(RTCCategory rtcCat) {
        Date curDate = new Date();
        long curTime = curDate.getTime();
        long rWindow = 86400000L;
        LOG.debug("curdate: {}", (Object)curDate);
        EuiLevel level = new EuiLevel();
        this.m_header.setCreated(EventConstants.formatToString((Date)curDate));
        level.setHeader(this.m_header);
        Category levelCat = new Category();
        DataManager dataManager = this.m_dataMgr;
        synchronized (dataManager) {
            levelCat.setCatlabel(rtcCat.getLabel());
            levelCat.setCatvalue(this.m_dataMgr.getValue(rtcCat, curTime, rWindow));
            for (int nodeID : this.m_dataMgr.getNodes(rtcCat)) {
                Node levelNode = new Node();
                levelNode.setNodeid((long)nodeID);
                levelNode.setNodevalue(this.m_dataMgr.getValue(nodeID, rtcCat, curTime, rWindow));
                levelNode.setNodesvccount((long)this.m_dataMgr.getServiceCount(nodeID, rtcCat));
                levelNode.setNodesvcdowncount((long)this.m_dataMgr.getServiceDownCount(nodeID, rtcCat));
                levelCat.addNode(levelNode);
            }
        }
        level.addCategory(levelCat);
        return level;
    }
}

