/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.CategoryFactory;
import org.opennms.netmgt.config.api.CatFactory;
import org.opennms.netmgt.config.categories.Category;
import org.opennms.netmgt.config.categories.Categorygroup;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.filter.api.FilterParseException;
import org.opennms.netmgt.rtc.datablock.RTCCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RTCUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RTCUtils.class);

    public static double getOutagePercentage(double totalOutageTime, long outageWindow, long numberOfServices) {
        if (numberOfServices > 0L) {
            return 100.0 * (1.0 - totalOutageTime / ((double)outageWindow * (double)numberOfServices));
        }
        return 100.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, RTCCategory> createCategoriesMap() {
        CatFactory cFactory = null;
        try {
            CategoryFactory.init();
            cFactory = CategoryFactory.getInstance();
        }
        catch (IOException ex) {
            LOG.error("Failed to load categories information", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (MarshalException ex) {
            LOG.error("Failed to load categories information", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            LOG.error("Failed to load categories information", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        HashMap<String, RTCCategory> retval = new HashMap<String, RTCCategory>();
        cFactory.getReadLock().lock();
        try {
            for (Categorygroup cg : cFactory.getConfig().getCategorygroupCollection()) {
                String commonRule = cg.getCommon().getRule();
                for (Category cat : cg.getCategories().getCategoryCollection()) {
                    RTCCategory rtcCat = new RTCCategory(cat, commonRule);
                    retval.put(rtcCat.getLabel(), rtcCat);
                }
            }
        }
        finally {
            cFactory.getReadLock().unlock();
        }
        return retval;
    }

    public static Set<Integer> getNodeIdsForCategory(FilterDao filterDao, RTCCategory cat) {
        String filterRule = cat.getEffectiveRule();
        try {
            LOG.debug("Category: {}\t{}", (Object)cat.getLabel(), (Object)filterRule);
            TreeSet<Integer> nodeIds = new TreeSet<Integer>(filterDao.getNodeMap(filterRule).keySet());
            LOG.debug("Number of nodes satisfying rule: {}", (Object)nodeIds.size());
            return nodeIds;
        }
        catch (FilterParseException e) {
            LOG.error("Unable to parse filter rule {} ignoring category {}", new Object[]{filterRule, cat.getLabel(), e});
            return Collections.emptySet();
        }
    }
}

