/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.Map;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.dao.api.MinionDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.minion.OnmsMinion;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;

@Distributable(value={DistributionContext.DAEMON})
public class MinionHeartbeatMonitor
extends AbstractServiceMonitor {
    private final Supplier<NodeDao> nodeDao = Suppliers.memoize(() -> (NodeDao)BeanUtils.getBean((String)"daoContext", (String)"nodeDao", NodeDao.class));
    private final Supplier<MinionDao> minionDao = Suppliers.memoize(() -> (MinionDao)BeanUtils.getBean((String)"daoContext", (String)"minionDao", MinionDao.class));

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        int period = 2 * ParameterMap.getKeyedInteger(parameters, (String)"period", (int)30000);
        OnmsNode node = (OnmsNode)((NodeDao)this.nodeDao.get()).get((Serializable)Integer.valueOf(svc.getNodeId()));
        OnmsMinion minion = ((MinionDao)this.minionDao.get()).findById(node.getForeignId());
        long lastSeen = System.currentTimeMillis() - minion.getLastUpdated().getTime();
        PollStatus status = lastSeen <= (long)period ? PollStatus.available() : (ManagementFactory.getRuntimeMXBean().getUptime() < (long)period ? PollStatus.unknown("JVM has not been started long enough to process a heartbeat.") : PollStatus.unavailable(String.format("Last heartbeat was %.2f seconds ago", (double)lastSeen / 1000.0)));
        return status;
    }

    public String getEffectiveLocation(String location) {
        return null;
    }
}

