/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scriptd;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.netmgt.config.ScriptdConfigFactory;
import org.opennms.netmgt.config.scriptd.Engine;
import org.opennms.netmgt.config.scriptd.EventScript;
import org.opennms.netmgt.config.scriptd.ReloadScript;
import org.opennms.netmgt.config.scriptd.StopScript;
import org.opennms.netmgt.config.scriptd.Uei;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.scriptd.BroadcastEventProcessor;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Script;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Executor {
    private static final Logger LOG = LoggerFactory.getLogger(Executor.class);
    private final Set<EventScript> m_eventScripts = new CopyOnWriteArraySet<EventScript>();
    private final Map<String, Set<EventScript>> m_eventScriptMap = new ConcurrentHashMap<String, Set<EventScript>>();
    private final NodeDao m_nodeDao;
    private BSFManager m_scriptManager = null;
    private ExecutorService m_executorService;
    private BroadcastEventProcessor m_broadcastEventProcessor;
    private ScriptdConfigFactory m_config;

    Executor(ScriptdConfigFactory config, NodeDao nodeDao) {
        this.m_config = config;
        this.m_nodeDao = nodeDao;
        this.loadConfig();
    }

    private void loadConfig() {
        this.m_eventScripts.clear();
        this.m_eventScriptMap.clear();
        for (EventScript script : this.m_config.getEventScripts()) {
            Uei[] ueis = script.getUei();
            if (ueis.length == 0) {
                this.m_eventScripts.add(script);
                continue;
            }
            for (Uei uei : ueis) {
                String ueiName = uei.getName();
                Set<EventScript> list = this.m_eventScriptMap.get(ueiName);
                if (list == null) {
                    list = new CopyOnWriteArraySet<EventScript>();
                    list.add(script);
                    this.m_eventScriptMap.put(ueiName, list);
                    continue;
                }
                list.add(script);
            }
        }
    }

    public void addTask(Event event) {
        this.m_executorService.execute(new ScriptdRunnable(event));
    }

    private static boolean isReloadConfigEvent(Event event) {
        boolean isTarget = false;
        if ("uei.opennms.org/internal/reloadDaemonConfig".equals(event.getUei())) {
            List parmCollection = event.getParmCollection();
            for (Parm parm : parmCollection) {
                if (!"daemonName".equals(parm.getParmName()) || !"Scriptd".equalsIgnoreCase(parm.getValue().getContent())) continue;
                isTarget = true;
                break;
            }
        } else if ("uei.opennms.org/internal/reloadScriptConfig".equals(event.getUei())) {
            isTarget = true;
        }
        return isTarget;
    }

    public synchronized void start() {
        for (Engine engine : this.m_config.getEngines()) {
            LOG.debug("Registering engine: {}", (Object)engine.getLanguage());
            String[] extensions = null;
            String extensionList = engine.getExtensions();
            if (extensionList != null) {
                StringTokenizer st = new StringTokenizer(extensionList);
                extensions = new String[st.countTokens()];
                int j = 0;
                while (st.hasMoreTokens()) {
                    extensions[j++] = st.nextToken();
                }
            }
            BSFManager.registerScriptingEngine((String)engine.getLanguage(), (String)engine.getClassName(), extensions);
        }
        this.m_scriptManager = new BSFManager();
        this.m_scriptManager.registerBean("log", (Object)LOG);
        for (Engine engine : this.m_config.getStartScripts()) {
            try {
                this.m_scriptManager.exec(engine.getLanguage(), "", 0, 0, (Object)engine.getContent());
            }
            catch (BSFException e) {
                LOG.error("Start script failed: " + engine, (Throwable)e);
            }
        }
        this.m_executorService = Executors.newFixedThreadPool(1, (ThreadFactory)new LogPreservingThreadFactory("Scriptd-Executor", 1));
        try {
            this.m_broadcastEventProcessor = new BroadcastEventProcessor(this);
        }
        catch (Throwable e) {
            LOG.error("Failed to setup event reader", e);
            throw new UndeclaredThrowableException(e);
        }
        LOG.debug("Scriptd executor started");
    }

    public synchronized void stop() {
        if (this.m_broadcastEventProcessor != null) {
            this.m_broadcastEventProcessor.close();
        }
        this.m_broadcastEventProcessor = null;
        this.m_executorService.shutdown();
        for (StopScript stopScript : this.m_config.getStopScripts()) {
            try {
                this.m_scriptManager.exec(stopScript.getLanguage(), "", 0, 0, (Object)stopScript.getContent());
            }
            catch (BSFException e) {
                LOG.error("Stop script failed: " + stopScript, (Throwable)e);
            }
        }
        LOG.debug("Scriptd executor stopped");
    }

    private class ScriptdRunnable
    implements Runnable {
        private final Event m_event;

        public ScriptdRunnable(Event event) {
            this.m_event = event;
        }

        @Override
        public void run() {
            if (Executor.isReloadConfigEvent(this.m_event)) {
                try {
                    ReloadScript[] reloadScripts;
                    ScriptdConfigFactory.reload();
                    Executor.this.m_config = ScriptdConfigFactory.getInstance();
                    Executor.this.loadConfig();
                    for (ReloadScript script : reloadScripts = Executor.this.m_config.getReloadScripts()) {
                        try {
                            Executor.this.m_scriptManager.exec(script.getLanguage(), "", 0, 0, (Object)script.getContent());
                        }
                        catch (BSFException e) {
                            LOG.error("Reload script[{}] failed.", (Object)script, (Object)e);
                        }
                    }
                    LOG.debug("Scriptd configuration reloaded");
                }
                catch (Throwable e) {
                    LOG.error("Unable to reload Scriptd configuration: ", e);
                }
            }
            Script[] attachedScripts = this.m_event.getScript();
            Set mapScripts = null;
            try {
                mapScripts = (Set)Executor.this.m_eventScriptMap.get(this.m_event.getUei());
            }
            catch (Throwable e) {
                LOG.warn("Unexpected exception: " + e.getMessage(), e);
            }
            if (attachedScripts.length > 0 || mapScripts != null || Executor.this.m_eventScripts.size() > 0) {
                LOG.debug("Executing scripts for: {}", (Object)this.m_event.getUei());
                Executor.this.m_scriptManager.registerBean("event", (Object)this.m_event);
                OnmsNode node = null;
                if (this.m_event.hasNodeid()) {
                    Long nodeLong = this.m_event.getNodeid();
                    Integer nodeInt = nodeLong.intValue();
                    node = (OnmsNode)Executor.this.m_nodeDao.get((Serializable)nodeInt);
                    Executor.this.m_scriptManager.registerBean("node", (Object)node);
                }
                LOG.debug("Executing attached scripts");
                if (attachedScripts.length > 0) {
                    for (Script script : attachedScripts) {
                        try {
                            Executor.this.m_scriptManager.exec(script.getLanguage(), "", 0, 0, (Object)script.getContent());
                        }
                        catch (BSFException e) {
                            LOG.error("Attached script [{}] execution failed", (Object)script, (Object)e);
                        }
                    }
                }
                LOG.debug("Executing mapped scripts");
                if (mapScripts != null) {
                    for (EventScript script : mapScripts) {
                        try {
                            Executor.this.m_scriptManager.exec(script.getLanguage(), "", 0, 0, (Object)script.getContent());
                        }
                        catch (BSFException e) {
                            LOG.error("UEI-specific event handler script execution failed: {}", (Object)this.m_event.getUei(), (Object)e);
                        }
                    }
                }
                LOG.debug("Executing global scripts");
                for (EventScript script : Executor.this.m_eventScripts) {
                    try {
                        Executor.this.m_scriptManager.exec(script.getLanguage(), "", 0, 0, (Object)script.getContent());
                    }
                    catch (BSFException e) {
                        LOG.error("Non-UEI-specific event handler script execution failed : " + script, (Throwable)e);
                    }
                }
                if (node != null) {
                    Executor.this.m_scriptManager.unregisterBean("node");
                }
                Executor.this.m_scriptManager.unregisterBean("event");
                LOG.debug("Finished executing scripts for: {}", (Object)this.m_event.getUei());
            }
        }
    }
}

