/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.PersisterFactory;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.support.SingleResourceCollectionSet;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.dao.api.ResourceStorageDao;
import org.opennms.netmgt.poller.LatencyCollectionAttribute;
import org.opennms.netmgt.poller.LatencyCollectionAttributeType;
import org.opennms.netmgt.poller.LatencyCollectionResource;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitorAdaptor;
import org.opennms.netmgt.rrd.RrdRepository;
import org.opennms.netmgt.threshd.LatencyThresholdingSet;
import org.opennms.netmgt.threshd.ThresholdingEventProxy;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LatencyStoringServiceMonitorAdaptor
implements ServiceMonitorAdaptor {
    private static final Logger LOG = LoggerFactory.getLogger(LatencyStoringServiceMonitorAdaptor.class);
    public static final int HEARTBEAT_STEP_MULTIPLIER = 2;
    private PollerConfig m_pollerConfig;
    private Package m_pkg;
    private final PersisterFactory m_persisterFactory;
    private final ResourceStorageDao m_resourceStorageDao;
    private LatencyThresholdingSet m_thresholdingSet;

    public LatencyStoringServiceMonitorAdaptor(PollerConfig config, Package pkg, PersisterFactory persisterFactory, ResourceStorageDao resourceStorageDao) {
        this.m_pollerConfig = config;
        this.m_pkg = pkg;
        this.m_persisterFactory = persisterFactory;
        this.m_resourceStorageDao = resourceStorageDao;
    }

    @Override
    public PollStatus handlePollResult(MonitoredService svc, Map<String, Object> parameters, PollStatus status) {
        if (!status.getProperties().isEmpty()) {
            this.storeResponseTime(svc, new LinkedHashMap<String, Number>(status.getProperties()), parameters);
        }
        return status;
    }

    private void storeResponseTime(MonitoredService svc, Map<String, Number> entries, Map<String, Object> parameters) {
        String rrdPath = ParameterMap.getKeyedString(parameters, (String)"rrd-repository", null);
        String dsName = ParameterMap.getKeyedString(parameters, (String)"ds-name", (String)"response-time");
        String rrdBaseName = ParameterMap.getKeyedString(parameters, (String)"rrd-base-name", (String)dsName);
        String thresholds = ParameterMap.getKeyedString(parameters, (String)"thresholding-enabled", (String)"false");
        if (!entries.containsKey(dsName) && entries.containsKey("response-time")) {
            entries.put(dsName, entries.get("response-time"));
            entries.remove("response-time");
        }
        if (thresholds.equalsIgnoreCase("true")) {
            this.applyThresholds(rrdPath, svc, dsName, entries);
        } else {
            LOG.debug("storeResponseTime: Thresholds processing is not enabled. Check thresholding-enabled parameter on service definition");
        }
        if (rrdPath == null) {
            LOG.debug("storeResponseTime: RRD repository not specified in parameters, latency data will not be stored.");
            return;
        }
        LOG.debug("storeResponseTime: Persisting latency data for {}", (Object)svc);
        this.persistLatencySamples(svc, entries, new File(rrdPath), rrdBaseName);
    }

    private void applyThresholds(String rrdPath, MonitoredService service, String dsName, Map<String, Number> entries) {
        try {
            List<Event> events;
            if (this.m_thresholdingSet == null) {
                RrdRepository repository = new RrdRepository();
                repository.setRrdBaseDir(new File(rrdPath));
                this.m_thresholdingSet = new LatencyThresholdingSet(service.getNodeId(), service.getIpAddr(), service.getSvcName(), repository, this.m_resourceStorageDao);
            }
            LinkedHashMap<String, Double> attributes = new LinkedHashMap<String, Double>();
            for (String ds : entries.keySet()) {
                Number sampleValue = entries.get(ds);
                if (sampleValue == null) {
                    attributes.put(ds, Double.NaN);
                    continue;
                }
                attributes.put(ds, sampleValue.doubleValue());
            }
            if (this.m_thresholdingSet.isNodeInOutage()) {
                LOG.info("applyThresholds: the threshold processing will be skipped because the service {} is on a scheduled outage.", (Object)service);
            } else if (this.m_thresholdingSet.hasThresholds(attributes) && (events = this.m_thresholdingSet.applyThresholds(dsName, attributes)).size() > 0) {
                ThresholdingEventProxy proxy = new ThresholdingEventProxy();
                proxy.add(events);
                proxy.sendAllEvents();
            }
        }
        catch (Throwable e) {
            LOG.error("Failed to threshold on {} for {} because of an exception", new Object[]{service, dsName, e});
        }
    }

    private void persistLatencySamples(MonitoredService service, Map<String, Number> entries, File rrdRepositoryRoot, String rrdBaseName) {
        RrdRepository repository = new RrdRepository();
        repository.setStep(this.m_pollerConfig.getStep(this.m_pkg));
        repository.setRraList(this.m_pollerConfig.getRRAList(this.m_pkg));
        repository.setHeartBeat(repository.getStep() * 2);
        repository.setRrdBaseDir(rrdRepositoryRoot);
        LatencyCollectionResource latencyResource = new LatencyCollectionResource(service.getSvcName(), service.getIpAddr());
        for (Map.Entry<String, Number> entry : entries.entrySet()) {
            String ds = entry.getKey();
            Number value = entry.getValue() != null ? (Number)entry.getValue() : (Number)Double.NaN;
            LatencyCollectionAttributeType latencyType = new LatencyCollectionAttributeType(rrdBaseName, ds);
            latencyResource.addAttribute(new LatencyCollectionAttribute(latencyResource, latencyType, ds, value.doubleValue()));
        }
        ServiceParameters params = new ServiceParameters(Collections.emptyMap());
        Persister persister = this.m_persisterFactory.createPersister(params, repository, false, true, true);
        SingleResourceCollectionSet collectionSet = new SingleResourceCollectionSet((CollectionResource)latencyResource, new Date());
        collectionSet.setStatus(1);
        collectionSet.visit((CollectionSetVisitor)persister);
    }

    public void refreshThresholds() {
        if (this.m_thresholdingSet != null) {
            this.m_thresholdingSet.reinitialize();
        }
    }
}

