/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.collectd.CollectionAgentService;
import org.opennms.netmgt.collectd.SnmpIfData;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionProxyFactoryBean;

public class DefaultCollectionAgentService
implements CollectionAgentService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCollectionAgentService.class);
    private Integer m_ifaceId;
    private IpInterfaceDao m_ifaceDao;

    public static CollectionAgentService create(Integer ifaceId, IpInterfaceDao ifaceDao, PlatformTransactionManager transMgr) {
        DefaultCollectionAgentService agent = new DefaultCollectionAgentService(ifaceId, ifaceDao);
        TransactionProxyFactoryBean bean = new TransactionProxyFactoryBean();
        bean.setTransactionManager(transMgr);
        bean.setTarget((Object)agent);
        Properties props = new Properties();
        props.put("*", "PROPAGATION_REQUIRED");
        bean.setTransactionAttributes(props);
        bean.afterPropertiesSet();
        return (CollectionAgentService)bean.getObject();
    }

    private DefaultCollectionAgentService(Integer ifaceId, IpInterfaceDao ifaceDao) {
        this.m_ifaceId = ifaceId;
        this.m_ifaceDao = ifaceDao;
    }

    OnmsIpInterface getIpInterface() {
        return (OnmsIpInterface)this.m_ifaceDao.load((Serializable)this.m_ifaceId);
    }

    private OnmsNode getNode() {
        return this.getIpInterface().getNode();
    }

    @Override
    public String getHostAddress() {
        return InetAddressUtils.str((InetAddress)this.getInetAddress());
    }

    @Override
    public Boolean isStoreByForeignSource() {
        return ResourceTypeUtils.isStoreByForeignSource();
    }

    @Override
    public int getNodeId() {
        return this.getIpInterface().getNode().getId() == null ? -1 : this.getIpInterface().getNode().getId();
    }

    @Override
    public String getNodeLabel() {
        return this.getIpInterface().getNode().getLabel();
    }

    @Override
    public String getForeignSource() {
        return this.getIpInterface().getNode().getForeignSource();
    }

    @Override
    public String getForeignId() {
        return this.getIpInterface().getNode().getForeignId();
    }

    @Override
    public String getLocationName() {
        OnmsMonitoringLocation location = this.getIpInterface().getNode().getLocation();
        if (location != null) {
            return location.getLocationName();
        }
        return null;
    }

    @Override
    public File getStorageDir() {
        File dir = new File(String.valueOf(this.getNodeId()));
        String foreignSource = this.getForeignSource();
        String foreignId = this.getForeignId();
        if (this.isStoreByForeignSource().booleanValue() && foreignSource != null && foreignId != null) {
            File fsDir = new File("fs", foreignSource);
            dir = new File(fsDir, foreignId);
        }
        LOG.debug("getStorageDir: isStoreByForeignSource = {}, foreignSource = {}, foreignId = {}, dir = {}", new Object[]{this.isStoreByForeignSource(), foreignSource, foreignId, dir});
        return dir;
    }

    @Override
    public int getIfIndex() {
        return this.getIpInterface().getIfIndex() == null ? -1 : this.getIpInterface().getIfIndex();
    }

    @Override
    public String getSysObjectId() {
        return this.getIpInterface().getNode().getSysObjectId();
    }

    @Override
    public PrimaryType getIsSnmpPrimary() {
        return this.getIpInterface().getIsSnmpPrimary();
    }

    public String toString() {
        return "Agent[nodeid = " + this.getNodeId() + " ipaddr= " + this.getHostAddress() + ']';
    }

    @Override
    public SnmpAgentConfig getAgentConfig() {
        return SnmpPeerFactory.getInstance().getAgentConfig(this.getInetAddress());
    }

    @Override
    public Set<SnmpIfData> getSnmpInterfaceData() {
        Set<OnmsSnmpInterface> snmpIfs = this.getSnmpInterfaces();
        LinkedHashSet<SnmpIfData> ifData = new LinkedHashSet<SnmpIfData>(snmpIfs.size());
        for (OnmsSnmpInterface snmpIface : snmpIfs) {
            this.logInitializeSnmpIf(snmpIface);
            SnmpIfData snmpIfData = new SnmpIfData(snmpIface);
            ifData.add(snmpIfData);
        }
        return ifData;
    }

    private Set<OnmsSnmpInterface> getSnmpInterfaces() {
        OnmsNode node = this.getNode();
        Set snmpIfs = node.getSnmpInterfaces();
        if (snmpIfs.size() == 0) {
            LOG.debug("no known SNMP interfaces for node {}", (Object)node);
        }
        return snmpIfs;
    }

    private void logInitializeSnmpIf(OnmsSnmpInterface snmpIface) {
        LOG.debug("initialize: snmpifindex = {}, snmpifname = {}, snmpifdescr = {}, snmpphysaddr = -{}-", new Object[]{(int)snmpIface.getIfIndex(), snmpIface.getIfName(), snmpIface.getIfDescr(), snmpIface.getPhysAddr()});
        LOG.debug("initialize: ifLabel = '{}'", (Object)snmpIface.computeLabelForRRD());
    }

    @Override
    public InetAddress getInetAddress() {
        return this.getIpInterface().getIpAddress();
    }
}

