/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.enlinkd.snmp.IsisCircTableTracker;
import org.opennms.netmgt.enlinkd.snmp.IsisISAdjTableTracker;
import org.opennms.netmgt.enlinkd.snmp.IsisSysObjectGroupTracker;
import org.opennms.netmgt.model.IsIsLink;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryIsis
extends NodeDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryIsis.class);

    public NodeDiscoveryIsis(EnhancedLinkd linkd, Node node) {
        super(linkd, node);
    }

    @Override
    protected void runCollection() {
        Date now = new Date();
        IsisSysObjectGroupTracker isisSysObject = new IsisSysObjectGroupTracker();
        SnmpAgentConfig peer = this.m_linkd.getSnmpAgentConfig(this.getPrimaryIpAddress(), this.getLocation());
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)isisSysObject).withDescription("isisSysObjectCollection").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: node [{}]: ExecutionException: isisSysObjectCollection: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            LOG.info("run: node [{}]: InterruptedException: isisSysObjectCollection: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        if (isisSysObject.getIsisSysId() == null) {
            LOG.info("run: node [{}]: Is-Is mib not supported ", (Object)this.getNodeId());
            return;
        }
        this.m_linkd.getQueryManager().store(this.getNodeId(), isisSysObject.getIsisElement());
        final ArrayList links = new ArrayList();
        IsisISAdjTableTracker isisISAdjTableTracker = new IsisISAdjTableTracker(){

            @Override
            public void processIsisAdjRow(IsisISAdjTableTracker.IsIsAdjRow row) {
                links.add(row.getIsisLink());
            }
        };
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)isisISAdjTableTracker).withDescription("isisISAdjTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: node [{}]: ExecutionException: isisISAdjTable: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            LOG.info("run: node [{}]: InterruptedException: isisISAdjTable: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        IsisCircTableTracker isisCircTableTracker = new IsisCircTableTracker(){

            @Override
            public void processIsisCircRow(IsisCircTableTracker.IsIsCircRow row) {
                IsIsLink link = row.getIsisLink();
                for (IsIsLink adjlink : links) {
                    if (link.getIsisCircIndex().intValue() != adjlink.getIsisCircIndex().intValue()) continue;
                    adjlink.setIsisCircIfIndex(link.getIsisCircIfIndex());
                    adjlink.setIsisCircAdminState(link.getIsisCircAdminState());
                }
            }
        };
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(peer, (CollectionTracker)isisCircTableTracker).withDescription("isisCircTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: node [{}]: ExecutionException: isisCircTable: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        catch (InterruptedException e) {
            LOG.info("run: node [{}]: InterruptedException: isisCircTable: {}", (Object)this.getNodeId(), (Object)e.getMessage());
            return;
        }
        for (IsIsLink link : links) {
            this.m_linkd.getQueryManager().store(this.getNodeId(), link);
        }
        this.m_linkd.getQueryManager().reconcileIsis(this.getNodeId(), now);
    }

    @Override
    public String getName() {
        return "IsisLinkDiscovery";
    }
}

