/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.EnhancedLinkd;
import org.opennms.netmgt.enlinkd.Node;
import org.opennms.netmgt.enlinkd.NodeDiscovery;
import org.opennms.netmgt.enlinkd.snmp.IsisCircTableTracker;
import org.opennms.netmgt.enlinkd.snmp.IsisISAdjTableTracker;
import org.opennms.netmgt.enlinkd.snmp.IsisSysObjectGroupTracker;
import org.opennms.netmgt.model.IsIsLink;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeDiscoveryIsis
extends NodeDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(NodeDiscoveryIsis.class);

    public NodeDiscoveryIsis(EnhancedLinkd linkd, Node node) {
        super(linkd, node);
    }

    @Override
    protected void runCollection() {
        Date now = new Date();
        LOG.debug("run: collecting : {}", (Object)this.getPeer());
        IsisSysObjectGroupTracker isisSysObject = new IsisSysObjectGroupTracker();
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(this.getPeer(), (CollectionTracker)isisSysObject).withDescription("isisSysObjectCollection").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.info("run: Agent error while scanning the isisSysObjectCollection table", (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            LOG.error("run: Is-Is Linkd node collection interrupted, exiting", (Throwable)e);
            return;
        }
        if (isisSysObject.getIsisSysId() == null) {
            LOG.info("Is-Is mib not supported on: {}", (Object)InetAddressUtils.str((InetAddress)this.getPeer().getAddress()));
            return;
        }
        this.m_linkd.getQueryManager().store(this.getNodeId(), isisSysObject.getIsisElement());
        final ArrayList links = new ArrayList();
        IsisISAdjTableTracker isisISAdjTableTracker = new IsisISAdjTableTracker(){

            @Override
            public void processIsisAdjRow(IsisISAdjTableTracker.IsIsAdjRow row) {
                links.add(row.getIsisLink());
            }
        };
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(this.getPeer(), (CollectionTracker)isisISAdjTableTracker).withDescription("isisISAdjTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.error("run: collection execution failed, exiting", (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            LOG.error("run: Is-Is Linkd node collection interrupted, exiting", (Throwable)e);
            return;
        }
        IsisCircTableTracker isisCircTableTracker = new IsisCircTableTracker(){

            @Override
            public void processIsisCircRow(IsisCircTableTracker.IsIsCircRow row) {
                IsIsLink link = row.getIsisLink();
                for (IsIsLink adjlink : links) {
                    if (link.getIsisCircIndex().intValue() != adjlink.getIsisCircIndex().intValue()) continue;
                    adjlink.setIsisCircIfIndex(link.getIsisCircIfIndex());
                    adjlink.setIsisCircAdminState(link.getIsisCircAdminState());
                }
            }
        };
        try {
            this.m_linkd.getLocationAwareSnmpClient().walk(this.getPeer(), (CollectionTracker)isisCircTableTracker).withDescription("isisCircTable").withLocation(this.getLocation()).execute().get();
        }
        catch (ExecutionException e) {
            LOG.error("run: collection execution failed, exiting", (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            LOG.error("run: Is-Is Linkd node collection interrupted, exiting", (Throwable)e);
            return;
        }
        for (IsIsLink link : links) {
            this.m_linkd.getQueryManager().store(this.getNodeId(), link);
        }
        this.m_linkd.getQueryManager().reconcileIsis(this.getNodeId(), now);
    }

    @Override
    public String getInfo() {
        return "ReadyRunnable:IsisLinkNodeDiscovery node: " + this.getNodeId() + " ip:" + InetAddressUtils.str((InetAddress)this.getTarget()) + " package:" + this.getPackageName();
    }

    @Override
    public String getName() {
        return "IsisLinkDiscovery";
    }
}

