/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.AnyRestriction;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.NullRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.poller.QueryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class QueryManagerDaoImpl
implements QueryManager {
    private static final Logger LOG = LoggerFactory.getLogger(QueryManagerDaoImpl.class);
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private EventDao m_eventDao;
    @Autowired
    private OutageDao m_outageDao;
    @Autowired
    private MonitoredServiceDao m_monitoredServiceDao;

    @Override
    public String getNodeLabel(int nodeId) {
        OnmsNode onmsNode = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        if (onmsNode == null) {
            return null;
        }
        return onmsNode.getLabel();
    }

    @Override
    public String getNodeLocation(int nodeId) {
        OnmsNode onmsNode = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(nodeId));
        if (onmsNode == null) {
            return null;
        }
        return onmsNode.getLocation().getLocationName();
    }

    @Override
    public Integer openOutagePendingLostEventId(int nodeId, String ipAddr, String svcName, Date lostTime) {
        LOG.info("opening outage for {}:{}:{} @ {}", new Object[]{nodeId, ipAddr, svcName, lostTime});
        OnmsMonitoredService service = this.m_monitoredServiceDao.get(Integer.valueOf(nodeId), InetAddressUtils.addr((String)ipAddr), svcName);
        OnmsOutage outage = new OnmsOutage(lostTime, service);
        this.m_outageDao.saveOrUpdate((Object)outage);
        return outage.getId();
    }

    @Override
    public void updateOpenOutageWithEventId(int outageId, int lostEventId) {
        LOG.info("updating open outage {} with event id {}", (Object)outageId, (Object)lostEventId);
        OnmsEvent event = (OnmsEvent)this.m_eventDao.get((Serializable)Integer.valueOf(lostEventId));
        OnmsOutage outage = (OnmsOutage)this.m_outageDao.get((Serializable)Integer.valueOf(outageId));
        if (outage == null) {
            LOG.warn("Failed to update outage {} with event id {}. The outage no longer exists.", (Object)outageId, (Object)lostEventId);
            return;
        }
        outage.setServiceLostEvent(event);
        this.m_outageDao.saveOrUpdate((Object)outage);
    }

    @Override
    public Integer resolveOutagePendingRegainEventId(int nodeId, String ipAddr, String svcName, Date regainedTime) {
        LOG.info("resolving outage for {}:{}:{} @ {}", new Object[]{nodeId, ipAddr, svcName, regainedTime});
        OnmsMonitoredService service = this.m_monitoredServiceDao.get(Integer.valueOf(nodeId), InetAddressUtils.addr((String)ipAddr), svcName);
        if (service == null) {
            LOG.warn("Failed to resolve the pending outage for {}:{}:{} @ {}. The service could not be found.", new Object[]{nodeId, ipAddr, svcName, regainedTime});
            return null;
        }
        OnmsOutage outage = this.m_outageDao.currentOutageForService(service);
        if (outage == null) {
            return null;
        }
        outage.setIfRegainedService((Date)new Timestamp(regainedTime.getTime()));
        this.m_outageDao.saveOrUpdate((Object)outage);
        return outage.getId();
    }

    @Override
    public void updateResolvedOutageWithEventId(int outageId, int regainedEventId) {
        LOG.info("updating resolved outage {} with event id {}", (Object)outageId, (Object)regainedEventId);
        OnmsEvent event = (OnmsEvent)this.m_eventDao.get((Serializable)Integer.valueOf(regainedEventId));
        OnmsOutage outage = (OnmsOutage)this.m_outageDao.get((Serializable)Integer.valueOf(outageId));
        if (outage == null) {
            LOG.warn("Failed to update outage {} with event id {}. The outage no longer exists.", (Object)outageId, (Object)regainedEventId);
            return;
        }
        outage.setServiceRegainedEvent(event);
        this.m_outageDao.saveOrUpdate((Object)outage);
    }

    @Override
    public List<String[]> getNodeServices(int nodeId) {
        LinkedList<String[]> servicemap = new LinkedList<String[]>();
        Criteria criteria = new Criteria(OnmsMonitoredService.class);
        criteria.setAliases(Arrays.asList(new Alias("ipInterface", "ipInterface", Alias.JoinType.LEFT_JOIN), new Alias("ipInterface.node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.id", (Object)nodeId));
        for (OnmsMonitoredService service : this.m_monitoredServiceDao.findMatching(criteria)) {
            servicemap.add(new String[]{service.getIpAddressAsString(), service.getServiceName()});
        }
        return servicemap;
    }

    @Override
    public void closeOutagesForUnmanagedServices() {
        Date closeDate = new Date();
        Criteria criteria = new Criteria(OnmsOutage.class);
        criteria.setAliases(Arrays.asList(new Alias("monitoredService", "monitoredService", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new AnyRestriction(new Restriction[]{new EqRestriction("monitoredService.status", (Object)"D"), new EqRestriction("monitoredService.status", (Object)"F"), new EqRestriction("monitoredService.status", (Object)"U")}));
        criteria.addRestriction((Restriction)new NullRestriction("ifRegainedService"));
        List outages = this.m_outageDao.findMatching(criteria);
        for (OnmsOutage outage : outages) {
            outage.setIfRegainedService(closeDate);
            this.m_outageDao.update((Object)outage);
        }
        criteria = new Criteria(OnmsOutage.class);
        criteria.setAliases(Arrays.asList(new Alias("monitoredService.ipInterface", "ipInterface", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new AnyRestriction(new Restriction[]{new EqRestriction("ipInterface.isManaged", (Object)"F"), new EqRestriction("ipInterface.isManaged", (Object)"U")}));
        criteria.addRestriction((Restriction)new NullRestriction("ifRegainedService"));
        outages = this.m_outageDao.findMatching(criteria);
        for (OnmsOutage outage : outages) {
            outage.setIfRegainedService(closeDate);
            this.m_outageDao.update((Object)outage);
        }
    }

    @Override
    public void closeOutagesForNode(Date closeDate, int eventId, int nodeId) {
        Criteria criteria = new Criteria(OnmsOutage.class);
        criteria.setAliases(Arrays.asList(new Alias("monitoredService.ipInterface", "ipInterface", Alias.JoinType.LEFT_JOIN), new Alias("ipInterface.node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.id", (Object)nodeId));
        criteria.addRestriction((Restriction)new NullRestriction("ifRegainedService"));
        List outages = this.m_outageDao.findMatching(criteria);
        for (OnmsOutage outage : outages) {
            outage.setIfRegainedService(closeDate);
            outage.setServiceRegainedEvent((OnmsEvent)this.m_eventDao.get((Serializable)Integer.valueOf(eventId)));
            this.m_outageDao.update((Object)outage);
        }
    }

    @Override
    public void closeOutagesForInterface(Date closeDate, int eventId, int nodeId, String ipAddr) {
        Criteria criteria = new Criteria(OnmsOutage.class);
        criteria.setAliases(Arrays.asList(new Alias("monitoredService.ipInterface", "ipInterface", Alias.JoinType.LEFT_JOIN), new Alias("ipInterface.node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.id", (Object)nodeId));
        criteria.addRestriction((Restriction)new EqRestriction("ipInterface.ipAddress", (Object)InetAddressUtils.addr((String)ipAddr)));
        criteria.addRestriction((Restriction)new NullRestriction("ifRegainedService"));
        List outages = this.m_outageDao.findMatching(criteria);
        for (OnmsOutage outage : outages) {
            outage.setIfRegainedService(closeDate);
            outage.setServiceRegainedEvent((OnmsEvent)this.m_eventDao.get((Serializable)Integer.valueOf(eventId)));
            this.m_outageDao.update((Object)outage);
        }
    }

    @Override
    public void closeOutagesForService(Date closeDate, int eventId, int nodeId, String ipAddr, String serviceName) {
        Criteria criteria = new Criteria(OnmsOutage.class);
        criteria.setAliases(Arrays.asList(new Alias("monitoredService.ipInterface", "ipInterface", Alias.JoinType.LEFT_JOIN), new Alias("monitoredService.serviceType", "serviceType", Alias.JoinType.LEFT_JOIN), new Alias("ipInterface.node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.id", (Object)nodeId));
        criteria.addRestriction((Restriction)new EqRestriction("ipInterface.ipAddress", (Object)InetAddressUtils.addr((String)ipAddr)));
        criteria.addRestriction((Restriction)new EqRestriction("serviceType.name", (Object)serviceName));
        criteria.addRestriction((Restriction)new NullRestriction("ifRegainedService"));
        List outages = this.m_outageDao.findMatching(criteria);
        for (OnmsOutage outage : outages) {
            outage.setIfRegainedService(closeDate);
            outage.setServiceRegainedEvent((OnmsEvent)this.m_eventDao.get((Serializable)Integer.valueOf(eventId)));
            this.m_outageDao.update((Object)outage);
            LOG.info("Calling closeOutagesForService: {}", (Object)outage);
        }
    }

    @Override
    public void updateServiceStatus(int nodeId, String ipAddr, String serviceName, String status) {
        try {
            OnmsMonitoredService service = this.m_monitoredServiceDao.get(Integer.valueOf(nodeId), InetAddress.getByName(ipAddr), serviceName);
            service.setStatus(status);
            this.m_monitoredServiceDao.saveOrUpdate((Object)service);
        }
        catch (UnknownHostException e) {
            LOG.error("Failed to set the status for service named {} on node id {} and interface {} to {}.", new Object[]{serviceName, nodeId, ipAddr, status, e});
        }
    }
}

