/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Map;
import java.util.regex.Pattern;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SnmpMonitorStrategy
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpMonitorStrategy.class);
    public static final String LESS_THAN = "<";
    public static final String GREATER_THAN = ">";
    public static final String LESS_THAN_EQUALS = "<=";
    public static final String GREATER_THAN_EQUALS = ">=";
    public static final String EQUALS = "=";
    public static final String NOT_EQUAL = "!=";
    public static final String MATCHES = "~";
    protected boolean hex = false;

    public Map<String, Object> getRuntimeAttributes(MonitoredService svc, Map<String, Object> parameters) {
        try {
            SnmpPeerFactory.init();
        }
        catch (IOException e) {
            LOG.error("SnmpPeerFactory initialization failed.", (Throwable)e);
        }
        return ImmutableMap.of((Object)"agent", (Object)SnmpPeerFactory.getInstance().getAgentConfig(svc.getAddress()));
    }

    public SnmpAgentConfig getAgentConfig(MonitoredService svc, Map<String, Object> parameters) {
        return (SnmpAgentConfig)SnmpMonitorStrategy.getKeyedInstance(parameters, (String)"agent", () -> new SnmpAgentConfig(svc.getAddress()));
    }

    public String getStringValue(SnmpValue result) {
        if (this.hex) {
            return result.toHexString();
        }
        return result.toString();
    }

    public boolean meetsCriteria(SnmpValue result, String operator, String operand) {
        Boolean retVal = null;
        retVal = this.isCriteriaNull(result, operator, operand);
        if (retVal == null) {
            String value = this.getStringValue(result);
            retVal = this.checkStringCriteria(operator, operand, value);
            if (retVal == null) {
                BigInteger val = BigInteger.valueOf(result.toLong());
                BigInteger intOperand = new BigInteger(operand);
                if (LESS_THAN.equals(operator)) {
                    return val.compareTo(intOperand) < 0;
                }
                if (LESS_THAN_EQUALS.equals(operator)) {
                    return val.compareTo(intOperand) <= 0;
                }
                if (GREATER_THAN.equals(operator)) {
                    return val.compareTo(intOperand) > 0;
                }
                if (GREATER_THAN_EQUALS.equals(operator)) {
                    return val.compareTo(intOperand) >= 0;
                }
                throw new IllegalArgumentException("operator " + operator + " is unknown");
            }
        } else if (retVal.booleanValue()) {
            return true;
        }
        return retVal;
    }

    private Boolean checkStringCriteria(String operator, String operand, String value) {
        Boolean retVal = null;
        if (value == null) {
            value = "";
        } else if (value.startsWith(".")) {
            value = value.substring(1);
        }
        if (operand.startsWith(".") && !MATCHES.equals(operator)) {
            operand = operand.substring(1);
        }
        if (EQUALS.equals(operator)) {
            retVal = operand.equals(value);
        } else if (NOT_EQUAL.equals(operator)) {
            retVal = !operand.equals(value);
        } else if (MATCHES.equals(operator)) {
            retVal = Pattern.compile(operand).matcher(value).find();
        }
        return retVal;
    }

    private Boolean isCriteriaNull(Object result, String operator, String operand) {
        if (result == null) {
            return Boolean.FALSE;
        }
        if (operator == null || operand == null) {
            return Boolean.TRUE;
        }
        return null;
    }
}

