/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable(value={DistributionContext.DAEMON})
public class SnmpMonitor
extends SnmpMonitorStrategy {
    public static final Logger LOG = LoggerFactory.getLogger(SnmpMonitor.class);
    private static final String SERVICE_NAME = "SNMP";
    private static final String DEFAULT_OBJECT_IDENTIFIER = ".1.3.6.1.2.1.1.2.0";
    private static final String DEFAULT_REASON_TEMPLATE = "Observed value '${observedValue}' does not meet criteria '${operator} ${operand}'";

    public String serviceName() {
        return SERVICE_NAME;
    }

    @Override
    public void initialize(Map<String, Object> parameters) {
        try {
            SnmpPeerFactory.init();
        }
        catch (IOException ex) {
            LOG.error("initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    @Override
    public void initialize(MonitoredService svc) {
        super.initialize(svc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface<InetAddress> iface = svc.getNetInterface();
        PollStatus status = PollStatus.unavailable();
        InetAddress ipaddr = iface.getAddress();
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipaddr);
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
        }
        String hostAddress = InetAddressUtils.str((InetAddress)ipaddr);
        LOG.debug("poll: setting SNMP peer attribute for interface {}", (Object)hostAddress);
        String oid = ParameterMap.getKeyedString(parameters, (String)"oid", (String)DEFAULT_OBJECT_IDENTIFIER);
        String operator = ParameterMap.getKeyedString(parameters, (String)"operator", null);
        String operand = ParameterMap.getKeyedString(parameters, (String)"operand", null);
        String walkstr = ParameterMap.getKeyedString(parameters, (String)"walk", (String)"false");
        String matchstr = ParameterMap.getKeyedString(parameters, (String)"match-all", (String)"true");
        int countMin = ParameterMap.getKeyedInteger(parameters, (String)"minimum", (int)0);
        int countMax = ParameterMap.getKeyedInteger(parameters, (String)"maximum", (int)0);
        String reasonTemplate = ParameterMap.getKeyedString(parameters, (String)"reason-template", (String)DEFAULT_REASON_TEMPLATE);
        String hexstr = ParameterMap.getKeyedString(parameters, (String)"hex", (String)"false");
        this.hex = "true".equalsIgnoreCase(hexstr);
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, (String)"port", (int)agentConfig.getPort()));
        Properties svcParams = new Properties();
        svcParams.setProperty("oid", oid);
        svcParams.setProperty("operator", String.valueOf(operator));
        svcParams.setProperty("operand", String.valueOf(operand));
        svcParams.setProperty("walk", walkstr);
        svcParams.setProperty("matchAll", matchstr);
        svcParams.setProperty("minimum", String.valueOf(countMin));
        svcParams.setProperty("maximum", String.valueOf(countMax));
        svcParams.setProperty("timeout", String.valueOf(agentConfig.getTimeout()));
        svcParams.setProperty("retry", String.valueOf(agentConfig.getRetries()));
        svcParams.setProperty("retries", svcParams.getProperty("retry"));
        svcParams.setProperty("ipaddr", hostAddress);
        svcParams.setProperty("port", String.valueOf(agentConfig.getPort()));
        svcParams.setProperty("hex", hexstr);
        LOG.debug("poll: service= SNMP address= {}", (Object)agentConfig);
        try {
            SnmpValue result;
            LOG.debug("SnmpMonitor.poll: SnmpAgentConfig address: {}", (Object)agentConfig);
            TimeoutTracker tracker = new TimeoutTracker(parameters, agentConfig.getRetries(), agentConfig.getTimeout());
            tracker.reset();
            tracker.startAttempt();
            SnmpObjId snmpObjectId = SnmpObjId.get((String)oid);
            if ("count".equals(matchstr)) {
                if (DEFAULT_REASON_TEMPLATE.equals(reasonTemplate)) {
                    reasonTemplate = "Value: ${matchCount} outside of range Min: ${minimum} to Max: ${maximum}";
                }
                int matchCount = 0;
                List results2 = SnmpUtils.getColumns((SnmpAgentConfig)agentConfig, (String)"snmpPoller", (SnmpObjId)snmpObjectId);
                for (SnmpValue result2 : results2) {
                    if (result2 == null) continue;
                    LOG.debug("poll: SNMPwalk poll succeeded, addr={} oid={} value={}", new Object[]{hostAddress, oid, result2});
                    if (!this.meetsCriteria(result2, operator, operand)) continue;
                    ++matchCount;
                }
                svcParams.setProperty("matchCount", String.valueOf(matchCount));
                LOG.debug("poll: SNMPwalk count succeeded, total={} min={} max={}", new Object[]{matchCount, countMin, countMax});
                if (countMin <= matchCount && matchCount <= countMax) {
                    return PollStatus.available(tracker.elapsedTimeInMillis());
                }
                String reason = PropertiesUtils.substitute((String)reasonTemplate, (Properties[])new Properties[]{svcParams});
                LOG.debug(reason);
                return PollStatus.unavailable(reason);
            }
            if ("true".equals(walkstr)) {
                block16: {
                    if (DEFAULT_REASON_TEMPLATE.equals(reasonTemplate)) {
                        reasonTemplate = "SNMP poll failed, addr=${ipaddr} oid=${oid}";
                    }
                    List results = SnmpUtils.getColumns((SnmpAgentConfig)agentConfig, (String)"snmpPoller", (SnmpObjId)snmpObjectId);
                    Iterator results2 = results.iterator();
                    while (results2.hasNext()) {
                        SnmpValue result3 = (SnmpValue)results2.next();
                        if (result3 == null) continue;
                        svcParams.setProperty("observedValue", this.getStringValue(result3));
                        LOG.debug("poll: SNMPwalk poll succeeded, addr={} oid={} value={}", new Object[]{hostAddress, oid, result3});
                        if (this.meetsCriteria(result3, operator, operand)) {
                            status = PollStatus.available(tracker.elapsedTimeInMillis());
                            if (!"false".equals(matchstr)) continue;
                            return status;
                        }
                        if (!"true".equals(matchstr)) {
                            continue;
                        }
                        break block16;
                    }
                    return status;
                }
                String reason = PropertiesUtils.substitute((String)reasonTemplate, (Properties[])new Properties[]{svcParams});
                LOG.debug(reason);
                return PollStatus.unavailable(reason);
            }
            if (DEFAULT_REASON_TEMPLATE.equals(reasonTemplate)) {
                reasonTemplate = operator != null ? DEFAULT_REASON_TEMPLATE : "Observed value '${observedValue}' was null";
            }
            if ((result = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)snmpObjectId)) != null) {
                svcParams.setProperty("observedValue", this.getStringValue(result));
                LOG.debug("poll: SNMP poll succeeded, addr={} oid={} value={}", new Object[]{hostAddress, oid, result});
                if (!this.meetsCriteria(result, operator, operand)) return PollStatus.unavailable(PropertiesUtils.substitute((String)reasonTemplate, (Properties[])new Properties[]{svcParams}));
                return PollStatus.available(tracker.elapsedTimeInMillis());
            }
            String reason = "SNMP poll failed, addr=" + hostAddress + " oid=" + oid;
            LOG.debug(reason);
            return PollStatus.unavailable(reason);
        }
        catch (NumberFormatException e) {
            String reason = "Number operator used on a non-number " + e.getMessage();
            LOG.debug(reason);
            return PollStatus.unavailable(reason);
        }
        catch (IllegalArgumentException e) {
            String reason = "Invalid SNMP Criteria: " + e.getMessage();
            LOG.debug(reason);
            return PollStatus.unavailable(reason);
        }
        catch (Throwable t) {
            String reason = "Unexpected exception during SNMP poll of interface " + hostAddress;
            LOG.debug(reason, t);
            return PollStatus.unavailable(reason);
        }
    }
}

