/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.icmp.PingerFactory;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public final class IcmpMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(IcmpMonitor.class);

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface<InetAddress> iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_INET currently supported");
        }
        Number rtt = null;
        InetAddress host = iface.getAddress();
        try {
            int retries = ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)2);
            long timeout = ParameterMap.getKeyedLong(parameters, (String)"timeout", (long)800L);
            int packetSize = ParameterMap.getKeyedInteger(parameters, (String)"packet-size", (int)64);
            rtt = PingerFactory.getInstance().ping(host, timeout, retries, packetSize);
        }
        catch (Throwable e) {
            LOG.debug("failed to ping {}", (Object)host, (Object)e);
        }
        if (rtt != null) {
            return PollStatus.available(rtt.doubleValue());
        }
        return PollStatus.unavailable();
    }
}

