/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SimpleResolver;

@Distributable
public final class DnsMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(DnsMonitor.class);
    private static final int DEFAULT_PORT = 53;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final int[] DEFAULT_FATAL_RESP_CODES = new int[]{2};
    private static final int DEFAULT_MIN_ANSWERS = 0;
    private static final int DEFAULT_MAX_ANSWERS = Integer.MAX_VALUE;

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface<InetAddress> iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_INET currently supported");
        }
        TimeoutTracker timeoutTracker = new TimeoutTracker(parameters, 0, 5000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)53);
        String lookup = ParameterMap.getKeyedString(parameters, (String)"lookup", null);
        if ((lookup == null || lookup.length() == 0) && (lookup = InetAddressUtils.getLocalHostAddressAsString()) == null) {
            throw new UnsupportedOperationException("Unable to look up local host address.");
        }
        ArrayList<Integer> fatalCodes = new ArrayList<Integer>();
        for (int code : ParameterMap.getKeyedIntegerArray(parameters, (String)"fatal-response-codes", (int[])DEFAULT_FATAL_RESP_CODES)) {
            fatalCodes.add(code);
        }
        int minAnswers = ParameterMap.getKeyedInteger(parameters, (String)"min-answers", (int)0);
        int maxAnswers = ParameterMap.getKeyedInteger(parameters, (String)"max-answers", (int)Integer.MAX_VALUE);
        InetAddress addr = iface.getAddress();
        PollStatus serviceStatus = null;
        serviceStatus = this.pollDNS(timeoutTracker, port, addr, lookup, fatalCodes, minAnswers, maxAnswers);
        if (serviceStatus == null) {
            String reason = "Never received valid DNS response for address: " + addr;
            LOG.debug(reason);
            serviceStatus = PollStatus.unavailable(reason);
        }
        return serviceStatus;
    }

    private PollStatus pollDNS(TimeoutTracker timeoutTracker, int port, InetAddress address, String lookup, List<Integer> fatalCodes, int minAnswers, int maxAnswers) {
        String addr = InetAddressUtils.str((InetAddress)address);
        timeoutTracker.reset();
        while (timeoutTracker.shouldRetry()) {
            try {
                Name name = Name.fromString((String)lookup, (Name)Name.root);
                SimpleResolver resolver = new SimpleResolver();
                resolver.setAddress(new InetSocketAddress(addr, port));
                resolver.setLocalAddress((InetSocketAddress)null);
                double timeout = timeoutTracker.getSoTimeout() / 1000;
                resolver.setTimeout(timeout < 1.0 ? 1 : (int)timeout);
                Record question = Record.newRecord((Name)name, (int)1, (int)1);
                Message query = Message.newQuery((Record)question);
                timeoutTracker.startAttempt();
                Message response = resolver.send(query);
                double responseTime = timeoutTracker.elapsedTimeInMillis();
                Integer rcode = response.getHeader().getRcode();
                LOG.debug("received response code: {}", (Object)rcode);
                if (fatalCodes.contains(rcode)) {
                    PollStatus status = PollStatus.unavailable("Received an invalid DNS response for address: " + addr);
                    LOG.debug(status.getReason());
                    return status;
                }
                if (minAnswers != 0 || maxAnswers != Integer.MAX_VALUE) {
                    boolean tooManyAnswers;
                    int numAnswers = response.getSectionArray(1).length;
                    boolean tooFewAnswers = numAnswers < minAnswers;
                    boolean bl = tooManyAnswers = numAnswers > maxAnswers;
                    if (tooFewAnswers) {
                        PollStatus status = PollStatus.unavailable("Response contained only " + numAnswers + " answer(s), but at least " + minAnswers + " answers(s) are needed.");
                        LOG.warn(status.getReason());
                        return status;
                    }
                    if (tooManyAnswers) {
                        PollStatus status = PollStatus.unavailable("Response contained " + numAnswers + " answer(s), but " + maxAnswers + " or fewer answers(s) are needed.");
                        LOG.warn(status.getReason());
                        return status;
                    }
                    PollStatus status = PollStatus.up(responseTime);
                    LOG.debug("valid DNS response received with {} answer(s), responseTime = {}ms", (Object)numAnswers, (Object)responseTime);
                    return status;
                }
                PollStatus status = PollStatus.up(responseTime);
                LOG.debug("valid DNS response received, responseTime = {}ms", (Object)responseTime);
                return status;
            }
            catch (InterruptedIOException name) {
            }
            catch (NoRouteToHostException e) {
                String reason1 = "No route to host exception for address: " + addr;
                LOG.debug(reason1, (Throwable)e);
                return PollStatus.unavailable(reason1);
            }
            catch (ConnectException e) {
                String reason1 = "Connection exception for address: " + addr;
                LOG.debug(reason1, (Throwable)e);
                return PollStatus.unavailable(reason1);
            }
            catch (IOException e) {
                String reason1 = "IOException while polling address: " + addr + " " + e.getMessage();
                LOG.debug(reason1, (Throwable)e);
                return PollStatus.unavailable(reason1);
            }
            timeoutTracker.nextAttempt();
        }
        String reason = "Never received valid DNS response for address: " + addr;
        LOG.debug(reason);
        return PollStatus.unavailable(reason);
    }
}

