/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable(value={DistributionContext.DAEMON})
public final class OpenManageChassisMonitor
extends SnmpMonitorStrategy {
    public static final Logger LOG = LoggerFactory.getLogger(OpenManageChassisMonitor.class);
    private static final String m_serviceName = "Dell_OpenManageChassis";
    private static final String CHASSIS_STATUS_OID = ".1.3.6.1.4.1.674.10892.1.300.10.1.4.1";
    private static final String EVENT_LOG_STATUS_OID = ".1.3.6.1.4.1.674.10892.1.200.10.1.41.1";
    private static final String MANUFACTURER_OID = ".1.3.6.1.4.1.674.10892.1.300.10.1.8.1";
    private static final String MODEL_NAME_OID = "1.3.6.1.4.1.674.10892.1.300.10.1.9.1";
    private static final String SERVICE_TAG_OID = ".1.3.6.1.4.1.674.10892.1.300.10.1.11.1";

    public String serviceName() {
        return m_serviceName;
    }

    @Override
    public void initialize(Map<String, Object> parameters) {
        try {
            SnmpPeerFactory.init();
        }
        catch (IOException ex) {
            LOG.error("initialize: Failed to load SNMP configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    @Override
    public void initialize(MonitoredService svc) {
        super.initialize(svc);
    }

    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface<InetAddress> iface = svc.getNetInterface();
        String returnValue = "";
        PollStatus status = PollStatus.unavailable();
        InetAddress ipaddr = iface.getAddress();
        String eventLogStatusTxt = "N/A";
        String manufacturerName = "N/A";
        String modelName = "N/A";
        String serviceTagTxt = "N/A";
        String chassisStatusTxt = "N/A";
        SnmpAgentConfig agentConfig = SnmpPeerFactory.getInstance().getAgentConfig(ipaddr);
        if (agentConfig == null) {
            throw new RuntimeException("SnmpAgentConfig object not available for interface " + ipaddr);
        }
        String hostAddress = InetAddressUtils.str((InetAddress)ipaddr);
        LOG.debug("poll: setting SNMP peer attribute for interface {}", (Object)hostAddress);
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, (String)"port", (int)agentConfig.getPort()));
        try {
            LOG.debug("poll: SnmpAgentConfig address: {}", (Object)agentConfig);
            SnmpObjId chassisStatusSnmpObject = SnmpObjId.get((String)CHASSIS_STATUS_OID);
            SnmpValue chassisStatus = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)chassisStatusSnmpObject);
            if (chassisStatus == null) {
                LOG.warn("No chassis status received!");
                return status;
            }
            LOG.debug("poll: chassis status: {}", (Object)chassisStatus);
            if (chassisStatus.toInt() == DELL_STATUS.OK.value()) {
                LOG.debug("poll: chassis status: {}", (Object)chassisStatus.toInt());
                return PollStatus.available();
            }
            LOG.debug("poll: chassis status: {}", (Object)chassisStatus.toInt());
            chassisStatusTxt = this.resolveDellStatus(chassisStatus.toInt());
            SnmpObjId eventLogStatusSnmpObject = SnmpObjId.get((String)EVENT_LOG_STATUS_OID);
            SnmpValue eventLogStatus = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)eventLogStatusSnmpObject);
            if (eventLogStatus == null) {
                LOG.warn("Cannot receive eventLogStatus.");
            } else {
                LOG.debug("poll: eventLogStatus: {}", (Object)eventLogStatus);
                eventLogStatusTxt = this.resolveDellStatus(eventLogStatus.toInt());
            }
            SnmpObjId manufacturerSnmpObject = SnmpObjId.get((String)MANUFACTURER_OID);
            SnmpValue manufacturer = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)manufacturerSnmpObject);
            if (manufacturer == null) {
                LOG.warn("Cannot receive manufacturer.");
            } else {
                LOG.debug("poll: manufacturer: {}", (Object)manufacturer);
                manufacturerName = manufacturer.toString();
            }
            SnmpObjId modelSnmpObject = SnmpObjId.get((String)MODEL_NAME_OID);
            SnmpValue model = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)modelSnmpObject);
            if (model == null) {
                LOG.warn("Cannot receive model name.");
            } else {
                LOG.debug("poll: model name: {}", (Object)model);
                modelName = model.toString();
            }
            SnmpObjId serviceTagSnmpObject = SnmpObjId.get((String)SERVICE_TAG_OID);
            SnmpValue serviceTag = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)serviceTagSnmpObject);
            if (serviceTag == null) {
                LOG.warn("Cannot receive service tag");
            } else {
                LOG.debug("poll: service tag: {}", (Object)serviceTag);
                serviceTagTxt = serviceTag.toString();
            }
            returnValue = "Chassis status from " + manufacturerName + " " + modelName + " with service tag " + serviceTagTxt + " is " + chassisStatusTxt + ". Last event log status is " + eventLogStatusTxt + ". For further information, check your OpenManage website!";
            status = PollStatus.unavailable(returnValue);
        }
        catch (NullPointerException e) {
            String reason = "Unexpected error during SNMP poll of interface " + hostAddress;
            LOG.debug(reason, (Throwable)e);
            status = PollStatus.unavailable(reason);
        }
        catch (NumberFormatException e) {
            String reason = "Number operator used on a non-number " + e.getMessage();
            LOG.debug(reason);
            status = PollStatus.unavailable(reason);
        }
        catch (IllegalArgumentException e) {
            String reason = "Invalid SNMP Criteria: " + e.getMessage();
            LOG.debug(reason);
            status = PollStatus.unavailable(reason);
        }
        catch (Throwable t) {
            String reason = "Unexpected exception during SNMP poll of interface " + hostAddress;
            LOG.debug(reason, t);
            status = PollStatus.unavailable(reason);
        }
        return status;
    }

    private String resolveDellStatus(int sc) {
        String name = "N/A";
        if (DELL_STATUS.OTHER.value() == sc) {
            name = DELL_STATUS.OTHER.name();
        }
        if (DELL_STATUS.UNKNOWN.value() == sc) {
            name = DELL_STATUS.UNKNOWN.name();
        }
        if (DELL_STATUS.OK.value() == sc) {
            name = DELL_STATUS.OK.name();
        }
        if (DELL_STATUS.NON_CRITICAL.value() == sc) {
            name = DELL_STATUS.NON_CRITICAL.name();
        }
        if (DELL_STATUS.CRITICAL.value() == sc) {
            name = DELL_STATUS.CRITICAL.name();
        }
        if (DELL_STATUS.NON_RECOVERABLE.value() == sc) {
            name = DELL_STATUS.NON_RECOVERABLE.name();
        }
        return name;
    }

    private static enum DELL_STATUS {
        OTHER(1),
        UNKNOWN(2),
        OK(3),
        NON_CRITICAL(4),
        CRITICAL(5),
        NON_RECOVERABLE(6);

        private final int state;

        private DELL_STATUS(int s) {
            this.state = s;
        }

        private int value() {
            return this.state;
        }
    }
}

