/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public final class CitrixMonitor
extends AbstractServiceMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(CitrixMonitor.class);
    private static final int DEFAULT_PORT = 1494;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        TimeoutTracker timeoutTracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)1494);
        InetAddress ipv4Addr = svc.getAddress();
        String host = InetAddressUtils.str((InetAddress)ipv4Addr);
        LOG.debug("CitrixMonitor.poll: Polling interface: {} {}", (Object)host, (Object)timeoutTracker);
        PollStatus serviceStatus = PollStatus.unavailable();
        timeoutTracker.reset();
        while (timeoutTracker.shouldRetry() && !serviceStatus.isAvailable()) {
            String reason;
            Socket socket = null;
            try {
                timeoutTracker.startAttempt();
                socket = new Socket();
                socket.connect(new InetSocketAddress(ipv4Addr, port), timeoutTracker.getConnectionTimeout());
                socket.setSoTimeout(timeoutTracker.getSoTimeout());
                LOG.debug("CitrixMonitor: connected to host: {} on port: {}", (Object)host, (Object)port);
                BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                StringBuffer buffer = new StringBuffer();
                while (!serviceStatus.isAvailable()) {
                    buffer.append((char)reader.read());
                    if (buffer.toString().indexOf("ICA") > -1) {
                        serviceStatus = PollStatus.available(timeoutTracker.elapsedTimeInMillis());
                        continue;
                    }
                    serviceStatus = PollStatus.unavailable("magic cookie 'ICA' missing from service greeting.");
                }
            }
            catch (ConnectException e) {
                reason = "Connection refused by host " + host;
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable(reason);
            }
            catch (NoRouteToHostException e) {
                reason = "Unable to test host " + host + ", no route available";
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable(reason);
            }
            catch (InterruptedIOException e) {
                reason = "did not connect to host " + host + " within timeout: " + timeoutTracker;
                LOG.debug(reason);
                serviceStatus = PollStatus.unavailable(reason);
            }
            catch (IOException e) {
                reason = "Error communicating with host " + host;
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable(reason);
            }
            catch (Throwable t) {
                reason = "Undeclared throwable exception caught contacting host " + host;
                LOG.debug(reason, t);
                serviceStatus = PollStatus.unavailable(reason);
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                        socket = null;
                    }
                }
                catch (IOException e) {}
            }
            timeoutTracker.nextAttempt();
        }
        return serviceStatus;
    }
}

