/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.config.NotifdConfigManager;
import org.opennms.netmgt.config.NotificationManager;
import org.opennms.netmgt.config.notifd.Queue;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.notifd.BroadcastEventProcessor;
import org.opennms.netmgt.notifd.NoticeQueue;
import org.opennms.netmgt.notifd.NotifdQueueHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public final class Notifd
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(Notifd.class);
    private static final String LOG4J_CATEGORY = "notifd";
    private final Map<String, NoticeQueue> m_noticeQueues = new HashMap<String, NoticeQueue>();
    private final Map<String, NotifdQueueHandler> m_queueHandlers = new HashMap<String, NotifdQueueHandler>();
    @Autowired
    private volatile BroadcastEventProcessor m_eventReader;
    @Autowired
    private volatile NotifdConfigManager m_configManager;
    @Autowired
    private volatile NodeDao m_nodeDao;
    @Autowired
    private volatile NotificationManager m_notificationManager;

    protected Notifd() {
        super(LOG4J_CATEGORY);
    }

    protected void onInit() {
        try {
            Queue[] queues;
            LOG.info("Notification status = {}", (Object)this.getConfigManager().getNotificationStatus());
            for (Queue queue : queues = this.getConfigManager().getConfiguration().getQueue()) {
                NoticeQueue curQueue = new NoticeQueue();
                Class<?> handlerClass = Class.forName(queue.getHandlerClass().getName());
                NotifdQueueHandler handlerQueue = (NotifdQueueHandler)handlerClass.newInstance();
                handlerQueue.setQueueID(queue.getQueueId());
                handlerQueue.setNoticeQueue(curQueue);
                handlerQueue.setInterval(queue.getInterval());
                this.m_noticeQueues.put(queue.getQueueId(), curQueue);
                this.m_queueHandlers.put(queue.getQueueId(), handlerQueue);
            }
        }
        catch (Throwable t) {
            LOG.error("start: Failed to load notifd queue handlers.", t);
            throw new UndeclaredThrowableException(t);
        }
        this.m_eventReader.setNoticeQueues(this.m_noticeQueues);
        try {
            this.m_eventReader.init();
        }
        catch (Throwable e) {
            LOG.error("Failed to setup event receiver", e);
            throw new UndeclaredThrowableException(e);
        }
    }

    public NotifdConfigManager getConfigManager() {
        return this.m_configManager;
    }

    public void setConfigManager(NotifdConfigManager manager) {
        this.m_configManager = manager;
    }

    public BroadcastEventProcessor getBroadcastEventProcessor() {
        return this.m_eventReader;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public NotificationManager getNotificationManager() {
        return this.m_notificationManager;
    }

    protected void onStart() {
        for (NotifdQueueHandler curHandler : this.m_queueHandlers.values()) {
            curHandler.start();
        }
    }

    protected void onStop() {
        try {
            for (NotifdQueueHandler curHandler : this.m_queueHandlers.values()) {
                curHandler.stop();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.m_eventReader != null) {
            this.m_eventReader.close();
        }
    }

    protected void onPause() {
        for (NotifdQueueHandler curHandler : this.m_queueHandlers.values()) {
            curHandler.pause();
        }
    }

    protected void onResume() {
        for (NotifdQueueHandler curHandler : this.m_queueHandlers.values()) {
            curHandler.resume();
        }
    }

    public static String getLoggingCategory() {
        return LOG4J_CATEGORY;
    }
}

