/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.opennms.netmgt.enlinkd.snmp.SnmpGetter;
import org.opennms.netmgt.model.OspfElement;
import org.opennms.netmgt.model.OspfLink;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;

public class OspfIpAddrTableGetter
extends SnmpGetter {
    public static final SnmpObjId IPADENT_IFINDEX = SnmpObjId.get((String)".1.3.6.1.2.1.4.20.1.2");
    public static final SnmpObjId IPADENT_NETMASK = SnmpObjId.get((String)".1.3.6.1.2.1.4.20.1.3");

    public OspfIpAddrTableGetter(SnmpAgentConfig peer, LocationAwareSnmpClient client, String location) {
        super(peer, client, location);
    }

    public OspfElement get(OspfElement element) {
        List<SnmpValue> val = this.get(element.getOspfRouterId());
        if (val != null && val.size() == 2) {
            if (!val.get(0).isNull() && val.get(0).isNumeric()) {
                element.setOspfRouterIdIfindex(Integer.valueOf(val.get(0).toInt()));
            }
            if (!val.get(1).isNull() && !val.get(1).isError()) {
                try {
                    element.setOspfRouterIdNetmask(val.get(1).toInetAddress());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return element;
    }

    public OspfLink get(OspfLink link) {
        List<SnmpValue> val = this.get(link.getOspfIpAddr());
        if (val != null && val.size() == 2) {
            if (!val.get(0).isNull() && val.get(0).isNumeric()) {
                link.setOspfIfIndex(Integer.valueOf(val.get(0).toInt()));
            }
            if (!val.get(1).isNull() && !val.get(1).isError()) {
                try {
                    link.setOspfIpMask(val.get(1).toInetAddress());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return link;
    }

    private List<SnmpValue> get(InetAddress addr) {
        SnmpObjId instance = SnmpObjId.get((String)addr.getHostAddress());
        ArrayList<SnmpObjId> oids = new ArrayList<SnmpObjId>();
        oids.add(SnmpObjId.get((SnmpObjId)IPADENT_IFINDEX, (SnmpObjId)instance));
        oids.add(SnmpObjId.get((SnmpObjId)IPADENT_NETMASK, (SnmpObjId)instance));
        return this.get(oids);
    }
}

