/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.net.io.CRLFLineReader;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.NetworkInterface;
import org.opennms.netmgt.poller.NetworkInterfaceNotSupportedException;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable
public final class SmtpMonitor
extends AbstractServiceMonitor {
    public static final Logger LOG = LoggerFactory.getLogger(SmtpMonitor.class);
    private static final int DEFAULT_PORT = 25;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final String LOCALHOST_NAME = InetAddressUtils.getLocalHostName();
    private static final Pattern MULTILINE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        NetworkInterface iface = svc.getNetInterface();
        if (iface.getType() != 1) {
            throw new NetworkInterfaceNotSupportedException("Unsupported interface type, only TYPE_INET currently supported");
        }
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)25);
        InetAddress ipAddr = (InetAddress)iface.getAddress();
        String hostAddress = InetAddressUtils.str((InetAddress)ipAddr);
        LOG.debug("poll: address = {}, port = {}, {}", new Object[]{hostAddress, port, tracker});
        PollStatus serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            block45: {
                String reason;
                Socket socket = null;
                try {
                    tracker.startAttempt();
                    socket = new Socket();
                    socket.connect(new InetSocketAddress(ipAddr, port), tracker.getConnectionTimeout());
                    socket.setSoTimeout(tracker.getSoTimeout());
                    LOG.debug("SmtpMonitor: connected to host: {} on port: {}", (Object)ipAddr, (Object)port);
                    serviceStatus = PollStatus.unresponsive();
                    CRLFLineReader rdr = new CRLFLineReader((Reader)new InputStreamReader(socket.getInputStream(), "ASCII"));
                    String banner = this.sendMessage(socket, (BufferedReader)rdr, null);
                    LOG.debug("poll: banner = {}", (Object)banner);
                    StringTokenizer t = new StringTokenizer(banner);
                    int rc = Integer.parseInt(t.nextToken());
                    if (rc == 220) {
                        String cmd = "HELO " + LOCALHOST_NAME + "\r\n";
                        socket.getOutputStream().write(cmd.getBytes());
                        String response = rdr.readLine();
                        double responseTime = tracker.elapsedTimeInMillis();
                        if (response == null) break block45;
                        if (MULTILINE.matcher(response).find()) {
                            String multiLineRC = new String(response.getBytes("ASCII"), 0, 3, "ASCII");
                            Pattern endMultiline = null;
                            try {
                                endMultiline = Pattern.compile(multiLineRC);
                            }
                            catch (PatternSyntaxException ex) {
                                throw new UndeclaredThrowableException(ex);
                            }
                            while ((response = rdr.readLine()) != null && !endMultiline.matcher(response).find()) {
                            }
                            if (response == null) break block45;
                        }
                        if ((rc = Integer.parseInt((t = new StringTokenizer(response)).nextToken())) == 250 && (rc = Integer.parseInt((t = new StringTokenizer(response = this.sendMessage(socket, (BufferedReader)rdr, "QUIT\r\n"))).nextToken())) == 221) {
                            serviceStatus = PollStatus.available((Double)responseTime);
                        }
                    } else if (rc == 554) {
                        String response = this.sendMessage(socket, (BufferedReader)rdr, "QUIT\r\n");
                        serviceStatus = PollStatus.unavailable((String)"Server rejecting transactions with 554");
                    }
                    if (!serviceStatus.isAvailable()) {
                        serviceStatus = PollStatus.unavailable((String)serviceStatus.getReason());
                    }
                }
                catch (NumberFormatException e) {
                    reason = "NumberFormatException while polling address " + hostAddress;
                    LOG.debug(reason, (Throwable)e);
                    serviceStatus = PollStatus.unavailable((String)reason);
                }
                catch (NoRouteToHostException e) {
                    reason = "No route to host exception for address " + hostAddress;
                    LOG.debug(reason, (Throwable)e);
                    serviceStatus = PollStatus.unavailable((String)reason);
                    break;
                }
                catch (InterruptedIOException e) {
                    reason = "Did not receive expected response within timeout " + tracker;
                    LOG.debug(reason);
                    serviceStatus = PollStatus.unavailable((String)reason);
                }
                catch (ConnectException e) {
                    reason = "Unable to connect to address " + hostAddress;
                    LOG.debug(reason, (Throwable)e);
                    serviceStatus = PollStatus.unavailable((String)reason);
                }
                catch (IOException e) {
                    reason = "IOException while polling address " + hostAddress;
                    LOG.debug(reason, (Throwable)e);
                    serviceStatus = PollStatus.unavailable((String)reason);
                }
                finally {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (IOException e) {
                        e.fillInStackTrace();
                        LOG.debug("poll: Error closing socket.", (Throwable)e);
                    }
                }
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }

    private String sendMessage(Socket socket, BufferedReader rdr, String command) throws IOException {
        String response;
        if (command != null && !"".equals(command)) {
            socket.getOutputStream().write(command.getBytes("ASCII"));
        }
        if ((response = rdr.readLine()) == null) {
            return "";
        }
        if (MULTILINE.matcher(response).find()) {
            String multiLineRC = new String(response.getBytes("ASCII"), 0, 3, "ASCII") + " ";
            Pattern endMultiline = null;
            try {
                endMultiline = Pattern.compile(multiLineRC);
            }
            catch (PatternSyntaxException ex) {
                throw new UndeclaredThrowableException(ex);
            }
            while ((response = rdr.readLine()) != null && !endMultiline.matcher(response).find()) {
            }
            if (response == null) {
                return "";
            }
        }
        return response;
    }

    static {
        try {
            MULTILINE = Pattern.compile("^[0-9]{3}-");
        }
        catch (PatternSyntaxException ex) {
            throw new UndeclaredThrowableException(ex);
        }
    }
}

