/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scriptd;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.LinkedBlockingQueue;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.config.ScriptdConfigFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.scriptd.BroadcastEventProcessor;
import org.opennms.netmgt.scriptd.Executor;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.access.BeanFactoryReference;

public final class Scriptd
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(Scriptd.class);
    public static final String NAME = "scriptd";
    private static final Scriptd m_singleton = new Scriptd();
    private Executor m_execution = null;
    private BroadcastEventProcessor m_eventReader = null;

    private Scriptd() {
        super(NAME);
    }

    protected void onInit() {
        ScriptdConfigFactory aFactory = null;
        try {
            ScriptdConfigFactory.reload();
            aFactory = ScriptdConfigFactory.getInstance();
        }
        catch (MarshalException ex) {
            LOG.error("Failed to load scriptd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            LOG.error("Failed to load scriptd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            LOG.error("Failed to load scriptd configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        LinkedBlockingQueue<Event> execQ = new LinkedBlockingQueue<Event>();
        try {
            this.m_eventReader = new BroadcastEventProcessor(execQ);
        }
        catch (Throwable ex) {
            LOG.error("Failed to setup event reader", ex);
            throw new UndeclaredThrowableException(ex);
        }
        BeanFactoryReference bf = BeanUtils.getBeanFactory((String)"daoContext");
        NodeDao nodeDao = (NodeDao)BeanUtils.getBean((BeanFactoryReference)bf, (String)"nodeDao", NodeDao.class);
        this.m_execution = new Executor(execQ, aFactory, nodeDao);
    }

    protected void onStart() {
        if (this.m_execution == null) {
            this.init();
        }
        this.m_execution.start();
        LOG.info("Scriptd running");
    }

    protected void onStop() {
        try {
            if (this.m_execution != null) {
                this.m_execution.stop();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.m_eventReader != null) {
            this.m_eventReader.close();
        }
        this.m_eventReader = null;
        this.m_execution = null;
    }

    protected void onPause() {
        this.m_execution.pause();
    }

    protected void onResume() {
        this.m_execution.resume();
    }

    public static Scriptd getInstance() {
        return m_singleton;
    }
}

