/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scriptd;

import java.util.Queue;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BroadcastEventProcessor
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(BroadcastEventProcessor.class);
    private final Queue<Event> m_execQ;

    BroadcastEventProcessor(Queue<Event> execQ) {
        this.m_execQ = execQ;
        EventIpcManagerFactory.init();
        EventIpcManagerFactory.getIpcManager().addEventListener((EventListener)this);
    }

    public synchronized void close() {
        EventIpcManagerFactory.getIpcManager().removeEventListener((EventListener)this);
    }

    public void onEvent(Event event) {
        if (event == null) {
            return;
        }
        this.m_execQ.add(event);
        LOG.debug("Added event '{}' to scriptd execution queue.", (Object)event.getUei());
    }

    public String getName() {
        return "Scriptd:BroadcastEventProcessor";
    }
}

