/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.pollables;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.opennms.netmgt.poller.pollables.PollEvent;
import org.opennms.netmgt.poller.pollables.Scope;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingPollEvent
extends PollEvent {
    private static final Logger LOG = LoggerFactory.getLogger(PendingPollEvent.class);
    private static final long PENDING_EVENT_TIMEOUT = Long.getLong("org.opennms.netmgt.poller.pendingEventTimeout", 600000L);
    private final Event m_event;
    private Date m_date;
    private long m_expirationTimeInMillis;
    private volatile boolean m_pending = true;
    private List<Runnable> m_pendingOutages = new LinkedList<Runnable>();

    public PendingPollEvent(Event event) {
        super(Scope.fromUei(event.getUei()));
        this.m_event = event;
        this.m_date = this.m_event.getTime();
        this.m_expirationTimeInMillis = this.m_date.getTime() + PENDING_EVENT_TIMEOUT;
    }

    @Override
    public Date getDate() {
        return this.m_date;
    }

    @Override
    public int getEventId() {
        return this.m_event.getDbid();
    }

    public synchronized void addPending(Runnable r) {
        if (this.m_pending) {
            this.m_pendingOutages.add(r);
        } else {
            r.run();
        }
    }

    public Event getEvent() {
        return this.m_event;
    }

    public synchronized boolean isPending() {
        if (this.m_pending && this.isTimedOut()) {
            this.m_pending = false;
        }
        return this.m_pending;
    }

    boolean isTimedOut() {
        return System.currentTimeMillis() > this.m_expirationTimeInMillis;
    }

    public synchronized void complete(Event e) {
        this.m_pending = false;
    }

    public synchronized void processPending() {
        for (Runnable r : this.m_pendingOutages) {
            r.run();
        }
        this.m_pendingOutages.clear();
    }

    public String toString() {
        return this.m_event + ", uei: " + this.m_event.getUei() + ", id: " + this.m_event.getDbid() + ", isPending: " + this.m_pending + ", list size: " + this.m_pendingOutages.size();
    }

    void setExpirationTimeInMillis(long time) {
        this.m_expirationTimeInMillis = time;
    }
}

