/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.BSFManagerTerminator;
import org.apache.bsf.util.IOUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable(value={DistributionContext.DAEMON})
public class BSFMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(BSFMonitor.class);
    private static final String STATUS_UNKNOWN = "UNK";
    private static final String STATUS_UNRESPONSIVE = "UNR";
    private static final String STATUS_AVAILABLE = "OK";
    private static final String STATUS_UNAVAILABLE = "NOK";
    private BSFManager m_bsfManager;

    public void initialize(Map<String, Object> parameters) {
        this.m_bsfManager = new BSFManager();
    }

    public void release() {
        LOG.debug("Terminating the BSFManager.");
        BSFManagerTerminator.terminate(this.m_bsfManager);
    }

    private void undeclareBean(String beanName) {
        try {
            this.m_bsfManager.undeclareBean(beanName);
        }
        catch (BSFException e) {
            LOG.warn("Unable to undeclareBean '{}'", (Object)beanName);
        }
    }

    private void undeclareBeans(Map<String, Object> map) {
        this.undeclareBean("map");
        this.undeclareBean("ip_addr");
        this.undeclareBean("node_id");
        this.undeclareBean("node_label");
        this.undeclareBean("svc_name");
        this.undeclareBean("bsf_monitor");
        this.undeclareBean("results");
        this.undeclareBean("times");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.undeclareBean(entry.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized PollStatus executeScript(MonitoredService svc, Map<String, Object> map) {
        PollStatus pollStatus = PollStatus.unavailable();
        String fileName = ParameterMap.getKeyedString(map, (String)"file-name", null);
        String lang = ParameterMap.getKeyedString(map, (String)"lang-class", null);
        String langEngine = ParameterMap.getKeyedString(map, (String)"bsf-engine", null);
        String[] langExtensions = ParameterMap.getKeyedString(map, (String)"file-extensions", (String)"").split(",");
        String runType = ParameterMap.getKeyedString(map, (String)"run-type", (String)"eval");
        File file = new File(fileName);
        try {
            if (lang == null) {
                lang = BSFManager.getLangFromFilename((String)fileName);
            }
            if (langEngine != null && lang != null && langExtensions.length > 0) {
                LOG.debug("Registering scripting engine '{}' for '{}'", (Object)langEngine, (Object)lang);
                BSFManager.registerScriptingEngine((String)lang, (String)langEngine, (String[])langExtensions);
            }
            if (file.exists() && file.canRead()) {
                String code = IOUtils.getStringFromReader((Reader)new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                HashMap<String, String> results = new HashMap<String, String>();
                LinkedHashMap<String, Long> times = new LinkedHashMap<String, Long>();
                this.m_bsfManager.declareBean("map", map, Map.class);
                this.m_bsfManager.declareBean("ip_addr", (Object)svc.getIpAddr(), String.class);
                this.m_bsfManager.declareBean("node_id", (Object)svc.getNodeId(), Integer.TYPE);
                this.m_bsfManager.declareBean("node_label", (Object)svc.getNodeLabel(), String.class);
                this.m_bsfManager.declareBean("svc_name", (Object)svc.getSvcName(), String.class);
                this.m_bsfManager.declareBean("bsf_monitor", (Object)this, BSFMonitor.class);
                this.m_bsfManager.declareBean("results", results, Map.class);
                this.m_bsfManager.declareBean("times", times, Map.class);
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    this.m_bsfManager.declareBean(entry.getKey(), entry.getValue(), String.class);
                }
                pollStatus = PollStatus.unknown((String)"The script did not update the service status");
                long startTime = System.currentTimeMillis();
                if ("eval".equals(runType)) {
                    LOG.debug("m_bsfManager's hashCode is " + (this.m_bsfManager == null ? "null" : Integer.valueOf(this.m_bsfManager.hashCode())) + "; lang is " + lang + "; code's hashCode is " + (code == null ? "null" : Integer.valueOf(code.hashCode())));
                    results.put("status", this.m_bsfManager.eval(lang, "BSFMonitor", 0, 0, (Object)code).toString());
                } else if ("exec".equals(runType)) {
                    this.m_bsfManager.exec(lang, "BSFMonitor", 0, 0, (Object)code);
                } else {
                    LOG.warn("Invalid run-type parameter value '{}' for service '{}'. Only 'eval' and 'exec' are supported.", (Object)runType, (Object)svc.getSvcName());
                    throw new RuntimeException("Invalid run-type '" + runType + "'");
                }
                long endTime = System.currentTimeMillis();
                if (!times.containsKey("response-time")) {
                    times.put("response-time", endTime - startTime);
                }
                pollStatus = STATUS_UNKNOWN.equals(results.get("status")) ? PollStatus.unknown((String)((String)results.get("reason"))) : (STATUS_UNRESPONSIVE.equals(results.get("status")) ? PollStatus.unresponsive((String)((String)results.get("reason"))) : (STATUS_AVAILABLE.equals(results.get("status")) ? PollStatus.available() : (STATUS_UNAVAILABLE.equals(results.get("status")) ? PollStatus.unavailable((String)((String)results.get("reason"))) : PollStatus.unavailable((String)((String)results.get("status"))))));
                LOG.debug("Setting {} times for service '{}'", (Object)times.size(), (Object)svc.getSvcName());
                pollStatus.setProperties(times);
                if ("exec".equals(runType) && !results.containsKey("status")) {
                    LOG.warn("The exec script '{}' for service '{}' never put a 'status' entry in the 'results' bean. Exec scripts should put this entry with a value of 'OK' for up.", (Object)fileName, (Object)svc.getSvcName());
                }
            } else {
                LOG.warn("Cannot locate or read BSF script file '{}'. Marking service '{}' down.", (Object)fileName, (Object)svc.getSvcName());
                pollStatus = PollStatus.unavailable((String)("Cannot locate or read BSF script file: " + fileName));
            }
        }
        catch (BSFException e) {
            LOG.warn("BSFMonitor poll for service '{}' failed with BSFException: {}", new Object[]{svc.getSvcName(), e.getMessage(), e});
            pollStatus = PollStatus.unavailable((String)e.getMessage());
        }
        catch (FileNotFoundException e) {
            LOG.warn("Could not find BSF script file '{}'. Marking service '{}' down.", (Object)fileName, (Object)svc.getSvcName());
            pollStatus = PollStatus.unavailable((String)("Could not find BSF script file: " + fileName));
        }
        catch (IOException e) {
            pollStatus = PollStatus.unavailable((String)e.getMessage());
            LOG.warn("BSFMonitor poll for service '{}' failed with IOException: {}", new Object[]{svc.getSvcName(), e.getMessage(), e});
        }
        catch (Throwable e) {
            pollStatus = PollStatus.unavailable((String)e.getMessage());
            LOG.warn("BSFMonitor poll for service '{}' failed with unexpected throwable: {}", new Object[]{svc.getSvcName(), e.getMessage(), e});
        }
        finally {
            this.undeclareBeans(map);
        }
        return pollStatus;
    }

    public PollStatus poll(MonitoredService svc, Map<String, Object> map) {
        return this.executeScript(svc, map);
    }

    public void log(String level, String format, Object ... args) {
        if ("TRACE".equals(level)) {
            LOG.trace(format, args);
        }
        if ("DEBUG".equals(level)) {
            LOG.debug(format, args);
        }
        if ("INFO".equals(level)) {
            LOG.info(format, args);
        }
        if ("WARN".equals(level)) {
            LOG.warn(format, args);
        }
        if ("ERROR".equals(level)) {
            LOG.error(format, args);
        }
        if ("FATAL".equals(level)) {
            LOG.error(format, args);
        }
    }
}

