/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.translator.jmx;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.netmgt.config.EventTranslatorConfigFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventIpcManagerFactory;
import org.opennms.netmgt.translator.jmx.EventTranslatorMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventTranslator
extends AbstractServiceDaemon
implements EventTranslatorMBean {
    private static final Logger LOG = LoggerFactory.getLogger(EventTranslator.class);
    public static final String NAME = "event-translator";

    public EventTranslator() {
        super(NAME);
    }

    protected void onInit() {
        try {
            EventTranslatorConfigFactory.init();
        }
        catch (MarshalException e) {
            LOG.error("Could not unmarshall configuration", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ValidationException e) {
            LOG.error("validation error ", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException e) {
            LOG.error("IOException: ", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Unable to initialize database", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            LOG.error("SQLException: ", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (PropertyVetoException e) {
            LOG.error("PropertyVetoException: ", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        EventIpcManagerFactory.init();
        EventIpcManager mgr = EventIpcManagerFactory.getIpcManager();
        org.opennms.netmgt.translator.EventTranslator keeper = this.getEventTranslator();
        keeper.setConfig(EventTranslatorConfigFactory.getInstance());
        keeper.setEventManager(mgr);
        keeper.setDataSource(DataSourceFactory.getInstance());
        keeper.init();
    }

    protected void onStart() {
        this.getEventTranslator().start();
    }

    protected void onStop() {
        this.getEventTranslator().stop();
    }

    public int getStatus() {
        return this.getEventTranslator().getStatus();
    }

    private org.opennms.netmgt.translator.EventTranslator getEventTranslator() {
        return org.opennms.netmgt.translator.EventTranslator.getInstance();
    }
}

