/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.util.Map;
import org.opennms.netmgt.poller.Distributable;
import org.opennms.netmgt.poller.DistributionContext;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitor;
import org.opennms.netmgt.poller.monitors.AbstractServiceMonitor;
import org.opennms.netmgt.poller.monitors.IcmpMonitor;
import org.opennms.netmgt.poller.monitors.PassiveServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Distributable(value={DistributionContext.DAEMON})
public class IcmpMonitorWrapper
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(IcmpMonitorWrapper.class);
    private ServiceMonitor icmpMonitor = new IcmpMonitor();
    private ServiceMonitor pskMonitor = new PassiveServiceMonitor();

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        ServiceMonitor svcMonitor = svc.getIpAddr().startsWith("169.254.") ? this.pskMonitor : this.icmpMonitor;
        LOG.debug("Polling {}@{} using {}", new Object[]{svc.getSvcName(), svc.getIpAddr(), svcMonitor.getClass().getSimpleName()});
        return svcMonitor.poll(svc, parameters);
    }
}

