/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.poller.Poller;
import org.opennms.netmgt.poller.pollables.PollableInterface;
import org.opennms.netmgt.poller.pollables.PollableNetwork;
import org.opennms.netmgt.poller.pollables.PollableNode;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PollerEventProcessor
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(PollerEventProcessor.class);
    private final Poller m_poller;

    private void createMessageSelectorAndSubscribe() {
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/nodes/nodeGainedService");
        ueiList.add("uei.opennms.org/nodes/serviceDeleted");
        ueiList.add("uei.opennms.org/nodes/interfaceReparented");
        ueiList.add("uei.opennms.org/nodes/nodeDeleted");
        ueiList.add("uei.opennms.org/nodes/nodeLabelChanged");
        ueiList.add("uei.opennms.org/nodes/duplicateNodeDeleted");
        ueiList.add("uei.opennms.org/nodes/interfaceDeleted");
        ueiList.add("uei.opennms.org/internal/poller/suspendPollingService");
        ueiList.add("uei.opennms.org/internal/poller/resumePollingService");
        ueiList.add("uei.opennms.org/internal/schedOutagesChanged");
        ueiList.add("uei.opennms.org/internal/demandPollService");
        ueiList.add("uei.opennms.org/internal/thresholdConfigChange");
        ueiList.add("uei.opennms.org/nodes/assetInfoChanged");
        ueiList.add("uei.opennms.org/nodes/nodeCategoryMembershipChanged");
        ueiList.add("uei.opennms.org/internal/reloadDaemonConfig");
        this.getEventManager().addEventListener((EventListener)this, ueiList);
    }

    private void nodeGainedServiceHandler(Event event) {
        PollableService service;
        String ipAddr = event.getInterface();
        Long nodeId = event.getNodeid();
        String svcName = event.getService();
        String nodeLabel = EventUtils.getParm((Event)event, (String)"nodelabel");
        try {
            nodeLabel = this.getPoller().getQueryManager().getNodeLabel(nodeId.intValue());
        }
        catch (Exception e) {
            LOG.error("Unable to retrieve nodeLabel for node {}", (Object)nodeId, (Object)e);
        }
        PollableNode pnode = this.getNetwork().getNode(nodeId.intValue());
        if (pnode != null && (service = pnode.getService(InetAddressUtils.addr((String)ipAddr), svcName)) != null) {
            LOG.debug("Node {} gained service {} on IP {}, but it is already being polled!", new Object[]{nodeId, svcName, ipAddr});
            return;
        }
        this.getPoller().scheduleService(nodeId.intValue(), nodeLabel, ipAddr, svcName);
    }

    private void interfaceReparentedHandler(Event event) {
        LOG.debug("interfaceReparentedHandler: processing interfaceReparented event for {}", (Object)event.getInterface());
        if (event.getInterfaceAddress() == null) {
            return;
        }
        InetAddress ipAddr = event.getInterfaceAddress();
        String oldNodeIdStr = null;
        String newNodeIdStr = null;
        String parmName = null;
        Value parmValue = null;
        String parmContent = null;
        for (Parm parm : event.getParmCollection()) {
            parmName = parm.getParmName();
            parmValue = parm.getValue();
            if (parmValue == null) continue;
            parmContent = parmValue.getContent();
            if (parmName.equals("oldNodeID")) {
                oldNodeIdStr = parmContent;
                continue;
            }
            if (!parmName.equals("newNodeID")) continue;
            newNodeIdStr = parmContent;
        }
        if (oldNodeIdStr == null || newNodeIdStr == null) {
            LOG.error("interfaceReparentedHandler: old and new nodeId parms are required, unable to process.");
            return;
        }
        try {
            PollableNode oldNode = this.getNetwork().getNode(Integer.parseInt(oldNodeIdStr));
            if (oldNode == null) {
                LOG.error("interfaceReparentedHandler: Cannot locate old node {} belonging to interface {}", oldNodeIdStr, (Object)ipAddr);
                return;
            }
            PollableNode newNode = this.getNetwork().getNode(Integer.parseInt(newNodeIdStr));
            if (newNode == null) {
                LOG.error("interfaceReparentedHandler: Cannot locate new node {} to move interface to.  Also, grammar error: ended a sentence with a preposition.", (Object)newNodeIdStr);
                return;
            }
            PollableInterface iface = oldNode.getInterface(ipAddr);
            if (iface == null) {
                LOG.error("interfaceReparentedHandler: Cannot locate interface with ipAddr {} to reparent.", (Object)ipAddr);
                return;
            }
            iface.reparentTo(newNode);
        }
        catch (NumberFormatException nfe) {
            LOG.error("interfaceReparentedHandler: failed converting old/new nodeid parm to integer, unable to process.");
            return;
        }
    }

    private void nodeRemovePollableServiceHandler(Event event) {
        Long nodeId = event.getNodeid();
        InetAddress ipAddr = event.getInterfaceAddress();
        String svcName = event.getService();
        if (svcName == null) {
            LOG.error("nodeRemovePollableServiceHandler: service name is null, ignoring event");
            return;
        }
        PollableService svc = this.getNetwork().getService(nodeId.intValue(), ipAddr, svcName);
        svc.delete();
    }

    private void nodeDeletedHandler(Event event) {
        Long nodeId = event.getNodeid();
        String sourceUei = event.getUei();
        long txNo = -1L;
        String parmName = null;
        Value parmValue = null;
        String parmContent = null;
        for (Parm parm : event.getParmCollection()) {
            parmName = parm.getParmName();
            parmValue = parm.getValue();
            if (parmValue == null) continue;
            parmContent = parmValue.getContent();
            if (!parmName.equals("txno")) continue;
            String temp = parmContent;
            LOG.debug("nodeDeletedHandler:  parmName: {} /parmContent: {}", (Object)parmName, (Object)parmContent);
            try {
                txNo = Long.valueOf(temp);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("nodeDeletedHandler: Parameter {} cannot be non-numeric", (Object)"txno", (Object)nfe);
                txNo = -1L;
            }
        }
        Date closeDate = event.getTime();
        this.getPoller().getQueryManager().closeOutagesForNode(closeDate, event.getDbid(), nodeId.intValue());
        PollableNode node = this.getNetwork().getNode(nodeId.intValue());
        if (node == null) {
            LOG.error("Nodeid {} does not exist in pollable node map, unable to delete node.", (Object)nodeId);
            return;
        }
        node.delete();
    }

    private void nodeLabelChangedHandler(Event event) {
        Long nodeId = event.getNodeid();
        for (Parm parm : event.getParmCollection()) {
            String parmName = parm.getParmName();
            Value parmValue = parm.getValue();
            if (parmValue == null || !parmName.equals("nodelabel")) continue;
            String label = parmValue.getContent();
            LOG.debug("nodeLabelChangedHandler: parmName: {} /parmContent: {}", (Object)parmName, (Object)label);
            PollableNode node = this.getNetwork().getNode(nodeId.intValue());
            if (node == null) {
                LOG.warn("nodeLabelChangedHandler: nodeid {} does not exist in pollable node map, unable to update node label.", (Object)nodeId);
                continue;
            }
            node.setNodeLabel(label);
            return;
        }
    }

    private void interfaceDeletedHandler(Event event) {
        Long nodeId = event.getNodeid();
        String sourceUei = event.getUei();
        InetAddress ipAddr = event.getInterfaceAddress();
        long txNo = -1L;
        String parmName = null;
        Value parmValue = null;
        String parmContent = null;
        for (Parm parm : event.getParmCollection()) {
            parmName = parm.getParmName();
            parmValue = parm.getValue();
            if (parmValue == null) continue;
            parmContent = parmValue.getContent();
            if (!parmName.equals("txno")) continue;
            String temp = parmContent;
            LOG.debug("interfaceDeletedHandlerHandler:  parmName: {} /parmContent: {}", (Object)parmName, (Object)parmContent);
            try {
                txNo = Long.valueOf(temp);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("interfaceDeletedHandlerHandler: Parameter {} cannot be non-numberic", (Object)"txno", (Object)nfe);
                txNo = -1L;
            }
        }
        Date closeDate = event.getTime();
        this.getPoller().getQueryManager().closeOutagesForInterface(closeDate, event.getDbid(), nodeId.intValue(), InetAddressUtils.str((InetAddress)ipAddr));
        PollableInterface iface = this.getNetwork().getInterface(nodeId.intValue(), ipAddr);
        if (iface == null) {
            LOG.error("Interface {}/{} does not exist in pollable node map, unable to delete node.", (Object)nodeId, (Object)event.getInterface());
            return;
        }
        iface.delete();
    }

    private void serviceDeletedHandler(Event event) {
        Long nodeId = event.getNodeid();
        InetAddress ipAddr = event.getInterfaceAddress();
        String service = event.getService();
        Date closeDate = event.getTime();
        this.getPoller().getQueryManager().closeOutagesForService(closeDate, event.getDbid(), nodeId.intValue(), InetAddressUtils.str((InetAddress)ipAddr), service);
        PollableService svc = this.getNetwork().getService(nodeId.intValue(), ipAddr, service);
        if (svc == null) {
            LOG.error("Interface {}/{} does not exist in pollable node map, unable to delete node.", (Object)nodeId, (Object)event.getInterface());
            return;
        }
        svc.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadConfigHandler(Event event) {
        String daemonName = "Pollerd";
        boolean isPoller = false;
        for (Parm parm : event.getParmCollection()) {
            if (!"daemonName".equals(parm.getParmName()) || !"Pollerd".equalsIgnoreCase(parm.getValue().getContent())) continue;
            isPoller = true;
            break;
        }
        if (isPoller) {
            LOG.info("reloadConfigHandler: reloading poller configuration");
            String targetFile = ConfigFileConstants.getFileName((int)ConfigFileConstants.POLLER_CONF_FILE_NAME);
            EventBuilder ebldr = null;
            try {
                this.getPollerConfig().update();
                this.rescheduleAllServices(event);
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", "Pollerd");
                ebldr.addParam("daemonName", "Pollerd");
                ebldr.addParam("configFile", targetFile);
            }
            catch (Throwable e) {
                LOG.error("reloadConfigHandler: Error reloading/processing poller configuration: {}", (Object)e.getMessage(), (Object)e);
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", "Pollerd");
                ebldr.addParam("daemonName", "Pollerd");
                ebldr.addParam("configFile", targetFile);
                ebldr.addParam("reason", e.getMessage());
            }
            finally {
                if (ebldr != null) {
                    this.getEventManager().sendNow(ebldr.getEvent());
                }
            }
        } else {
            LOG.warn("reloadConfigHandler: invalid parameters");
        }
    }

    PollerEventProcessor(Poller poller) {
        this.m_poller = poller;
        this.createMessageSelectorAndSubscribe();
        LOG.debug("Subscribed to eventd");
    }

    public void close() {
        this.getEventManager().removeEventListener((EventListener)this);
    }

    private EventIpcManager getEventManager() {
        return this.getPoller().getEventManager();
    }

    public void onEvent(Event event) {
        if (event == null) {
            return;
        }
        LOG.debug("PollerEventProcessor: received event, uei = {}", (Object)event.getUei());
        if (event.getUei().equals("uei.opennms.org/internal/schedOutagesChanged")) {
            LOG.info("Reloading poller config factory and polloutages config factory");
            this.scheduledOutagesChangeHandler();
        } else if (event.getUei().equals("uei.opennms.org/internal/thresholdConfigChange")) {
            LOG.info("Reloading thresholding configuration in pollerd");
            this.thresholdsConfigChangeHandler();
        } else if (event.getUei().equals("uei.opennms.org/internal/reloadDaemonConfig")) {
            LOG.info("Reloading poller configuration in pollerd");
            this.reloadConfigHandler(event);
        } else if (!event.hasNodeid()) {
            LOG.info("PollerEventProcessor: no database node id found, discarding event");
        } else if (event.getUei().equals("uei.opennms.org/nodes/nodeGainedService")) {
            if (event.getInterface() == null) {
                LOG.info("PollerEventProcessor: no interface found, discarding event");
            } else {
                this.nodeGainedServiceHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/internal/poller/resumePollingService")) {
            if (event.getInterface() == null) {
                LOG.info("PollerEventProcessor: no interface found, cannot resume polling service, discarding event");
            } else {
                this.nodeGainedServiceHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/internal/poller/suspendPollingService")) {
            if (event.getInterface() == null) {
                LOG.info("PollerEventProcessor: no interface found, cannot suspend polling service, discarding event");
            } else {
                this.nodeRemovePollableServiceHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/interfaceReparented")) {
            if (event.getInterface() == null) {
                LOG.info("PollerEventProcessor: no interface found, discarding event");
            } else {
                this.interfaceReparentedHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/nodeLabelChanged")) {
            if (event.getNodeid() < 0L) {
                LOG.info("PollerEventProcessor: no node or interface found, discarding event");
            }
            this.nodeLabelChangedHandler(event);
        } else if (event.getUei().equals("uei.opennms.org/nodes/nodeDeleted") || event.getUei().equals("uei.opennms.org/nodes/duplicateNodeDeleted")) {
            if (event.getNodeid() < 0L) {
                LOG.info("PollerEventProcessor: no node or interface found, discarding event");
            }
            this.nodeDeletedHandler(event);
        } else if (event.getUei().equals("uei.opennms.org/nodes/interfaceDeleted")) {
            if (event.getNodeid() < 0L || event.getInterface() == null) {
                LOG.info("PollerEventProcessor: invalid nodeid or no interface found, discarding event");
            } else {
                this.interfaceDeletedHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/serviceDeleted")) {
            if (event.getNodeid() < 0L || event.getInterface() == null || event.getService() == null) {
                LOG.info("PollerEventProcessor: invalid nodeid or no nodeinterface or service found, discarding event");
            } else {
                this.serviceDeletedHandler(event);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/nodeCategoryMembershipChanged")) {
            if (event.getNodeid() > 0L) {
                this.serviceReschedule(event, false);
            }
        } else if (event.getUei().equals("uei.opennms.org/nodes/assetInfoChanged") && event.getNodeid() > 0L) {
            this.serviceReschedule(event, false);
        }
    }

    private void serviceReschedule(Event event, boolean rescheduleExisting) {
        Long nodeId = event.getNodeid();
        if (nodeId == null || nodeId <= 0L) {
            LOG.warn("Invalid node ID for event, skipping service reschedule: {}", (Object)event);
            return;
        }
        String nodeLabel = EventUtils.getParm((Event)event, (String)"nodelabel");
        this.getPollerConfig().rebuildPackageIpListMap();
        this.serviceReschedule(nodeId, nodeLabel, event, rescheduleExisting);
    }

    private void rescheduleAllServices(Event event) {
        LOG.info("Poller configuration has been changed, rescheduling services.");
        this.getPollerConfig().rebuildPackageIpListMap();
        for (Long nodeId : this.getNetwork().getNodeIds()) {
            this.serviceReschedule(nodeId, null, event, true);
        }
    }

    private void serviceReschedule(Long nodeId, String nodeLabel, Event sourceEvent, boolean rescheduleExisting) {
        PollableService service;
        Service polledService;
        if (nodeId == null || nodeId <= 0L) {
            LOG.warn("Invalid node ID for event, skipping service reschedule: {}", (Object)sourceEvent);
            return;
        }
        Date closeDate = sourceEvent.getTime();
        HashSet<Service> databaseServices = new HashSet<Service>();
        for (String[] s : this.getPoller().getQueryManager().getNodeServices(nodeId.intValue())) {
            databaseServices.add(new Service(s));
        }
        LOG.debug("# of Services in Database: {}", (Object)databaseServices.size());
        LOG.trace("Database Services: {}", databaseServices);
        HashSet<Service> polledServices = new HashSet<Service>();
        PollableNode pnode = this.getNetwork().getNode(nodeId.intValue());
        if (pnode == null) {
            LOG.debug("Node {} is not already being polled.", (Object)nodeId);
        } else {
            if (pnode.getNodeLabel() != null) {
                nodeLabel = pnode.getNodeLabel();
            }
            for (PollableInterface iface : pnode.getInterfaces()) {
                for (PollableService s : iface.getServices()) {
                    polledServices.add(new Service(s.getIpAddr(), s.getSvcName()));
                }
            }
            LOG.debug("# of Polled Services: {}", (Object)polledServices.size());
            LOG.trace("Polled Services: {}", polledServices);
        }
        Iterator iter = polledServices.iterator();
        while (iter.hasNext()) {
            polledService = (Service)iter.next();
            if (databaseServices.contains(polledService)) continue;
            if (pnode != null) {
                service = pnode.getService(polledService.getInetAddress(), polledService.getServiceName());
                service.delete();
                while (!service.isDeleted()) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            LOG.debug("{} should no longer be polled.  Resolving outages.", (Object)polledService);
            this.closeOutagesForService(sourceEvent, nodeId, closeDate, polledService);
            iter.remove();
        }
        if (rescheduleExisting && pnode != null) {
            iter = polledServices.iterator();
            while (iter.hasNext()) {
                polledService = (Service)iter.next();
                service = pnode.getService(polledService.getInetAddress(), polledService.getServiceName());
                service.delete();
                while (!service.isDeleted()) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                iter.remove();
            }
        }
        for (Service databaseService : databaseServices) {
            if (polledServices.contains(databaseService)) {
                LOG.debug("{} is being skipped. Already scheduled.", (Object)databaseService);
            }
            LOG.debug("{} is being scheduled (or rescheduled) for polling.", (Object)databaseService);
            this.getPoller().scheduleService(nodeId.intValue(), nodeLabel, databaseService.getAddress(), databaseService.getServiceName());
            if (this.getPollerConfig().isPolled(databaseService.getAddress(), databaseService.getServiceName())) continue;
            LOG.debug("{} is no longer polled.  Closing any pending outages.", (Object)databaseService);
            this.closeOutagesForService(sourceEvent, nodeId, closeDate, databaseService);
        }
    }

    protected void closeOutagesForService(Event event, Long nodeId, Date closeDate, Service polledService) {
        this.getPoller().getQueryManager().closeOutagesForService(closeDate, event.getDbid(), nodeId.intValue(), polledService.getAddress(), polledService.getServiceName());
    }

    private void scheduledOutagesChangeHandler() {
        try {
            this.getPollerConfig().update();
            this.getPoller().getPollOutagesConfig().update();
        }
        catch (Throwable e) {
            LOG.error("Failed to reload PollerConfigFactory", e);
        }
        this.getPoller().refreshServicePackages();
    }

    private void thresholdsConfigChangeHandler() {
        this.getPoller().refreshServiceThresholds();
    }

    public String getName() {
        return "Poller:PollerEventProcessor";
    }

    private Poller getPoller() {
        return this.m_poller;
    }

    private PollerConfig getPollerConfig() {
        return this.getPoller().getPollerConfig();
    }

    private PollableNetwork getNetwork() {
        return this.getPoller().getNetwork();
    }

    public static class Service
    implements Comparable<Service> {
        private final String m_addr;
        private final String m_serviceName;

        public Service(String addr, String serviceName) {
            this.m_addr = addr;
            this.m_serviceName = serviceName;
        }

        public Service(String[] service) {
            this.m_addr = service[0];
            this.m_serviceName = service[1];
        }

        public InetAddress getInetAddress() {
            return InetAddressUtils.addr((String)this.m_addr);
        }

        public String getAddress() {
            return this.m_addr;
        }

        public String getServiceName() {
            return this.m_serviceName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_addr == null ? 0 : this.m_addr.hashCode());
            result = 31 * result + (this.m_serviceName == null ? 0 : this.m_serviceName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Service)) {
                return false;
            }
            Service other = (Service)obj;
            if (this.m_addr == null ? other.m_addr != null : !this.m_addr.equals(other.m_addr)) {
                return false;
            }
            return !(this.m_serviceName == null ? other.m_serviceName != null : !this.m_serviceName.equals(other.m_serviceName));
        }

        public String toString() {
            return "Service [" + this.m_addr + ":" + this.m_serviceName + "]";
        }

        @Override
        public int compareTo(Service o) {
            int ret = this.m_addr.compareTo(o.m_addr);
            if (ret == 0) {
                ret = this.m_serviceName.compareTo(o.m_serviceName);
            }
            return ret;
        }
    }
}

