/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.AlphaNumeric;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.collectd.JMXDataSource;
import org.opennms.netmgt.collectd.JMXNodeInfo;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAgent;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.api.ServiceCollector;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.opennms.netmgt.collection.support.AbstractCollectionAttribute;
import org.opennms.netmgt.collection.support.AbstractCollectionAttributeType;
import org.opennms.netmgt.collection.support.AbstractCollectionResource;
import org.opennms.netmgt.collection.support.SingleResourceCollectionSet;
import org.opennms.netmgt.config.JMXDataCollectionConfigFactory;
import org.opennms.netmgt.config.collectd.jmx.Attrib;
import org.opennms.netmgt.config.collectd.jmx.Mbean;
import org.opennms.netmgt.dao.jmx.JmxConfigDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.jmx.JmxCollectorConfig;
import org.opennms.netmgt.jmx.JmxSampleProcessor;
import org.opennms.netmgt.jmx.JmxUtils;
import org.opennms.netmgt.jmx.connection.JmxConnectors;
import org.opennms.netmgt.jmx.impl.DefaultJmxCollector;
import org.opennms.netmgt.jmx.samples.JmxAttributeSample;
import org.opennms.netmgt.jmx.samples.JmxCompositeSample;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JMXCollector
implements ServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(JMXCollector.class);
    protected JmxConfigDao m_jmxConfigDao = null;
    private static final String NODE_INFO_KEY = "org.opennms.netmgt.collectd.JMXCollector.nodeInfo";
    private String serviceName = null;

    public String serviceName() {
        return this.serviceName.toUpperCase();
    }

    public void setServiceName(String name) {
        this.serviceName = name;
    }

    public void initialize(Map<String, String> parameters) {
        try {
            JMXDataCollectionConfigFactory.init();
        }
        catch (Throwable e) {
            LOG.error("initialize: Failed to load data collection configuration", e);
            throw new UndeclaredThrowableException(e);
        }
        Connection ctest = null;
        try {
            ctest = DataSourceFactory.getInstance().getConnection();
        }
        catch (Exception e) {
            LOG.error("initialize: failed to get a database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        finally {
            if (ctest != null) {
                try {
                    ctest.close();
                }
                catch (Throwable t) {
                    LOG.debug("initialize: an exception occurred while closing the JDBC connection");
                }
            }
        }
        LOG.debug("initialize: successfully instantiated JNI interface to RRD.");
    }

    public void release() {
    }

    public void initialize(CollectionAgent agent, Map<String, Object> parameters) {
        InetAddress ipAddr = (InetAddress)agent.getAddress();
        int nodeID = agent.getNodeId();
        String collectionName = ParameterMap.getKeyedString(parameters, (String)ServiceParameters.ParameterName.COLLECTION.toString(), (String)this.serviceName);
        String hostAddress = InetAddressUtils.str((InetAddress)ipAddr);
        LOG.debug("initialize: InetAddress={}, collectionName={}", (Object)hostAddress, (Object)collectionName);
        JMXNodeInfo nodeInfo = new JMXNodeInfo(nodeID);
        LOG.debug("nodeInfo: {} {} {}", new Object[]{hostAddress, nodeID, agent});
        Map attrMap = JMXDataCollectionConfigFactory.getInstance().getAttributeMap(collectionName, this.serviceName, hostAddress);
        nodeInfo.setAttributeMap(attrMap);
        Map<String, JMXDataSource> dsList = JMXCollector.buildDataSourceList(collectionName, attrMap);
        nodeInfo.setDsMap(dsList);
        nodeInfo.setMBeans(JMXDataCollectionConfigFactory.getInstance().getMBeanInfo(collectionName));
        agent.setAttribute(NODE_INFO_KEY, (Object)nodeInfo);
        agent.setAttribute("collectionName", (Object)collectionName);
    }

    public void release(CollectionAgent agent) {
    }

    protected abstract JmxConnectors getConnectionName();

    public CollectionSet collect(CollectionAgent agent, EventProxy eproxy, Map<String, Object> map) {
        final Map stringMap = JmxUtils.convertToUnmodifiableStringMap(map);
        InetAddress ipaddr = (InetAddress)agent.getAddress();
        final JMXNodeInfo nodeInfo = (JMXNodeInfo)agent.getAttribute(NODE_INFO_KEY);
        String collectionName = (String)agent.getAttribute("collectionName");
        String port = ParameterMap.getKeyedString(map, (String)ServiceParameters.ParameterName.PORT.toString(), null);
        String friendlyName = ParameterMap.getKeyedString(map, (String)ServiceParameters.ParameterName.FRIENDLY_NAME.toString(), (String)port);
        String collDir = JmxUtils.getCollectionDirectory((Map)stringMap, (String)friendlyName, (String)this.serviceName);
        int retries = ParameterMap.getKeyedInteger(map, (String)ServiceParameters.ParameterName.RETRY.toString(), (int)3);
        final JMXCollectionResource collectionResource = new JMXCollectionResource(agent, collDir);
        SingleResourceCollectionSet collectionSet = new SingleResourceCollectionSet((CollectionResource)collectionResource, new Date());
        LOG.debug("connecting to {} on node ID {}", (Object)InetAddressUtils.str((InetAddress)ipaddr), (Object)nodeInfo.getNodeId());
        try {
            JmxCollectorConfig config = new JmxCollectorConfig();
            config.setAgentAddress(InetAddressUtils.str((InetAddress)ipaddr));
            config.setConnectionName(this.getConnectionName());
            config.setRetries(retries);
            config.setServiceProperties(stringMap);
            config.setJmxCollection(JMXDataCollectionConfigFactory.getInstance().getJmxCollection(collectionName));
            DefaultJmxCollector jmxCollector = new DefaultJmxCollector();
            jmxCollector.setJmxConfigDao(this.m_jmxConfigDao);
            jmxCollector.collect(config, new JmxSampleProcessor(){
                private final Map<String, AttributeGroupType> groupNameAttributeGroupTypeMap = new HashMap<String, AttributeGroupType>();

                public void process(JmxAttributeSample attributeSample) {
                    String objectName = attributeSample.getMbean().getObjectname();
                    String attributeName = attributeSample.getCollectedAttribute().getName();
                    AttributeGroupType attribGroupType = this.getAttributeGroupType(attributeSample.getMbean());
                    JMXDataSource ds = nodeInfo.getDsMap().get(objectName + "|" + attributeName);
                    JMXCollectionAttributeType attribType = new JMXCollectionAttributeType(ds, attribGroupType);
                    collectionResource.setAttributeValue((CollectionAttributeType)attribType, attributeSample.getCollectedValueAsString());
                }

                public void process(JmxCompositeSample compositeSample) {
                    String objectName = compositeSample.getMbean().getObjectname();
                    String attributeName = compositeSample.getCollectedAttribute().getName();
                    AttributeGroupType attribGroupType = this.getAttributeGroupType(compositeSample.getMbean());
                    JMXDataSource ds = nodeInfo.getDsMap().get(objectName + "|" + attributeName + "|" + compositeSample.getCompositeKey());
                    JMXCollectionAttributeType attribType = new JMXCollectionAttributeType(ds, attribGroupType);
                    collectionResource.setAttributeValue((CollectionAttributeType)attribType, compositeSample.getCollectedValueAsString());
                }

                private AttributeGroupType getAttributeGroupType(Mbean mbean) {
                    String groupName = JmxUtils.getGroupName((Map)stringMap, (Mbean)mbean);
                    if (!this.groupNameAttributeGroupTypeMap.containsKey(groupName)) {
                        AttributeGroupType attribGroupType = new AttributeGroupType(JMXCollector.fixGroupName(groupName), "all");
                        this.groupNameAttributeGroupTypeMap.put(groupName, attribGroupType);
                    }
                    return this.groupNameAttributeGroupTypeMap.get(groupName);
                }
            });
        }
        catch (Exception e) {
            LOG.debug("{} Collector.collect: IOException while collecting address: {}", new Object[]{this.serviceName, agent.getAddress(), e});
        }
        collectionSet.setStatus(1);
        return collectionSet;
    }

    private static String fixGroupName(String objectName) {
        if (objectName == null) {
            return "NULL";
        }
        return AlphaNumeric.parseAndReplace((String)objectName, (char)'_');
    }

    protected static Map<String, JMXDataSource> buildDataSourceList(String collectionName, Map<String, List<Attrib>> attributeMap) {
        LOG.debug("buildDataSourceList - ***");
        HashMap<String, JMXDataSource> dsList = new HashMap<String, JMXDataSource>();
        LOG.debug("attributeMap size: {}", (Object)attributeMap.size());
        for (String objectName : attributeMap.keySet()) {
            List<Attrib> list = attributeMap.get(objectName);
            LOG.debug("ObjectName: {}, Attributes: {}", (Object)objectName, (Object)list.size());
            for (Attrib attr : list) {
                String ds_type = JMXDataSource.mapType(attr.getType());
                if (ds_type != null) {
                    JMXDataSource ds = new JMXDataSource();
                    ds.setHeartbeat(2 * JMXDataCollectionConfigFactory.getInstance().getStep(collectionName));
                    String ds_minval = attr.getMinval();
                    if (ds_minval == null) {
                        ds_minval = "U";
                    }
                    ds.setMax(ds_minval);
                    String ds_maxval = attr.getMaxval();
                    if (ds_maxval == null) {
                        ds_maxval = "U";
                    }
                    ds.setMax(ds_maxval);
                    ds.setInstance(collectionName);
                    ds.setName(attr.getAlias());
                    ds.setType(ds_type);
                    ds.setOid(attr.getName());
                    LOG.debug("buildDataSourceList: ds_name: {} ds_oid: {}.{} ds_max: {} ds_min: {}", new Object[]{ds.getName(), ds.getOid(), ds.getInstance(), ds.getMax(), ds.getMin()});
                    dsList.put(objectName + "|" + attr.getName(), ds);
                    continue;
                }
                LOG.warn("buildDataSourceList: Data type '{}' not supported.  Only integer-type data may be stored in RRD.  MBean object '{}' will not be mapped to RRD data source.", (Object)attr.getType(), (Object)attr.getAlias());
            }
        }
        return dsList;
    }

    public RrdRepository getRrdRepository(String collectionName) {
        return JMXDataCollectionConfigFactory.getInstance().getRrdRepository(collectionName);
    }

    public static class JMXCollectionResource
    extends AbstractCollectionResource {
        private final String m_resourceName;
        private final int m_nodeId;

        public JMXCollectionResource(CollectionAgent agent, String resourceName) {
            super(agent);
            this.m_resourceName = resourceName;
            this.m_nodeId = agent.getNodeId();
        }

        public String toString() {
            return "node[" + this.m_nodeId + ']';
        }

        public void setAttributeValue(CollectionAttributeType type, String value) {
            JMXCollectionAttribute attr = new JMXCollectionAttribute(this, type, value);
            this.addAttribute((CollectionAttribute)attr);
        }

        public Path getPath() {
            return super.getPath().resolve(this.m_resourceName);
        }

        public String getResourceTypeName() {
            return "node";
        }

        public String getInstance() {
            return null;
        }
    }

    private static class JMXCollectionAttribute
    extends AbstractCollectionAttribute {
        private final String m_value;

        JMXCollectionAttribute(JMXCollectionResource resource, CollectionAttributeType attribType, String value) {
            super(attribType, (CollectionResource)resource);
            this.m_value = value;
        }

        public Double getNumericValue() {
            try {
                return Double.parseDouble(this.m_value);
            }
            catch (NullPointerException | NumberFormatException e) {
                return null;
            }
        }

        public String getStringValue() {
            return this.m_value;
        }

        public String toString() {
            return "alias " + this.getName() + ", value " + this.m_value + ", resource " + this.m_resource + ", attributeType " + this.m_attribType;
        }

        public String getMetricIdentifier() {
            String metricId = this.m_attribType.getGroupType().getName();
            metricId = metricId.replace("_type_", ":type=");
            metricId = metricId.replace("_", ".");
            metricId = metricId.concat(".");
            metricId = metricId.concat(this.getName());
            return "JMX_".concat(metricId);
        }
    }

    private static class JMXCollectionAttributeType
    extends AbstractCollectionAttributeType {
        private final JMXDataSource m_dataSource;
        private final String m_name;

        public JMXCollectionAttributeType(JMXDataSource dataSource, AttributeGroupType groupType) {
            super(groupType);
            this.m_dataSource = dataSource;
            this.m_name = dataSource.getName();
        }

        public void storeAttribute(CollectionAttribute attribute, Persister persister) {
            persister.persistNumericAttribute(attribute);
        }

        public String getName() {
            return this.m_name;
        }

        public String getType() {
            return this.m_dataSource.getType();
        }
    }
}

