/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.protocols.dns;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.protocols.dns.DNSInputStream;

public final class DNSAddressRR {
    private String m_name;
    private int m_type;
    private int m_class;
    private long m_TTL;
    private long m_created;
    private int[] ipAddress;

    private String AddressToByteString() {
        return this.ipAddress[0] + "." + this.ipAddress[1] + "." + this.ipAddress[2] + "." + this.ipAddress[3];
    }

    public DNSAddressRR(String name, int type, int clas, long ttl, DNSInputStream dnsIn) throws IOException {
        this.m_name = name;
        this.m_type = type;
        this.m_class = clas;
        this.m_TTL = ttl;
        this.m_created = System.currentTimeMillis();
        this.ipAddress = new int[4];
        for (int i = 0; i < 4; ++i) {
            this.ipAddress[i] = dnsIn.readByte();
        }
    }

    public byte[] getAddress() {
        byte[] ip = new byte[4];
        for (int j = 0; j < 4; ++j) {
            ip[j] = (byte)this.ipAddress[j];
        }
        return ip;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        return InetAddressUtils.addr((String)this.AddressToByteString());
    }

    public String toString() {
        return this.getRRName() + "\tInternet Address = " + this.AddressToByteString();
    }

    public String getRRName() {
        return this.m_name;
    }

    public int getRRType() {
        return this.m_type;
    }

    public int getRRClass() {
        return this.m_class;
    }

    public long getRRTTL() {
        return this.m_TTL;
    }

    public boolean isValid() {
        return this.m_TTL * 1000L > System.currentTimeMillis() - this.m_created;
    }
}

