/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vacuumd;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.PropertiesUtils;
import org.opennms.netmgt.config.VacuumdConfigFactory;
import org.opennms.netmgt.config.vacuumd.Action;
import org.opennms.netmgt.config.vacuumd.ActionEvent;
import org.opennms.netmgt.config.vacuumd.Assignment;
import org.opennms.netmgt.config.vacuumd.AutoEvent;
import org.opennms.netmgt.config.vacuumd.Automation;
import org.opennms.netmgt.config.vacuumd.Trigger;
import org.opennms.netmgt.events.api.EventParameterUtils;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.scheduler.ReadyRunnable;
import org.opennms.netmgt.scheduler.Schedule;
import org.opennms.netmgt.vacuumd.AutomationException;
import org.opennms.netmgt.vacuumd.Transaction;
import org.opennms.netmgt.vacuumd.Vacuumd;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomationProcessor
implements ReadyRunnable {
    private static final Logger LOG = LoggerFactory.getLogger(AutomationProcessor.class);
    private final Automation m_automation;
    private final TriggerProcessor m_trigger;
    private final ActionProcessor m_action;
    private final AutoEventProcessor m_autoEvent;
    private final ActionEventProcessor m_actionEvent;
    private volatile Schedule m_schedule;
    private volatile boolean m_ready = true;

    public AutomationProcessor(Automation automation) {
        this.m_automation = automation;
        this.m_trigger = new TriggerProcessor(this.m_automation.getName(), VacuumdConfigFactory.getInstance().getTrigger(this.m_automation.getTriggerName()));
        this.m_action = new ActionProcessor(this.m_automation.getName(), VacuumdConfigFactory.getInstance().getAction(this.m_automation.getActionName()));
        this.m_autoEvent = new AutoEventProcessor(this.m_automation.getName(), VacuumdConfigFactory.getInstance().getAutoEvent(this.m_automation.getAutoEventName()));
        this.m_actionEvent = new ActionEventProcessor(this.m_automation.getName(), VacuumdConfigFactory.getInstance().getActionEvent(this.m_automation.getActionEvent()));
    }

    public ActionProcessor getAction() {
        return this.m_action;
    }

    public TriggerProcessor getTrigger() {
        return this.m_trigger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Map mdc = Logging.getCopyOfContextMap();
        Logging.putPrefix((String)"vacuumd");
        Date startDate = new Date();
        LOG.debug("Start Scheduled automation {}", (Object)this);
        if (this.getAutomation() != null) {
            this.setReady(false);
            try {
                this.runAutomation();
            }
            catch (SQLException e) {
                LOG.warn("Error running automation: {}, {}", (Object)this.getAutomation().getName(), (Object)e.getMessage());
            }
            finally {
                this.setReady(true);
            }
        }
        LOG.debug("run: Finished automation {}, started at {}", (Object)this.m_automation.getName(), (Object)startDate);
        Logging.setContextMap((Map)mdc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runAutomation() throws SQLException {
        LOG.debug("runAutomation: {} running...", (Object)this.m_automation.getName());
        if (this.hasTrigger()) {
            LOG.debug("runAutomation: {} trigger statement is: {}", (Object)this.m_automation.getName(), (Object)this.m_trigger.getTriggerSQL());
        }
        LOG.debug("runAutomation: {} action statement is: {}", (Object)this.m_automation.getName(), (Object)this.m_action.getActionSQL());
        LOG.debug("runAutomation: Executing trigger: {}", (Object)this.m_automation.getTriggerName());
        LinkedList<Event> eventsToSend = new LinkedList<Event>();
        Transaction.begin();
        try {
            LOG.debug("runAutomation: Processing automation: {}", (Object)this.m_automation.getName());
            TriggerResults results = this.processTrigger();
            boolean success = false;
            if (results.isSuccessful()) {
                success = this.processAction(results, eventsToSend);
            }
            boolean bl = success;
            return bl;
        }
        catch (Throwable e) {
            Transaction.rollbackOnly();
            LOG.warn("runAutomation: Could not execute automation: {}", (Object)this.m_automation.getName(), (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            LOG.debug("runAutomation: Closing transaction for automation: {}", (Object)this.m_automation.getName());
            Transaction.end();
            LOG.debug("runAutomation: Sending {} events for automation: {}", (Object)eventsToSend.size(), (Object)this.m_automation.getName());
            for (Event event : eventsToSend) {
                Vacuumd.getSingleton().getEventManager().sendNow(event);
            }
            LOG.debug("runAutomation: Done processing automation: {}", (Object)this.m_automation.getName());
        }
    }

    private boolean processAction(TriggerResults triggerResults, List<Event> eventsToSend) throws SQLException {
        LOG.debug("runAutomation: running action(s)/actionEvent(s) for : {}", (Object)this.m_automation.getName());
        this.m_action.checkForRequiredColumns(triggerResults);
        if (this.m_action.processAction(triggerResults)) {
            eventsToSend.addAll(this.m_actionEvent.processActionEvent(triggerResults));
            if (this.m_autoEvent.hasEvent()) {
                eventsToSend.add(this.m_autoEvent.getEvent());
            }
            return true;
        }
        return false;
    }

    private TriggerResults processTrigger() throws SQLException {
        if (this.m_trigger.hasTrigger()) {
            ResultSet triggerResultSet = this.m_trigger.runTriggerQuery();
            TriggerResults triggerResults = new TriggerResults(this.m_trigger, triggerResultSet, this.verifyRowCount(triggerResultSet));
            return triggerResults;
        }
        return new TriggerResults(this.m_trigger, null, true);
    }

    protected boolean verifyRowCount(ResultSet triggerResultSet) throws SQLException {
        if (!this.m_trigger.hasTrigger()) {
            return true;
        }
        boolean validRows = true;
        int resultRows = this.countRows(triggerResultSet);
        int triggerRowCount = this.m_trigger.getTrigger().getRowCount();
        String triggerOperator = this.m_trigger.getTrigger().getOperator();
        LOG.debug("verifyRowCount: Verifying trigger result: {} is {} than {}", new Object[]{resultRows, triggerOperator == null ? "<null>" : triggerOperator, triggerRowCount});
        if (!this.m_trigger.triggerRowCheck(triggerRowCount, triggerOperator, resultRows)) {
            validRows = false;
        }
        return validRows;
    }

    public int countRows(ResultSet rs) throws SQLException {
        if (rs == null) {
            return 0;
        }
        int rows = 0;
        while (rs.next()) {
            ++rows;
        }
        rs.beforeFirst();
        return rows;
    }

    public boolean containsTokens(String targetString) {
        return this.m_action.getTokenCount(targetString) > 0;
    }

    public Automation getAutomation() {
        return this.m_automation;
    }

    @Override
    public boolean isReady() {
        return this.m_ready;
    }

    public Schedule getSchedule() {
        return this.m_schedule;
    }

    public void setSchedule(Schedule schedule) {
        this.m_schedule = schedule;
    }

    private boolean hasTrigger() {
        return this.m_trigger.hasTrigger();
    }

    public void setReady(boolean ready) {
        this.m_ready = ready;
    }

    static class ActionEventProcessor {
        private static final Logger LOG = LoggerFactory.getLogger(ActionEventProcessor.class);
        private final String m_automationName;
        private final ActionEvent m_actionEvent;
        private final List<EventAssignment> m_assignments;

        public ActionEventProcessor(String automationName, ActionEvent actionEvent) {
            this.m_automationName = automationName;
            this.m_actionEvent = actionEvent;
            if (actionEvent != null) {
                this.m_assignments = new ArrayList<EventAssignment>(actionEvent.getAssignmentCount());
                for (Assignment assignment : actionEvent.getAssignment()) {
                    this.m_assignments.add(new EventAssignment(assignment));
                }
            } else {
                this.m_assignments = null;
            }
        }

        public boolean hasEvent() {
            return this.m_actionEvent != null;
        }

        public Event getEvent() {
            if (this.hasEvent()) {
                EventBuilder bldr = new EventBuilder(null, "Automation");
                this.buildEvent(bldr, new InvalidSymbolTable());
                LOG.debug("ActionEventProcessor: Generated action-event {} for automation {}", (Object)bldr.getEvent().getUei(), (Object)this.m_automationName);
                return bldr.getEvent();
            }
            LOG.debug("ActionEventProcessor: No action-event for automation {}", (Object)this.m_automationName);
            return null;
        }

        private void buildEvent(EventBuilder bldr, PropertiesUtils.SymbolTable symbols) {
            for (EventAssignment assignment : this.m_assignments) {
                assignment.assign(bldr, symbols);
            }
        }

        List<Event> processTriggerResults(TriggerResults triggerResults) throws SQLException {
            if (!this.hasEvent()) {
                LOG.debug("processTriggerResults: No action-event for automation {}", (Object)this.m_automationName);
                return Collections.emptyList();
            }
            ResultSet triggerResultSet = triggerResults.getResultSet();
            triggerResultSet.beforeFirst();
            LinkedList<Event> events = new LinkedList<Event>();
            while (triggerResultSet.next()) {
                EventBuilder bldr = new EventBuilder(null, "Automation");
                ResultSetSymbolTable symbols = new ResultSetSymbolTable(triggerResultSet);
                try {
                    if (this.m_actionEvent.isAddAllParms() && this.resultHasColumn(triggerResultSet, "eventParms")) {
                        bldr.setParms(EventParameterUtils.decode((String)triggerResultSet.getString("eventParms")));
                    }
                    this.buildEvent(bldr, symbols);
                }
                catch (SQLExceptionHolder holder) {
                    holder.rethrow();
                }
                LOG.debug("processTriggerResults: Generated action-event {} for automation {}", (Object)bldr.getEvent().getUei(), (Object)this.m_automationName);
                events.add(bldr.getEvent());
            }
            return events;
        }

        private boolean resultHasColumn(ResultSet resultSet, String columnName) {
            try {
                if (resultSet.findColumn(columnName) > 0) {
                    return true;
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return false;
        }

        public boolean forEachResult() {
            return this.m_actionEvent == null ? false : this.m_actionEvent.getForEachResult();
        }

        List<Event> processActionEvent(TriggerResults triggerResults) throws SQLException {
            if (triggerResults.hasTrigger() && this.forEachResult()) {
                return this.processTriggerResults(triggerResults);
            }
            if (this.hasEvent()) {
                return Collections.singletonList(this.getEvent());
            }
            return Collections.emptyList();
        }
    }

    static class EventAssignment {
        static final Pattern s_pattern = Pattern.compile("\\$\\{(\\w+)\\}");
        private final Assignment m_assignment;

        public EventAssignment(Assignment assignment) {
            this.m_assignment = assignment;
        }

        public void assign(EventBuilder bldr, PropertiesUtils.SymbolTable symbols) {
            String val = PropertiesUtils.substitute((String)this.m_assignment.getValue(), (PropertiesUtils.SymbolTable[])new PropertiesUtils.SymbolTable[]{symbols});
            if (this.m_assignment.getValue().equals(val) && s_pattern.matcher(val).matches()) {
                return;
            }
            if ("field".equals(this.m_assignment.getType())) {
                bldr.setField(this.m_assignment.getName(), val);
            } else {
                bldr.addParam(this.m_assignment.getName(), val);
            }
        }
    }

    static class InvalidSymbolTable
    implements PropertiesUtils.SymbolTable {
        InvalidSymbolTable() {
        }

        public String getSymbolValue(String symbol) {
            throw new IllegalArgumentException("token " + symbol + " is not allowed for " + this + " when no trigger is being processed");
        }
    }

    static class ResultSetSymbolTable
    implements PropertiesUtils.SymbolTable {
        private final ResultSet m_rs;

        public ResultSetSymbolTable(ResultSet rs) {
            this.m_rs = rs;
        }

        public String getSymbolValue(String symbol) {
            try {
                return this.m_rs.getString(symbol);
            }
            catch (SQLException e) {
                throw new SQLExceptionHolder(e);
            }
        }
    }

    static class SQLExceptionHolder
    extends RuntimeException {
        private static final long serialVersionUID = 2479066089399740468L;
        private final SQLException m_ex;

        public SQLExceptionHolder(SQLException ex) {
            this.m_ex = ex;
        }

        public void rethrow() throws SQLException {
            if (this.m_ex != null) {
                throw this.m_ex;
            }
        }
    }

    static class AutoEventProcessor {
        private static final Logger LOG = LoggerFactory.getLogger(ActionProcessor.class);
        private final String m_automationName;
        private final AutoEvent m_autoEvent;

        public AutoEventProcessor(String automationName, AutoEvent autoEvent) {
            this.m_automationName = automationName;
            this.m_autoEvent = autoEvent;
        }

        public boolean hasEvent() {
            return this.m_autoEvent != null;
        }

        public AutoEvent getAutoEvent() {
            return this.m_autoEvent;
        }

        String getUei() {
            if (this.hasEvent()) {
                return this.getAutoEvent().getUei().getContent();
            }
            return null;
        }

        Event getEvent() {
            if (this.hasEvent()) {
                LOG.debug("AutoEventProcessor: Generated auto-event {} for automation {}", (Object)this.getUei(), (Object)this.m_automationName);
                EventBuilder bldr = new EventBuilder(this.getUei(), "Automation");
                return bldr.getEvent();
            }
            LOG.debug("AutoEventProcessor: No auto-event for automation {}", (Object)this.m_automationName);
            return null;
        }
    }

    static class ActionProcessor {
        private static final Logger LOG = LoggerFactory.getLogger(ActionProcessor.class);
        private final String m_automationName;
        private final Action m_action;

        public ActionProcessor(String automationName, Action action) {
            this.m_automationName = automationName;
            this.m_action = action;
        }

        public boolean hasAction() {
            return this.m_action != null;
        }

        public Action getAction() {
            return this.m_action;
        }

        String getActionSQL() {
            return this.getAction().getStatement().getContent();
        }

        PreparedStatement createPreparedStatement() throws SQLException {
            String actionJDBC = this.getActionSQL().replaceAll("\\$\\{\\w+\\}", "?");
            LOG.debug("createPrepareStatement: This action SQL: {}\nTurned into this: {}", (Object)this.getActionSQL(), (Object)actionJDBC);
            Connection conn = Transaction.getConnection(this.m_action.getDataSource());
            PreparedStatement stmt = conn.prepareStatement(actionJDBC);
            Transaction.register(stmt);
            return stmt;
        }

        public List<String> getActionColumns() {
            return this.getTokenizedColumns(this.getActionSQL());
        }

        private List<String> getTokenizedColumns(String targetString) {
            String expression = "\\$\\{(\\w+)\\}";
            Pattern pattern = Pattern.compile(expression);
            Matcher matcher = pattern.matcher(targetString);
            LOG.debug("getTokenizedColumns: processing string: {}", (Object)targetString);
            ArrayList<String> tokens = new ArrayList<String>();
            int count = 0;
            while (matcher.find()) {
                LOG.debug("getTokenizedColumns: Token {}: {}", (Object)(++count), (Object)matcher.group(1));
                tokens.add(matcher.group(1));
            }
            return tokens;
        }

        void assignStatementParameters(PreparedStatement stmt, ResultSet rs) throws SQLException {
            List<String> actionColumns = this.getTokenizedColumns(this.getActionSQL());
            Iterator<String> it = actionColumns.iterator();
            String actionColumnName = null;
            int i = 0;
            while (it.hasNext()) {
                actionColumnName = it.next();
                stmt.setObject(++i, rs.getObject(actionColumnName));
            }
        }

        public int getTokenCount(String targetString) {
            String expression = "(\\$\\{\\w+\\})";
            Pattern pattern = Pattern.compile(expression, 2);
            Matcher matcher = pattern.matcher(targetString);
            LOG.debug("getTokenCount: processing string: {}", (Object)targetString);
            int count = 0;
            while (matcher.find()) {
                LOG.debug("getTokenCount: Token {}: {}", (Object)(++count), (Object)matcher.group(1));
            }
            return count;
        }

        boolean execute() throws SQLException {
            if (this.getTokenCount(this.getActionSQL()) != 0) {
                LOG.info("execute: not running action: {}.  Action contains tokens in an automation ({}) with no trigger.", (Object)this.m_action.getName(), (Object)this.m_automationName);
                return false;
            }
            PreparedStatement actionStatement = this.createPreparedStatement();
            actionStatement.executeUpdate();
            return true;
        }

        boolean processTriggerResults(TriggerResults triggerResults) throws SQLException {
            ResultSet triggerResultSet = triggerResults.getResultSet();
            triggerResultSet.beforeFirst();
            PreparedStatement actionStatement = this.createPreparedStatement();
            while (triggerResultSet.next()) {
                this.assignStatementParameters(actionStatement, triggerResultSet);
                actionStatement.executeUpdate();
            }
            return true;
        }

        boolean processAction(TriggerResults triggerResults) throws SQLException {
            if (triggerResults.hasTrigger()) {
                return this.processTriggerResults(triggerResults);
            }
            return this.execute();
        }

        public String getName() {
            return this.m_action.getName();
        }

        public String toString() {
            return this.m_action.getName();
        }

        public void checkForRequiredColumns(TriggerResults triggerResults) {
            ResultSet triggerResultSet = triggerResults.getResultSet();
            if (!this.resultSetHasRequiredActionColumns(triggerResultSet, this.getActionColumns())) {
                throw new AutomationException("Action " + this + " uses column not defined in trigger: " + triggerResults);
            }
        }

        public boolean resultSetHasRequiredActionColumns(ResultSet rs, Collection<String> actionColumns) {
            LOG.debug("resultSetHasRequiredActionColumns: Verifying required action columns in trigger ResultSet...");
            if (actionColumns.isEmpty()) {
                return true;
            }
            if (rs == null) {
                return false;
            }
            boolean verified = true;
            String actionColumnName2 = null;
            for (String actionColumnName2 : actionColumns) {
                try {
                    if (rs.findColumn(actionColumnName2) <= 0) continue;
                }
                catch (SQLException e) {
                    LOG.warn("resultSetHasRequiredActionColumns: Trigger ResultSet does NOT have required action columns.  Missing: {}", (Object)actionColumnName2);
                    LOG.warn(e.getMessage());
                    verified = false;
                }
            }
            return verified;
        }
    }

    static class TriggerResults {
        private final TriggerProcessor m_trigger;
        private final ResultSet m_resultSet;
        private final boolean m_successful;

        public TriggerResults(TriggerProcessor trigger, ResultSet set, boolean successful) {
            this.m_trigger = trigger;
            this.m_resultSet = set;
            this.m_successful = successful;
        }

        public boolean hasTrigger() {
            return this.m_trigger.hasTrigger();
        }

        public ResultSet getResultSet() {
            return this.m_resultSet;
        }

        public boolean isSuccessful() {
            return this.m_successful;
        }
    }

    static class TriggerProcessor {
        private static final Logger LOG = LoggerFactory.getLogger(TriggerProcessor.class);
        private final Trigger m_trigger;

        public TriggerProcessor(String automationName, Trigger trigger) {
            this.m_trigger = trigger;
        }

        public Trigger getTrigger() {
            return this.m_trigger;
        }

        public boolean hasTrigger() {
            return this.m_trigger != null;
        }

        public String getTriggerSQL() {
            if (this.hasTrigger()) {
                return this.getTrigger().getStatement().getContent();
            }
            return null;
        }

        public String getName() {
            return this.getTrigger().getName();
        }

        public String toString() {
            return this.m_trigger == null ? "<No-Trigger>" : this.m_trigger.getName();
        }

        ResultSet runTriggerQuery() throws SQLException {
            try {
                if (!this.hasTrigger()) {
                    return null;
                }
                Connection conn = Transaction.getConnection(this.m_trigger.getDataSource());
                Statement triggerStatement = conn.createStatement(1005, 1007);
                Transaction.register(triggerStatement);
                ResultSet triggerResultSet = triggerStatement.executeQuery(this.getTriggerSQL());
                Transaction.register(triggerResultSet);
                return triggerResultSet;
            }
            catch (SQLException e) {
                LOG.warn("Error executing trigger {}", (Object)this.getName(), (Object)e);
                throw e;
            }
        }

        public boolean triggerRowCheck(int trigRowCount, String trigOp, int resultRows) {
            if (trigRowCount == 0 || trigOp == null) {
                LOG.debug("triggerRowCheck: trigger has no row-count restrictions: operator is: {}, row-count is: {}", (Object)trigOp, (Object)trigRowCount);
                return true;
            }
            LOG.debug("triggerRowCheck: Verifying trigger resulting row count {} is {} {}", new Object[]{resultRows, trigOp, trigRowCount});
            boolean runAction = false;
            if ("<".equals(trigOp)) {
                if (resultRows < trigRowCount) {
                    runAction = true;
                }
            } else if ("<=".equals(trigOp)) {
                if (resultRows <= trigRowCount) {
                    runAction = true;
                }
            } else if ("=".equals(trigOp)) {
                if (resultRows == trigRowCount) {
                    runAction = true;
                }
            } else if (">=".equals(trigOp)) {
                if (resultRows >= trigRowCount) {
                    runAction = true;
                }
            } else if (">".equals(trigOp) && resultRows > trigRowCount) {
                runAction = true;
            }
            LOG.debug("Row count verification is: {}", (Object)runAction);
            return runAction;
        }
    }
}

