/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rtc;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.RTCConfigFactory;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.filter.api.FilterParseException;
import org.opennms.netmgt.rtc.AvailabilityService;
import org.opennms.netmgt.rtc.RTCException;
import org.opennms.netmgt.rtc.RTCUtils;
import org.opennms.netmgt.rtc.datablock.RTCCategory;
import org.opennms.netmgt.rtc.datablock.RTCHashMap;
import org.opennms.netmgt.rtc.datablock.RTCNode;
import org.opennms.netmgt.rtc.datablock.RTCNodeKey;
import org.opennms.netmgt.rtc.utils.LegacyEuiLevelMapper;
import org.opennms.netmgt.xml.rtc.EuiLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class DataManager
implements AvailabilityService,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DataManager.class);
    @Autowired
    private FilterDao m_filterDao;
    @Autowired
    private RTCConfigFactory m_configFactory;
    @Autowired
    private TransactionTemplate m_transactionTemplate;
    @Autowired
    private JdbcTemplate m_jdbcTemplate;
    @Autowired
    private MonitoredServiceDao m_monitoredServiceDao;
    private final LegacyEuiLevelMapper m_euiMapper = new LegacyEuiLevelMapper(this);
    private Map<String, RTCCategory> m_categories;
    private RTCHashMap m_map;

    private static void addOutageToRTCNode(RTCNode rtcN, Timestamp lostTimeTS, Timestamp regainedTimeTS) {
        if (lostTimeTS == null) {
            return;
        }
        long lostTime = lostTimeTS.getTime();
        long regainedTime = -1L;
        if (regainedTimeTS != null) {
            regainedTime = regainedTimeTS.getTime();
        }
        LOG.debug("lost time for nodeid/ip/svc: {}/{}/{}: {}/{}", new Object[]{rtcN.getNodeID(), rtcN.getIP(), rtcN.getSvcName(), lostTimeTS, lostTime});
        LOG.debug("regained time for nodeid/ip/svc: {}/{}/{}: {}/{}", new Object[]{rtcN.getNodeID(), rtcN.getIP(), rtcN.getSvcName(), regainedTimeTS, regainedTime});
        rtcN.addSvcTime(lostTime, regainedTime);
    }

    private void addRTCNode(RTCNode rtcN) {
        this.m_map.add(rtcN);
    }

    private static void addNodeToCategory(RTCCategory cat, RTCNode rtcN) {
        rtcN.addCategory(cat.getLabel());
        cat.addNode(rtcN);
        LOG.debug("rtcN : {}/{}/{} added to cat: {}", new Object[]{rtcN.getNodeID(), rtcN.getIP(), rtcN.getSvcName(), cat.getLabel()});
    }

    private void populateNodesFromDB(String query, Object[] args) throws SQLException, FilterParseException, RTCException {
        String getOutagesInWindow = "select        ifsvc.nodeid as nodeid,        ifsvc.ipAddr as ipaddr,        s.servicename as servicename,        o.ifLostService as ifLostService,        o.ifRegainedService as ifRegainedService   from        ifservices ifsvc   join        service s on (ifsvc.serviceid = s.serviceid) left outer  join        outages o on           (            o.nodeid = ifsvc.nodeid             and o.ipaddr = ifsvc.ipaddr             and o.serviceid = ifsvc.serviceid             and             (               o.ifLostService > ?                OR  o.ifRegainedService > ?                OR  o.ifRegainedService is null             )          )  where ifsvc.status='A' " + (query == null ? "" : "and " + query) + " order by " + "       ifsvc.nodeid, ifsvc.ipAddr, ifsvc.serviceid, o.ifLostService ";
        long window = new Date().getTime() - 86400000L;
        Timestamp windowTS = new Timestamp(window);
        RTCNodeProcessor rowHandler = new RTCNodeProcessor();
        Object[] sqlArgs = DataManager.createArgs(windowTS, windowTS, args);
        this.m_jdbcTemplate.query(getOutagesInWindow, sqlArgs, (RowCallbackHandler)rowHandler);
    }

    private static Object[] createArgs(Object arg1, Object arg2, Object[] remaining) {
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(arg1);
        args.add(arg2);
        if (remaining != null) {
            args.addAll(Arrays.asList(remaining));
        }
        return args.toArray();
    }

    public void afterPropertiesSet() throws Exception {
        this.m_categories = RTCUtils.createCategoriesMap();
        if (this.m_categories == null || this.m_categories.isEmpty()) {
            throw new RTCException("No categories found in categories.xml");
        }
        LOG.debug("Number of categories read: {}", (Object)this.m_categories.size());
        this.m_map = new RTCHashMap(30000);
        this.m_transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus arg0) {
                try {
                    DataManager.this.populateNodesFromDB(null, null);
                }
                catch (FilterParseException e) {
                    throw new IllegalStateException("Cannot load RTC data from the database: " + e.getMessage(), e);
                }
                catch (SQLException e) {
                    throw new IllegalStateException("Cannot load RTC data from the database: " + e.getMessage(), e);
                }
                catch (RTCException e) {
                    throw new IllegalStateException("Cannot load RTC data from the database: " + e.getMessage(), e);
                }
            }
        });
    }

    public synchronized void nodeGainedService(int nodeid, InetAddress ip, String svcName) {
        String svcStatus = this.m_monitoredServiceDao.get(Integer.valueOf(nodeid), ip, svcName).getStatus();
        if (!"A".equals(svcStatus)) {
            LOG.info("nodeGainedSvc: {}/{}/{} IGNORED because status is not active: {}", new Object[]{nodeid, ip, svcName, svcStatus});
        } else {
            LOG.debug("nodeGainedSvc: {}/{}/{}/{}", new Object[]{nodeid, ip, svcName, svcStatus});
            LOG.debug("rtcN : Rescanning services on : {}", (Object)ip);
            try {
                this.rtcNodeRescan(nodeid);
            }
            catch (FilterParseException ex) {
                LOG.warn("Failed to unmarshall database config", (Throwable)ex);
                throw new UndeclaredThrowableException(ex);
            }
            catch (SQLException ex) {
                LOG.warn("Failed to get database connection", (Throwable)ex);
                throw new UndeclaredThrowableException(ex);
            }
            catch (RTCException ex) {
                LOG.warn("Failed to get database connection", (Throwable)ex);
                throw new UndeclaredThrowableException(ex);
            }
        }
    }

    public synchronized void outageCreated(int nodeid, InetAddress ip, String svcName, long t) {
        RTCNodeKey key = new RTCNodeKey(nodeid, ip, svcName);
        RTCNode rtcN = this.m_map.getRTCNode(key);
        if (rtcN == null) {
            LOG.info("Received a outageCreated event for an unknown/irrelevant node: {}", (Object)key.toString());
            return;
        }
        rtcN.nodeLostService(t);
    }

    public synchronized void outageResolved(int nodeid, InetAddress ip, String svcName, long t) {
        RTCNodeKey key = new RTCNodeKey(nodeid, ip, svcName);
        RTCNode rtcN = this.m_map.getRTCNode(key);
        if (rtcN == null) {
            LOG.info("Received a outageResolved event for an unknown/irrelevant node: {}", (Object)key.toString());
            return;
        }
        rtcN.nodeRegainedService(t);
    }

    public synchronized void serviceDeleted(int nodeid, InetAddress ip, String svcName) {
        RTCNodeKey key = new RTCNodeKey(nodeid, ip, svcName);
        RTCNode rtcN = this.m_map.getRTCNode(key);
        if (rtcN == null) {
            LOG.warn("Received a {} event for an unknown node: {}", (Object)"uei.opennms.org/nodes/serviceDeleted", (Object)key.toString());
            return;
        }
        List<String> categories = rtcN.getCategories();
        ListIterator<String> catIter = categories.listIterator();
        while (catIter.hasNext()) {
            String catlabel = catIter.next();
            RTCCategory cat = this.m_categories.get(catlabel);
            List<Integer> catNodes = cat.getNodes();
            int nIndex = catNodes.indexOf(rtcN.getNodeID());
            if (nIndex == -1) continue;
            if (this.m_map.getServiceCount(nodeid, catlabel) == 1) {
                catNodes.remove(nIndex);
                LOG.info("Removing node from category: {}", (Object)catlabel);
            }
            catIter.remove();
        }
        this.m_map.delete(rtcN);
    }

    public synchronized void assetInfoChanged(int nodeid) {
        try {
            this.rtcNodeRescan(nodeid);
        }
        catch (FilterParseException ex) {
            LOG.warn("Failed to unmarshall database config", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (SQLException ex) {
            LOG.warn("Failed to get database connection", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (RTCException ex) {
            LOG.warn("Failed to get database connection", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    public synchronized void nodeCategoryMembershipChanged(int nodeid) {
        try {
            this.rtcNodeRescan(nodeid);
        }
        catch (FilterParseException ex) {
            LOG.warn("Failed to unmarshall database config", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (SQLException ex) {
            LOG.warn("Failed to get database connection", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (RTCException ex) {
            LOG.warn("Failed to get database connection", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
    }

    public synchronized void rtcNodeRescan(int nodeid) throws SQLException, FilterParseException, RTCException {
        for (RTCCategory cat : this.m_categories.values()) {
            cat.deleteNode(nodeid);
        }
        this.m_map.deleteNode(nodeid);
        this.populateNodesFromDB("ifsvc.nodeid = ?", new Object[]{(long)nodeid});
    }

    public synchronized void interfaceReparented(InetAddress ip, int oldNodeId, int newNodeId) {
        for (RTCNode rtcN : this.m_map.getRTCNodes(oldNodeId, ip)) {
            this.m_map.delete(rtcN);
            rtcN.setNodeID(newNodeId);
            this.m_map.add(rtcN);
            for (String catlabel : rtcN.getCategories()) {
                RTCCategory rtcCat = this.m_categories.get(catlabel);
                rtcCat.deleteNode(oldNodeId);
                rtcCat.addNode(newNodeId);
            }
        }
    }

    public synchronized double getValue(RTCCategory category, long curTime, long rollingWindow) {
        return this.m_map.getValue(category.getLabel(), curTime, rollingWindow);
    }

    public synchronized double getValue(int nodeid, RTCCategory category, long curTime, long rollingWindow) {
        return this.m_map.getValue(nodeid, category.getLabel(), curTime, rollingWindow);
    }

    public synchronized int getServiceCount(int nodeid, RTCCategory category) {
        return this.m_map.getServiceCount(nodeid, category.getLabel());
    }

    public synchronized int getServiceDownCount(int nodeid, RTCCategory category) {
        return this.m_map.getServiceDownCount(nodeid, category.getLabel());
    }

    @Override
    public synchronized Map<String, RTCCategory> getCategories() {
        return this.m_categories;
    }

    public Collection<Integer> getNodes(RTCCategory category) {
        return category.getNodes();
    }

    @Override
    public EuiLevel getEuiLevel(RTCCategory category) {
        return this.m_euiMapper.convertToEuiLevelXML(category);
    }

    private class RTCNodeProcessor
    implements RowCallbackHandler {
        RTCNodeKey m_currentKey = null;
        Map<String, Set<Integer>> m_categoryNodeIdLists = new HashMap<String, Set<Integer>>();

        private RTCNodeProcessor() {
        }

        public void processRow(ResultSet rs) throws SQLException {
            RTCNodeKey key = new RTCNodeKey(rs.getInt("nodeid"), InetAddressUtils.addr((String)rs.getString("ipaddr")), rs.getString("servicename"));
            this.processKey(key);
            this.processOutage(key, rs.getTimestamp("ifLostService"), rs.getTimestamp("ifRegainedService"));
        }

        private void processKey(RTCNodeKey key) {
            if (!this.matchesCurrent(key)) {
                this.m_currentKey = key;
                this.processIfService(key);
            }
        }

        private boolean matchesCurrent(RTCNodeKey key) {
            return this.m_currentKey != null && this.m_currentKey.equals(key);
        }

        public synchronized void processIfService(RTCNodeKey key) {
            for (RTCCategory cat : DataManager.this.m_categories.values()) {
                if (!this.catContainsIfService(cat, key)) continue;
                RTCNode rtcN = this.getRTCNode(key);
                DataManager.addNodeToCategory(cat, rtcN);
            }
        }

        private RTCNode getRTCNode(RTCNodeKey key) {
            RTCNode rtcN = DataManager.this.m_map.getRTCNode(key);
            if (rtcN == null) {
                rtcN = new RTCNode(key, DataManager.this.m_configFactory.getRollingWindow());
                DataManager.this.addRTCNode(rtcN);
            }
            return rtcN;
        }

        private boolean catContainsIfService(RTCCategory cat, RTCNodeKey key) {
            return cat.containsService(key.getSvcName()) && this.catContainsNode(cat, key.getNodeID());
        }

        private boolean catContainsNode(RTCCategory cat, Integer nodeID) {
            Set<Integer> nodeIds = this.catGetNodeIds(cat);
            return nodeIds.contains(nodeID);
        }

        private Set<Integer> catGetNodeIds(RTCCategory cat) {
            Set<Integer> nodeIds = this.m_categoryNodeIdLists.get(cat.getLabel());
            if (nodeIds == null) {
                nodeIds = RTCUtils.getNodeIdsForCategory(DataManager.this.m_filterDao, cat);
                this.m_categoryNodeIdLists.put(cat.getLabel(), nodeIds);
            }
            return nodeIds;
        }

        public void processOutage(RTCNodeKey key, Timestamp ifLostService, Timestamp ifRegainedService) {
            RTCNode rtcN = DataManager.this.m_map.getRTCNode(key);
            if (rtcN == null) {
                return;
            }
            DataManager.addOutageToRTCNode(rtcN, ifLostService, ifRegainedService);
        }
    }
}

