/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.queued;

import java.util.Set;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.events.api.EventIpcManager;
import org.opennms.netmgt.events.api.EventListener;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Queued
extends AbstractServiceDaemon
implements EventListener {
    private static final Logger LOG = LoggerFactory.getLogger(Queued.class);
    private static final String LOG4J_CATEGORY = "queued";
    private volatile EventIpcManager m_eventMgr;
    private volatile RrdStrategy<?, ?> m_rrdStrategy;

    public Queued() {
        super(LOG4J_CATEGORY);
    }

    public void setEventIpcManager(EventIpcManager eventMgr) {
        this.m_eventMgr = eventMgr;
    }

    public RrdStrategy<?, ?> getRrdStrategy() {
        return this.m_rrdStrategy;
    }

    public void setRrdStrategy(RrdStrategy<?, ?> rrdStrategy) {
        this.m_rrdStrategy = rrdStrategy;
    }

    protected void onInit() {
        Assert.state((this.m_eventMgr != null ? 1 : 0) != 0, (String)"setEventIpcManager must be set");
        Assert.state((this.m_rrdStrategy != null ? 1 : 0) != 0, (String)"rrdStrategy must be set");
        this.m_eventMgr.addEventListener((EventListener)this, "uei.opennms.org/internal/promoteQueueData");
    }

    public void onEvent(Event e) {
        String fileList = EventUtils.getParm((Event)e, (String)"filesToPromote");
        Set<String> files = this.commaDelimitedListToSet(fileList);
        this.logFilePromotion(files);
        this.m_rrdStrategy.promoteEnqueuedFiles(files);
    }

    private Set<String> commaDelimitedListToSet(String fileList) {
        return StringUtils.commaDelimitedListToSet((String)fileList);
    }

    private void logFilePromotion(Set<String> files) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        for (String file : files) {
            LOG.debug("Promoting file: {}", (Object)file);
        }
    }

    public static String getLoggingCateogy() {
        return LOG4J_CATEGORY;
    }
}

